/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.beans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.directory.BasicAttribute;
import org.lsc.LscDatasetModification;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;
import org.lsc.Task;
import org.lsc.beans.IBean;
import org.lsc.beans.OrderedValuesBean;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.PolicyType;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.JndiModifications;
import org.lsc.utils.ScriptingEvaluator;
import org.lsc.utils.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanComparator.class);

    private BeanComparator() {
    }

    public static LscModificationType calculateModificationType(Task task, IBean srcBean, IBean dstBean) throws LscServiceException {
        if (srcBean == null && dstBean == null) {
            return null;
        }
        if (srcBean == null && dstBean != null) {
            return LscModificationType.DELETE_OBJECT;
        }
        if (dstBean == null) {
            return LscModificationType.CREATE_OBJECT;
        }
        IBean itmBean = BeanComparator.cloneSrcBean(task, srcBean, dstBean);
        if (!"".equals(itmBean.getMainIdentifier()) && dstBean.getMainIdentifier().compareToIgnoreCase(itmBean.getMainIdentifier()) != 0) {
            return LscModificationType.CHANGE_ID;
        }
        return LscModificationType.UPDATE_OBJECT;
    }

    public static LscModifications calculateModifications(Task task, IBean srcBean, IBean dstBean) throws LscServiceException {
        LscModifications lm = null;
        IBean itmBean = BeanComparator.cloneSrcBean(task, srcBean, dstBean);
        LscModificationType modificationType = BeanComparator.calculateModificationType(task, srcBean, dstBean);
        if (modificationType == null) {
            return null;
        }
        lm = new LscModifications(modificationType, task.getName());
        lm.setSourceBean(srcBean);
        lm.setDestinationBean(dstBean);
        lm.setMainIdentifer(BeanComparator.getDstDN(itmBean, dstBean));
        switch (modificationType) {
            case CREATE_OBJECT: 
            case UPDATE_OBJECT: {
                lm = BeanComparator.getUpdatedObject(task, lm, srcBean, itmBean, dstBean);
                break;
            }
            case CHANGE_ID: {
                lm.setNewMainIdentifier(itmBean.getMainIdentifier());
                break;
            }
        }
        return lm;
    }

    private static String getDstDN(IBean itmBean, IBean dstBean) {
        if (dstBean != null) {
            return dstBean.getMainIdentifier();
        }
        if (itmBean != null && itmBean.getMainIdentifier() != null) {
            return itmBean.getMainIdentifier();
        }
        throw new RuntimeException("No DN set! Read it from the source or set lsc.tasks.NAME.dn");
    }

    private static LscModifications getUpdatedObject(Task task, LscModifications modOperation, IBean srcBean, IBean itmBean, IBean dstBean) throws LscServiceException {
        String id = modOperation.getMainIdentifier();
        String logPrefix = "In object \"" + id + "\": ";
        LscModificationType modType = modOperation.getOperation();
        if (modType != LscModificationType.CREATE_OBJECT && modType != LscModificationType.UPDATE_OBJECT) {
            return null;
        }
        HashMap<String, Object> javaScriptObjects = new HashMap<String, Object>();
        if (srcBean != null) {
            javaScriptObjects.put("srcBean", srcBean);
        }
        if (dstBean != null) {
            javaScriptObjects.put("dstBean", dstBean);
        }
        if (task.getCustomLibraries() != null) {
            javaScriptObjects.put("custom", task.getCustomLibraries());
        }
        javaScriptObjects.putAll(task.getScriptingVars());
        Set<String> writeAttributes = BeanComparator.getWriteAttributes(task, itmBean);
        LOGGER.debug("{} List of attributes considered for writing in destination: {}", (Object)logPrefix, writeAttributes);
        ArrayList<LscDatasetModification> modificationItems = new ArrayList<LscDatasetModification>();
        for (String attrName : writeAttributes) {
            Set<Object> toSetAttrValues;
            BasicAttribute dstAttr;
            PolicyType attrStatus = task.getSyncOptions().getStatus(id, attrName);
            LOGGER.debug("{} Attribute \"{}\" is in {} status", new Object[]{logPrefix, attrName, attrStatus});
            HashSet<Object> srcAttrValues = itmBean != null && itmBean.getDatasetById(attrName) != null ? itmBean.getDatasetById(attrName) : new HashSet<Object>();
            HashSet<Object> dstAttrValues = dstBean != null && dstBean.getDatasetById(attrName) != null ? dstBean.getDatasetById(attrName) : new HashSet<Object>();
            BasicAttribute srcAttr = itmBean != null ? new BasicAttribute(attrName, srcAttrValues) : null;
            BasicAttribute basicAttribute = dstAttr = dstBean != null ? new BasicAttribute(attrName, dstAttrValues) : null;
            if (srcAttrValues != null) {
                javaScriptObjects.put("srcValues", srcAttrValues);
                javaScriptObjects.put("srcAttr", srcAttr);
            }
            if (dstAttrValues != null) {
                javaScriptObjects.put("dstValues", dstAttrValues);
                javaScriptObjects.put("dstAttr", dstAttr);
            }
            if ((toSetAttrValues = BeanComparator.getValuesToSet(task, attrName, srcAttrValues, dstAttrValues, javaScriptObjects, modType)) == null) continue;
            LscDatasetModification.LscDatasetModificationType operationType = BeanComparator.getRequiredOperationForAttribute(toSetAttrValues, dstAttrValues);
            ArrayList<LscDatasetModification> multiMi = null;
            LscDatasetModification mi = null;
            switch (operationType) {
                case DELETE_VALUES: {
                    if (attrStatus != PolicyType.FORCE) break;
                    LOGGER.debug("{} Deleting attribute  \"{}\"", (Object)logPrefix, (Object)attrName);
                    mi = new LscDatasetModification(operationType, attrName, new HashSet<Object>());
                    break;
                }
                case ADD_VALUES: {
                    LOGGER.debug("{} Adding attribute \"{}\" with values {}", new Object[]{logPrefix, attrName, toSetAttrValues});
                    if (modType != LscModificationType.CREATE_OBJECT && attrStatus == PolicyType.FORCE) {
                        operationType = LscDatasetModification.LscDatasetModificationType.REPLACE_VALUES;
                    }
                    mi = new LscDatasetModification(operationType, attrName, toSetAttrValues);
                    break;
                }
                case REPLACE_VALUES: {
                    Set<Object> missingValues;
                    if (attrStatus == PolicyType.FORCE) {
                        missingValues = SetUtils.findMissingNeedles(dstAttrValues, toSetAttrValues);
                        Set<Object> extraValues = SetUtils.findMissingNeedles(toSetAttrValues, dstAttrValues);
                        if (missingValues.size() + extraValues.size() >= toSetAttrValues.size()) {
                            LOGGER.debug("{} Replacing attribute \"{}\": source values are {}, old values were {}, new values are {}", new Object[]{logPrefix, attrName, srcAttrValues, dstAttrValues, toSetAttrValues});
                            mi = new LscDatasetModification(operationType, dstAttr.getID(), toSetAttrValues);
                            break;
                        }
                        multiMi = new ArrayList<LscDatasetModification>(2);
                        if (extraValues.size() > 0) {
                            LOGGER.debug("{} Removing values from attribute \"{}\": old values are {}", new Object[]{logPrefix, attrName, extraValues});
                            multiMi.add(new LscDatasetModification(LscDatasetModification.LscDatasetModificationType.DELETE_VALUES, dstAttr.getID(), extraValues));
                        }
                        if (missingValues.size() <= 0) break;
                        LOGGER.debug("{} Adding values to attribute \"{}\": new values are {}", new Object[]{logPrefix, attrName, missingValues});
                        multiMi.add(new LscDatasetModification(LscDatasetModification.LscDatasetModificationType.ADD_VALUES, dstAttr.getID(), missingValues));
                        break;
                    }
                    if (attrStatus != PolicyType.MERGE || (missingValues = SetUtils.findMissingNeedles(dstAttrValues, toSetAttrValues)).size() <= 0) break;
                    LOGGER.debug("{} Adding values to attribute \"{}\": new values are {}", new Object[]{logPrefix, attrName, missingValues});
                    mi = new LscDatasetModification(LscDatasetModification.LscDatasetModificationType.ADD_VALUES, dstAttr.getID(), missingValues);
                }
            }
            if (mi == null && multiMi == null) {
                LOGGER.debug("{} Attribute \"{}\" will not be written to the destination", (Object)logPrefix, (Object)attrName);
            } else if (multiMi != null) {
                modificationItems.addAll(multiMi);
            } else if (mi != null) {
                modificationItems.add(mi);
            }
            if (srcAttr != null) {
                javaScriptObjects.remove("srcAttr");
            }
            if (dstAttr == null) continue;
            javaScriptObjects.remove("dstAttr");
        }
        LscModifications result = null;
        if (modificationItems.size() != 0) {
            result = modOperation;
            result.setLscAttributeModifications(modificationItems);
        } else {
            LOGGER.debug("Entry \"{}\" will not be written to the destination", (Object)id);
        }
        return result;
    }

    private static boolean isModified(IBean dstBean, Set<Object> dstAttrValues, Set<Object> toSetAttrValues) {
        if (dstBean instanceof OrderedValuesBean) {
            return !SetUtils.doSetsMatchWithOrder(toSetAttrValues, dstAttrValues);
        }
        return !SetUtils.doSetsMatch(toSetAttrValues, dstAttrValues);
    }

    private static LscDatasetModification.LscDatasetModificationType getRequiredOperationForAttribute(Set<Object> toSetAttrValues, Set<Object> currentAttrValues) {
        if (toSetAttrValues.size() == 0 && currentAttrValues.size() != 0) {
            return LscDatasetModification.LscDatasetModificationType.DELETE_VALUES;
        }
        if (toSetAttrValues.size() > 0 && currentAttrValues.size() == 0) {
            return LscDatasetModification.LscDatasetModificationType.ADD_VALUES;
        }
        if (toSetAttrValues.size() > 0 && currentAttrValues.size() > 0) {
            return LscDatasetModification.LscDatasetModificationType.REPLACE_VALUES;
        }
        return LscDatasetModification.LscDatasetModificationType.UNKNOWN;
    }

    private static Set<String> getWriteAttributes(Task task, IBean srcBean) {
        HashSet<String> res = new HashSet<String>();
        List<String> syncOptionsWriteAttributes = task.getDestinationService().getWriteDatasetIds();
        if (syncOptionsWriteAttributes != null) {
            for (String attrName : syncOptionsWriteAttributes) {
                res.add(attrName);
            }
        }
        if (res.size() == 0) {
            List<String> itmBeanAttrsList = srcBean.datasets().getAttributesNames();
            Set<String> forceAttrsList = task.getSyncOptions().getForceValuedAttributeNames();
            Set<String> defaultAttrsList = task.getSyncOptions().getDefaultValuedAttributeNames();
            Set<String> createAttrsList = task.getSyncOptions().getCreateAttributeNames();
            if (itmBeanAttrsList != null) {
                res.addAll(itmBeanAttrsList);
            }
            if (forceAttrsList != null) {
                res.addAll(forceAttrsList);
            }
            if (defaultAttrsList != null) {
                res.addAll(defaultAttrsList);
            }
            if (createAttrsList != null) {
                res.addAll(createAttrsList);
            }
        }
        return res;
    }

    public static JndiModifications[] checkOtherModifications(IBean srcBean, IBean destBean, JndiModifications jm) throws IllegalAccessException, InvocationTargetException {
        String methodName = "checkDependencies";
        Class[] params = new Class[]{JndiModifications.class};
        try {
            Method checkDependencies = destBean.getClass().getMethod(methodName, params);
            if (checkDependencies != null) {
                return (JndiModifications[])checkDependencies.invoke((Object)destBean, jm);
            }
        }
        catch (SecurityException e) {
            LOGGER.warn("Unattended exception has been raised : {}", (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug("No method \"{}\" to manage modification dependencies {} ({})", new Object[]{methodName, destBean.getClass().getName(), e});
        }
        return new JndiModifications[0];
    }

    private static IBean cloneSrcBean(Task task, IBean srcBean, IBean dstBean) throws LscServiceException {
        IBean itmBean = null;
        if (srcBean != null) {
            try {
                itmBean = srcBean.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new LscServiceException(e);
            }
            String dn = task.getSyncOptions().getDn();
            if (dn != null) {
                HashMap<String, Object> table = new HashMap<String, Object>();
                table.put("srcBean", srcBean);
                table.put("dstBean", dstBean);
                if (task.getCustomLibraries() != null) {
                    table.put("custom", task.getCustomLibraries());
                }
                itmBean.setMainIdentifier(ScriptingEvaluator.evalToString(task, dn, table));
            }
        }
        return itmBean;
    }

    protected static Set<Object> getValuesToSet(Task task, String attrName, Set<Object> srcAttrValues, Set<Object> dstAttrValues, Map<String, Object> javaScriptObjects, LscModificationType modType) throws LscServiceException {
        List<String> newValuesDefs;
        LinkedHashSet<Object> attrValues = new LinkedHashSet<Object>();
        PolicyType attrPolicy = task.getSyncOptions().getStatus(null, attrName);
        if (attrPolicy == PolicyType.KEEP && dstAttrValues.size() > 0) {
            return null;
        }
        List<String> forceValueDefs = task.getSyncOptions().getForceValues(null, attrName);
        if (forceValueDefs != null) {
            for (String forceValueDef : forceValueDefs) {
                List<? extends Object> forceValues = BeanComparator.evaluateExpression(task, attrName, forceValueDef, javaScriptObjects);
                if (forceValues == null) continue;
                attrValues.addAll(forceValues);
            }
            return BeanComparator.splitValues(task, attrName, attrValues);
        }
        if (srcAttrValues != null && srcAttrValues.size() > 0) {
            attrValues.addAll(srcAttrValues);
        }
        if ((attrValues.size() == 0 || attrPolicy == PolicyType.MERGE) && (newValuesDefs = modType == LscModificationType.CREATE_OBJECT ? task.getSyncOptions().getCreateValues(null, attrName) : task.getSyncOptions().getDefaultValues(null, attrName)) != null) {
            for (String defaultValueDef : newValuesDefs) {
                List<? extends Object> defaultValues = BeanComparator.evaluateExpression(task, attrName, defaultValueDef, javaScriptObjects);
                if (defaultValues == null) continue;
                attrValues.addAll(defaultValues);
            }
        }
        if (attrValues.size() == 0 && modType != LscModificationType.CREATE_OBJECT && task.getSyncOptions().getCreateValues(null, attrName) != null) {
            return null;
        }
        return BeanComparator.splitValues(task, attrName, attrValues);
    }

    private static List<? extends Object> evaluateExpression(Task task, String attributeName, String expression, Map<String, Object> scriptingObjects) throws LscServiceException {
        if (LscConfiguration.isLdapBinaryAttribute(attributeName)) {
            return ScriptingEvaluator.evalToByteArrayList(task, expression, scriptingObjects);
        }
        return ScriptingEvaluator.evalToObjectList(task, expression, scriptingObjects);
    }

    private static Set<Object> splitValues(Task task, String attrName, Set<Object> attrValues) {
        LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
        for (Object value : attrValues) {
            if (value instanceof String) {
                String delimiter = task.getSyncOptions().getDelimiter(attrName);
                if (delimiter != null) {
                    StringTokenizer sTok = new StringTokenizer((String)value, delimiter);
                    while (sTok.hasMoreTokens()) {
                        ret.add(sTok.nextToken());
                    }
                    continue;
                }
                ret.add(value);
                continue;
            }
            ret.add(value);
        }
        return ret;
    }
}

