/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.connectors.xmlrpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

public abstract class AbstractLscXmlRpcObject {
    protected String message;
    public static final String LSC_XMLRPC_PROTOCOL_VERSION = "1.0";
    public static final String LSC_XMLRPC_SERVICE_NAME = "LSC-XMLRPC";
    public static int RESULT_SUCCESS = 200;
    public static int AUTHENTICATION_ERROR = 401;
    public static int UNHANDLED_ERROR = 500;
    public static int BAD_SERVICE_NAME = 510;
    public static int BAD_PROTOCOL_VERSION = 511;

    public List<Object> encodeResult(int code, Object ... parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("" + code);
        result.add(LSC_XMLRPC_PROTOCOL_VERSION);
        ArrayList<Object> data = new ArrayList<Object>();
        if (parameters.length > 0) {
            for (Object parameter : parameters) {
                data.add(parameter);
            }
        }
        result.add(data);
        return result;
    }

    protected int checkRequestService(String service, String version) {
        if (!service.equals(LSC_XMLRPC_SERVICE_NAME)) {
            return BAD_SERVICE_NAME;
        }
        if (!version.equals(LSC_XMLRPC_PROTOCOL_VERSION)) {
            return BAD_PROTOCOL_VERSION;
        }
        return RESULT_SUCCESS;
    }

    protected int checkResultService(String code, String version) {
        if (!code.equals("" + RESULT_SUCCESS)) {
            return Integer.parseInt(code);
        }
        if (!version.equals(LSC_XMLRPC_PROTOCOL_VERSION)) {
            return BAD_PROTOCOL_VERSION;
        }
        return RESULT_SUCCESS;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public List<String> decodeStringListResult(Object[] result) {
        ArrayList<String> ret = new ArrayList<String>();
        if (result.length != 3) {
            return null;
        }
        int resultCode = this.checkResultService((String)result[0], (String)result[1]);
        if (resultCode == RESULT_SUCCESS && Object[].class.isInstance(result[2])) {
            for (Object data : (Object[])result[2]) {
                if (!String.class.isInstance(data)) {
                    return null;
                }
                ret.add((String)data);
            }
            return ret;
        }
        return null;
    }

    public List<Object> decodeObjectListResult(Object[] result) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (result.length != 3) {
            return null;
        }
        int resultCode = this.checkResultService((String)result[0], (String)result[1]);
        if (resultCode == RESULT_SUCCESS && Object[].class.isInstance(result[2])) {
            for (Object data : (Object[])result[2]) {
                ret.add(data);
            }
            return ret;
        }
        return null;
    }

    public boolean decodeBooleanResult(Object[] result) {
        if (result.length != 3) {
            return false;
        }
        int resultCode = this.checkResultService((String)result[0], (String)result[1]);
        if (resultCode == RESULT_SUCCESS && Boolean.class.isInstance(result[2])) {
            return (Boolean)result[2];
        }
        return false;
    }

    public Object[] encodeRequest(Object ... parameters) {
        Object[] params = new Object[parameters.length + 2];
        int index = 0;
        params[index++] = LSC_XMLRPC_PROTOCOL_VERSION;
        params[index++] = LSC_XMLRPC_SERVICE_NAME;
        for (Object parameter : parameters) {
            params[index++] = parameter;
        }
        return params;
    }

    public Object encodeMap(List<Attribute> attributes) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Attribute attribute : attributes) {
            values.put(attribute.getID(), this.encodeAttributeValue(attribute));
        }
        return values;
    }

    public Object encodeAttributeValue(Attribute attribute) {
        ArrayList values = new ArrayList();
        try {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                values.add(namingEnumeration.nextElement());
            }
            namingEnumeration.close();
        }
        catch (NamingException ne) {
            System.err.println(ne);
            ne.printStackTrace();
        }
        return values;
    }
}

