/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.lsc.beans.SimpleBean;
import org.lsc.jmx.LscServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LscAgent
implements NotificationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LscAgent.class);
    private String taskName;
    private OperationType operation = OperationType.UNKNOWN;
    private JMXServiceURL url;
    private RMIConnector jmxC;
    private MBeanServerConnection jmxc;
    private LscServer lscServer;
    private String hostname;
    private String port;
    private String idToSync;
    private Map<String, String> attrsToSync = new HashMap<String, String>();

    public static void main(String[] args) {
        LscAgent jmxAgent = new LscAgent();
        int retCode = jmxAgent.parseOptions(args);
        if (retCode > 0) {
            System.exit(retCode);
        }
        System.exit(jmxAgent.run(jmxAgent.getOperation()));
    }

    public int run(OperationType operation) {
        if (!this.jmxBind()) {
            System.exit(1);
            return 1;
        }
        switch (operation.ordinal()) {
            case 0: {
                if (this.idToSync != null) {
                    if (this.lscServer.launchSyncTaskById(this.taskName, this.idToSync, this.attrsToSync)) {
                        LOGGER.info("Synchronization per id successfully achieved.");
                        break;
                    }
                    LOGGER.error("Synchronization per id failed !");
                    return 2;
                }
                this.lscServer.startAsyncTask(this.taskName);
                break;
            }
            case 1: {
                this.lscServer.shutdownAsyncTask(this.taskName);
                break;
            }
            case 2: {
                boolean status = this.lscServer.isAsyncTaskRunning(this.taskName);
                if (ArrayUtils.contains((Object[])this.lscServer.getAsyncTasksName(), (Object)this.taskName)) {
                    LOGGER.info("Asynchronous task " + this.taskName + " is " + (status ? "running" : "stopped"));
                } else if (ArrayUtils.contains((Object[])this.lscServer.getSyncTasksName(), (Object)this.taskName)) {
                    LOGGER.info("Synchronous task " + this.taskName + " is " + (status ? "running" : "stopped"));
                } else {
                    LOGGER.error("Unknown or synchronous task name: " + this.taskName);
                    return 3;
                }
                if (status) {
                    String fullStatus = this.lscServer.getTaskStatus(this.taskName);
                    LOGGER.info(fullStatus);
                    return 0;
                }
                return 1;
            }
            case 3: {
                LOGGER.info("Available asynchronous tasks are: ");
                for (String taskName : this.lscServer.getAsyncTasksName()) {
                    LOGGER.info(" - " + taskName);
                }
                LOGGER.info("Available synchronous tasks are: ");
                for (String taskName : this.lscServer.getSyncTasksName()) {
                    LOGGER.info(" - " + taskName);
                }
                break;
            }
        }
        this.jmxUnbind();
        return 0;
    }

    public boolean syncByObject(String taskName, String id, Map<String, List<String>> map) {
        if (!this.jmxBind()) {
            return false;
        }
        SimpleBean bean = new SimpleBean();
        bean.setMainIdentifier(id);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            bean.setDataset(entry.getKey(), new HashSet<Object>(Arrays.asList(entry.getValue().toArray())));
        }
        return this.lscServer.launchSyncTask(taskName, bean);
    }

    protected int parseOptions(String[] args) {
        Options options = new Options();
        options.addOption("a", "start", true, "Start an asynchronous task");
        options.addOption("h", "hostname", true, "Specify the hostname to connect to");
        options.addOption("l", "list", false, "List the available asynchronous tasks");
        options.addOption("o", "stop", true, "Stop an asynchronous task");
        options.addOption("p", "port", true, "Specify the port to connect to");
        options.addOption("i", "identifier", true, "Specify the identifier to synchronize");
        options.addOption("t", "attributes", true, "Specify the attributes pivot to synchronize (comma separated, identifier parameter required)");
        options.addOption("s", "status", true, "Get a task status");
        GnuParser parser = new GnuParser();
        try {
            CommandLine cmdLine = parser.parse(options, args);
            if (cmdLine.hasOption("a")) {
                this.operation = OperationType.START;
                this.taskName = cmdLine.getOptionValue("a");
            }
            if (cmdLine.hasOption("l")) {
                this.operation = OperationType.TASKS_LIST;
            }
            if (cmdLine.hasOption("o")) {
                this.operation = OperationType.STOP;
                this.taskName = cmdLine.getOptionValue("o");
            }
            if (cmdLine.hasOption("s")) {
                this.operation = OperationType.STATUS;
                this.taskName = cmdLine.getOptionValue("s");
            }
            if (cmdLine.hasOption("i")) {
                this.idToSync = cmdLine.getOptionValue("i");
                if (cmdLine.hasOption("t")) {
                    StringTokenizer attrsStr = new StringTokenizer(cmdLine.getOptionValue("t"), ",");
                    while (attrsStr.hasMoreTokens()) {
                        String token = attrsStr.nextToken();
                        if (token.contains("=")) {
                            this.attrsToSync.put(token.substring(0, token.indexOf("=")), token.substring(token.indexOf("=") + 1));
                            continue;
                        }
                        LOGGER.error("Unknown attribute name=value couple in \"{}\". Please check your parameters !", (Object)token);
                        LscAgent.printHelp(options);
                        return 1;
                    }
                }
            } else if (cmdLine.hasOption("t")) {
                LOGGER.error("Attributes specified, but missing identifier !");
                LscAgent.printHelp(options);
                return 1;
            }
            if (cmdLine.hasOption("h")) {
                this.hostname = cmdLine.getOptionValue("h");
            } else {
                this.hostname = "localhost";
                LOGGER.info("Hostname parameter not specified, using {} as default value.", (Object)this.hostname);
            }
            if (cmdLine.hasOption("p")) {
                this.port = cmdLine.getOptionValue("p");
            } else {
                this.port = "1099";
                LOGGER.info("TCP Port parameter not specified, using {} as default value.", (Object)this.port);
            }
            if (this.operation == OperationType.UNKNOWN) {
                LscAgent.printHelp(options);
                return 1;
            }
        }
        catch (ParseException e) {
            LOGGER.error("Unable to parse the options ({})", (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            return 1;
        }
        return 0;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("lsc", options);
    }

    public boolean jmxBind() {
        try {
            String sUrl = "service:jmx:rmi:///jndi/rmi://" + this.hostname + ":" + this.port + "/jmxrmi";
            LOGGER.info("Connecting to remote engine on : " + sUrl);
            this.url = new JMXServiceURL(sUrl);
            this.jmxC = new RMIConnector(this.url, null);
            this.jmxC.connect();
            this.jmxc = this.jmxC.getMBeanServerConnection();
            ObjectName lscServerName = new ObjectName("org.lsc.jmx:type=LscServer");
            this.lscServer = JMX.newMXBeanProxy(this.jmxc, lscServerName, LscServer.class, true);
            return true;
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        return false;
    }

    protected boolean jmxUnbind() {
        try {
            this.jmxC.close();
            return true;
        }
        catch (IOException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        LOGGER.info("\nReceived notification: " + String.valueOf(notification));
    }

    public OperationType getOperation() {
        return this.operation;
    }

    public static enum OperationType {
        START,
        STOP,
        STATUS,
        TASKS_LIST,
        UNKNOWN;

    }
}

