/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.lsc.LscDatasetModification;
import org.lsc.jndi.JndiModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiModifications {
    private String distinguishName;
    private String newDistinguishName;
    private JndiModificationType operation;
    private List<ModificationItem> modificationItems;
    private String taskName;
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiModifications.class);

    public JndiModifications(JndiModificationType operation) {
        this.operation = operation;
    }

    public JndiModifications(JndiModificationType operation, String taskName) {
        this.operation = operation;
        this.taskName = taskName;
    }

    public final List<ModificationItem> getModificationItems() {
        return this.modificationItems;
    }

    public final void setModificationItems(List<ModificationItem> mi) {
        this.modificationItems = mi;
    }

    public final JndiModificationType getOperation() {
        return this.operation;
    }

    public final void setOperation(JndiModificationType operation) {
        this.operation = operation;
    }

    public final String getDistinguishName() {
        return this.distinguishName;
    }

    public final void setDistinguishName(String ldistinguishName) {
        this.distinguishName = ldistinguishName;
    }

    public final String getNewDistinguishName() {
        return this.newDistinguishName;
    }

    public final void setNewDistinguishName(String lnewDistinguishName) {
        this.newDistinguishName = lnewDistinguishName;
    }

    public Map<String, List<String>> getModificationsItemsByHash() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        List<ModificationItem> mi = this.getModificationItems();
        if (mi != null) {
            for (ModificationItem modificationItem : mi) {
                Attribute attr = modificationItem.getAttribute();
                String id = attr.getID().toLowerCase();
                ArrayList<String> values = new ArrayList<String>(attr.size());
                try {
                    NamingEnumeration<?> namingEnumeration = attr.getAll();
                    while (namingEnumeration.hasMoreElements()) {
                        values.add(namingEnumeration.next().toString());
                    }
                    namingEnumeration.close();
                }
                catch (NamingException e) {
                    LOGGER.error("Error in getting the value(s) of the attribute {}", (Object)id);
                }
                result.put(id, values);
            }
        }
        return result;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public static List<ModificationItem> fromLscAttributeModifications(List<LscDatasetModification> lams) {
        if (lams == null) {
            return null;
        }
        ArrayList<ModificationItem> mis = new ArrayList<ModificationItem>();
        for (LscDatasetModification lam : lams) {
            int operationType = 2;
            switch (lam.getOperation()) {
                case ADD_VALUES: {
                    operationType = 1;
                    break;
                }
                case DELETE_VALUES: {
                    operationType = 3;
                    break;
                }
                case REPLACE_VALUES: {
                    operationType = 2;
                }
            }
            BasicAttribute attr = new BasicAttribute(lam.getAttributeName());
            for (Object val : lam.getValues()) {
                attr.add(val);
            }
            mis.add(new ModificationItem(operationType, attr));
        }
        return mis;
    }
}

