/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.lsc.Configuration;
import org.lsc.LscDatasets;
import org.lsc.configuration.LdapAuthenticationType;
import org.lsc.configuration.LdapConnectionType;
import org.lsc.configuration.LdapDerefAliasesType;
import org.lsc.configuration.LdapReferralType;
import org.lsc.configuration.LdapVersionType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.JndiModifications;
import org.lsc.jndi.KerberosCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JndiServices {
    protected static final String TLS_CONFIGURATION = "java.naming.tls";
    protected static final String RELAX_RULES_CONTROL_OID = "1.3.6.1.4.1.4203.666.5.12";
    public static final String DEFAULT_FILTER = "objectClass=*";
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiServices.class);
    private LdapContext ctx;
    private StartTlsResponse tlsResponse;
    private Dn contextDn;
    private static Map<Properties, JndiServices> cache = new HashMap<Properties, JndiServices>();
    private int pageSize;
    private LdapUrl namingContext;
    private boolean recursiveDelete;
    private boolean relaxRules;
    private Properties connProps;
    private Control[] defaultRequestControls;

    private JndiServices(Properties connProps) throws NamingException, IOException {
        this.connProps = connProps;
        this.initConnection();
    }

    private void initConnection() throws NamingException, IOException {
        this.logConnectingTo(this.connProps);
        if (this.connProps.get(TLS_CONFIGURATION) != null && ((Boolean)this.connProps.get(TLS_CONFIGURATION)).booleanValue()) {
            Properties localConnProps = new Properties();
            localConnProps.putAll((Map<?, ?>)this.connProps);
            String jndiContextAuthentication = localConnProps.getProperty("java.naming.security.authentication");
            String jndiContextPrincipal = localConnProps.getProperty("java.naming.security.principal");
            String jndiContextCredentials = localConnProps.getProperty("java.naming.security.credentials");
            localConnProps.remove("java.naming.security.authentication");
            localConnProps.remove("java.naming.security.principal");
            localConnProps.remove("java.naming.security.credentials");
            this.ctx = new InitialLdapContext(localConnProps, null);
            try {
                this.tlsResponse = (StartTlsResponse)this.ctx.extendedOperation(new StartTlsRequest());
                this.tlsResponse.negotiate();
            }
            catch (IOException e) {
                LOGGER.error("Error starting TLS encryption on connection to {}", (Object)localConnProps.getProperty("java.naming.provider.url"));
                LOGGER.debug(e.toString(), (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                LOGGER.error("Error starting TLS encryption on connection to {}", (Object)localConnProps.getProperty("java.naming.provider.url"));
                LOGGER.debug(e.toString(), (Throwable)e);
                throw e;
            }
            this.ctx.addToEnvironment("java.naming.security.authentication", jndiContextAuthentication);
            this.ctx.addToEnvironment("java.naming.security.principal", jndiContextPrincipal);
            this.ctx.addToEnvironment("java.naming.security.credentials", jndiContextCredentials);
        } else {
            this.ctx = new InitialLdapContext(this.connProps, null);
        }
        try {
            this.namingContext = new LdapUrl((String)this.ctx.getEnvironment().get("java.naming.provider.url"));
        }
        catch (LdapURLEncodingException e) {
            LOGGER.error(e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new NamingException(e.getMessage());
        }
        try {
            this.contextDn = this.namingContext.getDn() != null ? this.namingContext.getDn() : new Dn(new String[]{""});
        }
        catch (LdapInvalidDnException e) {
            LOGGER.error(e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new NamingException(e.getMessage());
        }
        String recursiveDeleteStr = (String)this.ctx.getEnvironment().get("java.naming.recursivedelete");
        this.recursiveDelete = recursiveDeleteStr != null ? Boolean.parseBoolean(recursiveDeleteStr) : false;
        String relaxRulesStr = (String)this.ctx.getEnvironment().get("java.naming.relaxRules");
        this.relaxRules = relaxRulesStr != null ? Boolean.parseBoolean(relaxRulesStr) : false;
        LdapApiService ldapApiService = LdapApiServiceFactory.getSingleton();
        SyncStateValueFactory factory = new SyncStateValueFactory(ldapApiService);
        ldapApiService.registerResponseControl((ControlFactory)factory);
        factory = new PersistentSearchFactory(ldapApiService);
        ldapApiService.registerResponseControl((ControlFactory)factory);
    }

    private void logConnectingTo(Properties connProps) {
        if (LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Connecting to LDAP server ");
            sb.append(connProps.getProperty("java.naming.provider.url"));
            if (connProps.getProperty("java.naming.security.authentication") == null || connProps.getProperty("java.naming.security.authentication").equals("none")) {
                sb.append(" anonymously");
            } else {
                sb.append(" as ");
                sb.append(connProps.getProperty("java.naming.security.principal"));
            }
            if (connProps.get(TLS_CONFIGURATION) != null && ((Boolean)connProps.get(TLS_CONFIGURATION)).booleanValue()) {
                sb.append(" with STARTTLS extended operation");
            }
            LOGGER.info(sb.toString());
        }
    }

    public static JndiServices getInstance(Properties props) throws NamingException, IOException {
        return JndiServices.getInstance(props, false);
    }

    public static JndiServices getInstance(Properties props, boolean forceNewConnection) throws NamingException, IOException {
        if (forceNewConnection) {
            return new JndiServices(props);
        }
        if (!cache.containsKey(props)) {
            cache.put(props, new JndiServices(props));
        }
        JndiServices instance = cache.get(props);
        if (instance.ctx == null) {
            instance.initConnection();
        }
        return instance;
    }

    public static Properties getLdapProperties(LdapConnectionType connection) throws LscConfigurationException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", connection.getFactory() != null ? connection.getFactory() : "com.sun.jndi.ldap.LdapCtxFactory");
        props.put(TLS_CONFIGURATION, connection.isTlsActivated());
        if (connection.getUsername() != null) {
            props.setProperty("java.naming.security.authentication", connection.getAuthentication().value());
            props.setProperty("java.naming.security.principal", connection.getUsername());
            if (connection.getAuthentication().equals((Object)LdapAuthenticationType.GSSAPI)) {
                if (System.getProperty("java.security.krb5.conf") != null) {
                    throw new RuntimeException("Multiple Kerberos connections not supported (existing value: " + System.getProperty("java.security.krb5.conf") + "). Need to set another LSC instance or unset system property !");
                }
                System.setProperty("java.security.krb5.conf", new File(Configuration.getConfigurationDirectory(), "krb5.ini").getAbsolutePath());
                if (System.getProperty("java.security.auth.login.config") != null) {
                    throw new RuntimeException("Multiple JAAS not supported (existing value: " + System.getProperty("java.security.auth.login.config") + "). Need to set another LSC instance or unset system property !");
                }
                System.setProperty("java.security.auth.login.config", new File(Configuration.getConfigurationDirectory(), "gsseg_jaas.conf").getAbsolutePath());
                props.setProperty("javax.security.sasl.server.authentication", "" + connection.isSaslMutualAuthentication());
                props.put("javax.security.auth.useSubjectCredsOnly", "true");
                props.setProperty("javax.security.sasl.qop", connection.getSaslQop().value());
                try {
                    LoginContext lc = new LoginContext(JndiServices.class.getName(), new KerberosCallbackHandler(connection.getUsername(), connection.getPassword()));
                    lc.login();
                }
                catch (LoginException e) {
                    e.printStackTrace();
                }
            } else {
                props.setProperty("java.naming.security.credentials", connection.getPassword());
            }
        } else {
            props.setProperty("java.naming.security.authentication", "none");
        }
        try {
            LdapUrl connectionUrl = new LdapUrl(connection.getUrl());
            if (connectionUrl.getHost() == null) {
                String hostname;
                String domainExt;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Hostname is empty in LDAP URL, will try to lookup through the naming context ...");
                }
                if ((domainExt = JndiServices.convertToDomainExtension(connectionUrl.getDn())) != null && (hostname = JndiServices.lookupLdapSrvThroughDNS("_ldap._tcp." + domainExt)) != null) {
                    connectionUrl.setHost(hostname.substring(0, hostname.indexOf(":")));
                    connectionUrl.setPort(Integer.parseInt(hostname.substring(hostname.indexOf(":") + 1)));
                    connection.setUrl(connectionUrl.toString());
                }
            }
        }
        catch (LdapURLEncodingException e) {
            throw new LscConfigurationException(e);
        }
        props.setProperty("java.naming.provider.url", connection.getUrl());
        if (connection.getReferral() != null) {
            props.setProperty("java.naming.referral", connection.getReferral().value().toLowerCase());
        } else {
            props.setProperty("java.naming.referral", LdapReferralType.IGNORE.value().toLowerCase());
        }
        if (connection.getDerefAliases() != null) {
            props.setProperty("java.naming.ldap.derefAliases", JndiServices.getDerefJndiValue(connection.getDerefAliases()));
        } else {
            props.setProperty("java.naming.ldap.derefAliases", JndiServices.getDerefJndiValue(LdapDerefAliasesType.NEVER));
        }
        if (connection.getBinaryAttributes() != null) {
            props.setProperty("java.naming.ldap.attributes.binary", StringUtils.join(connection.getBinaryAttributes().getString(), (String)" "));
        }
        if (connection.getPageSize() != null) {
            props.setProperty("java.naming.ldap.pageSize", "" + connection.getPageSize());
        }
        if (connection.getSortedBy() != null) {
            props.setProperty("java.naming.ldap.sortedBy", connection.getSortedBy());
        }
        props.setProperty("java.naming.ldap.version", connection.getVersion() == LdapVersionType.VERSION_2 ? "2" : "3");
        if (connection.isRecursiveDelete() != null) {
            props.setProperty("java.naming.recursivedelete", Boolean.toString(connection.isRecursiveDelete()));
        }
        if (connection.isRelaxRules() != null) {
            props.setProperty("java.naming.relaxRules", Boolean.toString(connection.isRelaxRules()));
        }
        return props;
    }

    private static String lookupLdapSrvThroughDNS(String hostname) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            if (ctx != null) {
                Attributes attrs = ctx.getAttributes(hostname, new String[]{"SRV"});
                String[] attributes = ((String)attrs.getAll().next().get()).split(" ");
                return attributes[3] + ":" + attributes[2];
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return hostname + ":389";
    }

    private static String convertToDomainExtension(Dn dn) {
        Object fqdn = "";
        List rdns = dn.getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getAva().getType().equalsIgnoreCase("dc")) {
                return null;
            }
            if (((String)fqdn).length() > 0) {
                fqdn = rdn.getValue() + "." + (String)fqdn;
                continue;
            }
            fqdn = rdn.getValue();
        }
        return fqdn;
    }

    private static String getDerefJndiValue(LdapDerefAliasesType derefAliases) {
        switch (derefAliases) {
            case ALWAYS: {
                return "always";
            }
            case FIND: {
                return "finding";
            }
            case SEARCH: {
                return "searching";
            }
            case NEVER: {
                return "never";
            }
        }
        return "";
    }

    public static JndiServices getInstance(LdapConnectionType connection) {
        try {
            return JndiServices.getInstance(JndiServices.getLdapProperties(connection));
        }
        catch (Exception e) {
            LOGGER.error("Error opening LDAP connection \"" + connection.getName() + "\" to " + connection.getUrl() + " (" + e.toString() + ")");
            throw new RuntimeException(e);
        }
    }

    public SearchResult getEntry(String base, String filter) throws NamingException {
        SearchControls sc = new SearchControls();
        return this.getEntry(base, filter, sc);
    }

    public SearchResult getEntry(String base, String filter, SearchControls sc) throws NamingException {
        return this.getEntry(base, filter, sc, 2);
    }

    public SearchResult getEntry(String base, String filter, SearchControls sc, int scope) throws NamingException {
        try {
            return this.doGetEntry(base, filter, sc, scope);
        }
        catch (NamingException nex) {
            if (nex instanceof CommunicationException || nex instanceof ServiceUnavailableException) {
                LOGGER.warn("Communication error, retrying: " + nex.getMessage());
                LOGGER.debug(nex.getMessage(), (Throwable)nex);
                try {
                    this.initConnection();
                }
                catch (IOException ioex) {
                    LOGGER.error("I/O error: " + ioex.getMessage());
                    LOGGER.debug(ioex.getMessage(), (Throwable)ioex);
                    throw nex;
                }
                return this.doGetEntry(base, filter, sc, scope);
            }
            throw nex;
        }
    }

    private SearchResult doGetEntry(String base, String filter, SearchControls sc, int scope) throws NamingException {
        String searchBase = base == null ? "" : base;
        String searchFilter = filter == null ? DEFAULT_FILTER : filter;
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            sc.setSearchScope(scope);
            String rewrittenBase = null;
            rewrittenBase = !this.getContextDn().isEmpty() && searchBase.toLowerCase().endsWith(this.contextDn.toString().toLowerCase()) ? (!searchBase.equalsIgnoreCase(this.contextDn.toString()) ? searchBase.substring(0, searchBase.toLowerCase().lastIndexOf(this.contextDn.toString().toLowerCase()) - 1) : "") : searchBase;
            namingEnumeration = this.ctx.search(rewrittenBase, searchFilter, sc);
        }
        catch (NamingException nex) {
            LOGGER.error("Error while looking for {} in {}: {}", new Object[]{searchFilter, searchBase, nex});
            throw nex;
        }
        SearchResult sr = null;
        if (namingEnumeration.hasMoreElements()) {
            sr = (SearchResult)namingEnumeration.nextElement();
            if (namingEnumeration.hasMoreElements()) {
                LOGGER.error("Too many entries returned (base: \"{}\", filter: \"{}\")", (Object)searchBase, (Object)searchFilter);
                namingEnumeration.close();
                throw new SizeLimitExceededException("Too many entries returned (base: \"" + searchBase + "\", filter: \"" + searchFilter + "\")");
            }
            namingEnumeration.close();
            return sr;
        }
        namingEnumeration.hasMore();
        namingEnumeration.close();
        return sr;
    }

    public boolean exists(String dn, String filter) {
        try {
            return this.readEntry(dn, filter, true) != null;
        }
        catch (NamingException e) {
            LOGGER.error(e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            return false;
        }
    }

    public boolean exists(String dn) {
        return this.exists(dn, DEFAULT_FILTER);
    }

    public SearchResult readEntry(String base, boolean allowError) throws NamingException {
        return this.readEntry(base, DEFAULT_FILTER, allowError);
    }

    public SearchResult readEntry(String base, String filter, boolean allowError) throws NamingException {
        SearchControls sc = new SearchControls();
        return this.readEntry(base, filter, allowError, sc);
    }

    public String rewriteBase(String base) {
        try {
            Dn lowerCasedContextDn = this.getContextDn().isEmpty() ? null : new Dn(new String[]{this.contextDn.toString().toLowerCase()});
            Dn lowerCasedBaseDn = new Dn(new String[]{base.toLowerCase()});
            if (!lowerCasedBaseDn.isDescendantOf(lowerCasedContextDn)) {
                return base;
            }
            if (lowerCasedBaseDn.equals((Object)lowerCasedContextDn)) {
                return "";
            }
            Dn lowerCasedRelativeDn = lowerCasedBaseDn.getDescendantOf(lowerCasedContextDn);
            return base.substring(0, lowerCasedRelativeDn.toString().length());
        }
        catch (LdapInvalidDnException e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResult readEntry(String base, String filter, boolean allowError, SearchControls sc) throws NamingException {
        try {
            return this.doReadEntry(base, filter, allowError, sc);
        }
        catch (NamingException nex) {
            if (nex instanceof CommunicationException || nex instanceof ServiceUnavailableException) {
                LOGGER.info("Communication error, retrying: " + nex.getMessage());
                LOGGER.debug(nex.getMessage(), (Throwable)nex);
                try {
                    this.initConnection();
                }
                catch (IOException ioex) {
                    LOGGER.error("I/O error: " + ioex.getMessage());
                    LOGGER.debug(ioex.getMessage(), (Throwable)ioex);
                    throw nex;
                }
                return this.doReadEntry(base, filter, allowError, sc);
            }
            throw nex;
        }
    }

    private SearchResult doReadEntry(String base, String filter, boolean allowError, SearchControls sc) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        sc.setSearchScope(0);
        try {
            namingEnumeration = this.ctx.search(this.rewriteBase(base), filter, sc);
        }
        catch (NamingException nex) {
            if (nex instanceof CommunicationException || nex instanceof ServiceUnavailableException) {
                throw nex;
            }
            if (!allowError) {
                LOGGER.error("Error while reading entry {}: {}", (Object)base, (Object)nex);
                LOGGER.debug(nex.toString(), (Throwable)nex);
            }
            return null;
        }
        SearchResult sr = null;
        if (namingEnumeration.hasMore()) {
            sr = namingEnumeration.next();
            if (namingEnumeration.hasMore()) {
                LOGGER.error("Too many entries returned (base: \"{}\")", (Object)base);
            } else {
                namingEnumeration.close();
                return sr;
            }
        }
        namingEnumeration.close();
        return sr;
    }

    public List<String> getDnList(String base, String filter, int scope) throws NamingException {
        try {
            return this.doGetDnList(base, filter, scope);
        }
        catch (NamingException nex) {
            if (nex instanceof CommunicationException || nex instanceof ServiceUnavailableException) {
                LOGGER.warn("Communication error, retrying: " + nex.getMessage());
                LOGGER.debug(nex.getMessage(), (Throwable)nex);
                try {
                    this.initConnection();
                }
                catch (IOException ioex) {
                    LOGGER.error("I/O error: " + ioex.getMessage());
                    LOGGER.debug(ioex.getMessage(), (Throwable)ioex);
                    throw nex;
                }
                return this.doGetDnList(base, filter, scope);
            }
            throw nex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> doGetDnList(String base, String filter, int scope) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        ArrayList<String> list = new ArrayList<String>();
        try (LdapContext searchContext = (LdapContext)this.ctx.lookup("");){
            this.setRequestControls(searchContext);
            SearchControls sc = new SearchControls();
            sc.setDerefLinkFlag(false);
            sc.setReturningAttributes(new String[]{"1.1"});
            sc.setSearchScope(scope);
            sc.setReturningObjFlag(true);
            byte[] pagedResultsResponse = null;
            do {
                namingEnumeration = searchContext.search(base, filter, sc);
                Object completedBaseDn = "";
                if (base.length() > 0) {
                    completedBaseDn = "," + base;
                }
                while (namingEnumeration.hasMoreElements()) {
                    list.add(namingEnumeration.next().getName() + (String)completedBaseDn);
                }
            } while ((pagedResultsResponse = this.pagination(searchContext)) != null);
        }
        namingEnumeration.close();
        return list;
    }

    public boolean apply(JndiModifications jm) throws CommunicationException {
        try {
            return this.doApply(jm);
        }
        catch (CommunicationException cex) {
            LOGGER.warn("Communication error, retrying: " + cex.getMessage());
            LOGGER.debug(cex.getMessage(), (Throwable)cex);
            try {
                this.initConnection();
            }
            catch (IOException ioex) {
                LOGGER.error("I/O error: " + ioex.getMessage());
                LOGGER.debug(ioex.getMessage(), (Throwable)ioex);
                throw cex;
            }
            catch (NamingException nex) {
                LOGGER.error("Naming error: " + nex.getMessage());
                LOGGER.debug(nex.getMessage(), (Throwable)nex);
                throw cex;
            }
            return this.doApply(jm);
        }
    }

    private boolean doApply(JndiModifications jm) throws CommunicationException {
        if (jm == null) {
            return true;
        }
        try {
            LdapContext updateCtx = this.getContext(true);
            switch (jm.getOperation()) {
                case ADD_ENTRY: {
                    updateCtx.createSubcontext(new LdapName(this.rewriteBase(jm.getDistinguishName())), this.getAttributes(jm.getModificationItems(), true));
                    break;
                }
                case DELETE_ENTRY: {
                    if (this.recursiveDelete) {
                        this.deleteChildrenRecursively(updateCtx, this.rewriteBase(jm.getDistinguishName()));
                        break;
                    }
                    updateCtx.destroySubcontext(new LdapName(this.rewriteBase(jm.getDistinguishName())));
                    break;
                }
                case MODIFY_ENTRY: {
                    Object[] table = jm.getModificationItems().toArray();
                    ModificationItem[] mis = new ModificationItem[table.length];
                    System.arraycopy(table, 0, mis, 0, table.length);
                    updateCtx.modifyAttributes(new LdapName(this.rewriteBase(jm.getDistinguishName())), mis);
                    break;
                }
                case MODRDN_ENTRY: {
                    LOGGER.warn("WARNING: updating the RDN of the entry will cancel other modifications! Relaunch synchronization to complete update.");
                    updateCtx.rename(new LdapName(this.rewriteBase(jm.getDistinguishName())), new LdapName(this.rewriteBase(jm.getNewDistinguishName())));
                    break;
                }
                default: {
                    LOGGER.error("Unable to identify the right modification type: {}", (Object)jm.getOperation());
                    return false;
                }
            }
            return true;
        }
        catch (ContextNotEmptyException e) {
            LOGGER.error("Object {} not deleted because it has children (LDAP error code 66 received). To delete this entry and it's subtree, set the dst.java.naming.recursivedelete property to true", (Object)jm.getDistinguishName());
            return false;
        }
        catch (NamingException ne) {
            if (LOGGER.isErrorEnabled()) {
                StringBuilder errorMessage = new StringBuilder("Error while ");
                switch (jm.getOperation()) {
                    case ADD_ENTRY: {
                        errorMessage.append("adding");
                        break;
                    }
                    case MODIFY_ENTRY: {
                        errorMessage.append("modifying");
                        break;
                    }
                    case MODRDN_ENTRY: {
                        errorMessage.append("renaming");
                        break;
                    }
                    case DELETE_ENTRY: {
                        if (this.recursiveDelete) {
                            errorMessage.append("recursively ");
                        }
                        errorMessage.append("deleting");
                    }
                }
                errorMessage.append(" entry ").append(jm.getDistinguishName());
                errorMessage.append(" in directory :").append(ne.toString());
                LOGGER.error(errorMessage.toString());
            }
            if (ne instanceof CommunicationException) {
                throw (CommunicationException)ne;
            }
            if (ne instanceof ServiceUnavailableException) {
                CommunicationException ce = new CommunicationException(ne.getExplanation());
                ce.setRootCause(ne);
                throw ce;
            }
            return false;
        }
    }

    private void deleteChildrenRecursively(LdapContext updateCtx, String distinguishName) throws NamingException {
        try {
            this.doDeleteChildrenRecursively(updateCtx, distinguishName);
            return;
        }
        catch (NamingException nex) {
            if (nex instanceof CommunicationException || nex instanceof ServiceUnavailableException) {
                LOGGER.warn("Communication error, retrying: " + nex.getMessage());
                LOGGER.debug(nex.getMessage(), (Throwable)nex);
                try {
                    this.initConnection();
                }
                catch (IOException ioex) {
                    LOGGER.error("I/O error: " + ioex.getMessage());
                    LOGGER.debug(ioex.getMessage(), (Throwable)ioex);
                    throw nex;
                }
                this.doDeleteChildrenRecursively(this.getContext(true), distinguishName);
                return;
            }
            throw nex;
        }
    }

    private void doDeleteChildrenRecursively(LdapContext updateCtx, String distinguishName) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search(distinguishName, DEFAULT_FILTER, sc);
        while (namingEnumeration.hasMore()) {
            SearchResult sr = namingEnumeration.next();
            String childrenDn = this.rewriteBase(sr.getName() + "," + distinguishName);
            this.deleteChildrenRecursively(updateCtx, childrenDn);
        }
        namingEnumeration.close();
        updateCtx.destroySubcontext(new LdapName(distinguishName));
    }

    private Attributes getAttributes(List<ModificationItem> modificationItems, boolean forgetEmpty) {
        BasicAttributes attrs = new BasicAttributes();
        for (ModificationItem mi : modificationItems) {
            if (forgetEmpty && mi.getAttribute().size() == 0) continue;
            attrs.put(mi.getAttribute());
        }
        return attrs;
    }

    public Map<String, List<String>> getSchema(String[] attrsToReturn) throws NamingException {
        HashMap<String, List<String>> attrsResult = new HashMap<String, List<String>>();
        Hashtable<?, ?> props = this.ctx.getEnvironment();
        String baseUrl = (String)props.get("java.naming.provider.url");
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47));
        props.put("java.naming.provider.url", baseUrl);
        InitialLdapContext schemaCtx = new InitialLdapContext(props, null);
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        sc.setReturningAttributes(new String[]{"subschemaSubentry"});
        NamingEnumeration<SearchResult> schemaDnSR = schemaCtx.search("", "(objectclass=*)", sc);
        SearchResult sr = null;
        Attribute subschemaSubentry = null;
        String subschemaSubentryDN = null;
        if (schemaDnSR.hasMore()) {
            sr = schemaDnSR.next();
        }
        schemaDnSR.close();
        if (sr != null) {
            subschemaSubentry = sr.getAttributes().get("subschemaSubentry");
        }
        if (subschemaSubentry != null && subschemaSubentry.size() > 0) {
            subschemaSubentryDN = (String)subschemaSubentry.get();
        }
        if (subschemaSubentryDN != null) {
            String[] stringArray;
            if (attrsToReturn != null) {
                stringArray = attrsToReturn;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "*";
                stringArray = stringArray2;
                stringArray2[1] = "+";
            }
            Attributes schemaAttrs = schemaCtx.getAttributes(subschemaSubentryDN, stringArray);
            if (schemaAttrs != null) {
                for (String attr : attrsToReturn) {
                    Attribute schemaAttr = schemaAttrs.get(attr);
                    if (schemaAttr == null) continue;
                    attrsResult.put(schemaAttr.getID(), Collections.list(schemaAttr.getAll()));
                }
            }
        }
        return attrsResult;
    }

    public List<String> sup(String dn, int level) throws NamingException {
        int ncLevel = new LdapName(this.contextDn.toString()).size();
        LdapName lName = new LdapName(dn);
        ArrayList<String> cList = new ArrayList<String>();
        if (level > 0) {
            if (lName.size() > level) {
                for (int i = 0; i < level; ++i) {
                    lName.remove(lName.size() - 1);
                }
                cList.add(lName.toString());
            }
        } else if (level == 0) {
            cList.add(lName.toString());
            int size = lName.size();
            for (int i = 0; i < size - 1 && i < size - ncLevel; ++i) {
                lName.remove(lName.size() - 1);
                cList.add(lName.toString());
            }
        } else {
            return null;
        }
        return cList;
    }

    public Map<String, LscDatasets> getAttrsList(String base, String filter, int scope, List<String> attrsNames) throws NamingException {
        try {
            return this.doGetAttrsList(base, filter, scope, attrsNames);
        }
        catch (NamingException nex) {
            if (nex instanceof CommunicationException || nex instanceof ServiceUnavailableException) {
                LOGGER.warn("Communication error, retrying: " + nex.getMessage());
                LOGGER.debug(nex.getMessage(), (Throwable)nex);
                try {
                    this.initConnection();
                }
                catch (IOException ioex) {
                    LOGGER.error("I/O error: " + ioex.getMessage());
                    LOGGER.debug(ioex.getMessage(), (Throwable)ioex);
                    throw nex;
                }
                return this.doGetAttrsList(base, filter, scope, attrsNames);
            }
            throw nex;
        }
    }

    public List<String> getAttributeValues(String objectDn, String attribute) throws LscServiceException {
        ArrayList<String> values = null;
        try {
            SearchControls sc = new SearchControls();
            sc.setDerefLinkFlag(false);
            sc.setReturningAttributes(new String[]{attribute});
            sc.setSearchScope(0);
            sc.setReturningObjFlag(true);
            SearchResult res = this.getEntry(objectDn, DEFAULT_FILTER, sc, 0);
            Attribute attr = res.getAttributes().get(attribute);
            if (attr != null) {
                values = new ArrayList<String>();
                NamingEnumeration<?> namingEnumeration = attr.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    Object val = namingEnumeration.next();
                    values.add(val.toString());
                }
                namingEnumeration.close();
            }
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LscDatasets> doGetAttrsList(String base, String filter, int scope, List<String> attrsNames) throws NamingException {
        String searchBase = base == null ? "" : this.rewriteBase(base);
        String searchFilter = filter == null ? DEFAULT_FILTER : filter;
        LinkedHashMap<String, LscDatasets> res = new LinkedHashMap<String, LscDatasets>();
        if (attrsNames == null || attrsNames.size() == 0) {
            LOGGER.error("No attribute names to read! Check configuration.");
            return res;
        }
        String[] attributes = new String[attrsNames.size()];
        attributes = attrsNames.toArray(attributes);
        SearchControls constraints = new SearchControls();
        constraints.setDerefLinkFlag(false);
        constraints.setReturningAttributes(attributes);
        constraints.setSearchScope(scope);
        constraints.setReturningObjFlag(true);
        try (LdapContext searchContext = (LdapContext)this.ctx.lookup("");){
            byte[] pagedResultsResponse;
            this.setRequestControls(searchContext);
            do {
                NamingEnumeration<SearchResult> results;
                if ((results = searchContext.search(searchBase, searchFilter, constraints)) != null) {
                    HashMap<String, Object> attrsValues = null;
                    while (results.hasMoreElements()) {
                        attrsValues = new HashMap<String, Object>();
                        SearchResult ldapResult = results.next();
                        for (String attributeName : attrsNames) {
                            Attribute attr = ldapResult.getAttributes().get(attributeName);
                            if (attr == null || attr.get() == null) continue;
                            attrsValues.put(attributeName, attr.get());
                        }
                        res.put(ldapResult.getNameInNamespace(), new LscDatasets(attrsValues));
                    }
                }
                results.close();
            } while ((pagedResultsResponse = this.pagination(searchContext)) != null);
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (ServiceUnavailableException e) {
            throw e;
        }
        catch (IOException | NamingException e) {
            LOGGER.error(e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        finally {
            this.ctx.setRequestControls(this.defaultRequestControls);
        }
        return res;
    }

    public byte[] pagination(LdapContext ldapContext) throws IOException, NamingException {
        byte[] pagedResultsResponse = null;
        Control[] respCtls = ldapContext.getResponseControls();
        if (respCtls != null) {
            for (Control respCtl : respCtls) {
                if (!(respCtl instanceof PagedResultsResponseControl)) continue;
                pagedResultsResponse = ((PagedResultsResponseControl)respCtl).getCookie();
            }
        }
        if (pagedResultsResponse != null) {
            ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pageSize, pagedResultsResponse, true)});
        }
        return pagedResultsResponse;
    }

    public void setRequestControls(LdapContext ldapContext) {
        try {
            String sortedBy;
            ArrayList<BasicControl> requestControls = new ArrayList<BasicControl>();
            String pageSizeStr = (String)ldapContext.getEnvironment().get("java.naming.ldap.pageSize");
            if (pageSizeStr != null && Integer.parseInt(pageSizeStr) > -1) {
                this.pageSize = Integer.parseInt(pageSizeStr);
                requestControls.add(new PagedResultsControl(this.pageSize, true));
            }
            if ((sortedBy = (String)ldapContext.getEnvironment().get("java.naming.ldap.sortedBy")) != null) {
                requestControls.add(new SortControl(sortedBy, true));
            }
            if (requestControls.size() > 0) {
                ldapContext.setRequestControls(requestControls.toArray(new Control[requestControls.size()]));
            }
        }
        catch (IOException | NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getContextDn() {
        return this.contextDn.toString();
    }

    protected void finalize() throws Throwable {
        if (this.tlsResponse != null) {
            this.tlsResponse.close();
        }
        if (this.ctx != null) {
            this.ctx.close();
            this.ctx = null;
        }
        super.finalize();
    }

    public LdapContext getContext() throws NamingException {
        return this.getContext(false);
    }

    public LdapContext getContext(boolean forUpdates) throws NamingException {
        if (forUpdates && this.relaxRules) {
            LOGGER.debug("Using relax rules control to apply modifications");
            LdapContext newCtx = this.ctx.newInstance(null);
            Control[] controls = newCtx.getRequestControls();
            if (controls == null) {
                controls = new Control[]{};
            }
            int length = newCtx.getRequestControls().length;
            controls = Arrays.copyOf(controls, length + 1);
            controls[length] = new BasicControl(RELAX_RULES_CONTROL_OID, true, null);
            newCtx.setRequestControls(controls);
            return newCtx;
        }
        return this.ctx;
    }

    public String completeDn(String dn) {
        if (!dn.toLowerCase().endsWith(this.contextDn.toString().toLowerCase())) {
            if (dn.length() > 0) {
                return dn + "," + this.contextDn.toString();
            }
            return this.contextDn.toString();
        }
        return dn;
    }

    public static CallbackHandler getCallbackHandler(String user, String pass) {
        return new KerberosCallbackHandler(user, pass);
    }
}

