/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.runnable;

import java.util.HashMap;
import java.util.Map;
import org.lsc.AbstractSynchronize;
import org.lsc.Hooks;
import org.lsc.LscDatasets;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;
import org.lsc.Task;
import org.lsc.beans.BeanComparator;
import org.lsc.beans.IBean;
import org.lsc.beans.InfoCounter;
import org.lsc.exception.LscServiceCommunicationException;
import org.lsc.runnable.AbstractEntryRunner;
import org.lsc.utils.ScriptingEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizeEntryRunner
extends AbstractEntryRunner {
    static final Logger LOGGER = LoggerFactory.getLogger(SynchronizeEntryRunner.class);
    private boolean fromSource;
    private Hooks hooks;

    public SynchronizeEntryRunner(Task task, InfoCounter counter, AbstractSynchronize abstractSynchronize, Map.Entry<String, LscDatasets> id, boolean fromSource) {
        super(task, counter, abstractSynchronize, id);
        this.fromSource = fromSource;
        this.hooks = new Hooks();
    }

    @Override
    public void run() {
        this.counter.incrementCountAll();
        try {
            this.run(this.abstractSynchronize.getBean(this.task, this.fromSource ? this.task.getSourceService() : this.task.getDestinationService(), (String)this.id.getKey(), (LscDatasets)this.id.getValue(), true, this.fromSource));
        }
        catch (RuntimeException e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(null, this.id.getValue(), e);
            if (e.getCause() instanceof LscServiceCommunicationException) {
                LOGGER.error("Connection lost! Aborting.");
            }
        }
        catch (Exception e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(null, this.id.getValue(), e);
        }
    }

    public boolean run(IBean entry) {
        LscModifications lm = null;
        IBean dstBean = null;
        HashMap<String, Object> conditionObjects = null;
        try {
            if (entry == null) {
                this.counter.incrementCountError();
                StringBuilder sb = new StringBuilder("Cannot synchronize entry");
                if (this.id != null) {
                    sb.append(" ").append((String)this.id.getKey());
                }
                sb.append(": no matching object found in source");
                if (this.id != null && this.id.getValue() != null && !((LscDatasets)this.id.getValue()).getDatasets().isEmpty()) {
                    sb.append(" with pivots ").append(((LscDatasets)this.id.getValue()).toString());
                }
                LOGGER.error(sb.toString());
                return false;
            }
            if (this.id != null) {
                dstBean = this.abstractSynchronize.getBean(this.task, this.task.getDestinationService(), (String)this.id.getKey(), (LscDatasets)this.id.getValue(), !this.fromSource, this.fromSource);
            } else {
                LscDatasets entryDatasets = new LscDatasets();
                for (String datasetName : entry.datasets().getAttributesNames()) {
                    entryDatasets.getDatasets().put(datasetName, entry.getDatasetById(datasetName));
                }
                dstBean = this.abstractSynchronize.getBean(this.task, this.task.getDestinationService(), entry.getMainIdentifier(), entryDatasets, !this.fromSource, this.fromSource);
            }
            LscModificationType modificationType = BeanComparator.calculateModificationType(this.task, entry, dstBean);
            Boolean applyCondition = null;
            String conditionString = this.task.getSyncOptions().getCondition(modificationType);
            if (conditionString.matches("true")) {
                applyCondition = true;
            } else if (conditionString.matches("false")) {
                applyCondition = false;
            } else {
                conditionObjects = new HashMap<String, Object>();
                conditionObjects.put("dstBean", dstBean);
                conditionObjects.put("srcBean", entry);
                conditionObjects.putAll(this.task.getScriptingVars());
                if (this.task.getCustomLibraries() != null) {
                    conditionObjects.put("custom", this.task.getCustomLibraries());
                }
                applyCondition = ScriptingEvaluator.evalToBoolean(this.task, conditionString, conditionObjects);
            }
            if (applyCondition.booleanValue()) {
                lm = BeanComparator.calculateModifications(this.task, entry, dstBean);
                if (lm == null) {
                    return true;
                }
                this.counter.incrementCountModifiable();
                if (modificationType == LscModificationType.CREATE_OBJECT && this.abstractSynchronize.nocreate || modificationType == LscModificationType.UPDATE_OBJECT && this.abstractSynchronize.noupdate || modificationType == LscModificationType.CHANGE_ID && (this.abstractSynchronize.nomodrdn || this.abstractSynchronize.noupdate)) {
                    this.abstractSynchronize.logShouldAction(lm, this.syncName);
                    return true;
                }
            } else {
                return true;
            }
            if (this.task.getDestinationService().apply(lm)) {
                this.hooks.postSyncHook(this.task.getSyncOptions().getPostHook(modificationType), this.task.getSyncOptions().getPostHookOutputFormat(), lm);
                this.counter.incrementCountCompleted();
                this.abstractSynchronize.logAction(lm, this.id, this.syncName);
                return true;
            }
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id != null ? this.id.getValue() : entry.getMainIdentifier(), new Exception("Technical problem while applying modifications to the destination"));
            return false;
        }
        catch (RuntimeException e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id != null ? this.id.getValue() : (entry != null ? entry.getMainIdentifier() : e.toString()), e);
            if (e.getCause() instanceof LscServiceCommunicationException) {
                LOGGER.error("Connection lost! Aborting.");
            }
            return false;
        }
        catch (Exception e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id != null ? this.id.getValue() : entry.getMainIdentifier(), e);
            return false;
        }
    }
}

