/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.lsc.Task;
import org.lsc.jndi.AbstractSimpleJndiService;
import org.lsc.jndi.ScriptableJndiServices;
import org.lsc.utils.ScriptableEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroovyEvaluator
implements ScriptableEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyEvaluator.class);
    private GroovyScriptEngineImpl engine;

    public GroovyEvaluator(ScriptEngine se) {
        this.engine = (GroovyScriptEngineImpl)se;
    }

    @Override
    public String evalToString(Task task, String expression, Map<String, Object> params) {
        Object result = this.instanceEval(task, expression, params);
        if (result == null) {
            return null;
        }
        return (String)result;
    }

    @Override
    public List<Object> evalToObjectList(Task task, String expression, Map<String, Object> params) {
        Object result = this.instanceEval(task, expression, params);
        if (result == null) {
            return null;
        }
        if (result instanceof Object[]) {
            return Arrays.asList(result);
        }
        if (result instanceof List) {
            return (List)result;
        }
        if (result.getClass().isArray() && result.getClass().getComponentType().equals(Byte.TYPE)) {
            return Arrays.asList(result);
        }
        ArrayList<Object> resultsArray = new ArrayList<Object>();
        String resultAsString = result.toString();
        if (resultAsString != null && resultAsString.length() > 0) {
            resultsArray.add(resultAsString);
        }
        return resultsArray;
    }

    @Override
    public List<byte[]> evalToByteArrayList(Task task, String expression, Map<String, Object> params) {
        Object result = this.instanceEval(task, expression, params);
        if (result instanceof byte[][]) {
            return Arrays.asList((byte[][])result);
        }
        if (result instanceof byte[]) {
            return Collections.singletonList((byte[])result);
        }
        if (result instanceof List) {
            return (List)result;
        }
        if (result instanceof Set) {
            return new ArrayList<byte[]>((Set)result);
        }
        ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
        String resultAsString = result.toString();
        if (resultAsString != null && resultAsString.length() > 0) {
            resultsArray.add(resultAsString.getBytes());
        }
        return resultsArray;
    }

    @Override
    public byte[] evalToByteArray(Task task, String expression, Map<String, Object> params) {
        Object result = this.instanceEval(task, expression, params);
        if (result instanceof byte[]) {
            return (byte[])result;
        }
        if (result instanceof String) {
            return ((String)result).getBytes();
        }
        return result.toString().getBytes();
    }

    @Override
    public Boolean evalToBoolean(Task task, String expression, Map<String, Object> params) {
        return (Boolean)this.instanceEval(task, expression, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instanceEval(Task task, String expression, Map<String, Object> params) {
        Bindings bindings = this.engine.createBindings();
        String expressionImport = expression;
        if (!bindings.containsKey("ldap") && task.getDestinationService() instanceof AbstractSimpleJndiService) {
            ScriptableJndiServices dstSjs = new ScriptableJndiServices();
            dstSjs.setJndiServices(((AbstractSimpleJndiService)((Object)task.getDestinationService())).getJndiServices());
            bindings.put("ldap", (Object)dstSjs);
        }
        if (!bindings.containsKey("srcLdap") && task.getSourceService() instanceof AbstractSimpleJndiService) {
            ScriptableJndiServices srcSjs = new ScriptableJndiServices();
            srcSjs.setJndiServices(((AbstractSimpleJndiService)((Object)task.getSourceService())).getJndiServices());
            bindings.put("srcLdap", (Object)srcSjs);
        }
        if (params != null) {
            for (String string : params.keySet()) {
                bindings.put(string, params.get(string));
            }
        }
        Object ret = null;
        try {
            if (task.getScriptIncludes() != null) {
                for (File scriptInclude : task.getScriptIncludes()) {
                    String extension = FilenameUtils.getExtension((String)scriptInclude.getAbsolutePath());
                    if (!"groovy".equals(extension) && !"gvy".equals(extension) && !"gy".equals(extension) && !"gsh".equals(extension)) continue;
                    try (FileReader reader = new FileReader(scriptInclude);){
                        this.engine.eval((Reader)reader, bindings);
                    }
                }
            }
            ret = this.engine.eval(expressionImport, bindings);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            LOGGER.error(exception.toString());
            LOGGER.debug(exception.toString(), (Throwable)exception);
            return null;
        }
        return ret;
    }
}

