/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.lsc.configuration.LscConfiguration;
import org.lsc.utils.security.SymmetricEncryption;

public class SecurityUtils {
    public static final String HASH_MD5 = "MD5";
    public static final String HASH_SHA1 = "SHA1";
    public static final String HASH_SHA256 = "SHA256";
    public static final String HASH_SHA512 = "SHA512";
    private static SymmetricEncryption encryptionInstance;

    private SecurityUtils() {
    }

    private static SymmetricEncryption getEncryptionInstance() throws GeneralSecurityException {
        if (encryptionInstance == null) {
            if (LscConfiguration.getSecurity() == null) {
                throw new RuntimeException("lsc>security node of the LSC configuration cannot be null !");
            }
            if (LscConfiguration.getSecurity().getEncryption() == null) {
                throw new RuntimeException("lsc>security>encryption node of the LSC configuration cannot be null !");
            }
            encryptionInstance = new SymmetricEncryption(LscConfiguration.getSecurity().getEncryption());
        }
        return encryptionInstance;
    }

    public static String decrypt(String value) throws GeneralSecurityException, IOException {
        SymmetricEncryption se = SecurityUtils.getEncryptionInstance();
        if (!se.initialize()) {
            throw new RuntimeException("SecurityUtils: Error initializing SymmetricEncryption!");
        }
        return new String(se.decrypt(new Base64().decode(value.getBytes())));
    }

    public static String encrypt(String value) throws GeneralSecurityException, IOException {
        SymmetricEncryption se = SecurityUtils.getEncryptionInstance();
        if (!se.initialize()) {
            throw new RuntimeException("SecurityUtils: Error initializing SymmetricEncryption!");
        }
        return new String(new Base64().encode(se.encrypt(value.getBytes())));
    }

    public static String hash(String type, String value) throws NoSuchAlgorithmException {
        byte[] data = value.getBytes();
        byte[] hash = MessageDigest.getInstance(type).digest(data);
        return new String(new Base64().encode(hash));
    }

    public static String computeSambaLMPassword(String password) throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] oemPwd = password.toUpperCase().getBytes("US-ASCII");
        int pwdLength = Math.min(oemPwd.length, 14);
        byte[] p14 = new byte[14];
        System.arraycopy(oemPwd, 0, p14, 0, pwdLength);
        byte[] constantKGS = "KGS!@#$%".getBytes("US-ASCII");
        byte[] lmHash = new byte[16];
        Key lowKey = SecurityUtils.createDESKey(p14, 0);
        Key highKey = SecurityUtils.createDESKey(p14, 7);
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, lowKey);
        byte[] lowHash = des.doFinal(constantKGS);
        des.init(1, highKey);
        byte[] highHash = des.doFinal(constantKGS);
        System.arraycopy(lowHash, 0, lmHash, 0, 8);
        System.arraycopy(highHash, 0, lmHash, 8, 8);
        return SecurityUtils.bytesToHexString(lmHash);
    }

    public static String computeSambaNTPassword(String password) throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        byte[] unicodePassword = password.getBytes("UnicodeLittleUnmarked");
        MessageDigest md4 = MessageDigest.getInstance("MD4", (Provider)new BouncyCastleProvider());
        byte[] ntHash = md4.digest(unicodePassword);
        return SecurityUtils.bytesToHexString(ntHash);
    }

    private static final String bytesToHexString(byte[] bytes) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int hex = 0xFF & bytes[i];
            Object tmp = Integer.toHexString(hex);
            tmp = ((String)tmp).length() < 2 ? "0" + (String)tmp : tmp;
            hexString.append((String)tmp);
        }
        return hexString.toString().toUpperCase();
    }

    private static Key createDESKey(byte[] bytes, int offset) {
        byte[] keyBytes = new byte[7];
        System.arraycopy(bytes, offset, keyBytes, 0, 7);
        byte[] material = new byte[]{keyBytes[0], (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1), (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2), (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3), (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4), (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5), (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6), (byte)(keyBytes[6] << 1)};
        SecurityUtils.oddParity(material);
        return new SecretKeySpec(material, "DES");
    }

    private static void oddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            boolean needsParity;
            byte b = bytes[i];
            boolean bl = needsParity = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ b >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1);
                continue;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] & 0xFFFFFFFE);
        }
    }
}

