/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.factory;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.directory.api.util.Network;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.annotations.CreateConsumer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.security.CertificateUtil;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.sasl.MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmProvider;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncReplConfiguration;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumerImpl;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;

public final class ServerAnnotationProcessor {
    private ServerAnnotationProcessor() {
    }

    private static void createTransports(LdapServer ldapServer, CreateTransport[] transportBuilders) {
        if (transportBuilders.length != 0) {
            for (CreateTransport transportBuilder : transportBuilders) {
                List<Transport> transports = ServerAnnotationProcessor.createTransports(transportBuilder);
                for (Transport t : transports) {
                    ldapServer.addTransports(new Transport[]{t});
                }
            }
        } else {
            try {
                int port = ServerAnnotationProcessor.getFreePort();
                TcpTransport ldap = new TcpTransport(port);
                ldapServer.addTransports(new Transport[]{ldap});
            }
            catch (IOException port) {
                // empty catch block
            }
            try {
                int port = ServerAnnotationProcessor.getFreePort();
                TcpTransport ldaps = new TcpTransport(port);
                ldaps.setEnableSSL(true);
                ldapServer.addTransports(new Transport[]{ldaps});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static LdapServer instantiateLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        if (createLdapServer != null) {
            Class<?> ntlmProviderClass;
            LdapServer ldapServer = new LdapServer();
            ldapServer.setServiceName(createLdapServer.name());
            ServerAnnotationProcessor.createTransports(ldapServer, createLdapServer.transports());
            ldapServer.setDirectoryService(directoryService);
            directoryService.setAllowAnonymousAccess(createLdapServer.allowAnonymousAccess());
            ldapServer.setSaslHost(createLdapServer.saslHost());
            ldapServer.setSaslPrincipal(createLdapServer.saslPrincipal());
            if (!Strings.isEmpty((String)createLdapServer.keyStore())) {
                ldapServer.setKeystoreFile(createLdapServer.keyStore());
                ldapServer.setCertificatePassword(createLdapServer.certificatePassword());
            } else {
                try {
                    Object[] keyStoreFile = CertificateUtil.createTempKeyStore((String)"testStore", (char[])"secret".toCharArray());
                    ldapServer.setKeystoreFile(keyStoreFile.getAbsolutePath());
                    ldapServer.setCertificatePassword("secret");
                }
                catch (Exception keyStoreFile) {
                    // empty catch block
                }
            }
            for (Class<?> extOpClass : createLdapServer.extendedOpHandlers()) {
                try {
                    ExtendedOperationHandler extOpHandler = (ExtendedOperationHandler)extOpClass.newInstance();
                    ldapServer.addExtendedOperationHandler(extOpHandler);
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_690, (Object[])new Object[]{extOpClass.getName()}), e);
                }
            }
            for (SaslMechanism saslMech : createLdapServer.saslMechanisms()) {
                try {
                    MechanismHandler handler = (MechanismHandler)saslMech.implClass().newInstance();
                    ldapServer.addSaslMechanismHandler(saslMech.name(), handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_691, (Object[])new Object[]{saslMech.name(), saslMech.implClass().getName()}), e);
                }
            }
            NtlmMechanismHandler ntlmHandler = (NtlmMechanismHandler)ldapServer.getSaslMechanismHandlers().get("NTLM");
            if (ntlmHandler != null && (ntlmProviderClass = createLdapServer.ntlmProvider()) != null && ntlmProviderClass != Object.class) {
                try {
                    ntlmHandler.setNtlmProvider((NtlmProvider)ntlmProviderClass.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_692, (Object[])new Object[0]), e);
                }
            }
            ArrayList<String> realms = new ArrayList<String>();
            for (String s : createLdapServer.saslRealms()) {
                realms.add(s);
            }
            ldapServer.setSaslRealms(realms);
            if (createLdapServer.trustManagers() != null && createLdapServer.trustManagers().length > 0) {
                TrustManager[] trustManagers = new TrustManager[createLdapServer.trustManagers().length];
                for (int i = 0; i < createLdapServer.trustManagers().length; ++i) {
                    try {
                        trustManagers[i] = (TrustManager)createLdapServer.trustManagers()[i].newInstance();
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(I18n.err((I18n)I18n.ERR_751, (Object[])new Object[]{createLdapServer.trustManagers()[i].getName()}), e);
                    }
                }
                ldapServer.setTrustManagers(trustManagers);
            }
            return ldapServer;
        }
        return null;
    }

    public static LdapServer getLdapServer(DirectoryService directoryService) throws ClassNotFoundException {
        Object instance = AnnotationUtils.getInstance(CreateLdapServer.class);
        LdapServer ldapServer = null;
        if (instance != null) {
            CreateLdapServer createLdapServer = (CreateLdapServer)instance;
            ldapServer = ServerAnnotationProcessor.createLdapServer(createLdapServer, directoryService);
        }
        return ldapServer;
    }

    private static ReplicationConsumer createConsumer(CreateConsumer createConsumer) {
        ReplicationConsumerImpl consumer = new ReplicationConsumerImpl();
        SyncReplConfiguration config = new SyncReplConfiguration();
        String remoteHost = createConsumer.remoteHost();
        if (Strings.isEmpty((String)remoteHost)) {
            remoteHost = Network.LOOPBACK_HOSTNAME;
        }
        config.setRemoteHost(remoteHost);
        config.setRemotePort(createConsumer.remotePort());
        config.setReplUserDn(createConsumer.replUserDn());
        config.setReplUserPassword(Strings.getBytesUtf8((String)createConsumer.replUserPassword()));
        config.setUseTls(createConsumer.useTls());
        config.setBaseDn(createConsumer.baseDn());
        config.setRefreshInterval(createConsumer.refreshInterval());
        config.setStrictCertVerification(createConsumer.strictCertVerification());
        consumer.setConfig((ReplicationConsumerConfig)config);
        return consumer;
    }

    public static ReplicationConsumer createConsumer() throws ClassNotFoundException {
        Object instance = AnnotationUtils.getInstance(CreateConsumer.class);
        ReplicationConsumer consumer = null;
        if (instance != null) {
            CreateConsumer createConsumer = (CreateConsumer)instance;
            consumer = ServerAnnotationProcessor.createConsumer(createConsumer);
        }
        return consumer;
    }

    public static LdapServer createLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        LdapServer ldapServer = ServerAnnotationProcessor.instantiateLdapServer(createLdapServer, directoryService);
        if (ldapServer == null) {
            return null;
        }
        try {
            ldapServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ldapServer;
    }

    public static LdapServer createLdapServer(AnnotatedElement annotation, DirectoryService directoryService) {
        CreateLdapServer createLdapServer = annotation.getAnnotation(CreateLdapServer.class);
        return ServerAnnotationProcessor.createLdapServer(createLdapServer, directoryService);
    }

    private static Annotation getAnnotation(Class annotationClass) throws Exception {
        Method[] methods;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = stackTrace[0].getMethodName().equals("dumpThreads") ? 4 : 3;
        Class<?> classCaller = Class.forName(stackTrace[index].getClassName());
        String methodCaller = stackTrace[index].getMethodName();
        for (Method method : methods = classCaller.getMethods()) {
            Object annotation;
            if (!methodCaller.equals(method.getName()) || (annotation = method.getAnnotation(annotationClass)) == null) continue;
            return annotation;
        }
        return classCaller.getAnnotation(annotationClass);
    }

    private static List<Transport> createTransports(CreateTransport transportBuilder) {
        String protocol = transportBuilder.protocol();
        int port = transportBuilder.port();
        int nbThreads = transportBuilder.nbThreads();
        int backlog = transportBuilder.backlog();
        String address = transportBuilder.address();
        boolean clientAuth = transportBuilder.clientAuth();
        if (Strings.isEmpty((String)address)) {
            address = Network.LOOPBACK_HOSTNAME;
        }
        if (port <= 0) {
            try {
                port = ServerAnnotationProcessor.getFreePort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (protocol.equalsIgnoreCase("TCP") || protocol.equalsIgnoreCase("LDAP")) {
            TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
            return Collections.singletonList(tcp);
        }
        if (protocol.equalsIgnoreCase("LDAPS")) {
            TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
            tcp.setEnableSSL(true);
            tcp.setWantClientAuth(clientAuth);
            return Collections.singletonList(tcp);
        }
        if (protocol.equalsIgnoreCase("UDP")) {
            UdpTransport udp = new UdpTransport(address, port);
            return Collections.singletonList(udp);
        }
        if (protocol.equalsIgnoreCase("KRB") || protocol.equalsIgnoreCase("CPW")) {
            TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
            ArrayList<Transport> transports = new ArrayList<Transport>();
            transports.add((Transport)tcp);
            UdpTransport udp = new UdpTransport(address, port);
            transports.add((Transport)udp);
            return transports;
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_689, (Object[])new Object[]{protocol}));
    }

    private static int getFreePort() throws IOException {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }
}

