/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.ControlPanel;
import org.opends.guitools.controlpanel.ControlPanelLauncher;
import org.opends.guitools.controlpanel.util.ControlPanelLog;
import org.opends.quicksetup.SplashScreen;

class ControlPanelSplashScreen
extends SplashScreen {
    private static final long serialVersionUID = 4472839063380302713L;
    private static ControlPanel controlPanel;
    private static final Logger LOG;

    ControlPanelSplashScreen() {
    }

    public static void main(String[] args) {
        ControlPanelSplashScreen screen = new ControlPanelSplashScreen();
        screen.display(args);
    }

    @Override
    protected void constructApplication(String[] args) {
        try {
            controlPanel = new ControlPanel();
            controlPanel.initialize(args);
        }
        catch (Throwable t) {
            if (ControlPanelLog.isInitialized()) {
                LOG.log(Level.SEVERE, "Error launching GUI: " + t, t);
            }
            InternalError error = new InternalError("Failed to invoke initialize method");
            error.initCause(t);
            throw error;
        }
    }

    @Override
    protected void displayApplication() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.log(Level.INFO, "going to call createAndDisplayGUI.");
                    controlPanel.createAndDisplayGUI();
                    LOG.log(Level.INFO, "called createAndDisplayGUI.");
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error displaying GUI: " + t, t);
                    InternalError error = new InternalError("Failed to invoke display method");
                    error.initCause(t);
                    throw error;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error calling SwingUtilities.invokeAndWait: " + t, t);
                InternalError error = new InternalError("Failed to invoke SwingUtilities.invokeAndWait method");
                error.initCause(t);
                throw error;
            }
        }
    }

    static {
        LOG = Logger.getLogger(ControlPanelLauncher.class.getName());
    }
}

