/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.browser;

import java.util.ArrayList;
import java.util.HashMap;
import org.opends.guitools.controlpanel.browser.AbstractNodeTask;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;

class NodeSearcherQueue
implements Runnable {
    private String name;
    private ArrayList<AbstractNodeTask> waitingQueue = new ArrayList();
    private HashMap<BasicNode, AbstractNodeTask> workingList = new HashMap();
    private HashMap<BasicNode, BasicNode> cancelList = new HashMap();
    private ThreadGroup threadGroup;

    public NodeSearcherQueue(String name, int threadCount) {
        this.name = name;
        this.threadGroup = new ThreadGroup(name);
        for (int i = 0; i < threadCount; ++i) {
            Thread t = new Thread(this.threadGroup, this, name + "[" + i + "]");
            t.setPriority(1);
            t.start();
        }
    }

    public String getName() {
        return this.name;
    }

    public void shutdown() {
        this.threadGroup.interrupt();
    }

    public synchronized void queue(AbstractNodeTask nodeTask) {
        if (nodeTask == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.waitingQueue.add(nodeTask);
        this.notify();
    }

    public synchronized void cancelForNode(BasicNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument");
        }
        for (int i = this.waitingQueue.size() - 1; i >= 0; --i) {
            AbstractNodeTask task = this.waitingQueue.get(i);
            if (task.getNode() != node) continue;
            this.waitingQueue.remove(i);
        }
        AbstractNodeTask task = this.workingList.get(node);
        if (task != null) {
            this.cancelList.put(node, node);
            task.cancel();
        }
        this.notify();
    }

    public synchronized boolean isWorking(BasicNode node) {
        boolean isWorking = this.workingList.get(node) != null;
        return isWorking;
    }

    public synchronized void cancelAll() {
        this.waitingQueue.clear();
        for (BasicNode node : this.workingList.keySet()) {
            AbstractNodeTask task = this.workingList.get(node);
            this.cancelList.put(node, node);
            task.cancel();
        }
    }

    private synchronized AbstractNodeTask fetch() throws InterruptedException {
        AbstractNodeTask result = null;
        do {
            int i;
            int waitingSize = this.waitingQueue.size();
            for (i = 0; i < waitingSize && !this.canBeFetched(i); ++i) {
            }
            if (i == waitingSize) {
                this.wait();
                continue;
            }
            result = this.waitingQueue.get(i);
            this.waitingQueue.remove(i);
            this.workingList.put(result.getNode(), result);
        } while (result == null);
        return result;
    }

    private boolean canBeFetched(int i) {
        AbstractNodeTask task = this.waitingQueue.get(i);
        return this.workingList.get(task.getNode()) == null;
    }

    private synchronized void flush(AbstractNodeTask task) {
        if (task == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.workingList.remove(task.getNode());
        this.cancelList.remove(task.getNode());
        this.notify();
    }

    public int size() {
        return this.waitingQueue.size() + this.workingList.size();
    }

    @Override
    public void run() {
        boolean interrupted = false;
        while (!interrupted) {
            try {
                AbstractNodeTask task = this.fetch();
                task.run();
                this.flush(task);
            }
            catch (InterruptedException x) {
                interrupted = true;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

