/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.admin.ads.ADSContext;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;

public class BackendDescriptor {
    private final String backendID;
    private SortedSet<BaseDNDescriptor> baseDns;
    private SortedSet<IndexDescriptor> indexes;
    private SortedSet<VLVIndexDescriptor> vlvIndexes;
    private int entries;
    private final boolean isConfigBackend;
    private final boolean isEnabled;
    private CustomSearchResult monitoringEntry;
    private final Type type;
    private int hashCode;

    public BackendDescriptor(String backendID, Set<BaseDNDescriptor> baseDns, Set<IndexDescriptor> indexes, Set<VLVIndexDescriptor> vlvIndexes, int entries, boolean isEnabled, Type type) {
        this.backendID = backendID;
        this.entries = entries;
        this.isConfigBackend = this.isConfigBackend(backendID);
        this.type = type;
        this.isEnabled = isEnabled;
        this.updateBaseDnsAndIndexes(baseDns, indexes, vlvIndexes);
        this.recalculateHashCode();
    }

    public String getBackendID() {
        return this.backendID;
    }

    public SortedSet<BaseDNDescriptor> getBaseDns() {
        return this.baseDns;
    }

    public SortedSet<VLVIndexDescriptor> getVLVIndexes() {
        return this.vlvIndexes;
    }

    public SortedSet<IndexDescriptor> getIndexes() {
        return this.indexes;
    }

    public int getEntries() {
        return this.entries;
    }

    public boolean equals(Object v) {
        boolean equals = false;
        if (this != v) {
            if (v instanceof BackendDescriptor) {
                BackendDescriptor desc = (BackendDescriptor)v;
                boolean bl = equals = this.getBackendID().equals(desc.getBackendID()) && this.getEntries() == desc.getEntries();
                if (equals) {
                    equals = desc.getBaseDns().equals(this.getBaseDns());
                }
                if (equals) {
                    equals = desc.getIndexes().equals(this.getIndexes());
                }
                if (equals) {
                    equals = desc.getVLVIndexes().equals(this.getVLVIndexes());
                }
                if (equals) {
                    equals = this.getMonitoringEntry() == null ? desc.getMonitoringEntry() == null : this.getMonitoringEntry().equals(desc.getMonitoringEntry());
                }
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public CustomSearchResult getMonitoringEntry() {
        return this.monitoringEntry;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void recalculateHashCode() {
        this.hashCode = 0;
        for (BaseDNDescriptor baseDNDescriptor : this.getBaseDns()) {
            this.hashCode += baseDNDescriptor.hashCode();
        }
        this.hashCode += this.entries;
        for (IndexDescriptor indexDescriptor : this.indexes) {
            this.hashCode += indexDescriptor.hashCode();
        }
        for (VLVIndexDescriptor vLVIndexDescriptor : this.vlvIndexes) {
            this.hashCode += vLVIndexDescriptor.hashCode();
        }
    }

    private void updateBaseDnsAndIndexes(Set<BaseDNDescriptor> baseDns, Set<IndexDescriptor> indexes, Set<VLVIndexDescriptor> vlvIndexes) {
        for (BaseDNDescriptor baseDNDescriptor : baseDns) {
            baseDNDescriptor.setBackend(this);
        }
        this.baseDns = new TreeSet<BaseDNDescriptor>(baseDns);
        for (IndexDescriptor indexDescriptor : indexes) {
            indexDescriptor.setBackend(this);
        }
        this.indexes = new TreeSet<IndexDescriptor>(indexes);
        for (VLVIndexDescriptor vLVIndexDescriptor : vlvIndexes) {
            vLVIndexDescriptor.setBackend(this);
        }
        this.vlvIndexes = new TreeSet<VLVIndexDescriptor>(vlvIndexes);
    }

    private boolean isConfigBackend(String id) {
        return "tasks".equalsIgnoreCase(id) || "schema".equalsIgnoreCase(id) || "config".equalsIgnoreCase(id) || "monitor".equalsIgnoreCase(id) || "backup".equalsIgnoreCase(id) || ADSContext.getDefaultBackendName().equalsIgnoreCase(id) || "ads-truststore".equalsIgnoreCase(id) || "replicationchanges".equalsIgnoreCase(id);
    }

    public boolean isConfigBackend() {
        return this.isConfigBackend;
    }

    public void setEntries(int entries) {
        this.entries = entries;
        this.recalculateHashCode();
    }

    public void setMonitoringEntry(CustomSearchResult monitoringEntry) {
        this.monitoringEntry = monitoringEntry;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static enum Type {
        LOCAL_DB,
        LDIF,
        MEMORY,
        BACKUP,
        MONITOR,
        TASK,
        OTHER;

    }
}

