/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class BaseDNTableModel
extends SortableTableModel
implements Comparator<BaseDNDescriptor> {
    private static final long serialVersionUID = -5650762484071136983L;
    private HashSet<BaseDNDescriptor> data = new HashSet();
    private ServerDescriptor.ServerStatus serverStatus;
    private boolean isAuthenticated;
    private ArrayList<String[]> dataArray = new ArrayList();
    private String[] COLUMN_NAMES;
    private int sortColumn = 0;
    private boolean sortAscending = true;
    private boolean displayReplicationInformation;
    public static String NOT_AVAILABLE_SERVER_DOWN = "NOT_AVAILABLE_SERVER_DOWN";
    public static String NOT_AVAILABLE_AUTHENTICATION_REQUIRED = "NOT_AVAILABLE_AUTHENTICATION_REQUIRED";
    public static String NOT_AVAILABLE = "NOT_AVAILABLE";

    public BaseDNTableModel(boolean displayReplicationInformation) {
        this(displayReplicationInformation, true);
    }

    public BaseDNTableModel(boolean displayReplicationInformation, boolean wrapHeader) {
        this.displayReplicationInformation = displayReplicationInformation;
        this.COLUMN_NAMES = wrapHeader ? new String[]{this.getHeader(AdminToolMessages.INFO_BASEDN_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_BACKENDID_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_NUMBER_ENTRIES_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_REPLICATED_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_MISSING_CHANGES_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_AGE_OF_OLDEST_MISSING_CHANGE_COLUMN.get())} : new String[]{AdminToolMessages.INFO_BASEDN_COLUMN.get().toString(), AdminToolMessages.INFO_BACKENDID_COLUMN.get().toString(), AdminToolMessages.INFO_NUMBER_ENTRIES_COLUMN.get().toString(), AdminToolMessages.INFO_REPLICATED_COLUMN.get().toString(), AdminToolMessages.INFO_MISSING_CHANGES_COLUMN.get().toString(), AdminToolMessages.INFO_AGE_OF_OLDEST_MISSING_CHANGE_COLUMN.get().toString()};
    }

    public void setData(Set<BaseDNDescriptor> newData, ServerDescriptor.ServerStatus status, boolean isAuthenticated) {
        if (!newData.equals(this.data) || this.serverStatus != status || this.isAuthenticated != isAuthenticated) {
            this.serverStatus = status;
            this.isAuthenticated = isAuthenticated;
            this.data.clear();
            this.data.addAll(newData);
            this.updateDataArray();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    @Override
    public int compare(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        int result = 0;
        if (this.sortColumn == 0) {
            result = this.compareDns(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        }
        if (this.sortColumn == 1) {
            result = this.compareBackendIDs(desc1, desc2);
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 2) {
            result = this.compareEntries(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 3) {
            result = this.compareRepl(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 4) {
            result = this.compareMissingChanges(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 5) {
            result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
        }
        if (!this.sortAscending) {
            result = -result;
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return this.displayReplicationInformation ? 6 : 4;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataArray.get(row)[col];
    }

    private void updateDataArray() {
        TreeSet<BaseDNDescriptor> sortedSet = new TreeSet<BaseDNDescriptor>(this);
        sortedSet.addAll(this.data);
        this.dataArray.clear();
        for (BaseDNDescriptor desc : sortedSet) {
            String[] s = new String[]{Utilities.unescapeUtf8(desc.getDn().toString()), desc.getBackend().getBackendID(), this.getValueForEntries(desc), this.getStringForReplState(desc), this.getValueForMissingChanges(desc), this.getValueForOldestMissingChange(desc)};
            this.dataArray.add(s);
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.COLUMN_NAMES[col];
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    private int compareBackendIDs(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return desc1.getBackend().getBackendID().compareTo(desc2.getBackend().getBackendID());
    }

    private int compareEntries(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        int n1 = desc1.getEntries();
        int n2 = desc2.getEntries();
        return this.compareIntegers(n1, n2);
    }

    private int compareIntegers(int n1, int n2) {
        if (n1 == n2) {
            return 0;
        }
        if (n1 > n2) {
            return 1;
        }
        return -1;
    }

    private int compareLongs(long n1, long n2) {
        if (n1 == n2) {
            return 0;
        }
        if (n1 > n2) {
            return 1;
        }
        return -1;
    }

    private int compareDns(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return Utilities.unescapeUtf8(desc1.getDn().toString()).compareTo(Utilities.unescapeUtf8(desc2.getDn().toString()));
    }

    private int compareRepl(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return String.valueOf((Object)desc1.getType()).compareTo(String.valueOf((Object)desc2.getType()));
    }

    private int compareMissingChanges(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return this.compareIntegers(desc1.getMissingChanges(), desc2.getMissingChanges());
    }

    private int compareAgeOfOldestMissingChange(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return this.compareLongs(desc1.getAgeOfOldestMissingChange(), desc2.getAgeOfOldestMissingChange());
    }

    private String getValueForEntries(BaseDNDescriptor rep) {
        String returnValue = this.serverStatus != ServerDescriptor.ServerStatus.STARTED ? NOT_AVAILABLE_SERVER_DOWN : (!this.isAuthenticated ? NOT_AVAILABLE_AUTHENTICATION_REQUIRED : (rep.getEntries() < 0 ? NOT_AVAILABLE : String.valueOf(rep.getEntries())));
        return returnValue;
    }

    private String getValueForMissingChanges(BaseDNDescriptor rep) {
        String returnValue = rep.getType() == BaseDNDescriptor.Type.REPLICATED ? (this.serverStatus != ServerDescriptor.ServerStatus.STARTED ? NOT_AVAILABLE_SERVER_DOWN : (!this.isAuthenticated ? NOT_AVAILABLE_AUTHENTICATION_REQUIRED : (rep.getMissingChanges() < 0 ? NOT_AVAILABLE : String.valueOf(rep.getMissingChanges())))) : AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get().toString();
        return returnValue;
    }

    private String getValueForOldestMissingChange(BaseDNDescriptor rep) {
        String returnValue;
        if (rep.getType() == BaseDNDescriptor.Type.REPLICATED) {
            if (this.serverStatus != ServerDescriptor.ServerStatus.STARTED) {
                returnValue = NOT_AVAILABLE_SERVER_DOWN;
            } else if (!this.isAuthenticated) {
                returnValue = NOT_AVAILABLE_AUTHENTICATION_REQUIRED;
            } else {
                long age = rep.getAgeOfOldestMissingChange();
                if (age > 0L) {
                    Date date = new Date(age);
                    returnValue = date.toString();
                } else {
                    returnValue = NOT_AVAILABLE;
                }
            }
        } else {
            returnValue = AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get().toString();
        }
        return returnValue;
    }

    private String getStringForReplState(BaseDNDescriptor rep) {
        Message s = rep.getType() == BaseDNDescriptor.Type.REPLICATED ? AdminToolMessages.INFO_BASEDN_REPLICATED_LABEL.get() : (rep.getType() == BaseDNDescriptor.Type.NOT_REPLICATED ? AdminToolMessages.INFO_BASEDN_NOT_REPLICATED_LABEL.get() : AdminToolMessages.INFO_BASEDN_DISABLED_LABEL.get());
        return s.toString();
    }
}

