/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.io.File;
import java.text.ParseException;
import org.opends.server.util.Base64;

public class BinaryValue {
    private Type type;
    private String base64;
    private byte[] bytes;
    private File file;
    private int hashCode;

    private BinaryValue() {
    }

    public static BinaryValue createBase64(String base64) throws ParseException {
        BinaryValue value = new BinaryValue();
        value.type = Type.BASE64_STRING;
        value.base64 = base64;
        value.bytes = value.getBytes();
        value.hashCode = base64.hashCode();
        return value;
    }

    public static BinaryValue createBase64(byte[] bytes) {
        BinaryValue value = new BinaryValue();
        value.type = Type.BASE64_STRING;
        value.bytes = bytes;
        value.base64 = value.getBase64();
        value.hashCode = value.base64.hashCode();
        return value;
    }

    public static BinaryValue createFromFile(byte[] bytes, File file) {
        BinaryValue value = new BinaryValue();
        value.type = Type.BYTE_ARRAY;
        value.bytes = bytes;
        value.base64 = value.getBase64();
        value.hashCode = value.base64.hashCode();
        value.file = file;
        return value;
    }

    public String getBase64() {
        if (this.base64 == null && this.bytes != null) {
            this.base64 = Base64.encode(this.bytes);
        }
        return this.base64;
    }

    public byte[] getBytes() throws ParseException {
        if (this.bytes == null && this.base64 != null) {
            this.bytes = Base64.decode(this.base64);
        }
        return this.bytes;
    }

    public Type getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o != null) {
            boolean bl = equals = this == o;
            if (!equals && (equals = o instanceof BinaryValue)) {
                BinaryValue candidate = (BinaryValue)o;
                boolean bl2 = equals = candidate.getType() == this.getType();
                if (equals) {
                    equals = this.file == null ? candidate.getFile() == null : (candidate.getFile() != null ? this.file.equals(candidate.getFile()) : false);
                }
                if (equals) {
                    if (this.type == Type.BASE64_STRING) {
                        equals = candidate.getBase64().equals(this.getBase64());
                    } else {
                        try {
                            equals = candidate.getBytes().length == this.getBytes().length;
                            for (int i = 0; i < this.getBytes().length && equals; ++i) {
                                equals = this.bytes[i] == candidate.getBytes()[i];
                            }
                        }
                        catch (ParseException pe) {
                            throw new RuntimeException("Unexpected error getting bytes: " + pe, pe);
                        }
                    }
                }
            }
        }
        return equals;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum Type {
        BASE64_STRING,
        BYTE_ARRAY;

    }
}

