/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.StaticUtils;

public class CustomSearchResult
implements Comparable<CustomSearchResult> {
    private String dn;
    private Map<String, List<Object>> attributes;
    private SortedSet<String> attrNames;
    private String toString;
    private int hashCode;

    public CustomSearchResult(String dn) {
        this.dn = dn;
        this.attributes = new HashMap<String, List<Object>>();
        this.attrNames = new TreeSet<String>();
        this.toString = this.calculateToString();
        this.hashCode = this.calculateHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomSearchResult(SearchResult sr, String baseDN) throws NamingException {
        Name name;
        String sName = sr.getName();
        if (baseDN != null && baseDN.length() > 0) {
            if (sName != null && sName.length() > 0) {
                name = new CompositeName(sName);
                name.add(baseDN);
            } else {
                name = Utilities.getJNDIName(baseDN);
            }
        } else {
            name = new CompositeName(sName);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < name.size(); ++i) {
            String n = name.get(i);
            if (buf.length() != 0 && n != null && n.length() > 0) {
                buf.append(",");
            }
            if (n == null || n.length() <= 0) continue;
            buf.append(n);
        }
        this.dn = buf.toString();
        this.attributes = new HashMap<String, List<Object>>();
        this.attrNames = new TreeSet<String>();
        Attributes attrs = sr.getAttributes();
        if (attrs != null) {
            NamingEnumeration<? extends javax.naming.directory.Attribute> en = attrs.getAll();
            try {
                while (en.hasMore()) {
                    javax.naming.directory.Attribute attr = en.next();
                    String attrName = attr.getID();
                    this.attrNames.add(attrName);
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (int i = 0; i < attr.size(); ++i) {
                        Object v = attr.get(i);
                        if ("".equals(v.toString())) continue;
                        values.add(v);
                    }
                    this.attributes.put(attrName.toLowerCase(), values);
                }
            }
            finally {
                en.close();
            }
        }
        this.toString = this.calculateToString();
        this.hashCode = this.calculateHashCode();
    }

    public String getDN() {
        return this.dn;
    }

    public List<Object> getAttributeValues(String name) {
        List<Object> values = this.attributes.get(name.toLowerCase());
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    public SortedSet<String> getAttributeNames() {
        return this.attrNames;
    }

    @Override
    public int compareTo(CustomSearchResult o) {
        int compareTo = this.equals(o) ? 0 : this.toString().compareTo(o.toString());
        return compareTo;
    }

    public CustomSearchResult duplicate() {
        CustomSearchResult sr = new CustomSearchResult(this.dn);
        sr.attributes = new HashMap<String, List<Object>>(this.attributes);
        sr.attrNames = new TreeSet<String>(this.attrNames);
        sr.toString = this.toString;
        sr.hashCode = this.hashCode;
        return sr;
    }

    public boolean equals(Object o) {
        boolean equals;
        block3: {
            equals = false;
            if (o == null) break block3;
            boolean bl = equals = o == this;
            if (!equals && o instanceof CustomSearchResult) {
                CustomSearchResult sr = (CustomSearchResult)o;
                equals = this.getDN().equals(sr.getDN());
                if (equals && (equals = this.getAttributeNames().equals(sr.getAttributeNames()))) {
                    String attrName;
                    Iterator i$ = this.getAttributeNames().iterator();
                    while (i$.hasNext() && (equals = this.getAttributeValues(attrName = (String)i$.next()).equals(sr.getAttributeValues(attrName)))) {
                    }
                }
            }
        }
        return equals;
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void set(String attrName, List<Object> values) {
        this.attrNames.add(attrName);
        attrName = attrName.toLowerCase();
        this.attributes.put(attrName, values);
        this.toString = this.calculateToString();
        this.hashCode = this.calculateHashCode();
    }

    private String calculateToString() {
        return "dn: " + this.dn + "\nattributes: " + this.attributes;
    }

    private int calculateHashCode() {
        return 23 + this.toString.hashCode();
    }

    public Entry getEntry() throws OpenDsException {
        DN dn = DN.decode(this.getDN());
        HashMap<ObjectClass, String> objectClasses = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> userAttributes = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> operationalAttributes = new HashMap<AttributeType, List<Attribute>>();
        for (String wholeName : this.getAttributeNames()) {
            Attribute attribute = LDIFReader.parseAttrDescription(wholeName);
            String attrName = attribute.getName();
            String lowerName = StaticUtils.toLowerCase(attrName);
            if (lowerName.equals("objectclass")) {
                for (Object value : this.getAttributeValues(attrName)) {
                    String ocName = value.toString().trim();
                    String lowerOCName = StaticUtils.toLowerCase(ocName);
                    ObjectClass objectClass = DirectoryServer.getObjectClass(lowerOCName);
                    if (objectClass == null) {
                        objectClass = DirectoryServer.getDefaultObjectClass(ocName);
                    }
                    objectClasses.put(objectClass, ocName);
                }
                continue;
            }
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(attrName);
            }
            AttributeBuilder builder = new AttributeBuilder(attribute, true);
            for (Object value : this.getAttributeValues(attrName)) {
                ByteString bs = value instanceof byte[] ? ByteString.wrap((byte[])value) : ByteString.valueOf(value.toString());
                AttributeValue attributeValue = AttributeValues.create(attrType, bs);
                builder.add(attributeValue);
            }
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(builder.toAttribute());
            if (attrType.isOperational()) {
                operationalAttributes.put(attrType, attrList);
                continue;
            }
            userAttributes.put(attrType, attrList);
        }
        return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
    }
}

