/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public abstract class MonitoringTableModel<T, P>
extends SortableTableModel
implements Comparator<P> {
    private static final long serialVersionUID = -3974562860632179025L;
    private Set<P> data = new HashSet<P>();
    private ArrayList<String[]> dataArray = new ArrayList();
    private ArrayList<P> dataSourceArray = new ArrayList();
    private boolean showAverages;
    private long runningTime;
    private String[] columnNames = new String[0];
    private Message NO_VALUE_SET = AdminToolMessages.INFO_CTRL_PANEL_NO_MONITORING_VALUE.get();
    private Message NOT_IMPLEMENTED = AdminToolMessages.INFO_CTRL_PANEL_NOT_IMPLEMENTED.get();
    private LinkedHashSet<MonitoringAttributes> attributes = new LinkedHashSet();
    private int sortColumn = 0;
    private boolean sortAscending = true;

    protected boolean addTotalRow() {
        return true;
    }

    public void setData(Set<T> newData, long runningTime) {
        this.runningTime = runningTime;
        Set<P> newInternalData = this.convertToInternalData(newData);
        if (!newInternalData.equals(this.data) || this.showAverages) {
            this.data.clear();
            this.data.addAll(newInternalData);
            this.updateDataArray();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    public void forceDataStructureChange() {
        this.updateDataArray();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataArray.get(row)[col];
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public Collection<MonitoringAttributes> getAttributes() {
        return this.attributes;
    }

    protected abstract Message getNameHeader();

    public void setAttributes(LinkedHashSet<MonitoringAttributes> attributes, boolean showAverages) {
        this.showAverages = showAverages;
        this.attributes.clear();
        this.attributes.addAll(attributes);
        int columnCount = attributes.size() + 1;
        if (showAverages) {
            for (MonitoringAttributes attr : attributes) {
                if (!attr.canHaveAverage()) continue;
                ++columnCount;
            }
        }
        this.columnNames = new String[columnCount];
        this.columnNames[0] = this.getHeader(this.getNameHeader());
        int i = 1;
        for (MonitoringAttributes attribute : attributes) {
            this.columnNames[i] = this.getHeader(attribute.getMessage(), 15);
            if (showAverages && attribute.canHaveAverage()) {
                this.columnNames[++i] = this.getAverageHeader(attribute);
            }
            ++i;
        }
    }

    private void updateDataArray() {
        TreeSet<P> sortedSet = new TreeSet<P>(this);
        sortedSet.addAll(this.data);
        this.dataArray.clear();
        this.dataSourceArray.clear();
        for (Object ach : sortedSet) {
            String[] s = this.getLine(ach);
            this.dataArray.add(s);
            this.dataSourceArray.add(ach);
        }
        if (this.addTotalRow()) {
            String[] line = new String[this.columnNames.length];
            line[0] = "<html><b>" + AdminToolMessages.INFO_CTRL_PANEL_TOTAL_LABEL.get().toString() + "</b>";
            for (int i = 1; i < line.length; ++i) {
                boolean valueSet = false;
                boolean notImplemented = false;
                long totalValue = 0L;
                for (int j = 0; j < this.dataArray.size(); ++j) {
                    String[] l = this.dataArray.get(j);
                    String value = l[i];
                    try {
                        long v = Long.parseLong(value);
                        totalValue += v;
                        valueSet = true;
                        continue;
                    }
                    catch (Throwable t) {
                        notImplemented = this.NOT_IMPLEMENTED.toString().equals(value);
                    }
                }
                line[i] = notImplemented ? this.NOT_IMPLEMENTED.toString() : (valueSet ? String.valueOf(totalValue) : this.NO_VALUE_SET.toString());
            }
            this.dataArray.add(line);
        }
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected abstract Set<P> convertToInternalData(Set<T> var1);

    protected abstract String getName(P var1);

    protected abstract CustomSearchResult getMonitoringEntry(P var1);

    private String[] getLine(P o) {
        String[] line = new String[this.columnNames.length];
        line[0] = this.getName(o);
        int i = 1;
        CustomSearchResult monitoringEntry = this.getMonitoringEntry(o);
        for (MonitoringAttributes attribute : this.attributes) {
            line[i] = Utilities.getMonitoringValue(attribute, monitoringEntry);
            if (this.showAverages && attribute.canHaveAverage()) {
                ++i;
                try {
                    if (this.runningTime > 0L) {
                        long v = Long.parseLong(line[i - 1]);
                        long average = 1000L * v / this.runningTime;
                        String s = String.valueOf(average);
                        int index = s.indexOf(".");
                        if (index != -1 && index + 3 < s.length()) {
                            s = s.substring(0, index + 3);
                        }
                        line[i] = s;
                    } else {
                        line[i] = this.NO_VALUE_SET.toString();
                    }
                }
                catch (Throwable t) {
                    line[i] = this.NO_VALUE_SET.toString();
                }
            }
            ++i;
        }
        return line;
    }

    private String getAverageHeader(MonitoringAttributes attr) {
        return this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_AVERAGE_HEADER.get(attr.getMessage().toString()), 15);
    }

    protected Object getFirstMonitoringValue(CustomSearchResult sr, String attrName) {
        return Utilities.getFirstMonitoringValue(sr, attrName);
    }

    protected ArrayList<Integer> getMonitoringPossibleResults(CustomSearchResult monitor1, CustomSearchResult monitor2) {
        ArrayList<Integer> possibleResults = new ArrayList<Integer>();
        for (MonitoringAttributes operation : this.getAttributes()) {
            int possibleResult;
            if (monitor1 == null) {
                possibleResult = monitor2 == null ? 0 : -1;
            } else if (monitor2 == null) {
                possibleResult = 1;
            } else {
                double n2;
                double n1;
                Object v1 = null;
                Object v2 = null;
                for (String attrName : monitor1.getAttributeNames()) {
                    if (!operation.getAttributeName().equalsIgnoreCase(attrName)) continue;
                    v1 = this.getFirstMonitoringValue(monitor1, attrName);
                    break;
                }
                for (String attrName : monitor2.getAttributeNames()) {
                    if (!operation.getAttributeName().equalsIgnoreCase(attrName)) continue;
                    v2 = this.getFirstMonitoringValue(monitor2, attrName);
                    break;
                }
                possibleResult = v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : (v1 instanceof Number ? (v2 instanceof Number ? (v1 instanceof Double || v2 instanceof Double ? ((n1 = ((Number)v1).doubleValue()) > (n2 = ((Number)v2).doubleValue()) ? 1 : (n1 < n2 ? -1 : 0)) : ((n1 = ((Number)v1).longValue()) > (n2 = ((Number)v2).longValue()) ? 1 : (n1 < n2 ? -1 : 0))) : 1) : (v2 instanceof Number ? -1 : v1.toString().compareTo(v2.toString()))));
            }
            possibleResults.add(possibleResult);
        }
        return possibleResults;
    }
}

