/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

public class NewSchemaElementsTask
extends Task {
    LinkedHashSet<ObjectClass> ocsToAdd = new LinkedHashSet();
    LinkedHashSet<AttributeType> attrsToAdd = new LinkedHashSet();

    public NewSchemaElementsTask(ControlPanelInfo info, ProgressDialog dlg, LinkedHashSet<ObjectClass> ocsToAdd, LinkedHashSet<AttributeType> attrsToAdd) {
        super(info, dlg);
        this.ocsToAdd.addAll(ocsToAdd);
        this.attrsToAdd.addAll(attrsToAdd);
    }

    @Override
    public Set<String> getBackends() {
        return Collections.emptySet();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING && (taskToBeLaunched.getType() == Task.Type.DELETE_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.MODIFY_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.NEW_SCHEMA_ELEMENT)) {
            incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
            canLaunch = false;
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.updateSchema();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.NEW_SCHEMA_ELEMENT;
    }

    @Override
    public Message getTaskDescription() {
        if (this.attrsToAdd.size() == 1 && this.ocsToAdd.isEmpty()) {
            String attributeName = ((AttributeType)this.attrsToAdd.iterator().next()).getNameOrOID();
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_ATTRIBUTE_TASK_DESCRIPTION.get(attributeName);
        }
        if (this.ocsToAdd.size() == 1 && this.attrsToAdd.isEmpty()) {
            String ocName = ((ObjectClass)this.ocsToAdd.iterator().next()).getNameOrOID();
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASS_TASK_DESCRIPTION.get(ocName);
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        for (AttributeType attribute : this.attrsToAdd) {
            attrNames.add(attribute.getNameOrOID());
        }
        ArrayList<String> ocNames = new ArrayList<String>();
        for (ObjectClass oc : this.ocsToAdd) {
            ocNames.add(oc.getNameOrOID());
        }
        if (ocNames.isEmpty()) {
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_ATTRIBUTES_TASK_DESCRIPTION.get(Utils.getStringFromCollection(attrNames, ", "));
        }
        if (attrNames.isEmpty()) {
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_OBJECTCLASSES_TASK_DESCRIPTION.get(Utils.getStringFromCollection(ocNames, ", "));
        }
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_SCHEMA_ELEMENTS_TASK_DESCRIPTION.get(Utils.getStringFromCollection(attrNames, ", "), Utils.getStringFromCollection(ocNames, ", "));
    }

    private void updateSchema() throws OpenDsException {
        if (this.isServerRunning()) {
            this.updateSchemaOnline();
        } else {
            this.updateSchemaOffline();
        }
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    @Override
    protected List<String> getCommandLineArguments() {
        return Collections.emptyList();
    }

    private void updateSchemaOnline() throws OpenDsException {
        for (AttributeType attr : this.attrsToAdd) {
            this.addAttributeOnline(attr);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br><br>", ColorAndFontConstants.progressFont));
                }
            });
        }
        for (ObjectClass oc : this.ocsToAdd) {
            this.addObjectClassOnline(oc);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br><br>", ColorAndFontConstants.progressFont));
                }
            });
        }
    }

    private void updateSchemaOffline() throws OpenDsException {
        LinkedHashMap<String, ArrayList<AttributeType>> hmAttrs = new LinkedHashMap<String, ArrayList<AttributeType>>();
        for (AttributeType attr : this.attrsToAdd) {
            ArrayList<AttributeType> attrs;
            String fileName = this.getFileName(attr);
            if (fileName == null) {
                fileName = "";
            }
            if ((attrs = (ArrayList<AttributeType>)hmAttrs.get(fileName)) == null) {
                attrs = new ArrayList<AttributeType>();
                hmAttrs.put(fileName, attrs);
            }
            attrs.add(attr);
        }
        LinkedHashMap<String, ArrayList<ObjectClass>> hmOcs = new LinkedHashMap<String, ArrayList<ObjectClass>>();
        for (ObjectClass oc : this.ocsToAdd) {
            ArrayList<ObjectClass> ocs;
            String fileName = this.getFileName(oc);
            if (fileName == null) {
                fileName = "";
            }
            if ((ocs = (ArrayList<ObjectClass>)hmOcs.get(fileName)) == null) {
                ocs = new ArrayList<ObjectClass>();
                hmOcs.put(fileName, ocs);
            }
            ocs.add(oc);
        }
        LinkedHashSet allFileNames = new LinkedHashSet();
        allFileNames.addAll(hmAttrs.keySet());
        allFileNames.addAll(hmOcs.keySet());
        for (String fileName : allFileNames) {
            List<AttributeType> attrs = (List<AttributeType>)hmAttrs.get(fileName);
            List<ObjectClass> ocs = (List<ObjectClass>)hmOcs.get(fileName);
            if (attrs == null) {
                attrs = Collections.emptyList();
            }
            if (ocs == null) {
                ocs = Collections.emptyList();
            }
            if (fileName.equals("")) {
                fileName = null;
            }
            this.updateSchemaOffline(fileName, attrs, ocs);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br><br>", ColorAndFontConstants.progressFont));
                }
            });
        }
    }

    private void addAttributeOnline(final AttributeType attribute) throws OpenDsException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSchemaElementsTask.this.printEquivalentCommandLineToAddOnline(attribute);
                NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_ATTRIBUTE_PROGRESS.get(attribute.getNameOrOID()), ColorAndFontConstants.progressFont));
            }
        });
        try {
            BasicAttribute attr = new BasicAttribute(this.getAttributeName(attribute));
            attr.add(this.getValueOnline(attribute));
            ModificationItem mod = new ModificationItem(1, attr);
            this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
        }
        catch (NamingException ne) {
            throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
        }
        this.notifyConfigurationElementCreated(attribute);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
            }
        });
    }

    private void addObjectClassOnline(final ObjectClass objectClass) throws OpenDsException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSchemaElementsTask.this.printEquivalentCommandLineToAddOnline(objectClass);
                NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_PROGRESS.get(objectClass.getNameOrOID()), ColorAndFontConstants.progressFont));
            }
        });
        try {
            BasicAttribute attr = new BasicAttribute(this.getAttributeName(objectClass));
            attr.add(this.getValueOnline(objectClass));
            ModificationItem mod = new ModificationItem(1, attr);
            this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
        }
        catch (NamingException ne) {
            throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
        }
        this.notifyConfigurationElementCreated(objectClass);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
            }
        });
    }

    private String getValueOnline(CommonSchemaElements element) {
        return element.toString();
    }

    private String getValueOffline(CommonSchemaElements element) {
        Iterable<String> previousValues = element.getExtraProperty("X-SCHEMA-FILE");
        element.setExtraProperty("X-SCHEMA-FILE", (String)null);
        String attributeWithoutFileDefinition = element.toString();
        if (previousValues != null) {
            ArrayList<String> vs = new ArrayList<String>();
            for (String s : previousValues) {
                vs.add(s);
            }
            if (!vs.isEmpty()) {
                element.setExtraProperty("X-SCHEMA-FILE", vs);
            }
        }
        return attributeWithoutFileDefinition;
    }

    private void printEquivalentCommandLineToAddOnline(CommonSchemaElements element) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-a");
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(true, true)));
        args.add(this.getNoPropertiesFileArgument());
        String equiv = NewSchemaElementsTask.getEquivalentCommandLine(this.getCommandLinePath("ldapmodify"), args);
        StringBuilder sb = new StringBuilder();
        Message msg = element instanceof AttributeType ? AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_ATTRIBUTE_ONLINE.get(element.getNameOrOID()) : AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_OBJECTCLASS_ONLINE.get(element.getNameOrOID());
        sb.append(msg).append("<br><b>");
        sb.append(equiv);
        sb.append("<br>");
        sb.append("dn: cn=schema<br>");
        sb.append("changetype: modify<br>");
        sb.append("add: ").append(this.getAttributeName(element)).append("<br>");
        sb.append(this.getAttributeName(element)).append(": ").append(this.getValueOnline(element));
        sb.append("</b><br><br>");
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(sb.toString(), ColorAndFontConstants.progressFont));
    }

    private String getAttributeName(CommonSchemaElements element) {
        if (element instanceof AttributeType) {
            return "attributeTypes";
        }
        return "objectClasses";
    }

    private String getFileName(CommonSchemaElements element) {
        String value = null;
        Iterable<String> vs = element.getExtraProperty("X-SCHEMA-FILE");
        if (vs != null && vs.iterator().hasNext()) {
            value = vs.iterator().next();
        }
        return value;
    }

    private void updateSchemaOffline(String file, final List<AttributeType> attributes, final List<ObjectClass> objectClasses) throws OpenDsException {
        File f;
        if (file == null) {
            file = "99-user.ldif";
        }
        if (!(f = new File(file)).isAbsolute()) {
            f = new File(DirectoryServer.getEnvironmentConfig().getSchemaDirectory(), file);
        }
        final String fileName = f.getAbsolutePath();
        final boolean isSchemaFileDefined = this.isSchemaFileDefined(fileName);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSchemaElementsTask.this.printEquivalentCommandToAddOffline(fileName, isSchemaFileDefined, attributes, objectClasses);
                if (attributes.size() == 1 && objectClasses.isEmpty()) {
                    String attributeName = ((AttributeType)attributes.get(0)).getNameOrOID();
                    NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_ATTRIBUTE_PROGRESS.get(attributeName), ColorAndFontConstants.progressFont));
                } else if (objectClasses.size() == 1 && attributes.isEmpty()) {
                    String ocName = ((ObjectClass)objectClasses.get(0)).getNameOrOID();
                    NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_OBJECTCLASS_PROGRESS.get(ocName), ColorAndFontConstants.progressFont));
                } else {
                    NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_UPDATING_SCHEMA_FILE_PROGRESS.get(fileName), ColorAndFontConstants.progressFont));
                }
            }
        });
        this.updateSchemaFile(fileName, isSchemaFileDefined, attributes, objectClasses);
        for (AttributeType attr : attributes) {
            this.notifyConfigurationElementCreated(attr);
        }
        for (ObjectClass oc : objectClasses) {
            this.notifyConfigurationElementCreated(oc);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
            }
        });
    }

    private void printEquivalentCommandToAddOffline(String schemaFile, boolean isSchemaFileDefined, List<AttributeType> attributes, List<ObjectClass> objectClasses) {
        StringBuilder sb;
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeType attr : attributes) {
            names.add(attr.getNameOrOID());
        }
        for (ObjectClass oc : objectClasses) {
            names.add(oc.getNameOrOID());
        }
        if (isSchemaFileDefined) {
            sb = new StringBuilder();
            sb.append(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_SCHEMA_ELEMENT_OFFLINE.get(Utils.getStringFromCollection(names, ", "), schemaFile)).append("<br><b>");
            for (AttributeType attribute : attributes) {
                sb.append(this.getAttributeName(attribute)).append(": ").append(this.getValueOffline(attribute)).append("<br>");
            }
            for (ObjectClass oc : objectClasses) {
                sb.append(this.getAttributeName(oc)).append(": ").append(this.getValueOffline(oc)).append("<br>");
            }
            sb.append("</b><br><br>");
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(sb.toString(), ColorAndFontConstants.progressFont));
        } else {
            sb = new StringBuilder();
            sb.append(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ADD_SCHEMA_ENTRY_OFFLINE.get(Utils.getStringFromCollection(names, ", "), schemaFile)).append("<br><b>");
            for (String line : this.getSchemaEntryLines()) {
                sb.append(line);
                sb.append("<br>");
            }
            for (AttributeType attribute : attributes) {
                sb.append(this.getAttributeName(attribute)).append(": ").append(this.getValueOffline(attribute)).append("<br>");
            }
            for (ObjectClass oc : objectClasses) {
                sb.append(this.getAttributeName(oc)).append(": ").append(this.getValueOffline(oc)).append("<br>");
            }
            sb.append("</b><br><br>");
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(sb.toString(), ColorAndFontConstants.progressFont));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isSchemaFileDefined(String schemaFile) {
        LDIFReader reader;
        boolean schemaDefined;
        block4: {
            schemaDefined = false;
            reader = null;
            try {
                reader = new LDIFReader(new LDIFImportConfig(schemaFile));
                Entry entry = reader.readEntry();
                if (entry == null) break block4;
                schemaDefined = true;
            }
            catch (Throwable throwable) {
                StaticUtils.close(reader);
                catch (Throwable throwable2) {
                    StaticUtils.close(reader);
                    throw throwable2;
                }
            }
        }
        StaticUtils.close(reader);
        return schemaDefined;
    }

    private ArrayList<String> getSchemaEntryLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("dn: cn=schema");
        lines.add("objectClass: top");
        lines.add("objectClass: ldapSubentry");
        lines.add("objectClass: subschema");
        return lines;
    }

    private void updateSchemaFile(String schemaFile, boolean isSchemaFileDefined, List<AttributeType> attributes, List<ObjectClass> objectClasses) throws OpenDsException {
        block14: {
            block13: {
                if (!isSchemaFileDefined) break block13;
                LDIFExportConfig exportConfig = new LDIFExportConfig(schemaFile, ExistingFileBehavior.OVERWRITE);
                LDIFReader reader = null;
                LDIFWriter writer = null;
                try {
                    Modification mod;
                    reader = new LDIFReader(new LDIFImportConfig(schemaFile));
                    Entry schemaEntry = reader.readEntry();
                    for (AttributeType attribute : attributes) {
                        mod = new Modification(ModificationType.ADD, Attributes.create(this.getAttributeName(attribute).toLowerCase(), this.getValueOffline(attribute)));
                        schemaEntry.applyModification(mod);
                    }
                    for (ObjectClass oc : objectClasses) {
                        mod = new Modification(ModificationType.ADD, Attributes.create(this.getAttributeName(oc).toLowerCase(), this.getValueOffline(oc)));
                        schemaEntry.applyModification(mod);
                    }
                    writer = new LDIFWriter(exportConfig);
                    writer.writeEntry(schemaEntry);
                    exportConfig.getWriter().newLine();
                }
                catch (Throwable t) {
                    try {
                        throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(t.toString()), t);
                    }
                    catch (Throwable throwable) {
                        StaticUtils.close(reader, exportConfig, writer);
                        throw throwable;
                    }
                }
                StaticUtils.close(reader, exportConfig, writer);
                break block14;
            }
            LDIFExportConfig exportConfig = new LDIFExportConfig(schemaFile, ExistingFileBehavior.FAIL);
            try {
                ArrayList<String> lines = this.getSchemaEntryLines();
                for (AttributeType attribute : attributes) {
                    lines.add(this.getAttributeName(attribute) + ": " + this.getValueOffline(attribute));
                }
                for (ObjectClass oc : objectClasses) {
                    lines.add(this.getAttributeName(oc) + ": " + this.getValueOffline(oc));
                }
                for (String line : lines) {
                    LDIFWriter.writeLDIFLine(new StringBuilder(line), exportConfig.getWriter(), exportConfig.getWrapColumn() > 1, exportConfig.getWrapColumn());
                }
                exportConfig.getWriter().newLine();
            }
            catch (Throwable t) {
                try {
                    throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(t.toString()), t);
                }
                catch (Throwable throwable) {
                    StaticUtils.close(exportConfig);
                    throw throwable;
                }
            }
            StaticUtils.close(exportConfig);
        }
    }
}

