/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.IndexComboBoxCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.VLVSortOrderRenderer;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.meta.LocalDBVLVIndexCfgDefn;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.FilterType;
import org.opends.server.types.LDAPException;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RawFilter;
import org.opends.server.types.Schema;
import org.opends.server.util.ServerConstants;

public abstract class AbstractVLVIndexPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -82857384664911898L;
    protected TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    protected JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_NAME_LABEL.get());
    protected JLabel lBaseDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_BASE_DN_LABEL.get());
    protected JLabel lSearchScope = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_SEARCH_SCOPE_LABEL.get());
    protected JLabel lFilter = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_FILTER_LABEL.get());
    protected JLabel lSortOrder = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_SORT_ORDER_LABEL.get());
    protected JLabel lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
    protected JLabel lMaxBlockSize = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_MAX_BLOCK_SIZE_LABEL.get());
    protected JTextField name = Utilities.createMediumTextField();
    protected JLabel readOnlyName = Utilities.createDefaultLabel();
    protected JLabel backendName = Utilities.createDefaultLabel();
    protected JComboBox baseDNs = Utilities.createComboBox();
    protected JTextField baseDN = Utilities.createLongTextField();
    protected JRadioButton baseObject = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_BASE_OBJECT_LABEL.get());
    protected JRadioButton singleLevel = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_SINGLE_LEVEL_LABEL.get());
    protected JRadioButton subordinateSubtree = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_SUBORDINATE_SUBTREE_LABEL.get());
    protected JRadioButton wholeSubtree = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_WHOLE_SUBTREE_LABEL.get());
    protected JTextField filter = Utilities.createLongTextField();
    protected JTextField maxBlockSize = Utilities.createShortTextField();
    protected JComboBox attributes = Utilities.createComboBox();
    protected JList sortOrder = new JList();
    protected JButton add = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_ADD_BUTTON_LABEL.get());
    protected JButton moveUp = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_MOVE_UP_BUTTON_LABEL.get());
    protected JButton moveDown = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_MOVE_DOWN_BUTTON_LABEL.get());
    protected JButton remove = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_REMOVE_BUTTON_LABEL.get());
    protected JComboBox ascendingOrder = Utilities.createComboBox();
    protected DefaultListModel sortOrderModel;
    protected JLabel[] labels = new JLabel[]{this.lName, this.lBaseDN, this.lSearchScope, this.lFilter, this.lSortOrder, this.lBackend, this.lMaxBlockSize};
    protected Component relativeComponent;
    protected final Message OTHER_BASE_DN = AdminToolMessages.INFO_CTRL_PANEL_VLV_OTHER_BASE_DN_LABEL.get();
    protected final Message ASCENDING = AdminToolMessages.INFO_CTRL_PANEL_VLV_ASCENDING_LABEL.get();
    protected final Message DESCENDING = AdminToolMessages.INFO_CTRL_PANEL_VLV_DESCENDING_LABEL.get();
    protected Message CUSTOM_ATTRIBUTES = AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_ATTRIBUTES_LABEL.get();
    protected Message STANDARD_ATTRIBUTES = AdminToolMessages.INFO_CTRL_PANEL_STANDARD_ATTRIBUTES_LABEL.get();
    protected TreeSet<String> standardAttrNames = new TreeSet<String>(new LowerCaseComparator());
    protected TreeSet<String> configurationAttrNames = new TreeSet<String>(new LowerCaseComparator());
    protected TreeSet<String> customAttrNames = new TreeSet<String>(new LowerCaseComparator());
    private int defaultVLVEntryLimitValue;
    protected final int MIN_MAX_BLOCK_SIZE;
    protected final int MAX_MAX_BLOCK_SIZE = Integer.MAX_VALUE;
    protected final int DEFAULT_MAX_BLOCK_SIZE;

    protected AbstractVLVIndexPanel(String backendID, Component relativeComponent) {
        DefinedDefaultBehaviorProvider provider = (DefinedDefaultBehaviorProvider)LocalDBVLVIndexCfgDefn.getInstance().getMaxBlockSizePropertyDefinition().getDefaultBehaviorProvider();
        this.defaultVLVEntryLimitValue = Integer.parseInt(provider.getDefaultValues().iterator().next());
        this.MIN_MAX_BLOCK_SIZE = LocalDBVLVIndexCfgDefn.getInstance().getMaxBlockSizePropertyDefinition().getLowerLimit();
        this.MAX_MAX_BLOCK_SIZE = Integer.MAX_VALUE;
        this.DEFAULT_MAX_BLOCK_SIZE = this.defaultVLVEntryLimitValue;
        if (backendID != null) {
            this.backendName.setText(backendID);
        }
        this.relativeComponent = relativeComponent;
    }

    public void setBackendName(String backendID) {
        this.backendName.setText(backendID);
    }

    protected String getIndexLDIF(String indexName) {
        String dn = Utilities.getRDNString("ds-cfg-backend-id", this.backendName.getText()) + ",cn=Backends,cn=config";
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("dn: " + Utilities.getRDNString("ds-cfg-name", indexName) + ",cn=VLV Index," + dn);
        lines.add("objectClass: ds-cfg-local-db-vlv-index");
        lines.add("objectClass: top");
        lines.add("ds-cfg-name: " + indexName);
        lines.add("ds-cfg-filter: " + this.filter.getText().trim());
        lines.add("ds-cfg-sort-order: " + this.getSortOrderStringValue(this.getSortOrder()));
        lines.add("ds-cfg-base-dn: " + this.getBaseDN());
        lines.add("ds-cfg-scope: " + this.getScope().toString());
        lines.add("ds-cfg-max-block-size: " + this.maxBlockSize.getText().trim());
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line + ServerConstants.EOL);
        }
        return sb.toString();
    }

    protected LocalDBVLVIndexCfgDefn.Scope getScope() {
        LocalDBVLVIndexCfgDefn.Scope scope = this.baseObject.isSelected() ? LocalDBVLVIndexCfgDefn.Scope.BASE_OBJECT : (this.singleLevel.isSelected() ? LocalDBVLVIndexCfgDefn.Scope.SINGLE_LEVEL : (this.subordinateSubtree.isSelected() ? LocalDBVLVIndexCfgDefn.Scope.SUBORDINATE_SUBTREE : LocalDBVLVIndexCfgDefn.Scope.WHOLE_SUBTREE));
        return scope;
    }

    protected List<VLVSortOrder> getSortOrder() {
        ArrayList<VLVSortOrder> sortOrder = new ArrayList<VLVSortOrder>();
        for (int i = 0; i < this.sortOrderModel.getSize(); ++i) {
            sortOrder.add((VLVSortOrder)this.sortOrderModel.get(i));
        }
        return sortOrder;
    }

    protected String getSortOrderStringValue(List<VLVSortOrder> sortOrder) {
        StringBuilder sb = new StringBuilder();
        for (VLVSortOrder s : sortOrder) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (s.isAscending()) {
                sb.append("+");
            } else {
                sb.append("-");
            }
            sb.append(s.getAttributeName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateLayout(ServerDescriptor desc) {
        Schema schema = desc.getSchema();
        BackendDescriptor backend = this.getBackend();
        final boolean[] repack = new boolean[]{false};
        final boolean[] error = new boolean[]{false};
        if (backend != null) {
            this.updateBaseDNCombo(backend);
        }
        if (schema != null) {
            repack[0] = this.attributes.getItemCount() == 0;
            LinkedHashSet<CategorizedComboBoxElement> newElements = new LinkedHashSet<CategorizedComboBoxElement>();
            TreeSet<String> treeSet = this.standardAttrNames;
            synchronized (treeSet) {
                this.standardAttrNames.clear();
                this.configurationAttrNames.clear();
                this.customAttrNames.clear();
                for (AttributeType attr : schema.getAttributeTypes().values()) {
                    String name = attr.getPrimaryName();
                    boolean defined = false;
                    ListModel model = this.sortOrder.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        VLVSortOrder s = (VLVSortOrder)model.getElementAt(i);
                        if (!name.equalsIgnoreCase(s.getAttributeName())) continue;
                        defined = true;
                        break;
                    }
                    if (defined) continue;
                    if (Utilities.isStandard(attr)) {
                        this.standardAttrNames.add(name);
                        continue;
                    }
                    if (Utilities.isConfiguration(attr)) {
                        this.configurationAttrNames.add(name);
                        continue;
                    }
                    this.customAttrNames.add(name);
                }
            }
            if (this.customAttrNames.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.CUSTOM_ATTRIBUTES, CategorizedComboBoxElement.Type.CATEGORY));
                for (String attrName : this.customAttrNames) {
                    newElements.add(new CategorizedComboBoxElement(attrName, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            if (this.standardAttrNames.size() > 0) {
                newElements.add(new CategorizedComboBoxElement(this.STANDARD_ATTRIBUTES, CategorizedComboBoxElement.Type.CATEGORY));
                for (String attrName : this.standardAttrNames) {
                    newElements.add(new CategorizedComboBoxElement(attrName, CategorizedComboBoxElement.Type.REGULAR));
                }
            }
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.attributes.getModel();
            this.updateComboBoxModel(newElements, model);
        } else {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            repack[0] = true;
            error[0] = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractVLVIndexPanel.this.getButtonType() == GenericDialog.ButtonType.OK || AbstractVLVIndexPanel.this.getButtonType() == GenericDialog.ButtonType.OK) {
                    AbstractVLVIndexPanel.this.setEnabledOK(!error[0]);
                }
                AbstractVLVIndexPanel.this.errorPane.setVisible(error[0]);
                AbstractVLVIndexPanel.this.add.setEnabled(AbstractVLVIndexPanel.this.attributes.getModel().getSize() > 0);
                AbstractVLVIndexPanel.this.remove.setEnabled(AbstractVLVIndexPanel.this.sortOrder.getSelectedIndex() != -1);
                if (repack[0]) {
                    AbstractVLVIndexPanel.this.packParentDialog();
                    if (AbstractVLVIndexPanel.this.relativeComponent != null) {
                        Utilities.centerGoldenMean(Utilities.getParentDialog(AbstractVLVIndexPanel.this), AbstractVLVIndexPanel.this.relativeComponent);
                    }
                }
            }
        });
        return !error[0];
    }

    protected boolean checkIndexRequired() {
        boolean confirm = true;
        String f = this.filter.getText().trim();
        try {
            LDAPFilter ldapFilter = LDAPFilter.decode(f);
            ArrayList<Message> msgs = new ArrayList<Message>();
            this.updateIndexRequiredMessages(ldapFilter, msgs);
            if (!msgs.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Message msg : msgs) {
                    sb.append("<br>-" + msg);
                }
                confirm = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_NOT_DEFINED_CONFIRMATION_TITLE.get(), AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEXES_NOT_DEFINED_CONFIRMATION_MSG.get(this.getBackend().getBackendID(), sb.toString()));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected error: " + t, t);
        }
        return confirm;
    }

    private void updateIndexRequiredMessages(RawFilter filter, Collection<Message> msgs) {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                if (filter.getFilterComponents() == null) break;
                for (RawFilter f : filter.getFilterComponents()) {
                    this.updateIndexRequiredMessages(f, msgs);
                }
                break;
            }
            case NOT: {
                this.updateIndexRequiredMessages(filter.getNOTComponent(), msgs);
                break;
            }
            default: {
                FilterType[] filterTypes = new FilterType[]{FilterType.EQUALITY, FilterType.SUBSTRING, FilterType.GREATER_OR_EQUAL, FilterType.LESS_OR_EQUAL, FilterType.PRESENT, FilterType.APPROXIMATE_MATCH, FilterType.EXTENSIBLE_MATCH};
                LocalDBIndexCfgDefn.IndexType[] indexTypes = new LocalDBIndexCfgDefn.IndexType[]{LocalDBIndexCfgDefn.IndexType.EQUALITY, LocalDBIndexCfgDefn.IndexType.SUBSTRING, LocalDBIndexCfgDefn.IndexType.ORDERING, LocalDBIndexCfgDefn.IndexType.ORDERING, LocalDBIndexCfgDefn.IndexType.PRESENCE, LocalDBIndexCfgDefn.IndexType.APPROXIMATE, null};
                Message[] indexTypeNames = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_EQUALITY_TYPE.get(), AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_SUBSTRING_TYPE.get(), AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_ORDERING_TYPE.get(), AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_ORDERING_TYPE.get(), AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_PRESENCE_TYPE.get(), AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_APPROXIMATE_TYPE.get(), null};
                for (int i = 0; i < filterTypes.length; ++i) {
                    Object type;
                    if (filterTypes[i] != filter.getFilterType()) continue;
                    IndexDescriptor index = this.getIndex(filter.getAttributeType());
                    if (index != null) {
                        type = indexTypes[i];
                        if (type == null || index.getTypes().contains(type)) continue;
                        msgs.add(AdminToolMessages.INFO_CTRL_PANEL_MUST_UPDATE_INDEX_DEFINITION_TYPE.get(filter.getAttributeType(), indexTypeNames[i]));
                        continue;
                    }
                    type = indexTypeNames[i];
                    if (type != null) {
                        msgs.add(AdminToolMessages.INFO_CTRL_PANEL_MUST_DEFINE_INDEX_TYPE.get(filter.getAttributeType(), (CharSequence)type));
                        continue;
                    }
                    msgs.add(AdminToolMessages.INFO_CTRL_PANEL_MUST_DEFINE_INDEX.get(filter.getAttributeType()));
                }
            }
        }
    }

    private IndexDescriptor getIndex(String indexName) {
        IndexDescriptor index = null;
        BackendDescriptor backend = this.getBackend();
        if (backend != null) {
            for (IndexDescriptor i : backend.getIndexes()) {
                if (!i.getName().equalsIgnoreCase(indexName)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    protected void updateBaseDNCombo(BackendDescriptor backend) {
        ArrayList<CharSequence> newElements = new ArrayList<CharSequence>();
        for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
            String dn = null;
            try {
                dn = Utilities.unescapeUtf8(baseDN.getDn().toString());
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected error: " + t, t);
            }
            newElements.add(dn);
        }
        newElements.add("----------");
        newElements.add(this.OTHER_BASE_DN);
        this.updateComboBoxModel(newElements, (DefaultComboBoxModel)this.baseDNs.getModel());
    }

    protected List<Message> checkErrors(boolean checkName) {
        String baseDN;
        for (JLabel l : this.labels) {
            this.setPrimaryValid(l);
        }
        BackendDescriptor backend = this.getBackend();
        ArrayList<Message> errors = new ArrayList<Message>();
        if (checkName) {
            String n = this.name.getText();
            if (n.trim().length() == 0) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_VLV_INDEX_NAME_PROVIDED.get());
                this.setPrimaryInvalid(this.lName);
            } else if (backend != null) {
                for (VLVIndexDescriptor index : backend.getVLVIndexes()) {
                    if (!index.getName().equalsIgnoreCase(n)) continue;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_VLV_INDEX_ALREADY_DEFINED.get(n, this.backendName.getText()));
                    this.setPrimaryInvalid(this.lName);
                    break;
                }
            }
        }
        if ((baseDN = this.getBaseDN()) == null || baseDN.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BASE_DN_FOR_VLV_PROVIDED.get());
            this.setPrimaryInvalid(this.lBaseDN);
        } else {
            try {
                DN.decode(baseDN);
            }
            catch (OpenDsException oe) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_BASE_DN_FOR_VLV_PROVIDED.get(oe.getMessageObject().toString()));
                this.setPrimaryInvalid(this.lBaseDN);
            }
        }
        String f = this.filter.getText().trim();
        if (f.equals("")) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_FILTER_FOR_VLV_PROVIDED.get());
            this.setPrimaryInvalid(this.lFilter);
        } else {
            try {
                LDAPFilter.decode(f);
            }
            catch (LDAPException le) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_FILTER_FOR_VLV_PROVIDED.get(le.getMessageObject().toString()));
                this.setPrimaryInvalid(this.lFilter);
            }
        }
        if (this.sortOrder.getModel().getSize() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_ATTRIBUTE_FOR_VLV_PROVIDED.get());
            this.setPrimaryInvalid(this.lSortOrder);
        }
        String v = this.maxBlockSize.getText();
        try {
            int n = Integer.parseInt(v);
            if (n < this.MIN_MAX_BLOCK_SIZE || n > Integer.MAX_VALUE) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_MAX_BLOCK_SIZE_FOR_VLV_PROVIDED.get(this.MIN_MAX_BLOCK_SIZE, Integer.MAX_VALUE));
                this.setPrimaryInvalid(this.lMaxBlockSize);
            }
        }
        catch (Throwable t) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_MAX_BLOCK_SIZE_FOR_VLV_PROVIDED.get(this.MIN_MAX_BLOCK_SIZE, Integer.MAX_VALUE));
            this.setPrimaryInvalid(this.lMaxBlockSize);
        }
        return errors;
    }

    protected BackendDescriptor getBackend() {
        BackendDescriptor backend = null;
        for (BackendDescriptor b : this.getInfo().getServerDescriptor().getBackends()) {
            if (!b.getBackendID().equalsIgnoreCase(this.backendName.getText())) continue;
            backend = b;
            break;
        }
        return backend;
    }

    protected String getBaseDN() {
        Object selectedItem = this.baseDNs.getSelectedItem();
        if (this.OTHER_BASE_DN.equals(selectedItem)) {
            selectedItem = this.baseDN.getText().trim();
        }
        if (selectedItem != null) {
            return selectedItem.toString();
        }
        return null;
    }

    protected String getSelectedAttribute() {
        CategorizedComboBoxElement o = (CategorizedComboBoxElement)this.attributes.getSelectedItem();
        String attrName = o != null ? o.getValue().toString() : null;
        return attrName;
    }

    protected void createBasicLayout(Container c, GridBagConstraints gbc, boolean nameReadOnly) {
        JButton[] buttons;
        JPanel p;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(c, gbc);
        if (nameReadOnly) {
            ++gbc.gridy;
            this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_VLV_INDEX_DETAILS_LABEL.get());
            gbc.fill = 0;
            gbc.anchor = 17;
            gbc.insets.top = 10;
            c.add((Component)this.titlePanel, gbc);
        }
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        c.add((Component)this.lName, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        if (nameReadOnly) {
            c.add((Component)this.readOnlyName, gbc);
        } else {
            p = new JPanel(new GridBagLayout());
            p.setOpaque(false);
            c.add((Component)p, gbc);
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.weightx = 0.3;
            gbc2.fill = 2;
            gbc2.gridwidth = -1;
            p.add((Component)this.name, gbc2);
            gbc2.gridwidth = 0;
            gbc2.weightx = 0.7;
            p.add(Box.createHorizontalGlue(), gbc2);
        }
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridx = 0;
        c.add((Component)this.lBackend, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        c.add((Component)this.backendName, gbc);
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        c.add((Component)this.lBaseDN, gbc);
        gbc.anchor = 17;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        c.add((Component)p, gbc);
        ++gbc.gridy;
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(new Object[]{"----------", this.OTHER_BASE_DN});
        this.baseDNs.setModel(model);
        this.baseDNs.setRenderer(new CustomListCellRenderer(this.baseDNs));
        StatusGenericPanel.IgnoreItemListener listener = new StatusGenericPanel.IgnoreItemListener(this, this.baseDNs);
        this.baseDNs.addItemListener(listener);
        this.baseDNs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                AbstractVLVIndexPanel.this.baseDN.setEnabled(AbstractVLVIndexPanel.this.OTHER_BASE_DN.equals(AbstractVLVIndexPanel.this.baseDNs.getSelectedItem()));
            }
        });
        listener.itemStateChanged(null);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        p.add((Component)this.baseDNs, gbc2);
        gbc2.gridwidth = 0;
        gbc2.weightx = 1.0;
        gbc2.insets.left = 5;
        p.add((Component)this.baseDN, gbc2);
        gbc2.insets.top = 3;
        JLabel inlineHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SUBTREE_INLINE_HELP_LABEL.get());
        p.add((Component)inlineHelp, gbc2);
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        c.add((Component)this.lSearchScope, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        JRadioButton[] radios = new JRadioButton[]{this.baseObject, this.singleLevel, this.subordinateSubtree, this.wholeSubtree};
        this.singleLevel.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        for (JRadioButton radio : radios) {
            c.add((Component)radio, gbc);
            group.add(radio);
            gbc.insets.top = 5;
            ++gbc.gridy;
        }
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        c.add((Component)this.lFilter, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        c.add((Component)this.filter, gbc);
        ++gbc.gridy;
        gbc.insets.top = 3;
        inlineHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_FILTER_INLINE_HELP_LABEL.get());
        c.add((Component)inlineHelp, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        c.add((Component)this.lMaxBlockSize, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.fill = 2;
        c.add((Component)this.maxBlockSize, gbc);
        this.maxBlockSize.setText(String.valueOf(this.DEFAULT_MAX_BLOCK_SIZE));
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        c.add((Component)this.lSortOrder, gbc);
        gbc.fill = 2;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.attributes.addItemListener(new StatusGenericPanel.IgnoreItemListener(this, this.attributes));
        this.attributes.setRenderer(new IndexComboBoxCellRenderer(this.attributes));
        c.add((Component)this.attributes, gbc);
        ++gbc.gridx;
        this.ascendingOrder.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.ASCENDING, this.DESCENDING}));
        c.add((Component)this.ascendingOrder, gbc);
        ++gbc.gridy;
        final ListSelectionListener listListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                int[] indexes = AbstractVLVIndexPanel.this.sortOrder.getSelectedIndices();
                if (indexes != null && indexes.length > 0) {
                    AbstractVLVIndexPanel.this.moveUp.setEnabled(indexes[0] != 0);
                    AbstractVLVIndexPanel.this.moveDown.setEnabled(indexes[indexes.length - 1] != AbstractVLVIndexPanel.this.sortOrder.getModel().getSize() - 1);
                    AbstractVLVIndexPanel.this.remove.setEnabled(true);
                } else {
                    AbstractVLVIndexPanel.this.moveUp.setEnabled(false);
                    AbstractVLVIndexPanel.this.moveUp.setEnabled(false);
                    AbstractVLVIndexPanel.this.remove.setEnabled(false);
                }
            }
        };
        for (JButton button : buttons = new JButton[]{this.add, this.remove, this.moveUp, this.moveDown}) {
            button.setOpaque(false);
            button.setEnabled(false);
        }
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String attr = AbstractVLVIndexPanel.this.getSelectedAttribute();
                if (attr != null) {
                    boolean isAscending = AbstractVLVIndexPanel.this.ASCENDING == AbstractVLVIndexPanel.this.ascendingOrder.getSelectedItem();
                    AbstractVLVIndexPanel.this.sortOrderModel.addElement(new VLVSortOrder(attr, isAscending));
                    DefaultComboBoxModel model = (DefaultComboBoxModel)AbstractVLVIndexPanel.this.attributes.getModel();
                    int i = AbstractVLVIndexPanel.this.attributes.getSelectedIndex();
                    if (i > 0) {
                        CategorizedComboBoxElement o;
                        int j;
                        int newIndex = -1;
                        for (j = i - 1; j > 0 && newIndex == -1; --j) {
                            o = (CategorizedComboBoxElement)model.getElementAt(j);
                            if (o.getType() != CategorizedComboBoxElement.Type.REGULAR) continue;
                            newIndex = j;
                        }
                        if (newIndex == -1) {
                            for (j = i + 1; j < model.getSize() && newIndex == -1; ++j) {
                                o = (CategorizedComboBoxElement)model.getElementAt(j);
                                if (o.getType() != CategorizedComboBoxElement.Type.REGULAR) continue;
                                newIndex = j;
                            }
                        }
                        if (newIndex != -1) {
                            AbstractVLVIndexPanel.this.attributes.setSelectedIndex(newIndex);
                        }
                        model.removeElementAt(i);
                    }
                }
                listListener.valueChanged(null);
            }
        });
        this.moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int[] indexes = AbstractVLVIndexPanel.this.sortOrder.getSelectedIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    Object o1 = AbstractVLVIndexPanel.this.sortOrderModel.elementAt(indexes[i] - 1);
                    Object o2 = AbstractVLVIndexPanel.this.sortOrderModel.elementAt(indexes[i]);
                    AbstractVLVIndexPanel.this.sortOrderModel.set(indexes[i] - 1, o2);
                    AbstractVLVIndexPanel.this.sortOrderModel.set(indexes[i], o1);
                    indexes[i] = indexes[i] - 1;
                }
                AbstractVLVIndexPanel.this.sortOrder.setSelectedIndices(indexes);
                listListener.valueChanged(null);
            }
        });
        this.moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int[] indexes = AbstractVLVIndexPanel.this.sortOrder.getSelectedIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    Object o1 = AbstractVLVIndexPanel.this.sortOrderModel.elementAt(indexes[i] + 1);
                    Object o2 = AbstractVLVIndexPanel.this.sortOrderModel.elementAt(indexes[i]);
                    AbstractVLVIndexPanel.this.sortOrderModel.set(indexes[i] + 1, o2);
                    AbstractVLVIndexPanel.this.sortOrderModel.set(indexes[i], o1);
                    indexes[i] = indexes[i] + 1;
                }
                AbstractVLVIndexPanel.this.sortOrder.setSelectedIndices(indexes);
                listListener.valueChanged(null);
            }
        });
        this.remove.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ev) {
                int[] indexes = AbstractVLVIndexPanel.this.sortOrder.getSelectedIndices();
                TreeSet<String> treeSet = AbstractVLVIndexPanel.this.standardAttrNames;
                synchronized (treeSet) {
                    DefaultComboBoxModel model = (DefaultComboBoxModel)AbstractVLVIndexPanel.this.attributes.getModel();
                    block3: for (int i = 0; i < indexes.length; ++i) {
                        VLVSortOrder sortOrder = (VLVSortOrder)AbstractVLVIndexPanel.this.sortOrderModel.getElementAt(indexes[i]);
                        String attrName = sortOrder.getAttributeName();
                        boolean isCustom = AbstractVLVIndexPanel.this.customAttrNames.contains(attrName);
                        boolean dealingWithCustom = true;
                        for (int j = 0; j < model.getSize(); ++j) {
                            CategorizedComboBoxElement o = (CategorizedComboBoxElement)model.getElementAt(j);
                            if (o.getType() == CategorizedComboBoxElement.Type.REGULAR) {
                                if (dealingWithCustom != isCustom || attrName.compareTo(o.getValue().toString()) >= 0) continue;
                                model.insertElementAt(new CategorizedComboBoxElement(attrName, CategorizedComboBoxElement.Type.REGULAR), j);
                                continue block3;
                            }
                            if (o.getValue().equals(AbstractVLVIndexPanel.this.CUSTOM_ATTRIBUTES)) continue;
                            dealingWithCustom = false;
                            if (!isCustom) continue;
                            model.insertElementAt(new CategorizedComboBoxElement(attrName, CategorizedComboBoxElement.Type.REGULAR), j);
                            continue block3;
                        }
                    }
                }
                for (int i = indexes.length - 1; i >= 0; --i) {
                    AbstractVLVIndexPanel.this.sortOrderModel.remove(indexes[i]);
                }
                listListener.valueChanged(null);
            }
        });
        gbc.insets.top = 5;
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.anchor = 13;
        c.add((Component)this.add, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.sortOrderModel = new DefaultListModel();
        this.sortOrder.setModel(this.sortOrderModel);
        this.sortOrder.setCellRenderer(new VLVSortOrderRenderer(this.sortOrder));
        this.sortOrder.setVisibleRowCount(6);
        this.sortOrder.setPrototypeCellValue("AjA");
        c.add((Component)Utilities.createScrollPane(this.sortOrder), gbc);
        this.sortOrder.addListSelectionListener(listListener);
        gbc.gridx = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        gbc.insets.left = 5;
        gbc.fill = 2;
        gbc.anchor = 17;
        c.add((Component)this.moveUp, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        c.add((Component)this.moveDown, gbc);
        gbc.insets.top = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        Dimension d = new Dimension(Math.max(this.moveUp.getPreferredSize().width, this.moveDown.getPreferredSize().width), Math.max(this.moveUp.getPreferredSize().height, this.moveDown.getPreferredSize().height));
        this.moveUp.setPreferredSize(d);
        this.moveDown.setPreferredSize(d);
        c.add(Box.createVerticalGlue(), gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        c.add((Component)this.remove, gbc);
    }
}

