/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.event.BrowseActionListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Schema;

public class BinaryAttributeEditorPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -877248486446244170L;
    private JRadioButton useFile;
    private JRadioButton useBase64;
    private JTextField file;
    private JButton browse;
    private JLabel lFile;
    private JTextField base64;
    private JLabel imagePreview;
    private JButton refreshButton;
    private JLabel lImage = Utilities.createDefaultLabel();
    private JLabel attrName;
    private BinaryValue value;
    private boolean valueChanged;
    private static final int MAX_IMAGE_HEIGHT = 300;
    private static final int MAX_BASE64_TO_DISPLAY = 3072;
    private static final Logger LOG = Logger.getLogger(BinaryAttributeEditorPanel.class.getName());

    public BinaryAttributeEditorPanel() {
        this.createLayout();
    }

    public void setValue(final String attrName, final BinaryValue value) {
        boolean launchBackground = this.value != value;
        BackgroundTask<Void> worker = new BackgroundTask<Void>(){

            @Override
            public Void processBackgroundTask() throws Throwable {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                BinaryAttributeEditorPanel.this.valueChanged = false;
                BinaryAttributeEditorPanel.this.attrName.setText(attrName);
                if (BinaryAttributeEditorPanel.this.hasImageSyntax(attrName)) {
                    if (value != null) {
                        BinaryAttributeEditorPanel.updateImage(BinaryAttributeEditorPanel.this.lImage, value.getBytes());
                    } else {
                        BinaryAttributeEditorPanel.this.lImage.setIcon(null);
                        BinaryAttributeEditorPanel.this.lImage.setText(AdminToolMessages.INFO_CTRL_PANEL_NO_VALUE_SPECIFIED.get().toString());
                    }
                    BinaryAttributeEditorPanel.this.setImageVisible(true);
                    BinaryAttributeEditorPanel.this.useFile.setSelected(true);
                    BinaryAttributeEditorPanel.this.base64.setText("");
                } else {
                    BinaryAttributeEditorPanel.this.lImage.setIcon(null);
                    BinaryAttributeEditorPanel.this.lImage.setText("");
                    BinaryAttributeEditorPanel.this.setImageVisible(false);
                    if (value != null) {
                        BinaryAttributeEditorPanel.updateBase64(BinaryAttributeEditorPanel.this.base64, value.getBytes());
                    }
                }
                if (value != null) {
                    if (value.getType() == BinaryValue.Type.BASE64_STRING) {
                        BinaryAttributeEditorPanel.this.file.setText("");
                    } else {
                        BinaryAttributeEditorPanel.this.file.setText(value.getFile().getAbsolutePath());
                        BinaryAttributeEditorPanel.this.useFile.setSelected(true);
                    }
                } else {
                    BinaryAttributeEditorPanel.this.base64.setText("");
                    BinaryAttributeEditorPanel.this.file.setText("");
                    BinaryAttributeEditorPanel.this.useFile.setSelected(true);
                }
                BinaryAttributeEditorPanel.this.value = value;
                return null;
            }

            @Override
            public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                BinaryAttributeEditorPanel.this.setPrimaryValid(BinaryAttributeEditorPanel.this.useFile);
                BinaryAttributeEditorPanel.this.setPrimaryValid(BinaryAttributeEditorPanel.this.useBase64);
                BinaryAttributeEditorPanel.this.attrName.setText(attrName);
                BinaryAttributeEditorPanel.this.setEnabledOK(true);
                BinaryAttributeEditorPanel.this.displayMainPanel();
                BinaryAttributeEditorPanel.this.updateEnabling();
                BinaryAttributeEditorPanel.this.packParentDialog();
                if (t != null) {
                    LOG.log(Level.WARNING, "Error reading binary contents: " + t, t);
                }
            }
        };
        if (launchBackground) {
            this.setEnabledOK(false);
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_SUMMARY.get());
            worker.startBackgroundTask();
        } else {
            this.setPrimaryValid(this.lFile);
            this.setPrimaryValid(this.useFile);
            this.setPrimaryValid(this.useBase64);
            this.attrName.setText(attrName);
            this.setEnabledOK(true);
            boolean isImage = this.hasImageSyntax(attrName);
            this.setImageVisible(isImage);
            if (value == null) {
                if (isImage) {
                    this.useFile.setSelected(true);
                } else {
                    this.useBase64.setSelected(true);
                }
            }
        }
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.file;
    }

    @Override
    public void cancelClicked() {
        this.valueChanged = false;
        super.cancelClicked();
    }

    public BinaryValue getBinaryValue() {
        return this.value;
    }

    @Override
    public void okClicked() {
        this.refresh(true, false);
    }

    private void refresh(final boolean closeAndUpdateValue, final boolean updateImage) {
        final ArrayList<Message> errors = new ArrayList<Message>();
        this.setPrimaryValid(this.useFile);
        this.setPrimaryValid(this.useBase64);
        final BinaryValue oldValue = this.value;
        if (closeAndUpdateValue) {
            this.value = null;
        }
        if (this.useFile.isSelected()) {
            String f = this.file.getText();
            if (f.trim().length() == 0) {
                if (!this.hasImageSyntax(this.attrName.getText()) || oldValue == null || updateImage) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_FILE_NOT_PROVIDED.get());
                    this.setPrimaryInvalid(this.useFile);
                    this.setPrimaryInvalid(this.lFile);
                }
            } else {
                File theFile = new File(f);
                if (!theFile.exists()) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_FILE_DOES_NOT_EXIST.get(f));
                    this.setPrimaryInvalid(this.useFile);
                    this.setPrimaryInvalid(this.lFile);
                } else if (theFile.isDirectory()) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_PATH_IS_A_DIRECTORY.get(f));
                    this.setPrimaryInvalid(this.useFile);
                    this.setPrimaryInvalid(this.lFile);
                } else if (!theFile.canRead()) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_CANNOT_READ_FILE.get(f));
                    this.setPrimaryInvalid(this.useFile);
                    this.setPrimaryInvalid(this.lFile);
                }
            }
        } else {
            String b = this.base64.getText();
            if (b.length() == 0) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_VALUE_IN_BASE_64_REQUIRED.get());
                this.setPrimaryInvalid(this.useBase64);
            }
        }
        if (errors.size() == 0) {
            BackgroundTask<BinaryValue> worker = new BackgroundTask<BinaryValue>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public BinaryValue processBackgroundTask() throws Throwable {
                    BinaryValue returnValue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (BinaryAttributeEditorPanel.this.useBase64.isSelected()) {
                        returnValue = BinaryValue.createBase64(BinaryAttributeEditorPanel.this.base64.getText());
                    } else if (BinaryAttributeEditorPanel.this.file.getText().trim().length() > 0) {
                        File f = new File(BinaryAttributeEditorPanel.this.file.getText());
                        FileInputStream in = null;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] bytes = new byte[2048];
                        try {
                            in = new FileInputStream(f);
                            boolean done = false;
                            while (!done) {
                                int len = in.read(bytes);
                                if (len == -1) {
                                    done = true;
                                    continue;
                                }
                                out.write(bytes, 0, len);
                            }
                            returnValue = BinaryValue.createFromFile(out.toByteArray(), f);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                            out.close();
                        }
                    } else {
                        returnValue = oldValue;
                    }
                    if (closeAndUpdateValue) {
                        BinaryAttributeEditorPanel.this.valueChanged = !returnValue.equals(oldValue);
                    }
                    if (updateImage) {
                        BinaryAttributeEditorPanel.updateImage(BinaryAttributeEditorPanel.this.lImage, returnValue.getBytes());
                    }
                    return returnValue;
                }

                @Override
                public void backgroundTaskCompleted(BinaryValue returnValue, Throwable t) {
                    BinaryAttributeEditorPanel.this.setEnabledOK(true);
                    BinaryAttributeEditorPanel.this.displayMainPanel();
                    if (closeAndUpdateValue) {
                        BinaryAttributeEditorPanel.this.value = returnValue;
                    } else {
                        BinaryAttributeEditorPanel.this.packParentDialog();
                    }
                    if (t != null) {
                        if (BinaryAttributeEditorPanel.this.useFile.isSelected()) {
                            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ERROR_READING_FILE.get(t.toString()));
                        } else {
                            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ERROR_DECODING_BASE_64.get(t.toString()));
                        }
                        BinaryAttributeEditorPanel.this.displayErrorDialog(errors);
                    } else if (closeAndUpdateValue) {
                        Utilities.getParentDialog(BinaryAttributeEditorPanel.this).setVisible(false);
                    }
                }
            };
            this.setEnabledOK(false);
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_SUMMARY.get());
            worker.startBackgroundTask();
        } else {
            this.displayErrorDialog(errors);
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_EDIT_BINARY_ATTRIBUTE_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public boolean valueChanged() {
        return this.valueChanged;
    }

    @Override
    public boolean requiresScroll() {
        return true;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NAME_LABEL.get());
        this.add((Component)l, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.attrName = Utilities.createDefaultLabel();
        gbc.gridwidth = 2;
        this.add((Component)this.attrName, gbc);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.fill = 2;
        this.useFile = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_USE_CONTENTS_OF_FILE.get());
        this.lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_USE_CONTENTS_OF_FILE.get());
        this.useFile.setFont(ColorAndFontConstants.primaryFont);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.useFile, gbc);
        this.add((Component)this.lFile, gbc);
        ++gbc.gridx;
        this.file = Utilities.createLongTextField();
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        this.add((Component)this.file, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.browse.addActionListener(new CustomBrowseActionListener(this.file, BrowseActionListener.BrowseType.OPEN_GENERIC_FILE, this));
        this.browse.setOpaque(false);
        this.add((Component)this.browse, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.gridwidth = 3;
        this.useBase64 = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_USE_CONTENTS_IN_BASE_64.get());
        this.useBase64.setFont(ColorAndFontConstants.primaryFont);
        this.add((Component)this.useBase64, gbc);
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.base64 = Utilities.createLongTextField();
        this.add((Component)this.base64, gbc);
        this.imagePreview = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_IMAGE_PREVIEW_LABEL.get());
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.imagePreview, gbc);
        this.refreshButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_REFRESH_BUTTON_LABEL.get());
        ++gbc.gridx;
        gbc.insets.left = 5;
        gbc.fill = 0;
        this.add((Component)this.refreshButton, gbc);
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        this.add(Box.createHorizontalGlue(), gbc);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BinaryAttributeEditorPanel.this.refreshButtonClicked();
            }
        });
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.lImage, gbc);
        this.addBottomGlue(gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.useFile);
        group.add(this.useBase64);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BinaryAttributeEditorPanel.this.updateEnabling();
            }
        };
        this.useFile.addActionListener(listener);
        this.useBase64.addActionListener(listener);
    }

    private void updateEnabling() {
        this.base64.setEnabled(this.useBase64.isSelected());
        this.file.setEnabled(this.useFile.isSelected());
        this.browse.setEnabled(this.useFile.isSelected());
        this.refreshButton.setEnabled(this.useFile.isSelected());
    }

    static void updateBase64(JTextComponent base64, byte[] bytes) {
        if (bytes.length < 3072) {
            BinaryValue value = BinaryValue.createBase64(bytes);
            base64.setText(value.getBase64());
        } else {
            base64.setText(AdminToolMessages.INFO_CTRL_PANEL_SPECIFY_CONTENTS_IN_BASE_64.get().toString());
        }
    }

    static void updateImage(JLabel lImage, byte[] bytes) {
        ImageIcon icon = Utilities.createImageIcon(bytes, 300, AdminToolMessages.INFO_CTRL_PANEL_IMAGE_OF_ATTRIBUTE_LABEL.get(), false);
        if (icon.getIconHeight() > 0) {
            lImage.setIcon(icon);
            lImage.setText("");
        } else {
            Utilities.setWarningLabel(lImage, AdminToolMessages.INFO_CTRL_PANEL_PREVIEW_NOT_AVAILABLE_LABEL.get());
        }
    }

    private void setImageVisible(boolean visible) {
        this.imagePreview.setVisible(visible);
        this.refreshButton.setVisible(visible);
        this.lFile.setVisible(visible);
        this.useFile.setVisible(!visible);
        this.useBase64.setVisible(!visible);
        this.base64.setVisible(!visible);
        this.lImage.setVisible(visible);
    }

    private void refreshButtonClicked() {
        this.refresh(false, true);
    }

    private boolean hasImageSyntax(String attrName) {
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        return Utilities.hasImageSyntax(attrName, schema);
    }

    class CustomBrowseActionListener
    extends BrowseActionListener {
        public CustomBrowseActionListener(JTextComponent field, BrowseActionListener.BrowseType type, Component parent) {
            super(field, type, parent);
        }

        @Override
        protected void fieldUpdated() {
            super.fieldUpdated();
            if (BinaryAttributeEditorPanel.this.refreshButton.isVisible()) {
                BinaryAttributeEditorPanel.this.refreshButtonClicked();
            }
        }
    }
}

