/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.util.Utils;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPException;

public abstract class InclusionExclusionPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -3826176895778069011L;
    protected JTextArea dnsToExclude;
    protected JTextField attributesToExclude;
    protected JTextField exclusionFilter;
    protected JTextArea dnsToInclude;
    protected JTextField attributesToInclude;
    protected JTextField inclusionFilter;
    protected JLabel lDnsToInclude;
    protected JLabel lAttributesToInclude;
    protected JLabel lInclusionFilter;
    protected JLabel lDnsToExclude;
    protected JLabel lAttributesToExclude;
    protected JLabel lExclusionFilter;

    @Override
    public void cancelClicked() {
        this.setPrimaryValid(this.lDnsToInclude);
        this.setPrimaryValid(this.lAttributesToInclude);
        this.setPrimaryValid(this.lInclusionFilter);
        this.setPrimaryValid(this.lDnsToExclude);
        this.setPrimaryValid(this.lAttributesToExclude);
        this.setPrimaryValid(this.lExclusionFilter);
        super.cancelClicked();
    }

    protected Component createDataInclusionOptions(final JLabel[] extraComponentLabels, final Component[] extraComponents) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        int labelInsetLeft = 15;
        final BasicExpander expander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_DATA_INCLUSION_OPTIONS.get());
        panel.add((Component)expander, gbc);
        ++gbc.gridy;
        this.lDnsToInclude = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DNS_TO_INCLUDE.get());
        gbc.insets.left = labelInsetLeft;
        gbc.anchor = 18;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        panel.add((Component)this.lDnsToInclude, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        this.dnsToInclude = Utilities.createTextArea(Message.EMPTY, 5, 25);
        final JScrollPane scrollDns = Utilities.createScrollPane(this.dnsToInclude);
        panel.add((Component)scrollDns, gbc);
        this.lDnsToInclude.setLabelFor(this.dnsToInclude);
        gbc.insets.top = 2;
        ++gbc.gridy;
        final JLabel lDnsExplanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATE_DNS_LINE_BREAK.get());
        panel.add((Component)lDnsExplanation, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.lAttributesToInclude = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTES_TO_INCLUDE.get());
        gbc.insets.left = labelInsetLeft;
        gbc.anchor = 18;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        panel.add((Component)this.lAttributesToInclude, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.weightx = 1.0;
        this.attributesToInclude = Utilities.createMediumTextField();
        panel.add((Component)this.attributesToInclude, gbc);
        this.lAttributesToInclude.setLabelFor(this.attributesToInclude);
        gbc.insets.top = 2;
        ++gbc.gridy;
        final JLabel lAttributesExplanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATE_ATTRIBUTES_COMMA.get());
        panel.add((Component)lAttributesExplanation, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.lInclusionFilter = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_INCLUSION_FILTER.get());
        gbc.insets.left = labelInsetLeft;
        gbc.anchor = 18;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        panel.add((Component)this.lInclusionFilter, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        this.inclusionFilter = Utilities.createMediumTextField();
        panel.add((Component)this.inclusionFilter, gbc);
        this.lInclusionFilter.setLabelFor(this.inclusionFilter);
        this.addExtraComponents(panel, extraComponentLabels, extraComponents, gbc, labelInsetLeft);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InclusionExclusionPanel.this.lDnsToInclude.setVisible(expander.isSelected());
                scrollDns.setVisible(expander.isSelected());
                lDnsExplanation.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.lAttributesToInclude.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.attributesToInclude.setVisible(expander.isSelected());
                lAttributesExplanation.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.lInclusionFilter.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.inclusionFilter.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.expanderStateChanged(expander, extraComponentLabels, extraComponents);
            }
        };
        expander.addChangeListener(changeListener);
        expander.setSelected(false);
        changeListener.stateChanged(null);
        return panel;
    }

    protected Component createDataExclusionOptions(final JLabel[] extraComponentLabels, final Component[] extraComponents) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        int labelInsetLeft = 15;
        final BasicExpander expander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_DATA_EXCLUSION_OPTIONS.get());
        panel.add((Component)expander, gbc);
        ++gbc.gridy;
        this.lDnsToExclude = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DNS_TO_EXCLUDE.get());
        gbc.insets.left = labelInsetLeft;
        gbc.anchor = 18;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        panel.add((Component)this.lDnsToExclude, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        this.dnsToExclude = Utilities.createTextArea(Message.EMPTY, 5, 0);
        final JScrollPane scrollDns = Utilities.createScrollPane(this.dnsToExclude);
        this.lDnsToExclude.setLabelFor(this.dnsToExclude);
        panel.add((Component)scrollDns, gbc);
        gbc.insets.top = 2;
        ++gbc.gridy;
        final JLabel lDnsExplanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATE_DNS_LINE_BREAK.get());
        panel.add((Component)lDnsExplanation, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.lAttributesToExclude = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTES_TO_EXCLUDE.get());
        gbc.insets.left = labelInsetLeft;
        gbc.anchor = 18;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        panel.add((Component)this.lAttributesToExclude, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.weightx = 1.0;
        this.attributesToExclude = Utilities.createTextField();
        panel.add((Component)this.attributesToExclude, gbc);
        this.lAttributesToExclude.setLabelFor(this.dnsToExclude);
        gbc.insets.top = 2;
        ++gbc.gridy;
        final JLabel lAttributesExplanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATE_ATTRIBUTES_COMMA.get());
        panel.add((Component)lAttributesExplanation, gbc);
        lAttributesExplanation.setLabelFor(this.dnsToExclude);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.lExclusionFilter = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_EXCLUSION_FILTER.get());
        gbc.insets.left = labelInsetLeft;
        gbc.anchor = 18;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        panel.add((Component)this.lExclusionFilter, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        this.exclusionFilter = Utilities.createTextField();
        panel.add((Component)this.exclusionFilter, gbc);
        this.lExclusionFilter.setLabelFor(this.exclusionFilter);
        this.addExtraComponents(panel, extraComponentLabels, extraComponents, gbc, labelInsetLeft);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InclusionExclusionPanel.this.lDnsToExclude.setVisible(expander.isSelected());
                scrollDns.setVisible(expander.isSelected());
                lDnsExplanation.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.lAttributesToExclude.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.attributesToExclude.setVisible(expander.isSelected());
                lAttributesExplanation.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.lExclusionFilter.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.exclusionFilter.setVisible(expander.isSelected());
                InclusionExclusionPanel.this.expanderStateChanged(expander, extraComponentLabels, extraComponents);
            }
        };
        expander.addChangeListener(changeListener);
        expander.setSelected(false);
        changeListener.stateChanged(null);
        return panel;
    }

    private void addExtraComponents(JPanel panel, JLabel[] extraComponentLabels, Component[] extraComponents, GridBagConstraints gbc, int labelInsetLeft) {
        for (int i = 0; i < extraComponentLabels.length; ++i) {
            if (extraComponentLabels[i] == null) {
                ++gbc.gridy;
                gbc.gridx = 0;
                gbc.insets.left = labelInsetLeft;
                gbc.anchor = 18;
                gbc.insets.top = 10;
                gbc.gridwidth = 2;
                gbc.weightx = 1.0;
                panel.add(extraComponents[i], gbc);
                continue;
            }
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.insets.left = labelInsetLeft;
            gbc.anchor = 18;
            gbc.insets.top = 10;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            panel.add((Component)extraComponentLabels[i], gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.insets.left = 10;
            panel.add(extraComponents[i], gbc);
            extraComponentLabels[i].setLabelFor(extraComponents[i]);
        }
    }

    private void expanderStateChanged(BasicExpander expander, JLabel[] extraComponentLabels, Component[] extraComponents) {
        for (JLabel jLabel : extraComponentLabels) {
            if (jLabel == null) continue;
            jLabel.setVisible(expander.isSelected());
        }
        for (Component component : extraComponents) {
            component.setVisible(expander.isSelected());
        }
    }

    protected void updateIncludeExclude(Collection<Message> errors, String backendName) {
        this.updateErrors(this.lDnsToInclude, this.dnsToInclude, this.lAttributesToInclude, this.attributesToInclude, this.lInclusionFilter, this.inclusionFilter, errors, backendName);
        this.updateErrors(this.lDnsToExclude, this.dnsToExclude, this.lAttributesToExclude, this.attributesToExclude, this.lExclusionFilter, this.exclusionFilter, errors, backendName);
    }

    private void updateErrors(JLabel lDns, JTextComponent dns, JLabel lAttributes, JTextComponent attributes, JLabel lFilter, JTextComponent filter, Collection<Message> errors, String backendName) {
        this.setPrimaryValid(lDns);
        this.setPrimaryValid(lAttributes);
        this.setPrimaryValid(lFilter);
        String s = dns.getText();
        boolean validDn = true;
        if (s.trim().length() > 0) {
            String[] dnArray = s.split("\n");
            for (int i = 0; i < dnArray.length; ++i) {
                if (!Utils.isDn(dnArray[i])) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_DN_NOT_VALID_WITH_VALUE.get(dnArray[i]));
                    validDn = false;
                    continue;
                }
                BackendDescriptor backend = null;
                if (backendName != null) {
                    ServerDescriptor server = this.getInfo().getServerDescriptor();
                    for (BackendDescriptor b : server.getBackends()) {
                        if (!b.getBackendID().equalsIgnoreCase(backendName)) continue;
                        backend = b;
                        break;
                    }
                }
                if (backend == null) continue;
                boolean found = false;
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    try {
                        DN dn = DN.decode(dnArray[i]);
                        if (!dn.isDescendantOf(baseDN.getDn())) continue;
                        found = true;
                        break;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (found) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NOT_A_DESCENDANT_OF_BASE_DN.get(dnArray[i], backendName));
            }
        }
        if (!validDn) {
            this.setPrimaryInvalid(lDns);
        }
        s = attributes.getText();
        boolean validAttributes = true;
        if (s.trim().length() > 0) {
            String[] attributeArray = s.split(",");
            for (int i = 0; i < attributeArray.length; ++i) {
                if (Utilities.isValidAttributeName(attributeArray[i])) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NOT_VALID_ATTRIBUTE_NAME.get(attributeArray[i]));
                validAttributes = false;
            }
        }
        if (!validAttributes) {
            this.setPrimaryInvalid(lAttributes);
        }
        if ((s = filter.getText()) != null && s.trim().length() > 0) {
            try {
                LDAPFilter.decode(s);
            }
            catch (LDAPException le) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_FILTER_DETAILS_WITH_VALUE.get(s, le.getMessageObject().toString()));
                this.setPrimaryInvalid(lFilter);
            }
        }
    }

    protected abstract class InclusionExclusionTask
    extends Task {
        protected InclusionExclusionTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
        }

        protected ArrayList<String> getCommandLineArguments() {
            String[] attrArray;
            int i;
            String[] dnArray;
            ArrayList<String> args = new ArrayList<String>();
            String s = InclusionExclusionPanel.this.dnsToInclude.getText();
            if (s.trim().length() > 0) {
                dnArray = s.split("\n");
                for (i = 0; i < dnArray.length; ++i) {
                    args.add("--includeBranch");
                    args.add(dnArray[i]);
                }
            }
            if ((s = InclusionExclusionPanel.this.attributesToInclude.getText()).trim().length() > 0) {
                attrArray = s.split(",");
                for (i = 0; i < attrArray.length; ++i) {
                    args.add("--includeAttribute");
                    args.add(attrArray[i]);
                }
            }
            if ((s = InclusionExclusionPanel.this.inclusionFilter.getText()).trim().length() > 0) {
                args.add("--includeFilter");
                args.add(s);
            }
            if ((s = InclusionExclusionPanel.this.dnsToExclude.getText()).trim().length() > 0) {
                dnArray = s.split("\n");
                for (i = 0; i < dnArray.length; ++i) {
                    args.add("--excludeBranch");
                    args.add(dnArray[i]);
                }
            }
            if ((s = InclusionExclusionPanel.this.attributesToExclude.getText()).trim().length() > 0) {
                attrArray = s.split(",");
                for (i = 0; i < attrArray.length; ++i) {
                    args.add("--excludeAttribute");
                    args.add(attrArray[i]);
                }
            }
            if ((s = InclusionExclusionPanel.this.exclusionFilter.getText()).trim().length() > 0) {
                args.add("--excludeFilter");
                args.add(s);
            }
            args.addAll(this.getConnectionCommandLineArguments());
            return args;
        }
    }
}

