/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.controlpanel.datamodel.ConfigReadException;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.quicksetup.util.Utils;
import org.opends.server.types.DN;

public class LoginPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 5051556513294844797L;
    private JPasswordField pwd;
    private JTextField dn;
    private JLabel pwdLabel;
    private JLabel dnLabel;
    private String usedUrl;
    private static final Logger LOG = Logger.getLogger(LoginPanel.class.getName());

    public LoginPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_LOGIN_PANEL_TITLE.get();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.dnLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BIND_DN_LABEL.get());
        this.add((Component)this.dnLabel, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.dn = Utilities.createTextField("cn=Directory Manager", 20);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.dn, gbc);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.pwdLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BIND_PASSWORD_LABEL.get());
        this.add((Component)this.pwdLabel, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.pwd = Utilities.createPasswordField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.pwd, gbc);
        this.addBottomGlue(gbc);
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.pwd;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        if (visible) {
            this.pwd.setText("");
        }
    }

    @Override
    public void okClicked() {
        this.setPrimaryValid(this.dnLabel);
        this.setPrimaryValid(this.pwdLabel);
        final LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        boolean dnInvalid = false;
        boolean pwdInvalid = false;
        if ("".equals(this.dn.getText().trim())) {
            dnInvalid = true;
            errors.add(QuickSetupMessages.INFO_EMPTY_DIRECTORY_MANAGER_DN.get());
        } else if (!Utils.isDn(this.dn.getText())) {
            dnInvalid = true;
            errors.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_DN.get());
        }
        if (this.pwd.getPassword().length == 0) {
            pwdInvalid = true;
            errors.add(QuickSetupMessages.INFO_EMPTY_PWD.get());
        }
        if (dnInvalid) {
            this.setPrimaryInvalid(this.dnLabel);
        }
        if (pwdInvalid) {
            this.setPrimaryInvalid(this.pwdLabel);
        }
        if (errors.isEmpty()) {
            this.setEnabledOK(false);
            this.setEnabledCancel(false);
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_AUTHENTICATION_SUMMARY.get());
            BackgroundTask<InitialLdapContext> worker = new BackgroundTask<InitialLdapContext>(){

                @Override
                public InitialLdapContext processBackgroundTask() throws Throwable {
                    InitialContext ctx = null;
                    try {
                        LoginPanel.this.usedUrl = LoginPanel.this.getInfo().getAdminConnectorURL();
                        ctx = Utilities.getAdminDirContext(LoginPanel.this.getInfo(), LoginPanel.this.dn.getText(), String.valueOf(LoginPanel.this.pwd.getPassword()));
                        if (LoginPanel.this.getInfo().getDirContext() != null) {
                            try {
                                LoginPanel.this.getInfo().getDirContext().close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (LoginPanel.this.getInfo().getUserDataDirContext() != null) {
                            try {
                                LoginPanel.this.getInfo().getUserDataDirContext().close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LoginPanel.this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_CONFIGURATION_SUMMARY.get());
                            }
                        });
                        LoginPanel.this.getInfo().setDirContext((InitialLdapContext)ctx);
                        LoginPanel.this.getInfo().setUserDataDirContext(null);
                        LoginPanel.this.getInfo().regenerateDescriptor();
                        return ctx;
                    }
                    catch (Throwable t) {
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        throw t;
                    }
                }

                @Override
                public void backgroundTaskCompleted(InitialLdapContext ctx, Throwable throwable) {
                    boolean handleCertificateException = false;
                    if (throwable != null) {
                        LOG.log(Level.INFO, "Error connecting: " + throwable, throwable);
                        if (Utils.isCertificateException(throwable)) {
                            ApplicationTrustManager.Cause cause = LoginPanel.this.getInfo().getTrustManager().getLastRefusedCause();
                            LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                            UserDataCertificateException.Type excType = null;
                            if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
                                excType = UserDataCertificateException.Type.NOT_TRUSTED;
                            } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
                                excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
                            } else {
                                Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), throwable);
                                errors.add(msg);
                            }
                            if (excType != null) {
                                int p;
                                String h;
                                try {
                                    URI uri = new URI(LoginPanel.this.usedUrl);
                                    h = uri.getHost();
                                    p = uri.getPort();
                                }
                                catch (Throwable t) {
                                    LOG.log(Level.WARNING, "Error parsing ldap url of ldap url.", t);
                                    h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                                    p = -1;
                                }
                                UserDataCertificateException udce = new UserDataCertificateException(null, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), throwable, h, p, LoginPanel.this.getInfo().getTrustManager().getLastRefusedChain(), LoginPanel.this.getInfo().getTrustManager().getLastRefusedAuthType(), excType);
                                LoginPanel.this.handleCertificateException(udce);
                                handleCertificateException = true;
                            }
                        } else if (throwable instanceof NamingException) {
                            boolean found = false;
                            String providedDn = LoginPanel.this.dn.getText();
                            Iterator<DN> it = LoginPanel.this.getInfo().getServerDescriptor().getAdministrativeUsers().iterator();
                            while (it.hasNext() && !found) {
                                found = Utils.areDnsEqual(providedDn, it.next().toString());
                            }
                            if (!found) {
                                errors.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_IN_CONFIG.get());
                            } else {
                                errors.add(Utils.getMessageForException((NamingException)throwable));
                            }
                            LoginPanel.this.setPrimaryInvalid(LoginPanel.this.dnLabel);
                            LoginPanel.this.setPrimaryInvalid(LoginPanel.this.pwdLabel);
                        } else if (throwable instanceof ConfigReadException) {
                            errors.add(((ConfigReadException)throwable).getMessageObject());
                        } else {
                            throwable.printStackTrace();
                            errors.add(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable));
                        }
                    }
                    LoginPanel.this.displayMainPanel();
                    LoginPanel.this.setEnabledCancel(true);
                    LoginPanel.this.setEnabledOK(true);
                    if (!errors.isEmpty()) {
                        LoginPanel.this.displayErrorDialog(errors);
                        LoginPanel.this.pwd.setSelectionStart(0);
                        LoginPanel.this.pwd.setSelectionEnd(LoginPanel.this.pwd.getPassword().length);
                        LoginPanel.this.pwd.requestFocusInWindow();
                    } else if (!handleCertificateException) {
                        Utilities.getParentDialog(LoginPanel.this).setVisible(false);
                    }
                }
            };
            worker.startBackgroundTask();
        } else {
            this.displayErrorDialog(errors);
            if (dnInvalid) {
                this.dn.setSelectionStart(0);
                this.dn.setSelectionEnd(this.dn.getText().length());
                this.dn.requestFocusInWindow();
            }
            if (pwdInvalid) {
                this.pwd.setSelectionStart(0);
                this.pwd.setSelectionEnd(this.pwd.getPassword().length);
                this.pwd.requestFocusInWindow();
            }
        }
    }

    @Override
    public void cancelClicked() {
        this.setPrimaryValid(this.dnLabel);
        this.setPrimaryValid(this.pwdLabel);
        this.pwd.setText(null);
        super.cancelClicked();
    }

    private void handleCertificateException(UserDataCertificateException ce) {
        X509Certificate[] chain;
        CertificateDialog dlg = new CertificateDialog(null, ce);
        dlg.pack();
        Utilities.centerGoldenMean(dlg, Utilities.getParentDialog(this));
        dlg.setVisible(true);
        if (dlg.getUserAnswer() != CertificateDialog.ReturnType.NOT_ACCEPTED) {
            chain = ce.getChain();
            String authType = ce.getAuthType();
            String host = ce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                this.getInfo().getTrustManager().acceptCertificate(chain, authType, host);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoginPanel.this.okClicked();
                    }
                });
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
        if (dlg.getUserAnswer() == CertificateDialog.ReturnType.ACCEPTED_PERMANENTLY && (chain = ce.getChain()) != null) {
            try {
                UIKeyStore.acceptCertificate(chain);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error accepting certificate: " + t, t);
            }
        }
    }
}

