/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.util.ArrayList;
import java.util.Collection;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.OpenDsException;

public class NumSubordinateHacker {
    String serverHost = "not-initialized";
    int serverPort = -1;
    ArrayList<DN> unreliableEntryList = new ArrayList();
    boolean isUnreliableEntryListEmpty;

    public boolean containsChildrenOf(LDAPURL parentUrl) {
        boolean containsChildren = false;
        if (!this.isUnreliableEntryListEmpty) {
            boolean isInServer;
            boolean bl = isInServer = this.serverHost.equalsIgnoreCase(String.valueOf(parentUrl.getHost())) && this.serverPort == parentUrl.getPort();
            if (isInServer) {
                for (DN dn : this.unreliableEntryList) {
                    try {
                        if (!dn.equals(DN.decode(parentUrl.getRawBaseDN()))) continue;
                        containsChildren = true;
                        break;
                    }
                    catch (OpenDsException oe) {
                        throw new RuntimeException("Error decoding DN of url: " + parentUrl);
                    }
                }
            }
        }
        return containsChildren;
    }

    public boolean contains(LDAPURL url) {
        boolean contains = false;
        if (!this.isUnreliableEntryListEmpty) {
            boolean isInServer;
            boolean bl = isInServer = this.serverHost.equalsIgnoreCase(String.valueOf(url.getHost())) && this.serverPort == url.getPort();
            if (isInServer) {
                for (DN dn : this.unreliableEntryList) {
                    try {
                        if (!dn.equals(DN.decode(url.getRawBaseDN()))) continue;
                        contains = true;
                        break;
                    }
                    catch (OpenDsException oe) {
                        throw new RuntimeException("Error decoding DN of url: " + url);
                    }
                }
            }
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<DN> allSuffixes, Collection<DN> rootSuffixes, String serverHost, int serverPort) {
        allSuffixes.removeAll(rootSuffixes);
        Collection<DN> subSuffixes = allSuffixes;
        ArrayList<DN> arrayList = this.unreliableEntryList;
        synchronized (arrayList) {
            this.unreliableEntryList.clear();
            for (DN subSuffixDN : subSuffixes) {
                this.unreliableEntryList.add(subSuffixDN.getParent());
            }
            this.isUnreliableEntryListEmpty = this.unreliableEntryList.isEmpty();
        }
        this.serverHost = serverHost;
        this.serverPort = serverPort;
    }
}

