/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.QuickSetupCli;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.SplashScreen;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.args.ArgumentParser;

public abstract class Launcher {
    private static final Logger LOG = Logger.getLogger(Launcher.class.getName());
    protected String[] args;

    public Launcher(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args cannot be null");
        }
        this.args = args;
    }

    public String[] getArguments() {
        return this.args;
    }

    public abstract ArgumentParser getArgumentParser();

    protected boolean shouldPrintUsage() {
        boolean printUsage = false;
        if (this.args != null && this.args.length > 0) {
            for (String arg : this.args) {
                if (!arg.equals("-?") && !arg.equalsIgnoreCase("-H") && !arg.equalsIgnoreCase("--help")) continue;
                printUsage = true;
            }
        }
        return printUsage;
    }

    protected boolean isQuiet() {
        boolean printUsage = false;
        if (this.args != null && this.args.length > 0) {
            for (String arg : this.args) {
                if (!arg.equals("-?") && !arg.equalsIgnoreCase("-Q") && !arg.equalsIgnoreCase("--quiet")) continue;
                printUsage = true;
            }
        }
        return printUsage;
    }

    protected boolean shouldPrintVersion() {
        boolean printVersion = false;
        if (this.args != null && this.args.length > 0) {
            for (String arg : this.args) {
                if (!arg.equalsIgnoreCase("--version")) continue;
                printVersion = true;
            }
        }
        return printVersion;
    }

    protected boolean isCli() {
        boolean isCli = false;
        for (String arg : this.args) {
            if (!arg.equalsIgnoreCase("--cli") && !arg.equalsIgnoreCase("-i")) continue;
            isCli = true;
            break;
        }
        return isCli;
    }

    protected void printUsage(String i18nMsg, boolean toStdErr) {
        if (toStdErr) {
            System.err.println(i18nMsg);
        } else {
            System.out.println(i18nMsg);
        }
    }

    protected int launchGui(final String[] args) {
        Utils.setMacOSXMenuBar(this.getFrameTitle());
        final int[] returnValue = new int[]{-1};
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        SplashScreen.main(args);
                        returnValue[0] = 0;
                    }
                    catch (Throwable t) {
                        if (!QuickSetupLog.isInitialized()) break block4;
                        LOG.log(Level.WARNING, "Error launching GUI: " + t);
                        StringBuilder buf = new StringBuilder();
                        while (t != null) {
                            StackTraceElement[] stack;
                            for (StackTraceElement aStack : stack = t.getStackTrace()) {
                                buf.append(aStack.toString()).append("\n");
                            }
                            if ((t = t.getCause()) == null) continue;
                            buf.append("Root cause:\n");
                        }
                        LOG.log(Level.WARNING, buf.toString());
                    }
                }
            }
        });
        PrintStream printStream = System.err;
        System.setErr(Utils.getEmptyPrintStream());
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.setErr(printStream);
        return returnValue[0];
    }

    protected abstract Message getFrameTitle();

    protected int launchCli(CliApplication cliApp) {
        System.setProperty("org.opends.quicksetup.cli", "true");
        QuickSetupCli cli = new QuickSetupCli(cliApp, this);
        ReturnCode returnValue = cli.run();
        if (returnValue.equals(ReturnCode.USER_DATA_ERROR)) {
            this.printUsage(true);
            System.exit(ReturnCode.USER_DATA_ERROR.getReturnCode());
        } else if (returnValue.equals(ReturnCode.CANCELED)) {
            System.exit(ReturnCode.CANCELED.getReturnCode());
        } else if (returnValue.equals(ReturnCode.USER_INPUT_ERROR)) {
            System.exit(ReturnCode.USER_INPUT_ERROR.getReturnCode());
        }
        return returnValue.getReturnCode();
    }

    protected void printVersion() {
        System.out.print(DynamicConstants.PRINTABLE_VERSION_STRING);
    }

    protected void printUsage(boolean toStdErr) {
        try {
            ArgumentParser argParser = this.getArgumentParser();
            if (argParser != null) {
                String msg = argParser.getUsage();
                this.printUsage(msg, toStdErr);
            }
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }

    protected abstract CliApplication createCliApplication();

    protected abstract void willLaunchGui();

    protected abstract void guiLaunchFailed(String var1);

    public void launch() {
        if (this.shouldPrintVersion()) {
            ArgumentParser parser = this.getArgumentParser();
            if (parser == null || !parser.usageOrVersionDisplayed()) {
                this.printVersion();
            }
            System.exit(ReturnCode.PRINT_VERSION.getReturnCode());
        } else if (this.shouldPrintUsage()) {
            ArgumentParser parser = this.getArgumentParser();
            if (parser == null || !parser.usageOrVersionDisplayed()) {
                this.printUsage(false);
            }
            System.exit(ReturnCode.SUCCESSFUL.getReturnCode());
        } else if (this.isCli()) {
            CliApplication cliApp = this.createCliApplication();
            int exitCode = this.launchCli(cliApp);
            this.preExit(cliApp);
            System.exit(exitCode);
        } else {
            this.willLaunchGui();
            int exitCode = this.launchGui(this.args);
            if (exitCode != 0) {
                File logFile = QuickSetupLog.getLogFile();
                if (logFile != null) {
                    this.guiLaunchFailed(logFile.toString());
                } else {
                    this.guiLaunchFailed(null);
                }
                CliApplication cliApp = this.createCliApplication();
                exitCode = this.launchCli(cliApp);
                this.preExit(cliApp);
                System.exit(exitCode);
            }
        }
    }

    private void preExit(CliApplication cliApp) {
        UserData ud;
        if (cliApp != null && (ud = cliApp.getUserData()) != null && !ud.isQuiet()) {
            System.out.println();
            File logFile = QuickSetupLog.getLogFile();
            if (logFile != null) {
                System.out.println(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(QuickSetupLog.getLogFile().getPath()));
            }
        }
    }
}

