/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OperationsException;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.admin.Reference;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.ClientConstraintHandler;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.condition.Condition;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerConstraintHandler;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.server.ServerManagedObjectChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.RootCfgDefn;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public final class AggregationPropertyDefinition<C extends ConfigurationClient, S extends Configuration>
extends PropertyDefinition<String> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Map<DN, List<ReferentialIntegrityChangeListener>> changeListeners = new HashMap<DN, List<ReferentialIntegrityChangeListener>>();
    private final Map<DN, List<ReferentialIntegrityDeleteListener>> deleteListeners = new HashMap<DN, List<ReferentialIntegrityDeleteListener>>();
    private ManagedObjectPath<?, ?> parentPath;
    private final String parentPathString;
    private final String rdName;
    private InstantiableRelationDefinition<C, S> relationDefinition;
    private final Constraint sourceConstraint;
    private final Condition targetIsEnabledCondition;
    private final Condition targetNeedsEnablingCondition;

    public static <C extends ConfigurationClient, S extends Configuration> Builder<C, S> createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private AggregationPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior, String parentPathString, String rdName, Condition targetNeedsEnablingCondition, Condition targetIsEnabledCondition) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
        this.parentPathString = parentPathString;
        this.rdName = rdName;
        this.targetNeedsEnablingCondition = targetNeedsEnablingCondition;
        this.targetIsEnabledCondition = targetIsEnabledCondition;
        this.sourceConstraint = new Constraint(){

            @Override
            public Collection<ClientConstraintHandler> getClientConstraintHandlers() {
                SourceClientHandler handler = new SourceClientHandler();
                return Collections.singleton(handler);
            }

            @Override
            public Collection<ServerConstraintHandler> getServerConstraintHandlers() {
                ServerHandler handler = new ServerHandler();
                return Collections.singleton(handler);
            }
        };
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitAggregation(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitAggregation(this, value, p);
    }

    @Override
    public String decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        try {
            this.validateValue(value);
            return value;
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
    }

    public final DN getChildDN(String name) {
        return this.getChildPath(name).toDN();
    }

    public final ManagedObjectPath<C, S> getChildPath(String name) {
        return this.parentPath.child(this.relationDefinition, name);
    }

    public final ManagedObjectPath<?, ?> getParentPath() {
        return this.parentPath;
    }

    public final InstantiableRelationDefinition<C, S> getRelationDefinition() {
        return this.relationDefinition;
    }

    public final Constraint getSourceConstraint() {
        return this.sourceConstraint;
    }

    public final Message getSourceConstraintSynopsis() {
        return this.getSourceConstraintSynopsis(Locale.getDefault());
    }

    public final Message getSourceConstraintSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.aggregation.constraint-synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final Condition getTargetIsEnabledCondition() {
        return this.targetIsEnabledCondition;
    }

    public final Condition getTargetNeedsEnablingCondition() {
        return this.targetNeedsEnablingCondition;
    }

    @Override
    public String normalizeValue(String value) throws IllegalPropertyValueException {
        try {
            Reference<C, S> reference = Reference.parseName(this.parentPath, this.relationDefinition, value);
            return reference.getNormalizedName();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalPropertyValueException(this, value);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" parentPath=");
        builder.append(this.parentPath);
        builder.append(" relationDefinition=");
        builder.append(this.relationDefinition.getName());
        builder.append(" targetNeedsEnablingCondition=");
        builder.append(String.valueOf(this.targetNeedsEnablingCondition));
        builder.append(" targetIsEnabledCondition=");
        builder.append(String.valueOf(this.targetIsEnabledCondition));
    }

    @Override
    public void validateValue(String value) throws IllegalPropertyValueException {
        try {
            Reference.parseName(this.parentPath, this.relationDefinition, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalPropertyValueException(this, value);
        }
    }

    @Override
    public void initialize() throws Exception {
        this.parentPath = ManagedObjectPath.valueOf(this.parentPathString);
        AbstractManagedObjectDefinition<?, ?> parent = this.parentPath.getManagedObjectDefinition();
        RelationDefinition<?, ?> rd = parent.getRelationDefinition(this.rdName);
        this.relationDefinition = (InstantiableRelationDefinition)rd;
        this.targetNeedsEnablingCondition.initialize(this.getManagedObjectDefinition());
        this.targetIsEnabledCondition.initialize(rd.getChildDefinition());
        Constraint constraint = new Constraint(){

            @Override
            public Collection<ClientConstraintHandler> getClientConstraintHandlers() {
                TargetClientHandler handler = new TargetClientHandler();
                return Collections.singleton(handler);
            }

            @Override
            public Collection<ServerConstraintHandler> getServerConstraintHandlers() {
                return Collections.emptyList();
            }
        };
        rd.getChildDefinition().registerConstraint(constraint);
    }

    private class TargetClientHandler
    extends ClientConstraintHandler {
        private TargetClientHandler() {
        }

        @Override
        public boolean isDeleteAcceptable(ManagementContext context, ManagedObjectPath<?, ?> path, Collection<Message> unacceptableReasons) throws AuthorizationException, CommunicationException {
            boolean isAcceptable = true;
            for (ManagedObject<?> mo : this.findReferences(context, AggregationPropertyDefinition.this.getManagedObjectDefinition(), path.getName())) {
                Message msg;
                String name = mo.getManagedObjectPath().getName();
                if (name == null) {
                    msg = AdminMessages.ERR_CLIENT_REFINT_CANNOT_DELETE_WITHOUT_NAME.get(AggregationPropertyDefinition.this.getName(), mo.getManagedObjectDefinition().getUserFriendlyName(), AggregationPropertyDefinition.this.getManagedObjectDefinition().getUserFriendlyName());
                    unacceptableReasons.add(msg);
                } else {
                    msg = AdminMessages.ERR_CLIENT_REFINT_CANNOT_DELETE_WITH_NAME.get(AggregationPropertyDefinition.this.getName(), mo.getManagedObjectDefinition().getUserFriendlyName(), name, AggregationPropertyDefinition.this.getManagedObjectDefinition().getUserFriendlyName());
                    unacceptableReasons.add(msg);
                }
                isAcceptable = false;
            }
            return isAcceptable;
        }

        @Override
        public boolean isModifyAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws AuthorizationException, CommunicationException {
            if (AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(context, managedObject)) {
                return true;
            }
            boolean isAcceptable = true;
            for (ManagedObject<?> mo : this.findReferences(context, AggregationPropertyDefinition.this.getManagedObjectDefinition(), managedObject.getManagedObjectPath().getName())) {
                Message msg;
                if (!AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(context, mo)) continue;
                String name = mo.getManagedObjectPath().getName();
                if (name == null) {
                    msg = AdminMessages.ERR_CLIENT_REFINT_CANNOT_DISABLE_WITHOUT_NAME.get(managedObject.getManagedObjectDefinition().getUserFriendlyName(), AggregationPropertyDefinition.this.getName(), mo.getManagedObjectDefinition().getUserFriendlyName());
                    unacceptableReasons.add(msg);
                } else {
                    msg = AdminMessages.ERR_CLIENT_REFINT_CANNOT_DISABLE_WITH_NAME.get(managedObject.getManagedObjectDefinition().getUserFriendlyName(), AggregationPropertyDefinition.this.getName(), mo.getManagedObjectDefinition().getUserFriendlyName(), name);
                    unacceptableReasons.add(msg);
                }
                isAcceptable = false;
            }
            return isAcceptable;
        }

        private <CC extends ConfigurationClient> List<ManagedObject<? extends CC>> findReferences(ManagementContext context, AbstractManagedObjectDefinition<CC, ?> mod, String name) throws AuthorizationException, CommunicationException {
            List<ManagedObject<CC>> instances = this.findInstances(context, mod);
            Iterator<ManagedObject<CC>> i = instances.iterator();
            while (i.hasNext()) {
                ManagedObject<CC> mo = i.next();
                boolean hasReference = false;
                for (String value : mo.getPropertyValues(AggregationPropertyDefinition.this)) {
                    if (AggregationPropertyDefinition.this.compare(value, name) != 0) continue;
                    hasReference = true;
                    break;
                }
                if (hasReference) continue;
                i.remove();
            }
            return instances;
        }

        private <CC extends ConfigurationClient> List<ManagedObject<? extends CC>> findInstances(ManagementContext context, AbstractManagedObjectDefinition<CC, ?> mod) throws AuthorizationException, CommunicationException {
            LinkedList<ManagedObject<CC>> instances = new LinkedList<ManagedObject<CC>>();
            if (mod == RootCfgDefn.getInstance()) {
                instances.add(context.getRootConfigurationManagedObject());
            } else {
                for (RelationDefinition<CC, ?> rd : mod.getAllReverseRelationDefinitions()) {
                    for (ManagedObject<?> parent : this.findInstances(context, rd.getParentDefinition())) {
                        try {
                            ManagedObject mo;
                            if (rd instanceof SingletonRelationDefinition) {
                                SingletonRelationDefinition srd = (SingletonRelationDefinition)rd;
                                mo = parent.getChild(srd);
                                if (!mo.getManagedObjectDefinition().isChildOf(mod)) continue;
                                instances.add(mo);
                                continue;
                            }
                            if (rd instanceof OptionalRelationDefinition) {
                                OptionalRelationDefinition ord = (OptionalRelationDefinition)rd;
                                mo = parent.getChild(ord);
                                if (!mo.getManagedObjectDefinition().isChildOf(mod)) continue;
                                instances.add(mo);
                                continue;
                            }
                            if (!(rd instanceof InstantiableRelationDefinition)) continue;
                            InstantiableRelationDefinition ird = (InstantiableRelationDefinition)rd;
                            for (String name : parent.listChildren(ird)) {
                                ManagedObject mo2 = parent.getChild(ird, name);
                                if (!mo2.getManagedObjectDefinition().isChildOf(mod)) continue;
                                instances.add(mo2);
                            }
                        }
                        catch (OperationsException operationsException) {
                        }
                    }
                }
            }
            return instances;
        }
    }

    private class SourceClientHandler
    extends ClientConstraintHandler {
        private SourceClientHandler() {
        }

        @Override
        public boolean isAddAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws AuthorizationException, CommunicationException {
            boolean needsEnabling = AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(context, managedObject);
            boolean isAcceptable = true;
            Message ufn = AggregationPropertyDefinition.this.getRelationDefinition().getUserFriendlyName();
            for (String name : managedObject.getPropertyValues(AggregationPropertyDefinition.this)) {
                Message msg;
                ManagedObject ref;
                ManagedObjectPath path = AggregationPropertyDefinition.this.getChildPath(name);
                try {
                    ref = context.getManagedObject(path);
                }
                catch (DefinitionDecodingException e) {
                    msg = AdminMessages.ERR_CLIENT_REFINT_TARGET_INVALID.get(ufn, name, AggregationPropertyDefinition.this.getName(), e.getMessageObject());
                    unacceptableReasons.add(msg);
                    isAcceptable = false;
                    continue;
                }
                catch (ManagedObjectDecodingException e) {
                    msg = AdminMessages.ERR_CLIENT_REFINT_TARGET_INVALID.get(ufn, name, AggregationPropertyDefinition.this.getName(), e.getMessageObject());
                    unacceptableReasons.add(msg);
                    isAcceptable = false;
                    continue;
                }
                catch (ManagedObjectNotFoundException e) {
                    msg = AdminMessages.ERR_CLIENT_REFINT_TARGET_DANGLING_REFERENCE.get(ufn, name, AggregationPropertyDefinition.this.getName());
                    unacceptableReasons.add(msg);
                    isAcceptable = false;
                    continue;
                }
                if (!needsEnabling || AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(context, ref)) continue;
                Message msg2 = AdminMessages.ERR_CLIENT_REFINT_TARGET_DISABLED.get(ufn, name, AggregationPropertyDefinition.this.getName());
                unacceptableReasons.add(msg2);
                isAcceptable = false;
            }
            return isAcceptable;
        }

        @Override
        public boolean isModifyAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws AuthorizationException, CommunicationException {
            return this.isAddAcceptable(context, managedObject, unacceptableReasons);
        }
    }

    private class ServerHandler
    extends ServerConstraintHandler {
        private ServerHandler() {
        }

        @Override
        public boolean isUsable(ServerManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws ConfigException {
            Collection names = managedObject.getPropertyValues((PropertyDefinition)AggregationPropertyDefinition.this);
            ServerManagementContext context = ServerManagementContext.getInstance();
            Message thisUFN = managedObject.getManagedObjectDefinition().getUserFriendlyName();
            String thisDN = managedObject.getDN().toString();
            Message thatUFN = AggregationPropertyDefinition.this.getRelationDefinition().getUserFriendlyName();
            boolean isUsable = true;
            boolean needsEnabling = AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(managedObject);
            for (String name : names) {
                ManagedObjectPath path = AggregationPropertyDefinition.this.getChildPath(name);
                String thatDN = path.toDN().toString();
                if (!context.managedObjectExists(path)) {
                    Message msg = AdminMessages.ERR_SERVER_REFINT_DANGLING_REFERENCE.get(name, AggregationPropertyDefinition.this.getName(), thisUFN, thisDN, thatUFN, thatDN);
                    unacceptableReasons.add(msg);
                    isUsable = false;
                    continue;
                }
                if (!needsEnabling) continue;
                ServerManagedObject ref = context.getManagedObject(path);
                if (AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(ref)) continue;
                Message msg = AdminMessages.ERR_SERVER_REFINT_TARGET_DISABLED.get(name, AggregationPropertyDefinition.this.getName(), thisUFN, thisDN, thatUFN, thatDN);
                unacceptableReasons.add(msg);
                isUsable = false;
            }
            return isUsable;
        }

        @Override
        public void performPostAdd(ServerManagedObject<?> managedObject) throws ConfigException {
            this.performPostDelete(managedObject);
            Message thisUFN = managedObject.getManagedObjectDefinition().getUserFriendlyName();
            String thisDN = managedObject.getDN().toString();
            Message thatUFN = AggregationPropertyDefinition.this.getRelationDefinition().getUserFriendlyName();
            boolean needsChangeListeners = AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(managedObject);
            ServerManagementContext context = ServerManagementContext.getInstance();
            ManagedObjectPath<?, ?> parentPath = AggregationPropertyDefinition.this.getParentPath();
            ServerManagedObject parent = context.getManagedObject(parentPath);
            LinkedList<ReferentialIntegrityDeleteListener> dlist = new LinkedList<ReferentialIntegrityDeleteListener>();
            AggregationPropertyDefinition.this.deleteListeners.put(managedObject.getDN(), dlist);
            LinkedList<ReferentialIntegrityChangeListener> clist = new LinkedList<ReferentialIntegrityChangeListener>();
            AggregationPropertyDefinition.this.changeListeners.put(managedObject.getDN(), clist);
            for (String name : managedObject.getPropertyValues((PropertyDefinition)AggregationPropertyDefinition.this)) {
                ManagedObjectPath path = AggregationPropertyDefinition.this.getChildPath(name);
                DN dn = path.toDN();
                String thatDN = dn.toString();
                Message msg = AdminMessages.ERR_SERVER_REFINT_CANNOT_DELETE.get(thatUFN, thatDN, AggregationPropertyDefinition.this.getName(), thisUFN, thisDN);
                ReferentialIntegrityDeleteListener dl = new ReferentialIntegrityDeleteListener(dn, msg);
                parent.registerDeleteListener(AggregationPropertyDefinition.this.getRelationDefinition(), dl);
                dlist.add(dl);
                if (!needsChangeListeners) continue;
                ServerManagedObject ref = context.getManagedObject(path);
                msg = AdminMessages.ERR_SERVER_REFINT_CANNOT_DISABLE.get(thatUFN, thatDN, AggregationPropertyDefinition.this.getName(), thisUFN, thisDN);
                ReferentialIntegrityChangeListener cl = new ReferentialIntegrityChangeListener(path, msg);
                ref.registerChangeListener(cl);
                clist.add(cl);
            }
        }

        @Override
        public void performPostDelete(ServerManagedObject<?> managedObject) throws ConfigException {
            ServerManagementContext context = ServerManagementContext.getInstance();
            DN dn = managedObject.getDN();
            ManagedObjectPath<?, ?> parentPath = AggregationPropertyDefinition.this.getParentPath();
            ServerManagedObject parent = context.getManagedObject(parentPath);
            if (AggregationPropertyDefinition.this.deleteListeners.containsKey(dn)) {
                for (ReferentialIntegrityDeleteListener dl : (List)AggregationPropertyDefinition.this.deleteListeners.get(dn)) {
                    parent.deregisterDeleteListener(AggregationPropertyDefinition.this.getRelationDefinition(), dl);
                }
                AggregationPropertyDefinition.this.deleteListeners.remove(dn);
            }
            if (AggregationPropertyDefinition.this.changeListeners.containsKey(dn)) {
                for (ReferentialIntegrityChangeListener cl : (List)AggregationPropertyDefinition.this.changeListeners.get(dn)) {
                    ManagedObjectPath path = cl.getManagedObjectPath();
                    ServerManagedObject ref = context.getManagedObject(path);
                    ref.deregisterChangeListener(cl);
                }
                AggregationPropertyDefinition.this.changeListeners.remove(dn);
            }
        }

        @Override
        public void performPostModify(ServerManagedObject<?> managedObject) throws ConfigException {
            this.performPostDelete(managedObject);
            this.performPostAdd(managedObject);
        }
    }

    private class ReferentialIntegrityDeleteListener
    implements ConfigurationDeleteListener<S> {
        private final DN dn;
        private final Message message;

        private ReferentialIntegrityDeleteListener(DN dn, Message message) {
            this.dn = dn;
            this.message = message;
        }

        @Override
        public ConfigChangeResult applyConfigurationDelete(S configuration) {
            if (configuration.dn().equals(this.dn)) {
                throw new IllegalStateException("Attempting to delete a referenced " + AggregationPropertyDefinition.this.relationDefinition.getChildDefinition().getUserFriendlyName());
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(S configuration, List<Message> unacceptableReasons) {
            if (configuration.dn().equals(this.dn)) {
                unacceptableReasons.add(this.message);
                return false;
            }
            return true;
        }
    }

    private class ReferentialIntegrityChangeListener
    implements ServerManagedObjectChangeListener<S> {
        private final Message message;
        private final ManagedObjectPath<C, S> path;

        private ReferentialIntegrityChangeListener(ManagedObjectPath<C, S> path, Message message) {
            this.path = path;
            this.message = message;
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(ServerManagedObject<? extends S> mo) {
            try {
                if (AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(mo)) {
                    return new ConfigChangeResult(ResultCode.SUCCESS, false);
                }
            }
            catch (ConfigException configException) {
                // empty catch block
            }
            throw new IllegalStateException("Attempting to disable a referenced " + AggregationPropertyDefinition.this.relationDefinition.getChildDefinition().getUserFriendlyName());
        }

        @Override
        public boolean isConfigurationChangeAcceptable(ServerManagedObject<? extends S> mo, List<Message> unacceptableReasons) {
            try {
                if (!AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(mo)) {
                    unacceptableReasons.add(this.message);
                    return false;
                }
                return true;
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = AdminMessages.ERR_REFINT_UNABLE_TO_EVALUATE_TARGET_CONDITION.get(mo.getManagedObjectDefinition().getUserFriendlyName(), String.valueOf(mo.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message);
                unacceptableReasons.add(message);
                return false;
            }
        }

        private ManagedObjectPath<C, S> getManagedObjectPath() {
            return this.path;
        }
    }

    public static class Builder<C extends ConfigurationClient, S extends Configuration>
    extends PropertyDefinition.AbstractBuilder<String, AggregationPropertyDefinition<C, S>> {
        private String parentPathString = null;
        private String rdName = null;
        private Condition targetIsEnabledCondition = Conditions.TRUE;
        private Condition targetNeedsEnablingCondition = Conditions.TRUE;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setParentPath(String pathString) {
            this.parentPathString = pathString;
        }

        public final void setRelationDefinition(String rdName) {
            this.rdName = rdName;
        }

        public final void setTargetIsEnabledCondition(Condition condition) {
            this.targetIsEnabledCondition = condition;
        }

        public final void setTargetNeedsEnablingCondition(Condition condition) {
            this.targetNeedsEnablingCondition = condition;
        }

        @Override
        protected AggregationPropertyDefinition<C, S> buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            if (this.parentPathString == null) {
                throw new IllegalStateException("Parent path undefined");
            }
            if (this.rdName == null) {
                throw new IllegalStateException("Relation definition undefined");
            }
            return new AggregationPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.parentPathString, this.rdName, this.targetNeedsEnablingCondition, this.targetIsEnabledCondition);
        }
    }
}

