/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefaultManagedObject;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationDefinitionVisitor;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.ClientConstraintHandler;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.client.spi.Driver;
import org.opends.server.admin.client.spi.Property;
import org.opends.server.admin.client.spi.PropertySet;

public abstract class AbstractManagedObject<T extends ConfigurationClient>
implements ManagedObject<T> {
    private final ManagedObjectDefinition<T, ? extends Configuration> definition;
    private boolean existsOnServer;
    private final PropertyDefinition<?> namingPropertyDefinition;
    private ManagedObjectPath<T, ? extends Configuration> path;
    private final PropertySet properties;

    protected AbstractManagedObject(ManagedObjectDefinition<T, ? extends Configuration> d, ManagedObjectPath<T, ? extends Configuration> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        this.definition = d;
        this.path = path;
        this.properties = properties;
        this.existsOnServer = existsOnServer;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    @Override
    public final void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
        LinkedList<PropertyIsMandatoryException> exceptions = new LinkedList<PropertyIsMandatoryException>();
        for (PropertyDefinition<?> pd : this.definition.getAllPropertyDefinitions()) {
            Property<?> p = this.getProperty(pd);
            if (!pd.hasOption(PropertyOption.MANDATORY) || !p.getEffectiveValues().isEmpty()) continue;
            exceptions.add(new PropertyIsMandatoryException(pd));
        }
        if (!exceptions.isEmpty()) {
            throw new MissingMandatoryPropertiesException(this.definition.getUserFriendlyName(), exceptions, !this.existsOnServer);
        }
        LinkedList<Message> messages = new LinkedList<Message>();
        boolean isAcceptable = true;
        ManagementContext context = this.getDriver().getManagementContext();
        for (Constraint constraint : this.definition.getAllConstraints()) {
            for (ClientConstraintHandler handler : constraint.getClientConstraintHandlers()) {
                if (this.existsOnServer) {
                    if (handler.isModifyAcceptable(context, this, messages)) continue;
                    isAcceptable = false;
                    continue;
                }
                if (handler.isAddAcceptable(context, this, messages)) continue;
                isAcceptable = false;
            }
            if (isAcceptable) continue;
            break;
        }
        if (!isAcceptable) {
            if (this.existsOnServer) {
                throw new OperationRejectedException(OperationRejectedException.OperationType.MODIFY, this.definition.getUserFriendlyName(), messages);
            }
            throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, this.definition.getUserFriendlyName(), messages);
        }
        if (this.existsOnServer) {
            this.modifyExistingManagedObject();
        } else {
            this.addNewManagedObject();
        }
        this.properties.commit();
        if (!this.existsOnServer) {
            DefaultManagedObjectFactory factory = new DefaultManagedObjectFactory();
            for (RelationDefinition<?, ?> rd : this.definition.getAllRelationDefinitions()) {
                factory.createDefaultManagedObjects(rd);
            }
            this.existsOnServer = true;
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration, CC extends C> ManagedObject<CC> createChild(InstantiableRelationDefinition<C, S> r, ManagedObjectDefinition<CC, ? extends S> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException, IllegalArgumentException {
        this.validateRelationDefinition(r);
        if (name.trim().length() == 0) {
            throw new IllegalManagedObjectNameException(name);
        }
        PropertyDefinition<?> pd = r.getNamingPropertyDefinition();
        if (pd != null) {
            try {
                pd.decodeValue(name);
            }
            catch (IllegalPropertyValueStringException e) {
                throw new IllegalManagedObjectNameException(name, pd);
            }
        }
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d, name);
        return this.createNewManagedObject(d, childPath, pd, name, exceptions);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration, CC extends C> ManagedObject<CC> createChild(OptionalRelationDefinition<C, S> r, ManagedObjectDefinition<CC, ? extends S> d, Collection<DefaultBehaviorException> exceptions) throws IllegalArgumentException {
        this.validateRelationDefinition(r);
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d);
        return this.createNewManagedObject(d, childPath, null, null, exceptions);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration, CC extends C> ManagedObject<CC> createChild(SetRelationDefinition<C, S> r, ManagedObjectDefinition<CC, ? extends S> d, Collection<DefaultBehaviorException> exceptions) throws IllegalArgumentException {
        this.validateRelationDefinition(r);
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d);
        return this.createNewManagedObject(d, childPath, null, null, exceptions);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(InstantiableRelationDefinition<C, S> r, String name) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        return ctx.getManagedObject(this.path.child(r, name));
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(OptionalRelationDefinition<C, S> r) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        return ctx.getManagedObject(this.path.child(r));
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(SingletonRelationDefinition<C, S> r) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        return ctx.getManagedObject(this.path.child(r));
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(SetRelationDefinition<C, S> r, String name) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        AbstractManagedObjectDefinition cd;
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        try {
            cd = d.getChild(name);
        }
        catch (IllegalArgumentException e) {
            throw new DefinitionDecodingException(d, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
        }
        return ctx.getManagedObject(this.path.child(r, cd));
    }

    @Override
    public final T getConfiguration() {
        return this.definition.createClientConfiguration(this);
    }

    @Override
    public final ManagedObjectDefinition<T, ? extends Configuration> getManagedObjectDefinition() {
        return this.definition;
    }

    @Override
    public final ManagedObjectPath<T, ? extends Configuration> getManagedObjectPath() {
        return this.path;
    }

    @Override
    public final <PD> SortedSet<PD> getPropertyDefaultValues(PropertyDefinition<PD> pd) throws IllegalArgumentException {
        return new TreeSet<PD>(this.getProperty(pd).getDefaultValues());
    }

    @Override
    public final <PD> PD getPropertyValue(PropertyDefinition<PD> pd) throws IllegalArgumentException {
        SortedSet<PD> values = this.getProperty(pd).getEffectiveValues();
        if (values.isEmpty()) {
            return null;
        }
        return (PD)values.iterator().next();
    }

    @Override
    public final <PD> SortedSet<PD> getPropertyValues(PropertyDefinition<PD> pd) throws IllegalArgumentException {
        return new TreeSet<PD>(this.getProperty(pd).getEffectiveValues());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> boolean hasChild(OptionalRelationDefinition<C, S> r) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            return ctx.managedObjectExists(this.path.child(r));
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final boolean isPropertyPresent(PropertyDefinition<?> pd) throws IllegalArgumentException {
        return !this.getProperty(pd).isEmpty();
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(InstantiableRelationDefinition<C, S> r) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        return this.listChildren(r, r.getChildDefinition());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(InstantiableRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            return ctx.listManagedObjects(this.path, r, d);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(SetRelationDefinition<C, S> r) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        return this.listChildren(r, r.getChildDefinition());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(SetRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            return ctx.listManagedObjects(this.path, r, d);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> void removeChild(InstantiableRelationDefinition<C, S> r, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        boolean found;
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            found = ctx.deleteManagedObject(this.path, r, name);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        if (!found) {
            throw new ManagedObjectNotFoundException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> void removeChild(OptionalRelationDefinition<C, S> r) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        boolean found;
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            found = ctx.deleteManagedObject(this.path, r);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        if (!found) {
            throw new ManagedObjectNotFoundException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> void removeChild(SetRelationDefinition<C, S> r, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        boolean found;
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            found = ctx.deleteManagedObject(this.path, r, name);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        if (!found) {
            throw new ManagedObjectNotFoundException();
        }
    }

    @Override
    public final <PD> void setPropertyValue(PropertyDefinition<PD> pd, PD value) throws IllegalPropertyValueException, PropertyIsReadOnlyException, PropertyIsMandatoryException, IllegalArgumentException {
        if (value == null) {
            this.setPropertyValues(pd, Collections.emptySet());
        } else {
            this.setPropertyValues(pd, Collections.singleton(value));
        }
    }

    @Override
    public final <PD> void setPropertyValues(PropertyDefinition<PD> pd, Collection<PD> values) throws IllegalPropertyValueException, PropertyIsSingleValuedException, PropertyIsReadOnlyException, PropertyIsMandatoryException, IllegalArgumentException {
        if (pd.hasOption(PropertyOption.MONITORING)) {
            throw new PropertyIsReadOnlyException(pd);
        }
        if (this.existsOnServer && pd.hasOption(PropertyOption.READ_ONLY)) {
            throw new PropertyIsReadOnlyException(pd);
        }
        this.properties.setPropertyValues(pd, values);
        if (pd.equals(this.namingPropertyDefinition)) {
            String newName = pd.encodeValue(values.iterator().next());
            this.path = this.path.rename(newName);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ TYPE=");
        builder.append(this.definition.getName());
        builder.append(", PATH=\"");
        builder.append(this.path);
        builder.append('\"');
        for (PropertyDefinition<?> pd : this.definition.getAllPropertyDefinitions()) {
            builder.append(", ");
            builder.append(pd.getName());
            builder.append('=');
            builder.append(this.getPropertyValues((PropertyDefinition)pd));
        }
        builder.append(" }");
        return builder.toString();
    }

    protected abstract void addNewManagedObject() throws AuthorizationException, CommunicationException, OperationRejectedException, ConcurrentModificationException, ManagedObjectAlreadyExistsException;

    protected abstract Driver getDriver();

    protected final PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }

    protected final <PD> Property<PD> getProperty(PropertyDefinition<PD> pd) throws IllegalArgumentException {
        return this.properties.getProperty(pd);
    }

    protected abstract void modifyExistingManagedObject() throws ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException;

    protected abstract <M extends ConfigurationClient> ManagedObject<M> newInstance(ManagedObjectDefinition<M, ?> var1, ManagedObjectPath<M, ?> var2, PropertySet var3, boolean var4, PropertyDefinition<?> var5);

    private <M extends ConfigurationClient, PD> ManagedObject<M> createNewManagedObject(ManagedObjectDefinition<M, ?> d, ManagedObjectPath<M, ?> p, PropertyDefinition<PD> namingPropertyDefinition, String name, Collection<DefaultBehaviorException> exceptions) {
        PropertySet childProperties = new PropertySet();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            try {
                this.createProperty(childProperties, p, pd);
            }
            catch (DefaultBehaviorException e) {
                if (exceptions == null) continue;
                exceptions.add(e);
            }
        }
        if (namingPropertyDefinition != null) {
            PD value = namingPropertyDefinition.decodeValue(name);
            childProperties.setPropertyValues(namingPropertyDefinition, Collections.singleton(value));
        }
        return this.newInstance(d, p, childProperties, false, namingPropertyDefinition);
    }

    private <PD> void createProperty(PropertySet properties, ManagedObjectPath<?, ?> p, PropertyDefinition<PD> pd) throws DefaultBehaviorException {
        try {
            Driver context = this.getDriver();
            Collection<PD> defaultValues = context.findDefaultValues(p, pd, true);
            properties.addProperty(pd, defaultValues, Collections.emptySet());
        }
        catch (DefaultBehaviorException e) {
            properties.addProperty(pd, Collections.emptySet(), Collections.emptySet());
            throw e;
        }
    }

    private void ensureThisManagedObjectExists() throws ConcurrentModificationException, CommunicationException, AuthorizationException {
        if (!this.path.isEmpty()) {
            Driver ctx = this.getDriver();
            try {
                if (!ctx.managedObjectExists(this.path)) {
                    throw new ConcurrentModificationException();
                }
            }
            catch (ManagedObjectNotFoundException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private void validateRelationDefinition(RelationDefinition<?, ?> rd) throws IllegalArgumentException {
        ManagedObjectDefinition<T, Configuration> d = this.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    private final class DefaultManagedObjectFactory
    implements RelationDefinitionVisitor<Void, Void> {
        private AuthorizationException ae = null;
        private ManagedObjectAlreadyExistsException moaee = null;
        private MissingMandatoryPropertiesException mmpe = null;
        private ConcurrentModificationException cme = null;
        private OperationRejectedException ore = null;
        private CommunicationException ce = null;

        private DefaultManagedObjectFactory() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitInstantiable(InstantiableRelationDefinition<C, S> rd, Void p) {
            for (String name : rd.getDefaultManagedObjectNames()) {
                ManagedObject<C> child;
                DefaultManagedObject<C, S> dmo = rd.getDefaultManagedObject(name);
                ManagedObjectDefinition<C, S> d = dmo.getManagedObjectDefinition();
                try {
                    child = AbstractManagedObject.this.createChild(rd, d, name, null);
                }
                catch (IllegalManagedObjectNameException e) {
                    throw new RuntimeException(e);
                }
                this.createDefaultManagedObject(d, child, dmo);
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitOptional(OptionalRelationDefinition<C, S> rd, Void p) {
            if (rd.getDefaultManagedObject() != null) {
                DefaultManagedObject<C, S> dmo = rd.getDefaultManagedObject();
                ManagedObjectDefinition<C, S> d = dmo.getManagedObjectDefinition();
                ManagedObject<C> child = AbstractManagedObject.this.createChild(rd, d, null);
                this.createDefaultManagedObject(d, child, dmo);
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSingleton(SingletonRelationDefinition<C, S> rd, Void p) {
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSet(SetRelationDefinition<C, S> rd, Void p) {
            for (String name : rd.getDefaultManagedObjectNames()) {
                DefaultManagedObject<C, S> dmo = rd.getDefaultManagedObject(name);
                ManagedObjectDefinition<C, S> d = dmo.getManagedObjectDefinition();
                ManagedObject<C> child = AbstractManagedObject.this.createChild(rd, d, null);
                this.createDefaultManagedObject(d, child, dmo);
            }
            return null;
        }

        private void createDefaultManagedObject(ManagedObjectDefinition<?, ?> d, ManagedObject<?> child, DefaultManagedObject<?, ?> dmo) {
            for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                this.setPropertyValues(child, pd, dmo);
            }
            try {
                child.commit();
            }
            catch (AuthorizationException e) {
                this.ae = e;
            }
            catch (ManagedObjectAlreadyExistsException e) {
                this.moaee = e;
            }
            catch (MissingMandatoryPropertiesException e) {
                this.mmpe = e;
            }
            catch (ConcurrentModificationException e) {
                this.cme = e;
            }
            catch (OperationRejectedException e) {
                this.ore = e;
            }
            catch (CommunicationException e) {
                this.ce = e;
            }
        }

        private void createDefaultManagedObjects(RelationDefinition<?, ?> rd) throws AuthorizationException, CommunicationException, ConcurrentModificationException, MissingMandatoryPropertiesException, ManagedObjectAlreadyExistsException, OperationRejectedException {
            rd.accept(this, null);
            if (this.ae != null) {
                throw this.ae;
            }
            if (this.ce != null) {
                throw this.ce;
            }
            if (this.cme != null) {
                throw this.cme;
            }
            if (this.mmpe != null) {
                throw this.mmpe;
            }
            if (this.moaee != null) {
                throw this.moaee;
            }
            if (this.ore != null) {
                throw this.ore;
            }
        }

        private <PD> void setPropertyValues(ManagedObject<?> mo, PropertyDefinition<PD> pd, DefaultManagedObject<?, ?> dmo) {
            mo.setPropertyValues(pd, dmo.getPropertyValues((PropertyDefinition)pd));
        }
    }
}

