/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.TraditionalWorkQueueCfgClient;
import org.opends.server.admin.std.meta.WorkQueueCfgDefn;
import org.opends.server.admin.std.server.TraditionalWorkQueueCfg;
import org.opends.server.admin.std.server.WorkQueueCfg;
import org.opends.server.types.DN;

public final class TraditionalWorkQueueCfgDefn
extends ManagedObjectDefinition<TraditionalWorkQueueCfgClient, TraditionalWorkQueueCfg> {
    private static final TraditionalWorkQueueCfgDefn INSTANCE = new TraditionalWorkQueueCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_MAX_WORK_QUEUE_CAPACITY;
    private static final IntegerPropertyDefinition PD_NUM_WORKER_THREADS;

    public static TraditionalWorkQueueCfgDefn getInstance() {
        return INSTANCE;
    }

    private TraditionalWorkQueueCfgDefn() {
        super("traditional-work-queue", WorkQueueCfgDefn.getInstance());
    }

    @Override
    public TraditionalWorkQueueCfgClient createClientConfiguration(ManagedObject<? extends TraditionalWorkQueueCfgClient> impl) {
        return new TraditionalWorkQueueCfgClientImpl(impl);
    }

    @Override
    public TraditionalWorkQueueCfg createServerConfiguration(ServerManagedObject<? extends TraditionalWorkQueueCfg> impl) {
        return new TraditionalWorkQueueCfgServerImpl(impl);
    }

    @Override
    public Class<TraditionalWorkQueueCfg> getServerConfigurationClass() {
        return TraditionalWorkQueueCfg.class;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getMaxWorkQueueCapacityPropertyDefinition() {
        return PD_MAX_WORK_QUEUE_CAPACITY;
    }

    public IntegerPropertyDefinition getNumWorkerThreadsPropertyDefinition() {
        return PD_NUM_WORKER_THREADS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.TraditionalWorkQueue");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.WorkQueue");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-work-queue-capacity");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-work-queue-capacity"));
        provider = new DefinedDefaultBehaviorProvider("1000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_MAX_WORK_QUEUE_CAPACITY = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_WORK_QUEUE_CAPACITY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-worker-threads");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "num-worker-threads"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "num-worker-threads"));
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_NUM_WORKER_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_WORKER_THREADS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class TraditionalWorkQueueCfgServerImpl
    implements TraditionalWorkQueueCfg {
        private ServerManagedObject<? extends TraditionalWorkQueueCfg> impl;
        private final String pJavaClass;
        private final int pMaxWorkQueueCapacity;
        private final Integer pNumWorkerThreads;

        private TraditionalWorkQueueCfgServerImpl(ServerManagedObject<? extends TraditionalWorkQueueCfg> impl) {
            this.impl = impl;
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMaxWorkQueueCapacity = impl.getPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition());
            this.pNumWorkerThreads = impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void addTraditionalChangeListener(ConfigurationChangeListener<TraditionalWorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeTraditionalChangeListener(ConfigurationChangeListener<TraditionalWorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public int getMaxWorkQueueCapacity() {
            return this.pMaxWorkQueueCapacity;
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.pNumWorkerThreads;
        }

        @Override
        public Class<? extends TraditionalWorkQueueCfg> configurationClass() {
            return TraditionalWorkQueueCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class TraditionalWorkQueueCfgClientImpl
    implements TraditionalWorkQueueCfgClient {
        private ManagedObject<? extends TraditionalWorkQueueCfgClient> impl;

        private TraditionalWorkQueueCfgClientImpl(ManagedObject<? extends TraditionalWorkQueueCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public int getMaxWorkQueueCapacity() {
            return this.impl.getPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition());
        }

        @Override
        public void setMaxWorkQueueCapacity(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition(), value);
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void setNumWorkerThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends TraditionalWorkQueueCfgClient, ? extends TraditionalWorkQueueCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

