/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.WorkflowCfgClient;
import org.opends.server.admin.std.client.WorkflowElementCfgClient;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.admin.std.server.WorkflowElementCfg;
import org.opends.server.types.DN;

public final class WorkflowCfgDefn
extends ManagedObjectDefinition<WorkflowCfgClient, WorkflowCfg> {
    private static final WorkflowCfgDefn INSTANCE = new WorkflowCfgDefn();
    private static final DNPropertyDefinition PD_BASE_DN;
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final AggregationPropertyDefinition<WorkflowElementCfgClient, WorkflowElementCfg> PD_WORKFLOW_ELEMENT;

    public static WorkflowCfgDefn getInstance() {
        return INSTANCE;
    }

    private WorkflowCfgDefn() {
        super("workflow", TopCfgDefn.getInstance());
    }

    @Override
    public WorkflowCfgClient createClientConfiguration(ManagedObject<? extends WorkflowCfgClient> impl) {
        return new WorkflowCfgClientImpl(impl);
    }

    @Override
    public WorkflowCfg createServerConfiguration(ServerManagedObject<? extends WorkflowCfg> impl) {
        return new WorkflowCfgServerImpl(impl);
    }

    @Override
    public Class<WorkflowCfg> getServerConfigurationClass() {
        return WorkflowCfg.class;
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PD_BASE_DN;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public AggregationPropertyDefinition<WorkflowElementCfgClient, WorkflowElementCfg> getWorkflowElementPropertyDefinition() {
        return PD_WORKFLOW_ELEMENT;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DNPropertyDefinition.createBuilder(INSTANCE, "base-dn");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "base-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BASE_DN);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "workflow-element");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "workflow-element"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("workflow-element");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_WORKFLOW_ELEMENT = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WORKFLOW_ELEMENT);
        INSTANCE.registerConstraint(PD_WORKFLOW_ELEMENT.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class WorkflowCfgServerImpl
    implements WorkflowCfg {
        private ServerManagedObject<? extends WorkflowCfg> impl;
        private final DN pBaseDN;
        private final boolean pEnabled;
        private final String pWorkflowElement;

        private WorkflowCfgServerImpl(ServerManagedObject<? extends WorkflowCfg> impl) {
            this.impl = impl;
            this.pBaseDN = impl.getPropertyValue(INSTANCE.getBaseDNPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pWorkflowElement = impl.getPropertyValue(INSTANCE.getWorkflowElementPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<WorkflowCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<WorkflowCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public DN getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getWorkflowElement() {
            return this.pWorkflowElement;
        }

        @Override
        public DN getWorkflowElementDN() {
            String value = this.getWorkflowElement();
            if (value == null) {
                return null;
            }
            return INSTANCE.getWorkflowElementPropertyDefinition().getChildDN(value);
        }

        @Override
        public Class<? extends WorkflowCfg> configurationClass() {
            return WorkflowCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class WorkflowCfgClientImpl
    implements WorkflowCfgClient {
        private ManagedObject<? extends WorkflowCfgClient> impl;

        private WorkflowCfgClientImpl(ManagedObject<? extends WorkflowCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public DN getBaseDN() {
            return this.impl.getPropertyValue(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(DN value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getBaseDNPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getWorkflowElement() {
            return this.impl.getPropertyValue(INSTANCE.getWorkflowElementPropertyDefinition());
        }

        @Override
        public void setWorkflowElement(String value) {
            this.impl.setPropertyValue(INSTANCE.getWorkflowElementPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends WorkflowCfgClient, ? extends WorkflowCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

