/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.AuthenticationPolicy;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public abstract class AuthenticationPolicyState {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected ConditionResult isDisabled = ConditionResult.UNDEFINED;
    protected final Entry userEntry;

    public static final AuthenticationPolicyState forUser(Entry userEntry, boolean useDefaultOnError) throws DirectoryException {
        AuthenticationPolicy policy = AuthenticationPolicy.forUser(userEntry, useDefaultOnError);
        return policy.createAuthenticationPolicyState(userEntry);
    }

    protected static final ConditionResult getBoolean(Entry entry, AttributeType attributeType) throws DirectoryException {
        List<Attribute> attrList = entry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                String valueString = StaticUtils.toLowerCase(a.iterator().next().getValue().toString());
                if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Attribute %s resolves to true for user entry %s", attributeType.getNameOrOID(), entry.getDN().toString());
                    }
                    return ConditionResult.TRUE;
                }
                if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Attribute %s resolves to false for user entry %s", attributeType.getNameOrOID(), entry.getDN().toString());
                    }
                    return ConditionResult.FALSE;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Unable to resolve value %s for attribute %s in user entry %s as a Boolean.", valueString, attributeType.getNameOrOID(), entry.getDN().toString());
                }
                Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_BOOLEAN.get(valueString, attributeType.getNameOrOID(), entry.getDN().toString());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %s because attribute %s does not exist in user entry %s", ConditionResult.UNDEFINED.toString(), attributeType.getNameOrOID(), entry.getDN().toString());
        }
        return ConditionResult.UNDEFINED;
    }

    protected static final long getGeneralizedTime(Entry entry, AttributeType attributeType) throws DirectoryException {
        long timeValue = -1L;
        List<Attribute> attrList = entry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                AttributeValue v = a.iterator().next();
                try {
                    timeValue = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(v.getNormalizedValue());
                    break;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        TRACER.debugWarning("Unable to decode value %s for attribute %s in user entry %s: %s", v.getValue().toString(), attributeType.getNameOrOID(), entry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                    }
                    Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_GENERALIZED_TIME.get(v.getValue().toString(), attributeType.getNameOrOID(), entry.getDN().toString(), String.valueOf(e));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                }
            }
        }
        if (timeValue == -1L && DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning -1 because attribute %s does not exist in user entry %s", attributeType.getNameOrOID(), entry.getDN().toString());
        }
        return timeValue;
    }

    protected AuthenticationPolicyState(Entry userEntry) {
        this.userEntry = userEntry;
    }

    public void finalizeStateAfterBind() throws DirectoryException {
    }

    public abstract AuthenticationPolicy getAuthenticationPolicy();

    public boolean isDisabled() {
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
        try {
            this.isDisabled = AuthenticationPolicyState.getBoolean(this.userEntry, type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.isDisabled = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("User %s is considered administratively disabled because an error occurred while attempting to make the determination: %s.", this.userEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
            }
            return true;
        }
        if (this.isDisabled == ConditionResult.UNDEFINED) {
            this.isDisabled = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("User %s is not administratively disabled since the attribute \"%s\" is not present in the entry.", this.userEntry.getDN().toString(), "ds-pwp-account-disabled");
            }
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("User %s %s administratively disabled.", this.userEntry.getDN().toString(), this.isDisabled == ConditionResult.TRUE ? " is" : " is not");
        }
        return this.isDisabled == ConditionResult.TRUE;
    }

    public boolean isPasswordPolicy() {
        return this.getAuthenticationPolicy().isPasswordPolicy();
    }

    public abstract boolean passwordMatches(ByteString var1) throws DirectoryException;
}

