/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.EntryCacheMonitorProvider;
import org.opends.server.types.Attribute;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=true, notes="Entry cache methods may only be invoked by backends")
public abstract class EntryCache<T extends EntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Set<SearchFilter> excludeFilters = new HashSet<SearchFilter>(0);
    private Set<SearchFilter> includeFilters = new HashSet<SearchFilter>(0);
    protected AtomicLong cacheHits = new AtomicLong(0L);
    protected AtomicLong cacheMisses = new AtomicLong(0L);
    private EntryCacheMonitorProvider entryCacheMonitor = null;

    public abstract void initializeEntryCache(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public abstract void finalizeEntryCache();

    public abstract boolean containsEntry(DN var1);

    public abstract Entry getEntry(DN var1);

    public Entry getEntry(Backend backend, long entryID) {
        DN entryDN = this.getEntryDN(backend, entryID);
        if (entryDN == null) {
            this.cacheMisses.getAndIncrement();
            return null;
        }
        return this.getEntry(entryDN);
    }

    public abstract long getEntryID(DN var1);

    public abstract DN getEntryDN(Backend var1, long var2);

    public abstract void putEntry(Entry var1, Backend var2, long var3);

    public abstract boolean putEntryIfAbsent(Entry var1, Backend var2, long var3);

    public abstract void removeEntry(DN var1);

    public abstract void clear();

    public abstract void clearBackend(Backend var1);

    public abstract void clearSubtree(DN var1);

    public abstract void handleLowMemory();

    public final EntryCacheMonitorProvider getEntryCacheMonitor() {
        return this.entryCacheMonitor;
    }

    public final void setEntryCacheMonitor(EntryCacheMonitorProvider entryCacheMonitor) {
        this.entryCacheMonitor = entryCacheMonitor;
    }

    public abstract ArrayList<Attribute> getMonitorData();

    public abstract Long getCacheCount();

    public Long getCacheHits() {
        return new Long(this.cacheHits.longValue());
    }

    public Long getCacheMisses() {
        return new Long(this.cacheMisses.longValue());
    }

    public Set<SearchFilter> getExcludeFilters() {
        return this.excludeFilters;
    }

    public void setExcludeFilters(Set<SearchFilter> excludeFilters) {
        this.excludeFilters = excludeFilters == null ? new HashSet<SearchFilter>(0) : excludeFilters;
    }

    public Set<SearchFilter> getIncludeFilters() {
        return this.includeFilters;
    }

    public void setIncludeFilters(Set<SearchFilter> includeFilters) {
        this.includeFilters = includeFilters == null ? new HashSet<SearchFilter>(0) : includeFilters;
    }

    public boolean filtersAllowCaching(Entry entry) {
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter f : this.excludeFilters) {
                try {
                    if (!f.matchesEntry(entry)) continue;
                    return false;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return false;
                }
            }
        }
        if (!this.includeFilters.isEmpty()) {
            boolean matchFound = false;
            for (SearchFilter f : this.includeFilters) {
                try {
                    if (!f.matchesEntry(entry)) continue;
                    matchFound = true;
                    break;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (!matchFound) {
                return false;
            }
        }
        return true;
    }

    public abstract String toVerboseString();
}

