/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumAccessType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.PermBindRulePair;

public class AciBody {
    private static final int VERSION = 1;
    private static final int NAME = 2;
    private static final int PERM = 1;
    private static final int RIGHTS = 2;
    private static final int BINDRULE = 3;
    private int startPos = 0;
    private String name = null;
    private String version = null;
    private List<PermBindRulePair> permBindRulePairs;
    private static final String permissionRegex = "(\\w+)\\s*\\(([^()]+)\\)";
    private static final String bindRuleRegex = "(.+?\"[)]*)\\s*;\\s*";
    private static final String actionRegex = "\\s*(\\w+)\\s*\\(([^()]+)\\)\\s*(.+?\"[)]*)\\s*;\\s*";
    private static final String versionRegex = "(\\d\\.\\d)";
    private static final String versionToken = "(?i)version(?-i)";
    private static final String aclToken = "(?i)acl(?-i)";
    public static final String bodyRegx = "\\(\\s*(?i)version(?-i)\\s*(\\d\\.\\d)\\s*;\\s*(?i)acl(?-i)\\s*\"([^\"]*)\"\\s*;\\s*\\s*(\\w+)\\s*\\(([^()]+)\\)\\s*(.+?\"[)]*)\\s*;\\s*\\s*\\)";
    private static final String header = "\\(\\s*(?i)version(?-i)\\s*(\\d\\.\\d)\\s*;\\s*(?i)acl(?-i)\\s*\"(.*?)\"\\s*;\\s*";

    private AciBody(String verision, String name, int startPos, List<PermBindRulePair> permBindRulePairs) {
        this.version = verision;
        this.name = name;
        this.startPos = startPos;
        this.permBindRulePairs = permBindRulePairs;
    }

    public static AciBody decode(String input) throws AciException {
        String version = null;
        String name = null;
        int startPos = 0;
        ArrayList<PermBindRulePair> permBindRulePairs = new ArrayList<PermBindRulePair>();
        Pattern bodyPattern = Pattern.compile(header);
        Matcher bodyMatcher = bodyPattern.matcher(input);
        if (bodyMatcher.find()) {
            startPos = bodyMatcher.start();
            version = bodyMatcher.group(1);
            if (!version.equalsIgnoreCase("3.0")) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVAILD_VERSION.get(version);
                throw new AciException(message);
            }
            name = bodyMatcher.group(2);
            input = input.substring(bodyMatcher.end());
        }
        Pattern bodyPattern1 = Pattern.compile("\\G\\s*(\\w+)\\s*\\(([^()]+)\\)\\s*(.+?\"[)]*)\\s*;\\s*");
        Matcher bodyMatcher1 = bodyPattern1.matcher(input);
        int lastIndex = -1;
        while (bodyMatcher1.find()) {
            String perm = bodyMatcher1.group(1);
            String rights = bodyMatcher1.group(2);
            String bRule = bodyMatcher1.group(3);
            PermBindRulePair pair = PermBindRulePair.decode(perm, rights, bRule);
            permBindRulePairs.add(pair);
            lastIndex = bodyMatcher1.end();
        }
        if (lastIndex >= 0 && input.charAt(lastIndex) != ')') {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_GENERAL_PARSE_FAILED.get(input);
            throw new AciException(message);
        }
        return new AciBody(version, name, startPos, permBindRulePairs);
    }

    public boolean hasAccessType(EnumAccessType accessType) {
        List<PermBindRulePair> pairs = this.getPermBindRulePairs();
        for (PermBindRulePair p : pairs) {
            if (!p.hasAccessType(accessType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRights(int rights) {
        List<PermBindRulePair> pairs = this.getPermBindRulePairs();
        for (PermBindRulePair p : pairs) {
            if (!p.hasRights(rights)) continue;
            return true;
        }
        return false;
    }

    private List<PermBindRulePair> getPermBindRulePairs() {
        return this.permBindRulePairs;
    }

    public int getMatcherStartPos() {
        return this.startPos;
    }

    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult res = EnumEvalResult.FALSE;
        List<PermBindRulePair> pairs = this.getPermBindRulePairs();
        for (PermBindRulePair p : pairs) {
            if (evalCtx.isDenyEval() && p.hasAccessType(EnumAccessType.ALLOW) || !p.hasRights(this.getEvalRights(evalCtx))) continue;
            res = p.getBindRule().evaluate(evalCtx);
            if (res != EnumEvalResult.TRUE && res != EnumEvalResult.FALSE) {
                res = EnumEvalResult.FAIL;
                break;
            }
            if (p.hasAccessType(EnumAccessType.DENY) && res == EnumEvalResult.TRUE) {
                res = EnumEvalResult.TRUE;
                break;
            }
            if (!p.hasAccessType(EnumAccessType.ALLOW) || res != EnumEvalResult.TRUE) continue;
            res = EnumEvalResult.TRUE;
            break;
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    private int getEvalRights(AciEvalContext evalCtx) {
        if (evalCtx.hasRights(8) && evalCtx.hasRights(64)) {
            return 64;
        }
        if (evalCtx.hasRights(1)) {
            return 1;
        }
        if (evalCtx.hasRights(2)) {
            return 2;
        }
        if (evalCtx.hasRights(4)) {
            return 4;
        }
        if (evalCtx.hasRights(16)) {
            return 16;
        }
        if (evalCtx.hasRights(32)) {
            return 32;
        }
        if (evalCtx.hasRights(8)) {
            return 8;
        }
        if (evalCtx.hasRights(128)) {
            return 128;
        }
        if (evalCtx.hasRights(256)) {
            return 256;
        }
        if (evalCtx.hasRights(512)) {
            return 512;
        }
        return 0;
    }

    public String getVersion() {
        return this.version;
    }
}

