/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.opends.messages.BackendMessages;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.MonitorBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.util.Validator;

public class MonitorBackend
extends Backend
implements ConfigurationChangeListener<MonitorBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<Attribute> userDefinedAttributes;
    private HashMap<ObjectClass, String> monitorObjectClasses;
    private DN configEntryDN;
    private MonitorBackendCfg currentConfig;
    private DN baseMonitorDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_ADD_NOT_SUPPORTED.get(String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(MonitorBackendCfg backendCfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<Attribute> userAttrs = new ArrayList<Attribute>();
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
            for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isMonitorConfigAttribute(a)) continue;
                    userAttrs.add(a);
                }
            }
            for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isMonitorConfigAttribute(a)) continue;
                    userAttrs.add(a);
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(ConfigMessages.ERR_CONFIG_BACKEND_ERROR_INTERACTING_WITH_BACKEND_ENTRY.get(String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        this.userDefinedAttributes = userAttrs;
        Message message = BackendMessages.INFO_MONITOR_USING_NEW_USER_ATTRS.get();
        messages.add(message);
        this.currentConfig = backendCfg;
        return new ConfigChangeResult(resultCode, false, messages);
    }

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof MonitorBackendCfg);
        MonitorBackendCfg cfg = (MonitorBackendCfg)config;
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(cfg.dn());
        if (configEntry == null) {
            Message message = BackendMessages.ERR_MONITOR_CONFIG_ENTRY_NULL.get();
            throw new ConfigException(message);
        }
        this.configEntryDN = configEntry.getDN();
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isMonitorConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isMonitorConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        this.monitorObjectClasses = new LinkedHashMap<ObjectClass, String>(2);
        ObjectClass topOC = DirectoryServer.getObjectClass("top", true);
        this.monitorObjectClasses.put(topOC, "top");
        ObjectClass monitorOC = DirectoryServer.getObjectClass("ds-monitor-entry", true);
        this.monitorObjectClasses.put(monitorOC, "ds-monitor-entry");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        try {
            this.baseMonitorDN = DN.decode("cn=monitor");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_MONITOR_CANNOT_DECODE_MONITOR_ROOT_DN.get(StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        this.baseDNs = new DN[]{this.baseMonitorDN};
        this.currentConfig = cfg;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_DELETE_NOT_SUPPORTED.get(String.valueOf(entryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        return this.getDIT().containsKey(entryDN);
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        block12: {
            LDIFWriter ldifWriter;
            try {
                ldifWriter = new LDIFWriter(exportConfig);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_ROOTDSE_UNABLE_TO_CREATE_LDIF_WRITER.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            try {
                ldifWriter.writeEntry(this.getBaseMonitorEntry());
            }
            catch (Exception e) {
                block11: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        ldifWriter.close();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block11;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                Message message = BackendMessages.ERR_MONITOR_UNABLE_TO_EXPORT_BASE.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            for (MonitorProvider monitorProvider : DirectoryServer.getMonitorProviders().values()) {
            }
            try {
                ldifWriter.close();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block12;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void finalizeBackend() {
        block2: {
            this.currentConfig.removeMonitorChangeListener(this);
            try {
                DirectoryServer.deregisterBaseDN(this.baseMonitorDN);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            Message message = BackendMessages.ERR_MONITOR_GET_ENTRY_NULL.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (entryDN.equals(this.baseMonitorDN)) {
            return this.getBaseMonitorEntry();
        }
        NavigableMap<DN, MonitorProvider<?>> dit = this.getDIT();
        if (!dit.containsKey(entryDN)) {
            Message message = BackendMessages.ERR_MONITOR_INVALID_BASE.get(String.valueOf(entryDN), String.valueOf(this.baseMonitorDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        return this.getEntry(entryDN, dit);
    }

    @Override
    public long getEntryCount() {
        return this.getDIT().size();
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        NavigableMap<DN, MonitorProvider<?>> dit = this.getDIT();
        if (!dit.containsKey(entryDN)) {
            return ConditionResult.UNDEFINED;
        }
        DN nextDN = dit.higherKey(entryDN);
        if (nextDN == null || !nextDN.isDescendantOf(entryDN)) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.TRUE;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_IMPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        this.currentConfig.addMonitorChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.baseMonitorDN, this, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(this.baseMonitorDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(MonitorBackendCfg backendCfg, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        NavigableMap<DN, MonitorProvider<?>> dit = this.getDIT();
        if (!dit.containsKey(entryDN)) {
            return -1L;
        }
        long count = 0L;
        int childDNSize = entryDN.getNumComponents() + 1;
        for (DN dn : dit.tailMap(entryDN, false).navigableKeySet()) {
            if (!dn.isDescendantOf(entryDN)) break;
            if (!subtree && dn.getNumComponents() != childDNSize) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_MODIFY_DN_NOT_SUPPORTED.get(String.valueOf(currentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_MODIFY_NOT_SUPPORTED.get(String.valueOf(newEntry.getDN()), String.valueOf(this.configEntryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_MONITOR_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        NavigableMap<DN, MonitorProvider<?>> dit = this.getDIT();
        if (!dit.containsKey(baseDN)) {
            DN matchedDN;
            for (matchedDN = baseDN.getParent(); matchedDN != null && !dit.containsKey(matchedDN); matchedDN = matchedDN.getParent()) {
            }
            Message message = BackendMessages.ERR_MEMORYBACKEND_ENTRY_DOESNT_EXIST.get(String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        for (Map.Entry<DN, MonitorProvider<?>> e : dit.tailMap(baseDN).entrySet()) {
            DN dn = e.getKey();
            if (dn.matchesBaseAndScope(baseDN, scope)) {
                Entry entry = this.getEntry(dn, dit);
                if (!filter.matchesEntry(entry)) continue;
                searchOperation.returnEntry(entry, null);
                continue;
            }
            if (scope != SearchScope.BASE_OBJECT && dn.isDescendantOf(baseDN)) continue;
            break;
        }
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    private Attribute createAttribute(String name, String lowerName, String value) {
        return Attributes.create(name, value);
    }

    private Entry getBaseMonitorEntry() {
        LinkedHashMap<ObjectClass, String> monitorClasses = new LinkedHashMap<ObjectClass, String>(3);
        monitorClasses.putAll(this.monitorObjectClasses);
        ObjectClass extensibleObjectOC = DirectoryServer.getObjectClass("extensibleobject", true);
        monitorClasses.put(extensibleObjectOC, "extensibleObject");
        LinkedHashMap<AttributeType, List<Attribute>> monitorUserAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> monitorOperationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        Attribute cnAttr = this.createAttribute("cn", "cn", "monitor");
        ArrayList<Attribute> cnList = new ArrayList<Attribute>(1);
        cnList.add(cnAttr);
        monitorUserAttrs.put(cnAttr.getAttributeType(), cnList);
        Attribute productNameAttr = this.createAttribute("productName", "productname", DynamicConstants.PRODUCT_NAME);
        ArrayList<Attribute> productNameList = new ArrayList<Attribute>(1);
        productNameList.add(productNameAttr);
        monitorUserAttrs.put(productNameAttr.getAttributeType(), productNameList);
        Attribute vendorNameAttr = this.createAttribute("vendorName", "vendorname", "ForgeRock AS.");
        ArrayList<Attribute> vendorNameList = new ArrayList<Attribute>(1);
        vendorNameList.add(vendorNameAttr);
        monitorUserAttrs.put(vendorNameAttr.getAttributeType(), vendorNameList);
        Attribute versionAttr = this.createAttribute("vendorVersion", "vendorversion", DirectoryServer.getVersionString());
        ArrayList<Attribute> versionList = new ArrayList<Attribute>(1);
        versionList.add(versionAttr);
        monitorUserAttrs.put(versionAttr.getAttributeType(), versionList);
        Attribute startTimeAttr = this.createAttribute("startTime", "starttime", DirectoryServer.getStartTimeUTC());
        ArrayList<Attribute> startTimeList = new ArrayList<Attribute>(1);
        startTimeList.add(startTimeAttr);
        monitorUserAttrs.put(startTimeAttr.getAttributeType(), startTimeList);
        Attribute currentTimeAttr = this.createAttribute("currentTime", "currenttime", TimeThread.getGMTTime());
        ArrayList<Attribute> currentTimeList = new ArrayList<Attribute>(1);
        currentTimeList.add(currentTimeAttr);
        monitorUserAttrs.put(currentTimeAttr.getAttributeType(), currentTimeList);
        long upSeconds = (System.currentTimeMillis() - DirectoryServer.getStartTime()) / 1000L;
        long upDays = upSeconds / 86400L;
        long upHours = (upSeconds %= 86400L) / 3600L;
        long upMinutes = (upSeconds %= 3600L) / 60L;
        Message upTimeStr = BackendMessages.INFO_MONITOR_UPTIME.get(upDays, upHours, upMinutes, upSeconds %= 60L);
        Attribute upTimeAttr = this.createAttribute("upTime", "uptime", upTimeStr.toString());
        ArrayList<Attribute> upTimeList = new ArrayList<Attribute>(1);
        upTimeList.add(upTimeAttr);
        monitorUserAttrs.put(upTimeAttr.getAttributeType(), upTimeList);
        long currentConns = DirectoryServer.getCurrentConnections();
        Attribute currentConnsAttr = this.createAttribute("currentConnections", "currentconnections", String.valueOf(currentConns));
        ArrayList<Attribute> currentConnsList = new ArrayList<Attribute>(1);
        currentConnsList.add(currentConnsAttr);
        monitorUserAttrs.put(currentConnsAttr.getAttributeType(), currentConnsList);
        long maxConns = DirectoryServer.getMaxConnections();
        Attribute maxConnsAttr = this.createAttribute("maxConnections", "maxconnections", String.valueOf(maxConns));
        ArrayList<Attribute> maxConnsList = new ArrayList<Attribute>(1);
        maxConnsList.add(maxConnsAttr);
        monitorUserAttrs.put(maxConnsAttr.getAttributeType(), maxConnsList);
        long totalConns = DirectoryServer.getTotalConnections();
        Attribute totalConnsAttr = this.createAttribute("totalConnections", "totalconnections", String.valueOf(totalConns));
        ArrayList<Attribute> totalConnsList = new ArrayList<Attribute>(1);
        totalConnsList.add(totalConnsAttr);
        monitorUserAttrs.put(totalConnsAttr.getAttributeType(), totalConnsList);
        for (Attribute a : this.userDefinedAttributes) {
            List<Attribute> attrs;
            AttributeType type = a.getAttributeType();
            if (type.isOperational()) {
                attrs = (ArrayList<Attribute>)((HashMap)monitorOperationalAttrs).get(type);
                if (attrs == null) {
                    attrs = new ArrayList<Attribute>();
                    attrs.add(a);
                    monitorOperationalAttrs.put(type, attrs);
                    continue;
                }
                attrs.add(a);
                continue;
            }
            attrs = (List)((HashMap)monitorUserAttrs).get(type);
            if (attrs == null) {
                attrs = new ArrayList();
                attrs.add(a);
                monitorUserAttrs.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        Entry e = new Entry(this.baseMonitorDN, monitorClasses, monitorUserAttrs, monitorOperationalAttrs);
        e.processVirtualAttributes();
        return e;
    }

    private Entry getBranchMonitorEntry(DN dn) {
        LinkedHashMap<ObjectClass, String> monitorClasses = new LinkedHashMap<ObjectClass, String>(3);
        monitorClasses.putAll(this.monitorObjectClasses);
        ObjectClass monitorOC = DirectoryServer.getObjectClass("ds-mon-branch", true);
        monitorClasses.put(monitorOC, "ds-mon-branch");
        LinkedHashMap<AttributeType, List<Attribute>> monitorUserAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        RDN rdn = dn.getRDN();
        if (rdn != null) {
            for (int i = 0; i < rdn.getNumValues(); ++i) {
                AttributeType attributeType = rdn.getAttributeType(i);
                AttributeValue value = rdn.getAttributeValue(attributeType);
                Attribute attr = Attributes.create(attributeType, value);
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(attr);
                monitorUserAttrs.put(attributeType, attrList);
            }
        }
        Entry e = new Entry(dn, monitorClasses, monitorUserAttrs, null);
        e.processVirtualAttributes();
        return e;
    }

    private NavigableMap<DN, MonitorProvider<?>> getDIT() {
        TreeMap dit = new TreeMap();
        for (MonitorProvider monitorProvider : DirectoryServer.getMonitorProviders().values()) {
            DN dn = DirectoryServer.getMonitorProviderDN(monitorProvider);
            dit.put(dn, monitorProvider);
            for (dn = dn.getParent(); dn != null && !dit.containsKey(dn); dn = dn.getParent()) {
                dit.put(dn, null);
            }
        }
        return dit;
    }

    private Entry getEntry(DN entryDN, Map<DN, MonitorProvider<?>> dit) {
        MonitorProvider<?> monitorProvider = dit.get(entryDN);
        if (monitorProvider != null) {
            return this.getMonitorEntry(entryDN, monitorProvider);
        }
        if (entryDN.equals(this.baseMonitorDN)) {
            return this.getBaseMonitorEntry();
        }
        return this.getBranchMonitorEntry(entryDN);
    }

    private Entry getMonitorEntry(DN entryDN, MonitorProvider<?> monitorProvider) {
        LinkedHashMap<ObjectClass, String> monitorClasses = new LinkedHashMap<ObjectClass, String>(3);
        monitorClasses.putAll(this.monitorObjectClasses);
        ObjectClass monitorOC = monitorProvider.getMonitorObjectClass();
        monitorClasses.put(monitorOC, monitorOC.getPrimaryName());
        List<Attribute> monitorAttrs = monitorProvider.getMonitorData();
        LinkedHashMap<AttributeType, List<Attribute>> attrMap = new LinkedHashMap<AttributeType, List<Attribute>>(monitorAttrs.size() + 1);
        RDN entryRDN = entryDN.getRDN();
        AttributeType rdnType = entryRDN.getAttributeType(0);
        AttributeValue rdnValue = entryRDN.getAttributeValue(0);
        Attribute rdnAttr = Attributes.create(rdnType, rdnValue);
        ArrayList<Attribute> rdnList = new ArrayList<Attribute>(1);
        rdnList.add(rdnAttr);
        attrMap.put(rdnType, rdnList);
        for (Attribute a : monitorAttrs) {
            AttributeType type = a.getAttributeType();
            ArrayList<Attribute> attrs = (ArrayList<Attribute>)((HashMap)attrMap).get(type);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                attrs.add(a);
                attrMap.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        Entry e = new Entry(entryDN, monitorClasses, attrMap, new HashMap<AttributeType, List<Attribute>>(0));
        e.processVirtualAttributes();
        return e;
    }

    private boolean isMonitorConfigAttribute(Attribute attribute) {
        AttributeType attrType = attribute.getAttributeType();
        return attrType.hasName("cn") || attrType.hasName("ds-cfg-enabled".toLowerCase()) || attrType.hasName("ds-cfg-java-class".toLowerCase()) || attrType.hasName("ds-cfg-base-dn".toLowerCase()) || attrType.hasName("ds-cfg-backend-id".toLowerCase()) || attrType.hasName("ds-cfg-writability-mode".toLowerCase());
    }
}

