/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Mac;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class BackupManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String BACKUP_BASE_FILENAME = "backup-";
    public static final String PROPERTY_LAST_LOGFILE_NAME = "last_logfile_name";
    public static final String PROPERTY_LAST_LOGFILE_SIZE = "last_logfile_size";
    public static final String ZIPENTRY_UNCHANGED_LOGFILES = "unchanged.txt";
    public static final String ZIPENTRY_EMPTY_PLACEHOLDER = "empty.placeholder";
    private String backendID;

    public BackupManager(String backendID) {
        this.backendID = backendID;
    }

    public void createBackup(File backendDir, BackupConfig backupConfig) throws DirectoryException {
        Object[] logFiles;
        OutputStream outputStream;
        String backupID = backupConfig.getBackupID();
        BackupDirectory backupDir = backupConfig.getBackupDirectory();
        boolean incremental = backupConfig.isIncremental();
        String incrBaseID = backupConfig.getIncrementalBaseID();
        boolean compress = backupConfig.compressData();
        boolean encrypt = backupConfig.encryptData();
        boolean hash = backupConfig.hashData();
        boolean signHash = backupConfig.signHash();
        HashMap<String, String> backupProperties = new HashMap<String, String>();
        CryptoManagerImpl cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest digest = null;
        String digestAlgorithm = null;
        String macKeyID = null;
        if (hash) {
            if (signHash) {
                try {
                    macKeyID = cryptoManager.getMacEngineKeyEntryID();
                    backupProperties.put("mac_key_id", macKeyID);
                    mac = cryptoManager.getMacEngine(macKeyID);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_MAC.get(macKeyID, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                }
            }
            digestAlgorithm = cryptoManager.getPreferredMessageDigestAlgorithm();
            backupProperties.put("digest_algorithm", digestAlgorithm);
            try {
                digest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_DIGEST.get(digestAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        Date backupDate = new Date();
        HashSet<String> dependencies = new HashSet<String>();
        BackupInfo baseBackup = null;
        if (incremental) {
            if (incrBaseID == null && backupDir.getLatestBackup() != null) {
                incrBaseID = backupDir.getLatestBackup().getBackupID();
            }
            if (incrBaseID == null) {
                incremental = false;
                Message message = JebMessages.WARN_BACKUPDB_INCREMENTAL_NOT_FOUND_DOING_NORMAL.get(backupDir.getPath());
                ErrorLogger.logError(message);
            } else {
                baseBackup = this.getBackupInfo(backupDir, incrBaseID);
            }
        }
        String latestFileName = null;
        long latestFileSize = 0L;
        if (baseBackup != null) {
            HashMap<String, String> properties = baseBackup.getBackupProperties();
            latestFileName = properties.get(PROPERTY_LAST_LOGFILE_NAME);
            latestFileSize = Long.parseLong(properties.get(PROPERTY_LAST_LOGFILE_SIZE));
        }
        String archiveFilename = null;
        try {
            archiveFilename = BACKUP_BASE_FILENAME + this.backendID + "-" + backupID;
            File archiveFile = new File(backupDir.getPath(), archiveFilename);
            if (archiveFile.exists()) {
                int i = 1;
                while ((archiveFile = new File(backupDir.getPath(), archiveFilename + "." + i)).exists()) {
                    ++i;
                }
                archiveFilename = archiveFilename + "." + i;
            }
            outputStream = new FileOutputStream(archiveFile, false);
            backupProperties.put("archive_file", archiveFilename);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_CREATE_ARCHIVE_FILE.get(String.valueOf(archiveFilename), backupDir.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (encrypt) {
            try {
                outputStream = cryptoManager.getCipherOutputStream(outputStream);
            }
            catch (CryptoManagerException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_CIPHER.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        Message message = JebMessages.ERR_JEB_BACKUP_ZIP_COMMENT.get(DynamicConstants.PRODUCT_NAME, backupID, this.backendID);
        zipStream.setComment(message.toString());
        if (compress) {
            zipStream.setLevel(-1);
        } else {
            zipStream.setLevel(0);
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return name.endsWith(".jdb");
            }
        };
        try {
            logFiles = backendDir.listFiles(filenameFilter);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = JebMessages.ERR_JEB_BACKUP_CANNOT_LIST_LOG_FILES.get(backendDir.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (logFiles.length <= 0) {
            try {
                ZipEntry emptyPlaceholder = new ZipEntry(ZIPENTRY_EMPTY_PLACEHOLDER);
                zipStream.putNextEntry(emptyPlaceholder);
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message = JebMessages.ERR_JEB_BACKUP_CANNOT_WRITE_ARCHIVE_FILE.get(ZIPENTRY_EMPTY_PLACEHOLDER, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        Arrays.sort(logFiles);
        try {
            Object logFile;
            int indexCurrent;
            if (latestFileName != null) {
                String logFileName;
                int compareResult;
                ArrayList<String> unchangedList = new ArrayList<String>();
                for (indexCurrent = 0; !(indexCurrent >= logFiles.length || backupConfig.isCancelled() || (compareResult = (logFileName = ((File)(logFile = logFiles[indexCurrent])).getName()).compareTo(latestFileName)) > 0 || compareResult == 0 && ((File)logFile).length() != latestFileSize); ++indexCurrent) {
                    message = JebMessages.NOTE_JEB_BACKUP_FILE_UNCHANGED.get(logFileName);
                    ErrorLogger.logError(message);
                    unchangedList.add(logFileName);
                }
                if (!unchangedList.isEmpty()) {
                    String zipEntryName = ZIPENTRY_UNCHANGED_LOGFILES;
                    try {
                        this.archiveList(zipStream, mac, digest, zipEntryName, unchangedList);
                    }
                    catch (IOException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = JebMessages.ERR_JEB_BACKUP_CANNOT_WRITE_ARCHIVE_FILE.get(zipEntryName, StaticUtils.stackTraceToSingleLineString(e));
                        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                    }
                    dependencies.add(baseBackup.getBackupID());
                }
            }
            while (true) {
                boolean deletedFiles = false;
                while (indexCurrent < logFiles.length && !backupConfig.isCancelled()) {
                    logFile = logFiles[indexCurrent];
                    try {
                        latestFileSize = this.archiveFile(zipStream, mac, digest, (File)logFile, backupConfig);
                        latestFileName = ((File)logFile).getName();
                    }
                    catch (FileNotFoundException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        deletedFiles = true;
                    }
                    catch (IOException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = JebMessages.ERR_JEB_BACKUP_CANNOT_WRITE_ARCHIVE_FILE.get(((File)logFile).getName(), StaticUtils.stackTraceToSingleLineString(e));
                        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                    }
                    ++indexCurrent;
                }
                if (!deletedFiles) break;
                final String latest = ((File)logFiles[logFiles.length - 1]).getName();
                final long latestSize = latestFileSize;
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File d, String name) {
                        if (!name.endsWith(".jdb")) {
                            return false;
                        }
                        int compareTo = name.compareTo(latest);
                        if (compareTo > 0) {
                            return true;
                        }
                        return compareTo == 0 && d.length() > latestSize;
                    }
                };
                try {
                    logFiles = backendDir.listFiles(filter);
                    indexCurrent = 0;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    message = JebMessages.ERR_JEB_BACKUP_CANNOT_LIST_LOG_FILES.get(backendDir.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                }
                if (logFiles != null) {
                    Arrays.sort(logFiles);
                    message = JebMessages.NOTE_JEB_BACKUP_CLEANER_ACTIVITY.get(String.valueOf(logFiles.length));
                    ErrorLogger.logError(message);
                    continue;
                }
                break;
            }
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                zipStream.close();
            }
            catch (Exception deletedFiles) {
                // empty catch block
            }
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = JebMessages.ERR_JEB_BACKUP_CANNOT_CLOSE_ZIP_STREAM.get(archiveFilename, backupDir.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] digestBytes = null;
        byte[] macBytes = null;
        if (hash) {
            if (signHash) {
                macBytes = mac.doFinal();
            } else {
                digestBytes = digest.digest();
            }
        }
        backupProperties.put(PROPERTY_LAST_LOGFILE_NAME, latestFileName);
        backupProperties.put(PROPERTY_LAST_LOGFILE_SIZE, String.valueOf(latestFileSize));
        BackupInfo backupInfo = new BackupInfo(backupDir, backupID, backupDate, incremental, compress, encrypt, digestBytes, macBytes, dependencies, backupProperties);
        try {
            backupDir.addBackup(backupInfo);
            backupDir.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = JebMessages.ERR_JEB_BACKUP_CANNOT_UPDATE_BACKUP_DESCRIPTOR.get(backupDir.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (backupConfig.isCancelled()) {
            this.removeBackup(backupDir, backupID);
        }
    }

    public void restoreBackup(File backendDir, RestoreConfig restoreConfig) throws DirectoryException {
        Set<String> includeFiles;
        String backupID = restoreConfig.getBackupID();
        BackupDirectory backupDir = restoreConfig.getBackupDirectory();
        boolean verifyOnly = restoreConfig.verifyOnly();
        BackupInfo backupInfo = this.getBackupInfo(backupDir, backupID);
        File restoreDir = new File(backendDir.getPath() + "-restore-" + backupID);
        if (!verifyOnly) {
            File[] files = restoreDir.listFiles();
            if (files != null) {
                for (File f : files) {
                    f.delete();
                }
            }
            restoreDir.mkdir();
        }
        try {
            includeFiles = this.getUnchanged(backupDir, backupInfo);
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_RESTORE.get(backupInfo.getBackupID(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        ArrayList<BackupInfo> dependents = this.getDependents(backupDir, backupInfo);
        for (BackupInfo dependent : dependents) {
            try {
                this.restoreArchive(restoreDir, restoreConfig, dependent, includeFiles);
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_RESTORE.get(dependent.getBackupID(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        try {
            this.restoreArchive(restoreDir, restoreConfig, backupInfo, null);
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_RESTORE.get(backupInfo.getBackupID(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (!verifyOnly) {
            File[] files = backendDir.listFiles();
            if (files != null) {
                for (File f : files) {
                    f.delete();
                }
            }
            backendDir.delete();
            if (!restoreDir.renameTo(backendDir)) {
                Message msg = JebMessages.ERR_JEB_CANNOT_RENAME_RESTORE_DIRECTORY.get(restoreDir.getPath(), backendDir.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
            }
        }
    }

    public void removeBackup(BackupDirectory backupDir, String backupID) throws DirectoryException {
        BackupInfo backupInfo = this.getBackupInfo(backupDir, backupID);
        HashMap<String, String> backupProperties = backupInfo.getBackupProperties();
        String archiveFilename = backupProperties.get("archive_file");
        File archiveFile = new File(backupDir.getPath(), archiveFilename);
        try {
            backupDir.removeBackup(backupID);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        try {
            backupDir.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_UPDATE_BACKUP_DESCRIPTOR.get(backupDir.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        archiveFile.delete();
    }

    private void restoreArchive(File restoreDir, RestoreConfig restoreConfig, BackupInfo backupInfo, Set<String> includeFiles) throws DirectoryException, IOException {
        byte[] computedSignHash;
        BackupDirectory backupDir = restoreConfig.getBackupDirectory();
        boolean verifyOnly = restoreConfig.verifyOnly();
        String backupID = backupInfo.getBackupID();
        boolean encrypt = backupInfo.isEncrypted();
        byte[] hash = backupInfo.getUnsignedHash();
        byte[] signHash = backupInfo.getSignedHash();
        HashMap<String, String> backupProperties = backupInfo.getBackupProperties();
        String archiveFilename = backupProperties.get("archive_file");
        File archiveFile = new File(backupDir.getPath(), archiveFilename);
        InputStream inputStream = new FileInputStream(archiveFile);
        CryptoManagerImpl cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest digest = null;
        String digestAlgorithm = null;
        String macKeyID = null;
        if (signHash != null) {
            macKeyID = backupProperties.get("mac_key_id");
            try {
                mac = cryptoManager.getMacEngine(macKeyID);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_MAC.get(macKeyID, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        if (hash != null) {
            digestAlgorithm = backupProperties.get("digest_algorithm");
            try {
                digest = cryptoManager.getMessageDigest(digestAlgorithm);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_DIGEST.get(digestAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        if (encrypt) {
            try {
                inputStream = cryptoManager.getCipherInputStream(inputStream);
            }
            catch (CryptoManagerException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_CIPHER.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipStream.getNextEntry();
        while (zipEntry != null && !restoreConfig.isCancelled()) {
            String name = zipEntry.getName();
            if (name.equals(ZIPENTRY_EMPTY_PLACEHOLDER)) {
                zipEntry = zipStream.getNextEntry();
                continue;
            }
            if (name.equals(ZIPENTRY_UNCHANGED_LOGFILES)) {
                if (mac != null || digest != null) {
                    if (mac != null) {
                        mac.update(StaticUtils.getBytes(name));
                    }
                    if (digest != null) {
                        digest.update(StaticUtils.getBytes(name));
                    }
                    InputStreamReader reader = new InputStreamReader(zipStream);
                    BufferedReader bufferedReader = new BufferedReader(reader);
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        if (mac != null) {
                            mac.update(StaticUtils.getBytes(line));
                        }
                        if (digest != null) {
                            digest.update(StaticUtils.getBytes(line));
                        }
                        line = bufferedReader.readLine();
                    }
                }
                zipEntry = zipStream.getNextEntry();
                continue;
            }
            File file = new File(restoreDir, name);
            FileOutputStream outputStream = null;
            if ((includeFiles == null || includeFiles.contains(zipEntry.getName())) && !verifyOnly) {
                outputStream = new FileOutputStream(file);
            }
            if (outputStream != null || mac != null || digest != null) {
                if (verifyOnly) {
                    Message message = JebMessages.NOTE_JEB_BACKUP_VERIFY_FILE.get(zipEntry.getName());
                    ErrorLogger.logError(message);
                }
                if (mac != null) {
                    mac.update(StaticUtils.getBytes(name));
                }
                if (digest != null) {
                    digest.update(StaticUtils.getBytes(name));
                }
                long totalBytesRead = 0L;
                byte[] buffer = new byte[8192];
                int bytesRead = zipStream.read(buffer);
                while (bytesRead > 0 && !restoreConfig.isCancelled()) {
                    totalBytesRead += (long)bytesRead;
                    if (mac != null) {
                        mac.update(buffer, 0, bytesRead);
                    }
                    if (digest != null) {
                        digest.update(buffer, 0, bytesRead);
                    }
                    if (outputStream != null) {
                        ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    }
                    bytesRead = zipStream.read(buffer);
                }
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                    Message message = JebMessages.NOTE_JEB_BACKUP_RESTORED_FILE.get(zipEntry.getName(), totalBytesRead);
                    ErrorLogger.logError(message);
                }
            }
            zipEntry = zipStream.getNextEntry();
        }
        zipStream.close();
        if (digest != null && !Arrays.equals(digest.digest(), hash)) {
            Message message = JebMessages.ERR_JEB_BACKUP_UNSIGNED_HASH_ERROR.get(backupID);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (mac != null && !Arrays.equals(computedSignHash = mac.doFinal(), signHash)) {
            Message message = JebMessages.ERR_JEB_BACKUP_SIGNED_HASH_ERROR.get(backupID);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
    }

    private long archiveFile(ZipOutputStream zipStream, Mac mac, MessageDigest digest, File file, BackupConfig backupConfig) throws IOException, FileNotFoundException {
        ZipEntry zipEntry = new ZipEntry(file.getName());
        FileInputStream inputStream = new FileInputStream(file);
        zipStream.putNextEntry(zipEntry);
        if (mac != null) {
            mac.update(StaticUtils.getBytes(file.getName()));
        }
        if (digest != null) {
            digest.update(StaticUtils.getBytes(file.getName()));
        }
        long totalBytesRead = 0L;
        byte[] buffer = new byte[8192];
        int bytesRead = ((InputStream)inputStream).read(buffer);
        while (bytesRead > 0 && !backupConfig.isCancelled()) {
            if (mac != null) {
                mac.update(buffer, 0, bytesRead);
            }
            if (digest != null) {
                digest.update(buffer, 0, bytesRead);
            }
            zipStream.write(buffer, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
            bytesRead = ((InputStream)inputStream).read(buffer);
        }
        ((InputStream)inputStream).close();
        zipStream.closeEntry();
        Message message = JebMessages.NOTE_JEB_BACKUP_ARCHIVED_FILE.get(zipEntry.getName());
        ErrorLogger.logError(message);
        return totalBytesRead;
    }

    private void archiveList(ZipOutputStream zipStream, Mac mac, MessageDigest digest, String fileName, List<String> list) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipStream.putNextEntry(zipEntry);
        if (mac != null) {
            mac.update(StaticUtils.getBytes(fileName));
        }
        if (digest != null) {
            digest.update(StaticUtils.getBytes(fileName));
        }
        OutputStreamWriter writer = new OutputStreamWriter(zipStream);
        for (String s : list) {
            if (mac != null) {
                mac.update(StaticUtils.getBytes(s));
            }
            if (digest != null) {
                digest.update(StaticUtils.getBytes(s));
            }
            writer.write(s);
            writer.write(ServerConstants.EOL);
        }
        ((Writer)writer).flush();
        zipStream.closeEntry();
    }

    private Set<String> getUnchanged(BackupDirectory backupDir, BackupInfo backupInfo) throws DirectoryException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        boolean encrypt = backupInfo.isEncrypted();
        HashMap<String, String> backupProperties = backupInfo.getBackupProperties();
        String archiveFilename = backupProperties.get("archive_file");
        File archiveFile = new File(backupDir.getPath(), archiveFilename);
        InputStream inputStream = new FileInputStream(archiveFile);
        CryptoManagerImpl cryptoManager = DirectoryServer.getCryptoManager();
        if (encrypt) {
            try {
                inputStream = cryptoManager.getCipherInputStream(inputStream);
            }
            catch (CryptoManagerException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_BACKUP_CANNOT_GET_CIPHER.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipStream.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equals(ZIPENTRY_UNCHANGED_LOGFILES)) {
                InputStreamReader reader = new InputStreamReader(zipStream);
                BufferedReader bufferedReader = new BufferedReader(reader);
                String line = bufferedReader.readLine();
                while (line != null) {
                    hashSet.add(line);
                    line = bufferedReader.readLine();
                }
                break;
            }
            zipEntry = zipStream.getNextEntry();
        }
        zipStream.close();
        return hashSet;
    }

    private ArrayList<BackupInfo> getDependents(BackupDirectory backupDir, BackupInfo backupInfo) throws DirectoryException {
        ArrayList<BackupInfo> dependents = new ArrayList<BackupInfo>();
        while (backupInfo != null && !backupInfo.getDependencies().isEmpty()) {
            String backupID = backupInfo.getDependencies().iterator().next();
            if ((backupInfo = this.getBackupInfo(backupDir, backupID)) == null) continue;
            dependents.add(backupInfo);
        }
        Collections.reverse(dependents);
        return dependents;
    }

    private BackupInfo getBackupInfo(BackupDirectory backupDir, String backupID) throws DirectoryException {
        BackupInfo backupInfo = backupDir.getBackupInfo(backupID);
        if (backupInfo == null) {
            Message message = JebMessages.ERR_JEB_BACKUP_MISSING_BACKUPID.get(backupID, backupDir.getPath());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        return backupInfo;
    }
}

