/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.admin.std.server.LocalDBVLVIndexCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.EntryCache;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.EntryIDSetSorter;
import org.opends.server.backends.jeb.ID2CIndexer;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ID2SIndexer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.IndexFilter;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.NullIndex;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.ServerSideSortResponseControl;
import org.opends.server.controls.SubtreeDeleteControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SortKey;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

public class EntryContainer
implements ConfigurationChangeListener<LocalDBBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String ID2ENTRY_DATABASE_NAME = "id2entry";
    public static final String DN2ID_DATABASE_NAME = "dn2id";
    public static final String ID2CHILDREN_DATABASE_NAME = "id2children";
    public static final String ID2SUBTREE_DATABASE_NAME = "id2subtree";
    public static final String REFERRAL_DATABASE_NAME = "referral";
    public static final String STATE_DATABASE_NAME = "state";
    public static final String ATTR_DEBUG_SEARCH_INDEX = "debugsearchindex";
    public AttributeJEIndexCfgManager attributeJEIndexCfgManager;
    public VLVJEIndexCfgManager vlvJEIndexCfgManager;
    private final Backend backend;
    private final RootContainer rootContainer;
    private final DN baseDN;
    private LocalDBBackendCfg config;
    private final Environment env;
    private DN2ID dn2id;
    private ID2Entry id2entry;
    private Index id2children;
    private Index id2subtree;
    private DN2URI dn2uri;
    private State state;
    private final HashMap<AttributeType, AttributeIndex> attrIndexMap;
    private final HashMap<String, VLVIndex> vlvIndexMap;
    private String databasePrefix;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock sharedLock = this.lock.readLock();
    final Lock exclusiveLock = this.lock.writeLock();

    public EntryContainer(DN baseDN, String databasePrefix, Backend backend, LocalDBBackendCfg config, Environment env, RootContainer rootContainer) throws ConfigException {
        this.backend = backend;
        this.baseDN = baseDN;
        this.config = config;
        this.env = env;
        this.rootContainer = rootContainer;
        this.databasePrefix = this.preparePrefix(databasePrefix);
        this.attrIndexMap = new HashMap();
        this.vlvIndexMap = new HashMap();
        config.addLocalDBChangeListener(this);
        this.attributeJEIndexCfgManager = new AttributeJEIndexCfgManager();
        config.addLocalDBIndexAddListener(this.attributeJEIndexCfgManager);
        config.addLocalDBIndexDeleteListener(this.attributeJEIndexCfgManager);
        this.vlvJEIndexCfgManager = new VLVJEIndexCfgManager();
        config.addLocalDBVLVIndexAddListener(this.vlvJEIndexCfgManager);
        config.addLocalDBVLVIndexDeleteListener(this.vlvJEIndexCfgManager);
    }

    public void open() throws DatabaseException, ConfigException {
        try {
            DataConfig entryDataConfig = new DataConfig(this.config.isEntriesCompressed(), this.config.isCompactEncoding(), this.rootContainer.getCompressedSchema());
            this.id2entry = new ID2Entry(this.databasePrefix + "_" + ID2ENTRY_DATABASE_NAME, entryDataConfig, this.env, this);
            this.id2entry.open();
            this.dn2id = new DN2ID(this.databasePrefix + "_" + DN2ID_DATABASE_NAME, this.env, this);
            this.dn2id.open();
            this.state = new State(this.databasePrefix + "_" + STATE_DATABASE_NAME, this.env, this);
            this.state.open();
            if (this.config.isSubordinateIndexesEnabled()) {
                this.openSubordinateIndexes();
            } else {
                this.id2children = new NullIndex(this.databasePrefix + "_" + ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), this.state, this.env, this);
                if (!this.env.getConfig().getReadOnly()) {
                    this.state.putIndexTrustState(null, this.id2children, false);
                }
                this.id2children.open();
                this.id2subtree = new NullIndex(this.databasePrefix + "_" + ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), this.state, this.env, this);
                if (!this.env.getConfig().getReadOnly()) {
                    this.state.putIndexTrustState(null, this.id2subtree, false);
                }
                this.id2subtree.open();
                ErrorLogger.logError(JebMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED.get(this.backend.getBackendID()));
            }
            this.dn2uri = new DN2URI(this.databasePrefix + "_" + REFERRAL_DATABASE_NAME, this.env, this);
            this.dn2uri.open();
            for (String idx : this.config.listLocalDBIndexes()) {
                LocalDBIndexCfg indexCfg = this.config.getLocalDBIndex(idx);
                AttributeIndex index = new AttributeIndex(indexCfg, this.state, this.env, this);
                index.open();
                if (!index.isTrusted()) {
                    ErrorLogger.logError(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(index.getName()));
                }
                this.attrIndexMap.put(indexCfg.getAttribute(), index);
            }
            for (String idx : this.config.listLocalDBVLVIndexes()) {
                LocalDBVLVIndexCfg vlvIndexCfg = this.config.getLocalDBVLVIndex(idx);
                VLVIndex vlvIndex = new VLVIndex(vlvIndexCfg, this.state, this.env, this);
                vlvIndex.open();
                if (!vlvIndex.isTrusted()) {
                    ErrorLogger.logError(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(vlvIndex.getName()));
                }
                this.vlvIndexMap.put(vlvIndexCfg.getName().toLowerCase(), vlvIndex);
            }
        }
        catch (DatabaseException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.close();
            throw de;
        }
    }

    public void close() throws DatabaseException {
        this.dn2id.close();
        this.id2entry.close();
        this.dn2uri.close();
        this.id2children.close();
        this.id2subtree.close();
        this.state.close();
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.close();
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.close();
        }
        this.config.removeLocalDBChangeListener(this);
        this.config.removeLocalDBIndexAddListener(this.attributeJEIndexCfgManager);
        this.config.removeLocalDBIndexDeleteListener(this.attributeJEIndexCfgManager);
        this.config.removeLocalDBVLVIndexAddListener(this.vlvJEIndexCfgManager);
        this.config.removeLocalDBVLVIndexDeleteListener(this.vlvJEIndexCfgManager);
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public DN2ID getDN2ID() {
        return this.dn2id;
    }

    public ID2Entry getID2Entry() {
        return this.id2entry;
    }

    public DN2URI getDN2URI() {
        return this.dn2uri;
    }

    public Index getID2Children() {
        return this.id2children;
    }

    public Index getID2Subtree() {
        return this.id2subtree;
    }

    public State getState() {
        return this.state;
    }

    public AttributeIndex getAttributeIndex(AttributeType attrType) {
        return this.attrIndexMap.get(attrType);
    }

    public Map<AttributeType, AttributeIndex> getAttributeIndexMap() {
        return this.attrIndexMap;
    }

    public VLVIndex getVLVIndex(String vlvIndexName) {
        return this.vlvIndexMap.get(vlvIndexName);
    }

    public Collection<AttributeIndex> getAttributeIndexes() {
        return this.attrIndexMap.values();
    }

    public Collection<VLVIndex> getVLVIndexes() {
        return this.vlvIndexMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryID getHighestEntryID() throws DatabaseException {
        EntryID entryID = new EntryID(0L);
        Cursor cursor = this.id2entry.openCursor(null, null);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try {
            OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                entryID = new EntryID(key);
            }
        }
        finally {
            cursor.close();
        }
        return entryID;
    }

    public long getNumSubordinates(DN entryDN, boolean subtree) throws DatabaseException {
        EntryID entryID = this.dn2id.get(null, entryDN, LockMode.DEFAULT);
        if (entryID != null) {
            DatabaseEntry key = new DatabaseEntry(JebFormat.entryIDToDatabase(entryID.longValue()));
            EntryIDSet entryIDSet = !subtree ? this.id2children.readKey(key, null, LockMode.DEFAULT) : this.id2subtree.readKey(key, null, LockMode.DEFAULT);
            long count = entryIDSet.size();
            if (count != Long.MAX_VALUE) {
                return count;
            }
        }
        return -1L;
    }

    public void search(SearchOperation searchOperation) throws DirectoryException, DatabaseException, CanceledOperationException {
        boolean candidatesAreInScope;
        EntryIDSet entryIDList;
        StringBuilder debugBuffer;
        ServerSideSortRequestControl sortRequest;
        PagedResultsControl pageRequest;
        block37: {
            DN aBaseDN = searchOperation.getBaseDN();
            SearchScope searchScope = searchOperation.getScope();
            pageRequest = searchOperation.getRequestControl(PagedResultsControl.DECODER);
            sortRequest = searchOperation.getRequestControl(ServerSideSortRequestControl.DECODER);
            if (sortRequest != null && !sortRequest.containsSortKeys() && sortRequest.isCritical()) {
                searchOperation.addResponseControl(new ServerSideSortResponseControl(16, null));
                searchOperation.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                return;
            }
            VLVRequestControl vlvRequest = searchOperation.getRequestControl(VLVRequestControl.DECODER);
            if (vlvRequest != null && pageRequest != null) {
                Message message = JebMessages.ERR_JEB_SEARCH_CANNOT_MIX_PAGEDRESULTS_AND_VLV.get();
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            if (pageRequest != null) {
                if (pageRequest.getSize() == 0) {
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
                    searchOperation.getResponseControls().add(control);
                    return;
                }
                if (searchOperation.getSizeLimit() > 0 && pageRequest.getSize() >= searchOperation.getSizeLimit()) {
                    pageRequest = null;
                }
            }
            if (searchScope == SearchScope.BASE_OBJECT) {
                Entry baseEntry = this.fetchBaseEntry(aBaseDN, searchScope);
                if (!EntryContainer.isManageDsaITOperation(searchOperation)) {
                    this.dn2uri.checkTargetForReferral(baseEntry, searchOperation.getScope());
                }
                if (searchOperation.getFilter().matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                if (pageRequest != null) {
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
                    searchOperation.getResponseControls().add(control);
                }
                return;
            }
            debugBuffer = null;
            if (searchOperation.getAttributes().contains(ATTR_DEBUG_SEARCH_INDEX)) {
                debugBuffer = new StringBuilder();
            }
            entryIDList = null;
            candidatesAreInScope = false;
            if (sortRequest != null) {
                for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
                    try {
                        entryIDList = vlvIndex.evaluate(null, searchOperation, sortRequest, vlvRequest, debugBuffer);
                        if (entryIDList == null) continue;
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(0, null));
                        candidatesAreInScope = true;
                        break;
                    }
                    catch (DirectoryException de) {
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(de.getResultCode().getIntValue(), null));
                        if (!sortRequest.isCritical()) continue;
                        throw de;
                    }
                }
            }
            if (entryIDList == null) {
                for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes()) {
                    if (!rule.getProvider().isSearchable(rule, searchOperation, true)) continue;
                    rule.getProvider().processSearch(rule, searchOperation);
                    return;
                }
                IndexFilter indexFilter = new IndexFilter(this, searchOperation, debugBuffer, this.rootContainer.getMonitorProvider());
                entryIDList = indexFilter.evaluate();
                if (entryIDList.size() > 10L) {
                    EntryIDSet scopeList;
                    EntryID baseID = this.dn2id.get(null, aBaseDN, LockMode.DEFAULT);
                    if (baseID == null) {
                        Message message = JebMessages.ERR_JEB_SEARCH_NO_SUCH_OBJECT.get(aBaseDN.toString());
                        DN matchedDN = this.getMatchedDN(aBaseDN);
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
                    }
                    DatabaseEntry baseIDData = baseID.getDatabaseEntry();
                    if (searchScope == SearchScope.SINGLE_LEVEL) {
                        scopeList = this.id2children.readKey(baseIDData, null, LockMode.DEFAULT);
                    } else {
                        scopeList = this.id2subtree.readKey(baseIDData, null, LockMode.DEFAULT);
                        if (searchScope == SearchScope.WHOLE_SUBTREE) {
                            scopeList.add(baseID);
                        }
                    }
                    entryIDList.retainAll(scopeList);
                    if (debugBuffer != null) {
                        debugBuffer.append(" scope=");
                        debugBuffer.append((Object)searchScope);
                        scopeList.toString(debugBuffer);
                    }
                    if (scopeList.isDefined()) {
                        candidatesAreInScope = true;
                    }
                }
                if (sortRequest != null) {
                    try {
                        entryIDList = EntryIDSetSorter.sort(this, entryIDList, searchOperation, sortRequest.getSortOrder(), vlvRequest);
                        if (sortRequest.containsSortKeys()) {
                            searchOperation.addResponseControl(new ServerSideSortResponseControl(0, null));
                        } else {
                            searchOperation.addResponseControl(new ServerSideSortResponseControl(16, null));
                        }
                    }
                    catch (DirectoryException de) {
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(de.getResultCode().getIntValue(), null));
                        if (!sortRequest.isCritical()) break block37;
                        throw de;
                    }
                }
            }
        }
        if (debugBuffer != null) {
            debugBuffer.append(" final=");
            entryIDList.toString(debugBuffer);
            Attribute attr = Attributes.create(ATTR_DEBUG_SEARCH_INDEX, debugBuffer.toString());
            Entry debugEntry = new Entry(DN.decode("cn=debugsearch"), null, null, null);
            debugEntry.addAttribute(attr, new ArrayList<AttributeValue>());
            searchOperation.returnEntry(debugEntry, null);
            return;
        }
        if (entryIDList.isDefined()) {
            if (this.rootContainer.getMonitorProvider().isFilterUseEnabled()) {
                this.rootContainer.getMonitorProvider().updateIndexedSearchCount();
            }
            this.searchIndexed(entryIDList, candidatesAreInScope, searchOperation, pageRequest);
        } else {
            Message message;
            if (this.rootContainer.getMonitorProvider().isFilterUseEnabled()) {
                this.rootContainer.getMonitorProvider().updateUnindexedSearchCount();
            }
            searchOperation.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "unindexed"));
            for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes()) {
                if (!rule.getProvider().isSearchable(rule, searchOperation, false)) continue;
                rule.getProvider().processSearch(rule, searchOperation);
                return;
            }
            ClientConnection clientConnection = searchOperation.getClientConnection();
            if (!clientConnection.hasPrivilege(Privilege.UNINDEXED_SEARCH, searchOperation)) {
                message = JebMessages.ERR_JEB_SEARCH_UNINDEXED_INSUFFICIENT_PRIVILEGES.get();
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
            }
            if (sortRequest != null) {
                searchOperation.addResponseControl(new ServerSideSortResponseControl(53, null));
                if (sortRequest.isCritical()) {
                    message = JebMessages.ERR_JEB_SEARCH_CANNOT_SORT_UNINDEXED.get();
                    throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, message);
                }
            }
            this.searchNotIndexed(searchOperation, pageRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchNotIndexed(SearchOperation searchOperation, PagedResultsControl pageRequest) throws DirectoryException, CanceledOperationException {
        block26: {
            byte[] begin;
            EntryCache entryCache = DirectoryServer.getEntryCache();
            DN aBaseDN = searchOperation.getBaseDN();
            SearchScope searchScope = searchOperation.getScope();
            boolean manageDsaIT = EntryContainer.isManageDsaITOperation(searchOperation);
            if (pageRequest == null || pageRequest.getCookie().length() == 0) {
                Entry baseEntry = this.fetchBaseEntry(aBaseDN, searchScope);
                if (!manageDsaIT) {
                    this.dn2uri.checkTargetForReferral(baseEntry, searchScope);
                }
                if (searchScope == SearchScope.WHOLE_SUBTREE && searchOperation.getFilter().matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                if (!manageDsaIT && !this.dn2uri.returnSearchReferences(searchOperation) && pageRequest != null) {
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
                    searchOperation.getResponseControls().add(control);
                }
            }
            byte[] baseDNKey = JebFormat.dnToDNKey(aBaseDN, this.baseDN.getNumComponents());
            byte[] suffix = Arrays.copyOf(baseDNKey, baseDNKey.length + 1);
            suffix[suffix.length - 1] = 0;
            byte[] end = (byte[])suffix.clone();
            end[end.length - 1] = (byte)(end[end.length - 1] + 1);
            if (pageRequest != null && pageRequest.getCookie().length() != 0) {
                try {
                    begin = pageRequest.getCookie().toByteArray();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    String str = pageRequest.getCookie().toHex();
                    Message msg = JebMessages.ERR_JEB_INVALID_PAGED_RESULTS_COOKIE.get(str);
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg, e);
                }
            } else {
                begin = suffix;
            }
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(begin);
            int lookthroughCount = 0;
            int lookthroughLimit = searchOperation.getClientConnection().getLookthroughLimit();
            try {
                Cursor cursor = this.dn2id.openCursor(null, null);
                try {
                    OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                    while (status == OperationStatus.SUCCESS) {
                        Entry cacheEntry;
                        Entry entry;
                        if (lookthroughLimit > 0 && lookthroughCount > lookthroughLimit) {
                            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
                            searchOperation.appendErrorMessage(JebMessages.NOTE_JEB_LOOKTHROUGH_LIMIT_EXCEEDED.get(lookthroughLimit));
                            return;
                        }
                        int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                        if (cmp >= 0) {
                            break;
                        }
                        EntryID entryID = new EntryID(data);
                        boolean isInScope = true;
                        if (searchScope == SearchScope.SINGLE_LEVEL && JebFormat.findDNKeyParent(key.getData(), 0, key.getSize()) != baseDNKey.length) {
                            isInScope = false;
                        }
                        if (isInScope && (entry = (cacheEntry = entryCache.getEntry(this.backend, entryID.longValue())) == null ? this.id2entry.get(null, entryID, LockMode.DEFAULT) : cacheEntry) != null) {
                            ++lookthroughCount;
                            if ((manageDsaIT || entry.getReferralURLs() == null) && searchOperation.getFilter().matchesEntry(entry)) {
                                if (pageRequest != null && searchOperation.getEntriesSent() == pageRequest.getSize()) {
                                    ByteString cookie = ByteString.wrap(key.getData());
                                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, cookie);
                                    searchOperation.getResponseControls().add(control);
                                    return;
                                }
                                if (!searchOperation.returnEntry(entry, null)) {
                                    return;
                                }
                            }
                        }
                        searchOperation.checkIfCanceled(false);
                        status = cursor.getNext(key, data, LockMode.DEFAULT);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (DatabaseException e) {
                if (!DebugLogger.debugEnabled()) break block26;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (pageRequest != null) {
            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
            searchOperation.getResponseControls().add(control);
        }
    }

    private void searchIndexed(EntryIDSet entryIDList, boolean candidatesAreInScope, SearchOperation searchOperation, PagedResultsControl pageRequest) throws DirectoryException, CanceledOperationException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        SearchScope searchScope = searchOperation.getScope();
        DN aBaseDN = searchOperation.getBaseDN();
        boolean manageDsaIT = EntryContainer.isManageDsaITOperation(searchOperation);
        boolean continueSearch = true;
        EntryID begin = null;
        if (pageRequest != null && pageRequest.getCookie().length() != 0) {
            try {
                begin = new EntryID(pageRequest.getCookie().toLong());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                String str = pageRequest.getCookie().toHex();
                Message msg = JebMessages.ERR_JEB_INVALID_PAGED_RESULTS_COOKIE.get(str);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg, e);
            }
        } else if (!manageDsaIT) {
            continueSearch = this.dn2uri.returnSearchReferences(searchOperation);
        }
        int lookthroughLimit = searchOperation.getClientConnection().getLookthroughLimit();
        if (lookthroughLimit > 0 && entryIDList.size() > (long)lookthroughLimit) {
            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
            searchOperation.appendErrorMessage(JebMessages.NOTE_JEB_LOOKTHROUGH_LIMIT_EXCEEDED.get(lookthroughLimit));
            continueSearch = false;
        }
        if (continueSearch) {
            Iterator<EntryID> iterator = entryIDList.iterator(begin);
            while (iterator.hasNext()) {
                Entry entry;
                Entry cacheEntry;
                EntryID id;
                block26: {
                    id = iterator.next();
                    cacheEntry = entryCache.getEntry(this.backend, id.longValue());
                    if (cacheEntry == null) {
                        try {
                            entry = this.id2entry.get(null, id, LockMode.DEFAULT);
                            break block26;
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            continue;
                        }
                    }
                    entry = cacheEntry;
                }
                if (entry == null) continue;
                boolean isInScope = false;
                DN entryDN = entry.getDN();
                if (candidatesAreInScope) {
                    isInScope = true;
                } else if (searchScope == SearchScope.SINGLE_LEVEL) {
                    if (entryDN.getNumComponents() == aBaseDN.getNumComponents() + 1 && entryDN.isDescendantOf(aBaseDN)) {
                        isInScope = true;
                    }
                } else if (searchScope == SearchScope.WHOLE_SUBTREE) {
                    if (entryDN.isDescendantOf(aBaseDN)) {
                        isInScope = true;
                    }
                } else if (searchScope == SearchScope.SUBORDINATE_SUBTREE && entryDN.getNumComponents() > aBaseDN.getNumComponents() && entryDN.isDescendantOf(aBaseDN)) {
                    isInScope = true;
                }
                if (cacheEntry == null) {
                    entryCache.putEntryIfAbsent(entry, this.backend, id.longValue());
                }
                if (!isInScope || !manageDsaIT && entry.getReferralURLs() != null || !searchOperation.getFilter().matchesEntry(entry)) continue;
                if (pageRequest != null && searchOperation.getEntriesSent() == pageRequest.getSize()) {
                    byte[] cookieBytes = id.getDatabaseEntry().getData();
                    ByteString cookie = ByteString.wrap(cookieBytes);
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, cookie);
                    searchOperation.getResponseControls().add(control);
                    return;
                }
                if (searchOperation.returnEntry(entry, null)) continue;
                break;
            }
            searchOperation.checkIfCanceled(false);
        }
        if (searchOperation.getEntriesSent() == 0 && searchOperation.getReferencesSent() == 0) {
            Entry baseEntry = this.fetchBaseEntry(aBaseDN, searchScope);
            if (!manageDsaIT) {
                this.dn2uri.checkTargetForReferral(baseEntry, searchScope);
            }
        }
        if (pageRequest != null) {
            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
            searchOperation.getResponseControls().add(control);
        }
    }

    public void addEntry(Entry entry, AddOperation addOperation) throws DatabaseException, DirectoryException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        DN parentDN = this.getParentWithinBase(entry.getDN());
        try {
            if (this.dn2id.get(txn, entry.getDN(), LockMode.DEFAULT) != null) {
                Message message = JebMessages.ERR_JEB_ADD_ENTRY_ALREADY_EXISTS.get(entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            EntryID parentID = null;
            if (parentDN != null) {
                this.dn2uri.targetEntryReferrals(entry.getDN(), null);
                parentID = this.dn2id.get(txn, parentDN, LockMode.DEFAULT);
                if (parentID == null) {
                    Message message = JebMessages.ERR_JEB_ADD_NO_SUCH_OBJECT.get(entry.getDN().toString());
                    DN matchedDN = this.getMatchedDN(this.baseDN);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
                }
            }
            EntryID entryID = this.rootContainer.getNextEntryID();
            if (!this.dn2id.insert(txn, entry.getDN(), entryID)) {
                Message message = JebMessages.ERR_JEB_ADD_ENTRY_ALREADY_EXISTS.get(entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            if (!this.dn2uri.addEntry(txn, entry)) {
                Message message = JebMessages.ERR_JEB_ADD_ENTRY_ALREADY_EXISTS.get(entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            if (!this.id2entry.insert(txn, entryID, entry)) {
                Message message = JebMessages.ERR_JEB_ADD_ENTRY_ALREADY_EXISTS.get(entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            this.indexInsertEntry(txn, entry, entryID);
            if (parentDN != null) {
                this.id2children.insertID(txn, parentID.getDatabaseEntry(), entryID);
                this.id2subtree.insertID(txn, parentID.getDatabaseEntry(), entryID);
                DN dn = this.getParentWithinBase(parentDN);
                while (dn != null) {
                    EntryID nodeID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                    if (nodeID == null) {
                        Message msg = JebMessages.ERR_JEB_MISSING_DN2ID_RECORD.get(dn.toNormalizedString());
                        throw new JebException(msg);
                    }
                    this.id2subtree.insertID(txn, nodeID.getDatabaseEntry(), entryID);
                    dn = this.getParentWithinBase(dn);
                }
            }
            if (addOperation != null) {
                addOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(entry, this.backend, entryID.longValue());
            }
        }
        catch (DatabaseException databaseException) {
            EntryContainer.transactionAbort(txn);
            throw databaseException;
        }
        catch (DirectoryException directoryException) {
            EntryContainer.transactionAbort(txn);
            throw directoryException;
        }
        catch (CanceledOperationException coe) {
            EntryContainer.transactionAbort(txn);
            throw coe;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString(e);
            }
            Message message = JebMessages.ERR_JEB_UNCHECKED_EXCEPTION.get(msg);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException, DatabaseException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        IndexBuffer indexBuffer = null;
        try {
            this.dn2uri.targetEntryReferrals(entryDN, null);
            boolean isSubtreeDelete = false;
            if (deleteOperation != null && deleteOperation.getRequestControl(SubtreeDeleteControl.DECODER) != null) {
                isSubtreeDelete = true;
            }
            byte[] entryDNKey = JebFormat.dnToDNKey(entryDN, this.baseDN.getNumComponents());
            byte[] suffix = Arrays.copyOf(entryDNKey, entryDNKey.length + 1);
            suffix[suffix.length - 1] = 0;
            byte[] end = (byte[])suffix.clone();
            end[end.length - 1] = (byte)(end[end.length - 1] + 1);
            int subordinateEntriesDeleted = 0;
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(suffix);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadCommitted(true);
            Cursor cursor = this.dn2id.openCursor(txn, cursorConfig);
            try {
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                while (status == OperationStatus.SUCCESS && this.dn2id.getComparator().compare(key.getData(), suffix) <= 0) {
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                    if (cmp >= 0) {
                        break;
                    }
                    if (!isSubtreeDelete) {
                        Message message = JebMessages.ERR_JEB_DELETE_NOT_ALLOWED_ON_NONLEAF.get(entryDN.toString());
                        throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message);
                    }
                    if (indexBuffer == null) {
                        indexBuffer = new IndexBuffer(this);
                    }
                    EntryID entryID = new EntryID(data);
                    if (deleteOperation != null && !deleteOperation.isSynchronizationOperation()) {
                        Entry subordinateEntry = this.id2entry.get(txn, entryID, LockMode.DEFAULT);
                        PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
                        PluginResult.SubordinateDelete pluginResult = pluginManager.invokeSubordinateDeletePlugins(deleteOperation, subordinateEntry);
                        if (!pluginResult.continueProcessing()) {
                            Message message = JebMessages.ERR_JEB_DELETE_ABORTED_BY_SUBORDINATE_PLUGIN.get(JebFormat.dnFromDNKey(key.getData(), 0, 0, this.getBaseDN()).toString());
                            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                        }
                    }
                    this.deleteEntry(txn, indexBuffer, true, entryDN, key, entryID);
                    ++subordinateEntriesDeleted;
                    if (deleteOperation != null) {
                        deleteOperation.checkIfCanceled(false);
                    }
                    data = new DatabaseEntry();
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
            }
            finally {
                cursor.close();
            }
            this.deleteEntry(txn, indexBuffer, isSubtreeDelete || EntryContainer.isManageDsaITOperation(deleteOperation), entryDN, null, null);
            if (indexBuffer != null) {
                indexBuffer.flush(txn);
            }
            if (deleteOperation != null) {
                deleteOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
            if (isSubtreeDelete) {
                deleteOperation.addAdditionalLogItem(AdditionalLogItem.unquotedKeyValue(this.getClass(), "deletedEntries", subordinateEntriesDeleted + 1));
            }
        }
        catch (DatabaseException databaseException) {
            EntryContainer.transactionAbort(txn);
            throw databaseException;
        }
        catch (DirectoryException directoryException) {
            EntryContainer.transactionAbort(txn);
            throw directoryException;
        }
        catch (CanceledOperationException coe) {
            EntryContainer.transactionAbort(txn);
            throw coe;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString(e);
            }
            Message message = JebMessages.ERR_JEB_UNCHECKED_EXCEPTION.get(msg);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    private void deleteEntry(Transaction txn, IndexBuffer indexBuffer, boolean manageDsaIT, DN targetDN, DatabaseEntry leafDNKey, EntryID leafID) throws DatabaseException, DirectoryException, JebException {
        Message msg;
        if (leafID == null || leafDNKey == null) {
            DatabaseEntry value;
            OperationStatus status;
            if (leafDNKey == null) {
                leafDNKey = new DatabaseEntry(JebFormat.dnToDNKey(targetDN, this.baseDN.getNumComponents()));
            }
            if ((status = this.dn2id.read(txn, leafDNKey, value = new DatabaseEntry(), LockMode.RMW)) != OperationStatus.SUCCESS) {
                Message message = JebMessages.ERR_JEB_DELETE_NO_SUCH_OBJECT.get(leafDNKey.toString());
                DN matchedDN = this.getMatchedDN(this.baseDN);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
            }
            leafID = new EntryID(value);
        }
        if (this.dn2id.delete(txn, leafDNKey) != OperationStatus.SUCCESS) {
            Message message = JebMessages.ERR_JEB_DELETE_NO_SUCH_OBJECT.get(leafDNKey.toString());
            DN matchedDN = this.getMatchedDN(this.baseDN);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        Entry entry = this.id2entry.get(txn, leafID, LockMode.RMW);
        if (entry == null) {
            msg = JebMessages.ERR_JEB_MISSING_ID2ENTRY_RECORD.get(leafID.toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
        }
        if (!manageDsaIT) {
            this.dn2uri.checkTargetForReferral(entry, null);
        }
        this.dn2uri.deleteEntry(txn, entry);
        if (!this.id2entry.remove(txn, leafID)) {
            msg = JebMessages.ERR_JEB_MISSING_ID2ENTRY_RECORD.get(leafID.toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
        }
        if (indexBuffer != null) {
            this.indexRemoveEntry(indexBuffer, entry, leafID);
        } else {
            this.indexRemoveEntry(txn, entry, leafID);
        }
        if (indexBuffer != null) {
            byte[] leafIDKeyBytes = JebFormat.entryIDToDatabase(leafID.longValue());
            this.id2children.delete(indexBuffer, leafIDKeyBytes);
            this.id2subtree.delete(indexBuffer, leafIDKeyBytes);
        } else {
            DatabaseEntry leafIDKey = leafID.getDatabaseEntry();
            this.id2children.delete(txn, leafIDKey);
            this.id2subtree.delete(txn, leafIDKey);
        }
        boolean isParent = true;
        DN parentDN = this.getParentWithinBase(targetDN);
        while (parentDN != null) {
            EntryID parentID = this.dn2id.get(txn, parentDN, LockMode.DEFAULT);
            if (parentID == null) {
                Message msg2 = JebMessages.ERR_JEB_MISSING_DN2ID_RECORD.get(parentDN.toNormalizedString());
                throw new JebException(msg2);
            }
            if (indexBuffer != null) {
                byte[] parentIDBytes = JebFormat.entryIDToDatabase(parentID.longValue());
                if (isParent) {
                    this.id2children.removeID(indexBuffer, parentIDBytes, leafID);
                    isParent = false;
                }
                this.id2subtree.removeID(indexBuffer, parentIDBytes, leafID);
            } else {
                DatabaseEntry nodeIDData = parentID.getDatabaseEntry();
                if (isParent) {
                    this.id2children.removeID(txn, nodeIDData, leafID);
                    isParent = false;
                }
                this.id2subtree.removeID(txn, nodeIDData, leafID);
            }
            parentDN = this.getParentWithinBase(parentDN);
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.removeEntry(entry.getDN());
        }
    }

    public boolean entryExists(DN entryDN) throws DirectoryException {
        EntryID id;
        block3: {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null && entryCache.containsEntry(entryDN)) {
                return true;
            }
            id = null;
            try {
                id = this.dn2id.get(null, entryDN, LockMode.DEFAULT);
            }
            catch (DatabaseException e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return id != null;
    }

    public Entry getEntry(DN entryDN) throws DatabaseException, DirectoryException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        Entry entry = null;
        if (entryCache != null) {
            entry = entryCache.getEntry(entryDN);
        }
        if (entry == null) {
            EntryID entryID = this.dn2id.get(null, entryDN, LockMode.DEFAULT);
            if (entryID == null) {
                this.dn2uri.targetEntryReferrals(entryDN, null);
                return null;
            }
            entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
            if (entry == null) {
                Message msg = JebMessages.ERR_JEB_MISSING_ID2ENTRY_RECORD.get(entryID.toString());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
            }
            if (entryCache != null) {
                entryCache.putEntryIfAbsent(entry, this.backend, entryID.longValue());
            }
        }
        return entry;
    }

    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DatabaseException, DirectoryException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        try {
            List<Modification> mods;
            EntryID entryID = this.dn2id.get(txn, newEntry.getDN(), LockMode.RMW);
            if (entryID == null) {
                Message message = JebMessages.ERR_JEB_MODIFY_NO_SUCH_OBJECT.get(newEntry.getDN().toString());
                DN matchedDN = this.getMatchedDN(this.baseDN);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
            }
            if (!EntryContainer.isManageDsaITOperation(modifyOperation)) {
                this.dn2uri.checkTargetForReferral(oldEntry, null);
            }
            if (modifyOperation != null) {
                mods = modifyOperation.getModifications();
                this.dn2uri.modifyEntry(txn, oldEntry, newEntry, mods);
            } else {
                this.dn2uri.replaceEntry(txn, oldEntry, newEntry);
            }
            this.id2entry.put(txn, entryID, newEntry);
            if (modifyOperation != null) {
                mods = modifyOperation.getModifications();
                this.indexModifications(txn, oldEntry, newEntry, entryID, mods);
            } else {
                this.indexRemoveEntry(txn, oldEntry, entryID);
                this.indexInsertEntry(txn, newEntry, entryID);
            }
            if (modifyOperation != null) {
                modifyOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(newEntry, this.backend, entryID.longValue());
            }
        }
        catch (DatabaseException databaseException) {
            EntryContainer.transactionAbort(txn);
            throw databaseException;
        }
        catch (DirectoryException directoryException) {
            EntryContainer.transactionAbort(txn);
            throw directoryException;
        }
        catch (CanceledOperationException coe) {
            EntryContainer.transactionAbort(txn);
            throw coe;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString(e);
            }
            Message message = JebMessages.ERR_JEB_UNCHECKED_EXCEPTION.get(msg);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DatabaseException, DirectoryException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        DN oldSuperiorDN = this.getParentWithinBase(currentDN);
        DN newSuperiorDN = this.getParentWithinBase(entry.getDN());
        boolean isApexEntryMoved = oldSuperiorDN != null ? !oldSuperiorDN.equals(newSuperiorDN) : (newSuperiorDN != null ? !newSuperiorDN.equals(oldSuperiorDN) : false);
        IndexBuffer buffer = new IndexBuffer(this);
        try {
            MovedEntry head;
            if (!currentDN.equals(entry.getDN()) && this.dn2id.get(txn, entry.getDN(), LockMode.DEFAULT) != null) {
                Message message = JebMessages.ERR_JEB_MODIFYDN_ALREADY_EXISTS.get(entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            EntryID oldApexID = this.dn2id.get(txn, currentDN, LockMode.DEFAULT);
            if (oldApexID == null) {
                this.dn2uri.targetEntryReferrals(currentDN, null);
                Message message = JebMessages.ERR_JEB_MODIFYDN_NO_SUCH_OBJECT.get(currentDN.toString());
                DN matchedDN = this.getMatchedDN(this.baseDN);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
            }
            Entry oldApexEntry = this.id2entry.get(txn, oldApexID, LockMode.DEFAULT);
            if (oldApexEntry == null) {
                Message msg = JebMessages.ERR_JEB_MISSING_ID2ENTRY_RECORD.get(oldApexID.toString());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
            }
            if (!EntryContainer.isManageDsaITOperation(modifyDNOperation)) {
                this.dn2uri.checkTargetForReferral(oldApexEntry, null);
            }
            EntryID newApexID = oldApexID;
            if (newSuperiorDN != null && isApexEntryMoved) {
                EntryID newSuperiorID = this.dn2id.get(txn, newSuperiorDN, LockMode.DEFAULT);
                if (newSuperiorID == null) {
                    Message msg = JebMessages.ERR_JEB_NEW_SUPERIOR_NO_SUCH_OBJECT.get(newSuperiorDN.toString());
                    DN matchedDN = this.getMatchedDN(this.baseDN);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, msg, matchedDN, null);
                }
                if (newSuperiorID.compareTo(oldApexID) > 0) {
                    newApexID = this.rootContainer.getNextEntryID();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Move of target entry requires renumberingall entries in the subtree. Old DN: %s New DN: %s Old entry ID: %d New entry ID: %d New Superior ID: %d" + oldApexEntry.getDN(), entry.getDN(), oldApexID.longValue(), newApexID.longValue(), newSuperiorID.longValue());
                    }
                }
            }
            MovedEntry current = head = new MovedEntry(null, null, false);
            this.removeApexEntry(txn, buffer, oldSuperiorDN, oldApexID, newApexID, oldApexEntry, entry, isApexEntryMoved, modifyDNOperation, current);
            current = current.next;
            byte[] currentDNKey = JebFormat.dnToDNKey(currentDN, this.baseDN.getNumComponents());
            byte[] suffix = Arrays.copyOf(currentDNKey, currentDNKey.length + 1);
            suffix[suffix.length - 1] = 0;
            byte[] end = (byte[])suffix.clone();
            end[end.length - 1] = (byte)(end[end.length - 1] + 1);
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(suffix);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadCommitted(true);
            Cursor cursor = this.dn2id.openCursor(txn, cursorConfig);
            try {
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                while (status == OperationStatus.SUCCESS && this.dn2id.getComparator().compare(key.getData(), suffix) <= 0) {
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                    if (cmp >= 0) {
                        break;
                    }
                    EntryID oldID = new EntryID(data);
                    Entry oldEntry = this.id2entry.get(txn, oldID, LockMode.DEFAULT);
                    DN newDN = EntryContainer.modDN(oldEntry.getDN(), currentDN.getNumComponents(), entry.getDN());
                    EntryID newID = oldID;
                    if (!newApexID.equals(oldApexID)) {
                        newID = this.rootContainer.getNextEntryID();
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Move of subordinate entry requires renumbering. Old DN: %s New DN: %s Old entry ID: %d New entry ID: %d", oldEntry.getDN(), newDN, oldID.longValue(), newID.longValue());
                        }
                    }
                    this.removeSubordinateEntry(txn, buffer, oldSuperiorDN, oldID, newID, oldEntry, newDN, isApexEntryMoved, modifyDNOperation, current);
                    current = current.next;
                    if (modifyDNOperation != null) {
                        modifyDNOperation.checkIfCanceled(false);
                    }
                    data = new DatabaseEntry();
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
            }
            finally {
                cursor.close();
            }
            current = head.next;
            head = null;
            while (current != null) {
                this.addRenamedEntry(txn, buffer, current.entryID, current.entry, isApexEntryMoved, current.renumbered, modifyDNOperation);
                current = current.next;
            }
            buffer.flush(txn);
            if (modifyDNOperation != null) {
                modifyDNOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
        }
        catch (DatabaseException databaseException) {
            EntryContainer.transactionAbort(txn);
            throw databaseException;
        }
        catch (DirectoryException directoryException) {
            EntryContainer.transactionAbort(txn);
            throw directoryException;
        }
        catch (CanceledOperationException coe) {
            EntryContainer.transactionAbort(txn);
            throw coe;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString(e);
            }
            Message message = JebMessages.ERR_JEB_UNCHECKED_EXCEPTION.get(msg);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    private void addRenamedEntry(Transaction txn, IndexBuffer buffer, EntryID newID, Entry newEntry, boolean isApexEntryMoved, boolean renumbered, ModifyDNOperation modifyDNOperation) throws DirectoryException, DatabaseException {
        if (!this.dn2id.insert(txn, newEntry.getDN(), newID)) {
            Message message = JebMessages.ERR_JEB_MODIFYDN_ALREADY_EXISTS.get(newEntry.getDN().toString());
            throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
        }
        this.id2entry.put(txn, newID, newEntry);
        this.dn2uri.addEntry(txn, newEntry);
        if (renumbered || modifyDNOperation == null) {
            this.indexInsertEntry(buffer, newEntry, newID);
        }
        if (isApexEntryMoved) {
            boolean isParent = true;
            DN dn = this.getParentWithinBase(newEntry.getDN());
            while (dn != null) {
                EntryID parentID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                byte[] parentIDKeyBytes = JebFormat.entryIDToDatabase(parentID.longValue());
                if (isParent) {
                    this.id2children.insertID(buffer, parentIDKeyBytes, newID);
                    isParent = false;
                }
                this.id2subtree.insertID(buffer, parentIDKeyBytes, newID);
                dn = this.getParentWithinBase(dn);
            }
        }
    }

    private void removeApexEntry(Transaction txn, IndexBuffer buffer, DN oldSuperiorDN, EntryID oldID, EntryID newID, Entry oldEntry, Entry newEntry, boolean isApexEntryMoved, ModifyDNOperation modifyDNOperation, MovedEntry tail) throws DirectoryException, DatabaseException {
        DN oldDN = oldEntry.getDN();
        this.dn2id.remove(txn, oldDN);
        if (!newID.equals(oldID)) {
            this.id2entry.remove(txn, oldID);
        }
        this.dn2uri.deleteEntry(txn, oldEntry);
        tail.next = new MovedEntry(newID, newEntry, !newID.equals(oldID));
        if (oldSuperiorDN != null && isApexEntryMoved) {
            boolean isParent = true;
            DN dn = oldSuperiorDN;
            while (dn != null) {
                EntryID parentID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                byte[] parentIDKeyBytes = JebFormat.entryIDToDatabase(parentID.longValue());
                if (isParent) {
                    this.id2children.removeID(buffer, parentIDKeyBytes, oldID);
                    isParent = false;
                }
                this.id2subtree.removeID(buffer, parentIDKeyBytes, oldID);
                dn = this.getParentWithinBase(dn);
            }
        }
        if (!newID.equals(oldID) || modifyDNOperation == null) {
            byte[] oldIDKeyBytes = JebFormat.entryIDToDatabase(oldID.longValue());
            this.id2children.delete(buffer, oldIDKeyBytes);
            this.id2subtree.delete(buffer, oldIDKeyBytes);
            this.indexRemoveEntry(buffer, oldEntry, oldID);
        } else {
            this.indexModifications(buffer, oldEntry, newEntry, oldID, modifyDNOperation.getModifications());
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.removeEntry(oldDN);
        }
    }

    private void removeSubordinateEntry(Transaction txn, IndexBuffer buffer, DN oldSuperiorDN, EntryID oldID, EntryID newID, Entry oldEntry, DN newDN, boolean isApexEntryMoved, ModifyDNOperation modifyDNOperation, MovedEntry tail) throws DirectoryException, DatabaseException {
        DN oldDN = oldEntry.getDN();
        Entry newEntry = oldEntry.duplicate(false);
        newEntry.setDN(newDN);
        List<Modification> modifications = Collections.unmodifiableList(new ArrayList(0));
        if (!modifyDNOperation.isSynchronizationOperation()) {
            MessageBuilder invalidReason;
            PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
            PluginResult.SubordinateModifyDN pluginResult = pluginManager.invokeSubordinateModifyDNPlugins(modifyDNOperation, oldEntry, newEntry, modifications);
            if (!pluginResult.continueProcessing()) {
                Message message = JebMessages.ERR_JEB_MODIFYDN_ABORTED_BY_SUBORDINATE_PLUGIN.get(oldDN.toString(), newDN.toString());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            if (!modifications.isEmpty() && !newEntry.conformsToSchema(null, false, false, false, invalidReason = new MessageBuilder())) {
                Message message = JebMessages.ERR_JEB_MODIFYDN_ABORTED_BY_SUBORDINATE_SCHEMA_ERROR.get(oldDN.toString(), newDN.toString(), invalidReason.toString());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
        }
        this.dn2id.remove(txn, oldDN);
        if (!newID.equals(oldID)) {
            this.id2entry.remove(txn, oldID);
        }
        this.dn2uri.deleteEntry(txn, oldEntry);
        tail.next = new MovedEntry(newID, newEntry, !newID.equals(oldID));
        if (isApexEntryMoved) {
            DN dn = oldSuperiorDN;
            while (dn != null) {
                EntryID parentID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                byte[] parentIDKeyBytes = JebFormat.entryIDToDatabase(parentID.longValue());
                this.id2subtree.removeID(buffer, parentIDKeyBytes, oldID);
                dn = this.getParentWithinBase(dn);
            }
        }
        if (!newID.equals(oldID)) {
            byte[] oldIDKeyBytes = JebFormat.entryIDToDatabase(oldID.longValue());
            this.id2children.delete(buffer, oldIDKeyBytes);
            this.id2subtree.delete(buffer, oldIDKeyBytes);
            this.indexRemoveEntry(buffer, oldEntry, oldID);
        } else if (!modifications.isEmpty()) {
            this.indexModifications(buffer, oldEntry, newEntry, oldID, modifications);
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.removeEntry(oldDN);
        }
    }

    public static DN modDN(DN oldDN, int oldSuffixLen, DN newSuffixDN) {
        int i;
        int oldDNNumComponents = oldDN.getNumComponents();
        int oldDNKeepComponents = oldDNNumComponents - oldSuffixLen;
        int newSuffixDNComponents = newSuffixDN.getNumComponents();
        RDN[] newDNComponents = new RDN[oldDNKeepComponents + newSuffixDNComponents];
        for (i = 0; i < oldDNKeepComponents; ++i) {
            newDNComponents[i] = oldDN.getRDN(i);
        }
        i = oldDNKeepComponents;
        for (int j = 0; j < newSuffixDNComponents; ++j) {
            newDNComponents[i] = newSuffixDN.getRDN(j);
            ++i;
        }
        return new DN(newDNComponents);
    }

    private void indexInsertEntry(Transaction txn, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.addEntry(txn, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.addEntry(txn, entryID, entry);
        }
    }

    private void indexInsertEntry(IndexBuffer buffer, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.addEntry(buffer, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.addEntry(buffer, entryID, entry);
        }
    }

    private void indexRemoveEntry(Transaction txn, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.removeEntry(txn, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.removeEntry(txn, entryID, entry);
        }
    }

    private void indexRemoveEntry(IndexBuffer buffer, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.removeEntry(buffer, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.removeEntry(buffer, entryID, entry);
        }
    }

    private void indexModifications(Transaction txn, Entry oldEntry, Entry newEntry, EntryID entryID, List<Modification> mods) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            if (!this.isAttributeModified(index, mods)) continue;
            index.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
    }

    private void indexModifications(IndexBuffer buffer, Entry oldEntry, Entry newEntry, EntryID entryID, List<Modification> mods) throws DatabaseException, DirectoryException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            if (!this.isAttributeModified(index, mods)) continue;
            index.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
    }

    public long getEntryCount() throws DatabaseException {
        EntryID entryID = this.dn2id.get(null, this.baseDN, LockMode.DEFAULT);
        if (entryID != null) {
            DatabaseEntry key = new DatabaseEntry(JebFormat.entryIDToDatabase(entryID.longValue()));
            EntryIDSet entryIDSet = this.id2subtree.readKey(key, null, LockMode.DEFAULT);
            long count = entryIDSet.size();
            if (count != Long.MAX_VALUE) {
                return ++count;
            }
            return this.id2entry.getRecordCount();
        }
        return 0L;
    }

    public int getEntryLimitExceededCount() {
        int count = 0;
        count += this.id2children.getEntryLimitExceededCount();
        count += this.id2subtree.getEntryLimitExceededCount();
        for (AttributeIndex index : this.attrIndexMap.values()) {
            count = (int)((long)count + index.getEntryLimitExceededCount());
        }
        return count;
    }

    public void listDatabases(List<DatabaseContainer> dbList) {
        dbList.add(this.dn2id);
        dbList.add(this.id2entry);
        dbList.add(this.dn2uri);
        if (this.config.isSubordinateIndexesEnabled()) {
            dbList.add(this.id2children);
            dbList.add(this.id2subtree);
        }
        dbList.add(this.state);
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.listDatabases(dbList);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            dbList.add(vlvIndex);
        }
    }

    public static boolean isManageDsaITOperation(Operation operation) {
        List<Control> controls;
        if (operation != null && (controls = operation.getRequestControls()) != null) {
            for (Control control : controls) {
                if (!control.getOID().equals("2.16.840.1.113730.3.4.2")) continue;
                return true;
            }
        }
        return false;
    }

    public Transaction beginTransaction() throws DatabaseException {
        Transaction parentTxn = null;
        TransactionConfig txnConfig = null;
        Transaction txn = this.env.beginTransaction(parentTxn, txnConfig);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("beginTransaction", "begin txnid=" + txn.getId());
        }
        return txn;
    }

    public static void transactionCommit(Transaction txn) throws DatabaseException {
        if (txn != null) {
            txn.commit();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("commit txnid=%d", txn.getId());
            }
        }
    }

    public static void transactionAbort(Transaction txn) throws DatabaseException {
        if (txn != null) {
            txn.abort();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("abort txnid=%d", txn.getId());
            }
        }
    }

    public void delete() throws DatabaseException {
        ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
        this.listDatabases(databases);
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                for (DatabaseContainer db : databases) {
                    this.env.removeDatabase(txn, db.getName());
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            for (DatabaseContainer db : databases) {
                this.env.removeDatabase(null, db.getName());
            }
        }
    }

    public void deleteDatabase(DatabaseContainer database) throws DatabaseException {
        if (database == this.state) {
            return;
        }
        database.close();
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                this.env.removeDatabase(txn, database.getName());
                if (database instanceof Index) {
                    this.state.removeIndexTrustState(txn, (Index)database);
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            this.env.removeDatabase(null, database.getName());
            if (database instanceof Index) {
                this.state.removeIndexTrustState(null, (Index)database);
            }
        }
    }

    public void deleteAttributeIndex(AttributeIndex index) throws DatabaseException {
        index.close();
        Transaction txn = this.env.getConfig().getTransactional() ? this.beginTransaction() : null;
        try {
            if (index.equalityIndex != null) {
                this.env.removeDatabase(txn, index.equalityIndex.getName());
                this.state.removeIndexTrustState(txn, index.equalityIndex);
            }
            if (index.presenceIndex != null) {
                this.env.removeDatabase(txn, index.presenceIndex.getName());
                this.state.removeIndexTrustState(txn, index.presenceIndex);
            }
            if (index.substringIndex != null) {
                this.env.removeDatabase(txn, index.substringIndex.getName());
                this.state.removeIndexTrustState(txn, index.substringIndex);
            }
            if (index.orderingIndex != null) {
                this.env.removeDatabase(txn, index.orderingIndex.getName());
                this.state.removeIndexTrustState(txn, index.orderingIndex);
            }
            if (index.approximateIndex != null) {
                this.env.removeDatabase(txn, index.approximateIndex.getName());
                this.state.removeIndexTrustState(txn, index.approximateIndex);
            }
            Map<String, Collection<Index>> extensibleIndexes = index.getExtensibleIndexes();
            for (String name : extensibleIndexes.keySet()) {
                for (Index extensibleIndex : extensibleIndexes.get(name)) {
                    this.env.removeDatabase(txn, extensibleIndex.getName());
                    this.state.removeIndexTrustState(txn, extensibleIndex);
                }
            }
            if (txn != null) {
                EntryContainer.transactionCommit(txn);
            }
        }
        catch (DatabaseException de) {
            if (txn != null) {
                EntryContainer.transactionAbort(txn);
            }
            throw de;
        }
    }

    public String getDatabasePrefix() {
        return this.databasePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabasePrefix(String newDatabasePrefix) throws DatabaseException, JebException {
        block12: {
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            this.listDatabases(databases);
            newDatabasePrefix = this.preparePrefix(newDatabasePrefix);
            for (DatabaseContainer db : databases) {
                db.close();
            }
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        String newName;
                        String oldName;
                        for (DatabaseContainer db : databases) {
                            oldName = db.getName();
                            newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                            this.env.renameDatabase(txn, oldName, newName);
                        }
                        EntryContainer.transactionCommit(txn);
                        for (DatabaseContainer db : databases) {
                            oldName = db.getName();
                            newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                            db.setName(newName);
                        }
                        this.databasePrefix = newDatabasePrefix;
                        break block12;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = StaticUtils.stackTraceToSingleLineString(e);
                        }
                        Message message = JebMessages.ERR_JEB_UNCHECKED_EXCEPTION.get(msg);
                        throw new JebException(message, (Throwable)e);
                    }
                }
                for (DatabaseContainer db : databases) {
                    String oldName = db.getName();
                    String newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                    this.env.renameDatabase(null, oldName, newName);
                    db.setName(newName);
                }
                this.databasePrefix = newDatabasePrefix;
            }
            finally {
                for (DatabaseContainer db : databases) {
                    db.open();
                }
            }
        }
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public DN getParentWithinBase(DN dn) {
        if (dn.equals(this.baseDN)) {
            return null;
        }
        return dn.getParent();
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LocalDBBackendCfg cfg, List<Message> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(LocalDBBackendCfg cfg) {
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.exclusiveLock.lock();
        try {
            if (this.config.isSubordinateIndexesEnabled() != cfg.isSubordinateIndexesEnabled()) {
                if (cfg.isSubordinateIndexesEnabled()) {
                    this.openSubordinateIndexes();
                } else {
                    this.id2children.close();
                    this.id2children = new NullIndex(this.databasePrefix + "_" + ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), this.state, this.env, this);
                    this.state.putIndexTrustState(null, this.id2children, false);
                    this.id2children.open();
                    this.id2subtree.close();
                    this.id2subtree = new NullIndex(this.databasePrefix + "_" + ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), this.state, this.env, this);
                    this.state.putIndexTrustState(null, this.id2subtree, false);
                    this.id2subtree.open();
                    ErrorLogger.logError(JebMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED.get(cfg.getBackendId()));
                }
            }
            if (this.config.getIndexEntryLimit() != cfg.getIndexEntryLimit()) {
                Message message;
                if (this.id2children.setIndexEntryLimit(cfg.getIndexEntryLimit())) {
                    adminActionRequired = true;
                    message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(this.id2children.getName());
                    messages.add(message);
                }
                if (this.id2subtree.setIndexEntryLimit(cfg.getIndexEntryLimit())) {
                    adminActionRequired = true;
                    message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(this.id2subtree.getName());
                    messages.add(message);
                }
            }
            DataConfig entryDataConfig = new DataConfig(cfg.isEntriesCompressed(), cfg.isCompactEncoding(), this.rootContainer.getCompressedSchema());
            this.id2entry.setDataConfig(entryDataConfig);
            this.config = cfg;
        }
        catch (DatabaseException e) {
            messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            ConfigChangeResult configChangeResult = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
            return configChangeResult;
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
    }

    public EnvironmentConfig getEnvironmentConfig() throws DatabaseException {
        return this.env.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clear() throws DatabaseException {
        long count;
        block23: {
            Transaction txn;
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            this.listDatabases(databases);
            count = 0L;
            for (DatabaseContainer db : databases) {
                db.close();
            }
            try {
                if (this.env.getConfig().getTransactional()) {
                    txn = this.beginTransaction();
                    try {
                        for (DatabaseContainer db : databases) {
                            count += this.env.truncateDatabase(txn, db.getName(), true);
                        }
                        EntryContainer.transactionCommit(txn);
                        break block23;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                for (DatabaseContainer db : databases) {
                    count += this.env.truncateDatabase(null, db.getName(), true);
                }
            }
            finally {
                block24: {
                    for (DatabaseContainer db : databases) {
                        db.open();
                    }
                    txn = null;
                    try {
                        if (this.env.getConfig().getTransactional()) {
                            txn = this.beginTransaction();
                        }
                        for (DatabaseContainer db : databases) {
                            if (!(db instanceof Index)) continue;
                            Index index = (Index)db;
                            index.setTrusted(txn, true);
                        }
                        if (this.env.getConfig().getTransactional()) {
                            EntryContainer.transactionCommit(txn);
                        }
                    }
                    catch (Exception de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        try {
                            if (txn != null) {
                                EntryContainer.transactionAbort(txn);
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block24;
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                    }
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatabase(DatabaseContainer database) throws DatabaseException {
        block7: {
            database.close();
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        this.env.removeDatabase(txn, database.getName());
                        EntryContainer.transactionCommit(txn);
                        break block7;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                this.env.removeDatabase(null, database.getName());
            }
            finally {
                database.open();
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Cleared the database %s", database.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clearAttributeIndex(AttributeIndex index) throws DatabaseException {
        long count;
        block17: {
            count = 0L;
            index.close();
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        if (index.equalityIndex != null) {
                            count += this.env.truncateDatabase(txn, index.equalityIndex.getName(), true);
                        }
                        if (index.presenceIndex != null) {
                            count += this.env.truncateDatabase(txn, index.presenceIndex.getName(), true);
                        }
                        if (index.substringIndex != null) {
                            count += this.env.truncateDatabase(txn, index.substringIndex.getName(), true);
                        }
                        if (index.orderingIndex != null) {
                            count += this.env.truncateDatabase(txn, index.orderingIndex.getName(), true);
                        }
                        if (index.approximateIndex != null) {
                            count += this.env.truncateDatabase(txn, index.approximateIndex.getName(), true);
                        }
                        EntryContainer.transactionCommit(txn);
                        break block17;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                if (index.equalityIndex != null) {
                    count += this.env.truncateDatabase(null, index.equalityIndex.getName(), true);
                }
                if (index.presenceIndex != null) {
                    count += this.env.truncateDatabase(null, index.presenceIndex.getName(), true);
                }
                if (index.substringIndex != null) {
                    count += this.env.truncateDatabase(null, index.substringIndex.getName(), true);
                }
                if (index.orderingIndex != null) {
                    count += this.env.truncateDatabase(null, index.orderingIndex.getName(), true);
                }
                if (index.approximateIndex != null) {
                    count += this.env.truncateDatabase(null, index.approximateIndex.getName(), true);
                }
            }
            finally {
                index.open();
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Cleared %d existing records from the index %s", count, index.getAttributeType().getNameOrOID());
        }
        return count;
    }

    private DN getMatchedDN(DN baseDN) throws DirectoryException {
        DN matchedDN = null;
        for (DN parentDN = baseDN.getParentDNInSuffix(); parentDN != null && parentDN.isDescendantOf(this.getBaseDN()); parentDN = parentDN.getParentDNInSuffix()) {
            if (!this.entryExists(parentDN)) continue;
            matchedDN = parentDN;
            break;
        }
        return matchedDN;
    }

    private void openSubordinateIndexes() {
        this.id2children = new Index(this.databasePrefix + "_" + ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), this.state, this.config.getIndexEntryLimit(), 0, true, this.env, this);
        this.id2children.open();
        if (!this.id2children.isTrusted()) {
            ErrorLogger.logError(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(this.id2children.getName()));
        }
        this.id2subtree = new Index(this.databasePrefix + "_" + ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), this.state, this.config.getIndexEntryLimit(), 0, true, this.env, this);
        this.id2subtree.open();
        if (!this.id2subtree.isTrusted()) {
            ErrorLogger.logError(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(this.id2subtree.getName()));
        }
    }

    private boolean isAttributeModified(AttributeIndex index, List<Modification> mods) {
        boolean attributeModified = false;
        AttributeType indexAttributeType = index.getAttributeType();
        Iterable<AttributeType> subTypes = DirectoryServer.getSchema().getSubTypes(indexAttributeType);
        block0: for (Modification mod : mods) {
            Attribute modAttr = mod.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (modAttrType.equals(indexAttributeType)) {
                attributeModified = true;
                break;
            }
            for (AttributeType subType : subTypes) {
                if (!modAttrType.equals(subType)) continue;
                attributeModified = true;
                continue block0;
            }
        }
        return attributeModified;
    }

    private Entry fetchBaseEntry(DN baseDN, SearchScope searchScope) throws DirectoryException {
        Entry baseEntry;
        block3: {
            baseEntry = null;
            try {
                baseEntry = this.getEntry(baseDN);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (baseEntry == null) {
            this.dn2uri.targetEntryReferrals(baseDN, searchScope);
            Message message = JebMessages.ERR_JEB_SEARCH_NO_SUCH_OBJECT.get(baseDN.toString());
            DN matchedDN = this.getMatchedDN(baseDN);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        return baseEntry;
    }

    private String preparePrefix(String databasePrefix) {
        StringBuilder builder = new StringBuilder(databasePrefix.length());
        for (int i = 0; i < databasePrefix.length(); ++i) {
            char ch = databasePrefix.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }

    public void lock() {
        this.exclusiveLock.lock();
    }

    public void unlock() {
        this.exclusiveLock.unlock();
    }

    public static class KeyReverseComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] a, byte[] b) {
            int ai = a.length - 1;
            for (int bi = b.length - 1; ai >= 0 && bi >= 0; --ai, --bi) {
                if (a[ai] > b[bi]) {
                    return 1;
                }
                if (a[ai] >= b[bi]) continue;
                return -1;
            }
            if (a.length == b.length) {
                return 0;
            }
            if (a.length > b.length) {
                return 1;
            }
            return -1;
        }
    }

    private static class MovedEntry {
        EntryID entryID;
        Entry entry;
        MovedEntry next;
        boolean renumbered;

        private MovedEntry(EntryID entryID, Entry entry, boolean renumbered) {
            this.entryID = entryID;
            this.entry = entry;
            this.renumbered = renumbered;
        }
    }

    public class VLVJEIndexCfgManager
    implements ConfigurationAddListener<LocalDBVLVIndexCfg>,
    ConfigurationDeleteListener<LocalDBVLVIndexCfg> {
        @Override
        public boolean isConfigurationAddAcceptable(LocalDBVLVIndexCfg cfg, List<Message> unacceptableReasons) {
            try {
                SearchFilter.createFilterFromString(cfg.getFilter());
            }
            catch (Exception e) {
                Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_BAD_FILTER.get(cfg.getFilter(), cfg.getName(), e.getLocalizedMessage());
                unacceptableReasons.add(msg);
                return false;
            }
            String[] sortAttrs = cfg.getSortOrder().split(" ");
            SortKey[] sortKeys = new SortKey[sortAttrs.length];
            boolean[] ascending = new boolean[sortAttrs.length];
            for (int i = 0; i < sortAttrs.length; ++i) {
                try {
                    if (sortAttrs[i].startsWith("-")) {
                        ascending[i] = false;
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    } else {
                        ascending[i] = true;
                        if (sortAttrs[i].startsWith("+")) {
                            sortAttrs[i] = sortAttrs[i].substring(1);
                        }
                    }
                }
                catch (Exception e) {
                    Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(String.valueOf(sortKeys[i]), cfg.getName());
                    unacceptableReasons.add(msg);
                    return false;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
                if (attrType == null) {
                    Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(sortAttrs[i], cfg.getName());
                    unacceptableReasons.add(msg);
                    return false;
                }
                sortKeys[i] = new SortKey(attrType, ascending[i]);
            }
            return true;
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(LocalDBVLVIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            try {
                VLVIndex vlvIndex = new VLVIndex(cfg, EntryContainer.this.state, EntryContainer.this.env, EntryContainer.this);
                vlvIndex.open();
                if (!vlvIndex.isTrusted()) {
                    adminActionRequired = true;
                    messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(cfg.getName()));
                }
                EntryContainer.this.vlvIndexMap.put(cfg.getName().toLowerCase(), vlvIndex);
            }
            catch (Exception e) {
                messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
                ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return ccr;
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(LocalDBVLVIndexCfg cfg, List<Message> unacceptableReasons) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConfigChangeResult applyConfigurationDelete(LocalDBVLVIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            EntryContainer.this.exclusiveLock.lock();
            try {
                VLVIndex vlvIndex = (VLVIndex)EntryContainer.this.vlvIndexMap.get(cfg.getName().toLowerCase());
                EntryContainer.this.deleteDatabase(vlvIndex);
                EntryContainer.this.vlvIndexMap.remove(cfg.getName());
            }
            catch (DatabaseException de) {
                ConfigChangeResult ccr;
                messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return configChangeResult;
            }
            finally {
                EntryContainer.this.exclusiveLock.unlock();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }
    }

    public class AttributeJEIndexCfgManager
    implements ConfigurationAddListener<LocalDBIndexCfg>,
    ConfigurationDeleteListener<LocalDBIndexCfg> {
        @Override
        public boolean isConfigurationAddAcceptable(LocalDBIndexCfg cfg, List<Message> unacceptableReasons) {
            boolean isValid = true;
            try {
                new AttributeIndex(cfg, EntryContainer.this.state, EntryContainer.this.env, EntryContainer.this);
            }
            catch (Exception e) {
                unacceptableReasons.add(Message.raw(e.getLocalizedMessage(), new Object[0]));
                isValid = false;
            }
            return isValid;
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(LocalDBIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            try {
                AttributeIndex index = new AttributeIndex(cfg, EntryContainer.this.state, EntryContainer.this.env, EntryContainer.this);
                index.open();
                if (!index.isTrusted()) {
                    adminActionRequired = true;
                    messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(cfg.getAttribute().getNameOrOID()));
                }
                EntryContainer.this.attrIndexMap.put(cfg.getAttribute(), index);
            }
            catch (Exception e) {
                messages.add(Message.raw(e.getLocalizedMessage(), new Object[0]));
                ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return ccr;
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(LocalDBIndexCfg cfg, List<Message> unacceptableReasons) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConfigChangeResult applyConfigurationDelete(LocalDBIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            EntryContainer.this.exclusiveLock.lock();
            try {
                AttributeIndex index = (AttributeIndex)EntryContainer.this.attrIndexMap.get(cfg.getAttribute());
                EntryContainer.this.deleteAttributeIndex(index);
                EntryContainer.this.attrIndexMap.remove(cfg.getAttribute());
            }
            catch (DatabaseException de) {
                ConfigChangeResult ccr;
                messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return configChangeResult;
            }
            finally {
                EntryContainer.this.exclusiveLock.unlock();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }
    }
}

