/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.IndexQueryFactory;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexQuery;
import org.opends.server.types.ByteSequence;

public final class IndexQueryFactoryImpl
implements IndexQueryFactory<IndexQuery> {
    private Map<String, Index> indexMap;

    public IndexQueryFactoryImpl(Map<String, Index> indexMap) {
        this.indexMap = indexMap;
    }

    @Override
    public IndexQuery createExactMatchQuery(final String indexID, final ByteSequence value) {
        return new IndexQuery(){

            @Override
            public EntryIDSet evaluate(List<Message> debugMessages) {
                DatabaseEntry key = new DatabaseEntry(value.toByteArray());
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(indexID);
                EntryIDSet entrySet = index.readKey(key, null, LockMode.DEFAULT);
                if (debugMessages != null && !entrySet.isDefined()) {
                    if (!index.isTrusted()) {
                        debugMessages.add(JebMessages.INFO_JEB_INDEX_FILTER_INDEX_NOT_TRUSTED.get(index.getName()));
                    } else if (index.isRebuildRunning()) {
                        debugMessages.add(JebMessages.INFO_JEB_INDEX_FILTER_INDEX_REBUILD_IN_PROGRESS.get(index.getName()));
                    } else {
                        debugMessages.add(JebMessages.INFO_JEB_INDEX_FILTER_INDEX_LIMIT_EXCEEDED.get(index.getName()));
                    }
                }
                return entrySet;
            }
        };
    }

    @Override
    public IndexQuery createRangeMatchQuery(final String indexID, final ByteSequence lowerBound, final ByteSequence upperBound, final boolean includeLowerBound, final boolean includeUpperBound) {
        return new IndexQuery(){

            @Override
            public EntryIDSet evaluate(List<Message> debugMessages) {
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(indexID);
                EntryIDSet entrySet = index.readRange(lowerBound.toByteArray(), upperBound.toByteArray(), includeLowerBound, includeUpperBound);
                if (debugMessages != null && !entrySet.isDefined()) {
                    if (!index.isTrusted()) {
                        debugMessages.add(JebMessages.INFO_JEB_INDEX_FILTER_INDEX_NOT_TRUSTED.get(index.getName()));
                    } else if (index.isRebuildRunning()) {
                        debugMessages.add(JebMessages.INFO_JEB_INDEX_FILTER_INDEX_REBUILD_IN_PROGRESS.get(index.getName()));
                    } else {
                        debugMessages.add(JebMessages.INFO_JEB_INDEX_FILTER_INDEX_LIMIT_EXCEEDED.get(index.getName()));
                    }
                }
                return entrySet;
            }
        };
    }

    @Override
    public IndexQuery createIntersectionQuery(Collection<IndexQuery> subqueries) {
        return IndexQuery.createIntersectionIndexQuery(subqueries);
    }

    @Override
    public IndexQuery createUnionQuery(Collection<IndexQuery> subqueries) {
        return IndexQuery.createUnionIndexQuery(subqueries);
    }

    @Override
    public IndexQuery createMatchAllQuery() {
        return new IndexQuery(){

            @Override
            public EntryIDSet evaluate(List<Message> debugMessages) {
                return new EntryIDSet();
            }
        };
    }
}

