/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class MatchedValuesControl
extends Control {
    public static final ControlDecoder<MatchedValuesControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ArrayList<MatchedValuesFilter> filters;

    public MatchedValuesControl(boolean isCritical, ArrayList<MatchedValuesFilter> filters) {
        super("1.2.826.0.1.3344810.2.3", isCritical);
        this.filters = filters;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        for (MatchedValuesFilter f : this.filters) {
            f.encode(writer);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public ArrayList<MatchedValuesFilter> getFilters() {
        return this.filters;
    }

    public boolean valueMatches(AttributeType type, AttributeValue value) {
        for (MatchedValuesFilter f : this.filters) {
            try {
                if (!f.valueMatches(type, value)) continue;
                return true;
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return false;
    }

    @Override
    public void toString(StringBuilder buffer) {
        if (this.filters.size() == 1) {
            buffer.append("MatchedValuesControl(filter=\"");
            this.filters.get(0).toString(buffer);
            buffer.append("\")");
        } else {
            buffer.append("MatchedValuesControl(filters=\"(");
            for (MatchedValuesFilter f : this.filters) {
                f.toString(buffer);
            }
            buffer.append(")\")");
        }
    }

    private static final class Decoder
    implements ControlDecoder<MatchedValuesControl> {
        private Decoder() {
        }

        @Override
        public MatchedValuesControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            ArrayList<MatchedValuesFilter> filters;
            if (value == null) {
                Message message = ProtocolMessages.ERR_MATCHEDVALUES_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                if (!reader.hasNextElement()) {
                    Message message = ProtocolMessages.ERR_MATCHEDVALUES_NO_FILTERS.get();
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                filters = new ArrayList<MatchedValuesFilter>();
                while (reader.hasNextElement()) {
                    filters.add(MatchedValuesFilter.decode(reader));
                }
                reader.readEndSequence();
            }
            catch (DirectoryException e) {
                throw e;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_MATCHEDVALUES_CANNOT_DECODE_VALUE_AS_SEQUENCE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new MatchedValuesControl(isCritical, filters);
        }

        @Override
        public String getOID() {
            return "1.2.826.0.1.3344810.2.3";
        }
    }
}

