/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class PagedResultsControl
extends Control {
    public static final ControlDecoder<PagedResultsControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int size;
    private ByteString cookie;

    public PagedResultsControl(boolean isCritical, int size, ByteString cookie) {
        super("1.2.840.113556.1.4.319", isCritical);
        this.size = size;
        this.cookie = cookie == null ? ByteString.empty() : cookie;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeInteger(this.size);
        writer.writeOctetString(this.cookie);
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public int getSize() {
        return this.size;
    }

    public ByteString getCookie() {
        return this.cookie;
    }

    private static final class Decoder
    implements ControlDecoder<PagedResultsControl> {
        private Decoder() {
        }

        @Override
        public PagedResultsControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            ByteString cookie;
            int size;
            if (value == null) {
                Message message = ProtocolMessages.ERR_LDAP_PAGED_RESULTS_DECODE_NULL.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SEQUENCE.get(String.valueOf(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            try {
                size = (int)reader.readInteger();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SIZE.get(String.valueOf(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            try {
                cookie = reader.readOctetString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_PAGED_RESULTS_DECODE_COOKIE.get(String.valueOf(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            try {
                reader.readEndSequence();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SEQUENCE.get(String.valueOf(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            return new PagedResultsControl(isCritical, size, cookie);
        }

        @Override
        public String getOID() {
            return "1.2.840.113556.1.4.319";
        }
    }
}

