/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class PasswordExpiredControl
extends Control {
    public static final ControlDecoder<PasswordExpiredControl> DECODER = new Decoder();

    public PasswordExpiredControl() {
        this(false);
    }

    public PasswordExpiredControl(boolean isCritical) {
        super("2.16.840.1.113730.3.4.4", isCritical);
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeOctetString("0");
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PasswordExpiredControl()");
    }

    private static final class Decoder
    implements ControlDecoder<PasswordExpiredControl> {
        private Decoder() {
        }

        @Override
        public PasswordExpiredControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value != null) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (Exception e) {
                    Message message = ProtocolMessages.ERR_PWEXPIRED_CONTROL_INVALID_VALUE.get();
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
            }
            return new PasswordExpiredControl(isCritical);
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.4";
        }
    }
}

