/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class PasswordPolicyRequestControl
extends Control {
    public static final ControlDecoder<PasswordPolicyRequestControl> DECODER = new Decoder();

    public PasswordPolicyRequestControl() {
        this(false);
    }

    public PasswordPolicyRequestControl(boolean isCritical) {
        super("1.3.6.1.4.1.42.2.27.8.5.1", isCritical);
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PasswordPolicyRequestControl()");
    }

    private static final class Decoder
    implements ControlDecoder<PasswordPolicyRequestControl> {
        private Decoder() {
        }

        @Override
        public PasswordPolicyRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value != null) {
                Message message = ProtocolMessages.ERR_PWPOLICYREQ_CONTROL_HAS_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new PasswordPolicyRequestControl(isCritical);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.42.2.27.8.5.1";
        }
    }
}

