/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.types.LDAPException;

public enum PersistentSearchChangeType {
    ADD(1),
    DELETE(2),
    MODIFY(4),
    MODIFY_DN(8);

    private int intValue;

    private PersistentSearchChangeType(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        switch (this.intValue) {
            case 1: {
                return "add";
            }
            case 2: {
                return "delete";
            }
            case 4: {
                return "modify";
            }
            case 8: {
                return "modDN";
            }
        }
        return "unknown";
    }

    public static PersistentSearchChangeType valueOf(int intValue) throws LDAPException {
        switch (intValue) {
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 4: {
                return MODIFY;
            }
            case 8: {
                return MODIFY_DN;
            }
        }
        Message message = ProtocolMessages.ERR_PSEARCH_CHANGETYPES_INVALID_TYPE.get(intValue);
        throw new LDAPException(19, message);
    }

    public static Set<PersistentSearchChangeType> intToTypes(int intValue) throws LDAPException {
        HashSet<PersistentSearchChangeType> changeTypes = new HashSet<PersistentSearchChangeType>(4);
        switch (intValue) {
            case 0: {
                Message message = ProtocolMessages.ERR_PSEARCH_CHANGETYPES_NO_TYPES.get();
                throw new LDAPException(19, message);
            }
            case 1: {
                changeTypes.add(ADD);
                break;
            }
            case 2: {
                changeTypes.add(DELETE);
                break;
            }
            case 3: {
                changeTypes.add(ADD);
                changeTypes.add(DELETE);
                break;
            }
            case 4: {
                changeTypes.add(MODIFY);
                break;
            }
            case 5: {
                changeTypes.add(ADD);
                changeTypes.add(MODIFY);
                break;
            }
            case 6: {
                changeTypes.add(DELETE);
                changeTypes.add(MODIFY);
                break;
            }
            case 7: {
                changeTypes.add(ADD);
                changeTypes.add(DELETE);
                changeTypes.add(MODIFY);
                break;
            }
            case 8: {
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 9: {
                changeTypes.add(ADD);
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 10: {
                changeTypes.add(DELETE);
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 11: {
                changeTypes.add(ADD);
                changeTypes.add(DELETE);
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 12: {
                changeTypes.add(MODIFY);
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 13: {
                changeTypes.add(ADD);
                changeTypes.add(MODIFY);
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 14: {
                changeTypes.add(DELETE);
                changeTypes.add(MODIFY);
                changeTypes.add(MODIFY_DN);
                break;
            }
            case 15: {
                changeTypes.add(ADD);
                changeTypes.add(DELETE);
                changeTypes.add(MODIFY);
                changeTypes.add(MODIFY_DN);
                break;
            }
            default: {
                Message message = ProtocolMessages.ERR_PSEARCH_CHANGETYPES_INVALID_TYPES.get(intValue);
                throw new LDAPException(19, message);
            }
        }
        return changeTypes;
    }

    public static int changeTypesToInt(Set<PersistentSearchChangeType> changeTypes) {
        int intValue = 0;
        if (changeTypes.contains((Object)ADD)) {
            intValue |= 1;
        }
        if (changeTypes.contains((Object)DELETE)) {
            intValue |= 2;
        }
        if (changeTypes.contains((Object)MODIFY)) {
            intValue |= 4;
        }
        if (changeTypes.contains((Object)MODIFY_DN)) {
            intValue |= 8;
        }
        return intValue;
    }

    public static String changeTypesToString(Set<PersistentSearchChangeType> changeTypes) {
        StringBuilder buffer = new StringBuilder();
        PersistentSearchChangeType.changeTypesToString(changeTypes, buffer);
        return buffer.toString();
    }

    public static void changeTypesToString(Set<PersistentSearchChangeType> changeTypes, StringBuilder buffer) {
        Iterator<PersistentSearchChangeType> iterator = changeTypes.iterator();
        if (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            while (iterator.hasNext()) {
                buffer.append("|");
                buffer.append(iterator.next().toString());
            }
        }
    }
}

