/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationAbandonOperation;
import org.opends.server.types.operation.PreParseAbandonOperation;

public class AbandonOperationBasis
extends AbstractOperation
implements Runnable,
AbandonOperation,
PreParseAbandonOperation,
PostOperationAbandonOperation {
    private final int idToAbandon;

    public AbandonOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, int idToAbandon) {
        super(clientConnection, operationID, messageID, requestControls);
        this.idToAbandon = idToAbandon;
        this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_ABANDON.get());
    }

    @Override
    public final int getIDToAbandon() {
        return this.idToAbandon;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.ABANDON;
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"idToAbandon", String.valueOf(this.idToAbandon)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return null;
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
    }

    @Override
    public final List<Control> getResponseControls() {
        return NO_RESPONSE_CONTROLS;
    }

    @Override
    public final void addResponseControl(Control control) {
    }

    @Override
    public final void removeResponseControl(Control control) {
    }

    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        this.setProcessingStartTime();
        AccessLogger.logAbandonRequest(this);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseAbandonPlugins(this);
        if (!preParseResult.continueProcessing()) {
            this.setResultCode(preParseResult.getResultCode());
            this.appendErrorMessage(preParseResult.getErrorMessage());
            this.setMatchedDN(preParseResult.getMatchedDN());
            this.setReferralURLs(preParseResult.getReferralURLs());
        } else {
            boolean notifyRequestor = DirectoryServer.notifyAbandonedOperations();
            Message cancelReason = CoreMessages.INFO_CANCELED_BY_ABANDON_REQUEST.get(this.messageID);
            CancelRequest _cancelRequest = new CancelRequest(notifyRequestor, cancelReason);
            CancelResult result = this.clientConnection.cancelOperation(this.idToAbandon, _cancelRequest);
            this.setResultCode(result.getResultCode());
            this.appendErrorMessage(result.getResponseMessage());
            PluginResult.PostOperation postOpResult = pluginConfigManager.invokePostOperationAbandonPlugins(this);
            if (!postOpResult.continueProcessing()) {
                this.setResultCode(preParseResult.getResultCode());
                this.appendErrorMessage(preParseResult.getErrorMessage());
                this.setMatchedDN(preParseResult.getMatchedDN());
                this.setReferralURLs(preParseResult.getReferralURLs());
            }
        }
        this.setProcessingStopTime();
        AccessLogger.logAbandonResult(this);
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("AbandonOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", idToAbandon=");
        buffer.append(this.idToAbandon);
        buffer.append(")");
    }
}

