/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseCompareOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;

public class CompareOperationBasis
extends AbstractOperation
implements PreParseCompareOperation,
CompareOperation,
Runnable,
PostResponseCompareOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType attributeType;
    private ByteString assertionValue;
    private Set<String> attributeOptions;
    private ByteString rawEntryDN;
    private DN entryDN;
    private DN proxiedAuthorizationDN;
    private List<Control> responseControls;
    private String rawAttributeType;

    public CompareOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN, String rawAttributeType, ByteString assertionValue) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.rawAttributeType = rawAttributeType;
        this.assertionValue = assertionValue;
        this.responseControls = new ArrayList<Control>();
        this.entryDN = null;
        this.attributeType = null;
        this.attributeOptions = null;
        this.cancelRequest = null;
        this.proxiedAuthorizationDN = null;
    }

    public CompareOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN, AttributeType attributeType, ByteString assertionValue) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.attributeType = attributeType;
        this.assertionValue = assertionValue;
        this.responseControls = new ArrayList<Control>();
        this.rawEntryDN = ByteString.valueOf(entryDN.toString());
        this.rawAttributeType = attributeType.getNameOrOID();
        this.cancelRequest = null;
        this.proxiedAuthorizationDN = null;
        this.attributeOptions = new HashSet<String>();
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        if (this.entryDN == null) {
            try {
                this.entryDN = DN.decode(this.rawEntryDN);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResultCode(de.getResultCode());
                this.appendErrorMessage(de.getMessageObject());
            }
        }
        return this.entryDN;
    }

    @Override
    public final String getRawAttributeType() {
        return this.rawAttributeType;
    }

    @Override
    public final void setRawAttributeType(String rawAttributeType) {
        this.rawAttributeType = rawAttributeType;
        this.attributeType = null;
        this.attributeOptions = null;
    }

    private void getAttributeTypeAndOptions() {
        String baseName;
        int semicolonPos = this.rawAttributeType.indexOf(59);
        if (semicolonPos > 0) {
            baseName = StaticUtils.toLowerCase(this.rawAttributeType.substring(0, semicolonPos));
            this.attributeOptions = new HashSet<String>();
            int nextPos = this.rawAttributeType.indexOf(59, semicolonPos + 1);
            while (nextPos > 0) {
                this.attributeOptions.add(this.rawAttributeType.substring(semicolonPos + 1, nextPos));
                semicolonPos = nextPos;
                nextPos = this.rawAttributeType.indexOf(59, semicolonPos + 1);
            }
            this.attributeOptions.add(this.rawAttributeType.substring(semicolonPos + 1));
        } else {
            baseName = StaticUtils.toLowerCase(this.rawAttributeType);
            this.attributeOptions = null;
        }
        this.attributeType = DirectoryServer.getAttributeType(baseName, true);
    }

    @Override
    public final AttributeType getAttributeType() {
        if (this.attributeType == null) {
            this.getAttributeTypeAndOptions();
        }
        return this.attributeType;
    }

    @Override
    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public Set<String> getAttributeOptions() {
        if (this.attributeOptions == null) {
            this.getAttributeTypeAndOptions();
        }
        return this.attributeOptions;
    }

    @Override
    public void setAttributeOptions(Set<String> attributeOptions) {
        this.attributeOptions = attributeOptions;
    }

    @Override
    public final ByteString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public final void setAssertionValue(ByteString assertionValue) {
        this.assertionValue = assertionValue;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}, {"compareAttribute", this.rawAttributeType}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        this.setProcessingStartTime();
        AccessLogger.logCompareRequest(this);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean workflowExecuted = false;
        try {
            this.checkIfCanceled(false);
            PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseComparePlugins(this);
            if (!preParseResult.continueProcessing()) {
                this.setResultCode(preParseResult.getResultCode());
                this.appendErrorMessage(preParseResult.getErrorMessage());
                this.setMatchedDN(preParseResult.getMatchedDN());
                this.setReferralURLs(preParseResult.getReferralURLs());
                return;
            }
            this.checkIfCanceled(false);
            try {
                if (this.entryDN == null) {
                    this.entryDN = DN.decode(this.rawEntryDN);
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResultCode(de.getResultCode());
                this.appendErrorMessage(de.getMessageObject());
                this.setProcessingStopTime();
                AccessLogger.logCompareResponse(this);
                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.clientConnection.sendResponse(this);
                }
                this.invokePostResponsePlugins(workflowExecuted);
                if (this.cancelResult == null) {
                    this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                }
                return;
            }
            NetworkGroup ng = this.getClientConnection().getNetworkGroup();
            Workflow workflow = ng.getWorkflowCandidate(this.entryDN);
            if (workflow == null) {
                this.updateOperationErrMsgAndResCode();
                return;
            }
            workflow.execute(this);
            workflowExecuted = true;
        }
        catch (CanceledOperationException coe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, coe);
            }
            this.setResultCode(ResultCode.CANCELED);
            this.cancelResult = new CancelResult(ResultCode.CANCELED, null);
            this.appendErrorMessage(coe.getCancelRequest().getCancelReason());
        }
        finally {
            this.setProcessingStopTime();
            AccessLogger.logCompareResponse(this);
            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.clientConnection.sendResponse(this);
            }
            this.invokePostResponsePlugins(workflowExecuted);
            if (this.cancelResult == null) {
                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
            }
        }
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (Object localOp : localOperations) {
                    LocalBackendCompareOperation localOperation = (LocalBackendCompareOperation)localOp;
                    pluginConfigManager.invokePostResponseComparePlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseComparePlugins(this);
        }
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        this.appendErrorMessage(CoreMessages.ERR_COMPARE_NO_SUCH_ENTRY.get(String.valueOf(this.getEntryDN())));
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("CompareOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(", attr=");
        buffer.append(this.rawAttributeType);
        buffer.append(")");
    }

    @Override
    public Entry getEntryToCompare() {
        return null;
    }
}

