/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.AuthenticationPolicyState;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationProperty;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public final class PasswordPolicyState
extends AuthenticationPolicyState {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final String userDNString;
    private final PasswordPolicy passwordPolicy;
    private final long currentTime;
    private long passwordChangedTime = Long.MIN_VALUE;
    private ConditionResult isAccountExpired = ConditionResult.UNDEFINED;
    private ConditionResult isPasswordExpired = ConditionResult.UNDEFINED;
    private ConditionResult isFirstWarning = ConditionResult.UNDEFINED;
    private ConditionResult isIdleLocked = ConditionResult.UNDEFINED;
    private ConditionResult mayUseGraceLogin = ConditionResult.UNDEFINED;
    private ConditionResult mustChangePassword = ConditionResult.UNDEFINED;
    private ConditionResult shouldWarn = ConditionResult.UNDEFINED;
    private int secondsUntilUnlock = Integer.MIN_VALUE;
    private List<Long> authFailureTimes = null;
    private List<Long> graceLoginTimes = null;
    private long accountExpirationTime = Long.MIN_VALUE;
    private long failureLockedTime = Long.MIN_VALUE;
    private long lastLoginTime = Long.MIN_VALUE;
    private long passwordExpirationTime = Long.MIN_VALUE;
    private long requiredChangeTime = Long.MIN_VALUE;
    private long warnedTime = Long.MIN_VALUE;
    private LinkedList<Modification> modifications = new LinkedList();

    PasswordPolicyState(PasswordPolicy policy, Entry userEntry, long currentTime) {
        super(userEntry);
        this.currentTime = currentTime;
        this.userDNString = userEntry.getDN().toString();
        this.passwordPolicy = policy;
    }

    private String getValue(AttributeType attributeType) {
        String stringValue = null;
        List<Attribute> attrList = this.userEntry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                stringValue = a.iterator().next().getValue().toString();
                break;
            }
        }
        if (stringValue == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning null because attribute %s does not exist in user entry %s", attributeType.getNameOrOID(), this.userDNString);
            }
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning value %s for user %s", stringValue, this.userDNString);
        }
        return stringValue;
    }

    private List<Long> getGeneralizedTimes(AttributeType attributeType) throws DirectoryException {
        ArrayList<Long> timeValues = new ArrayList<Long>();
        List<Attribute> attrList = this.userEntry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    try {
                        timeValues.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(v.getNormalizedValue()));
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            TRACER.debugWarning("Unable to decode value %s for attribute %sin user entry %s: %s", v.getValue().toString(), attributeType.getNameOrOID(), this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                        }
                        Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_GENERALIZED_TIME.get(v.getValue().toString(), attributeType.getNameOrOID(), this.userDNString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
            }
        }
        if (timeValues.isEmpty() && DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning an empty list because attribute %s does not exist in user entry %s", attributeType.getNameOrOID(), this.userDNString);
        }
        return timeValues;
    }

    @Override
    public PasswordPolicy getAuthenticationPolicy() {
        return this.passwordPolicy;
    }

    public long getPasswordChangedTime() {
        if (this.passwordChangedTime < 0L) {
            AttributeType type = DirectoryServer.getAttributeType("pwdchangedtime", true);
            try {
                this.passwordChangedTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, type);
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
            if (this.passwordChangedTime < 0L) {
                AttributeType createTimeType = DirectoryServer.getAttributeType("createtimestamp", true);
                try {
                    this.passwordChangedTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, createTimeType);
                }
                catch (DirectoryException directoryException) {
                    // empty catch block
                }
                if (this.passwordChangedTime < 0L) {
                    this.passwordChangedTime = 0L;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugWarning("Could not determine password changed time for user %s.", this.userDNString);
                    }
                }
            }
        }
        return this.passwordChangedTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public Set<AttributeValue> getPasswordValues() {
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(a.size());
                for (AttributeValue value : a) {
                    values.add(value);
                }
                return Collections.unmodifiableSet(values);
            }
        }
        return Collections.emptySet();
    }

    public void setPasswordChangedTime() {
        this.setPasswordChangedTime(this.currentTime);
    }

    public void setPasswordChangedTime(long passwordChangedTime) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Setting password changed time for user %s to current time of %d", this.userDNString, this.currentTime);
        }
        if (this.getPasswordChangedTime() != passwordChangedTime) {
            this.passwordChangedTime = passwordChangedTime;
            String timeValue = GeneralizedTimeSyntax.format(passwordChangedTime);
            Attribute a = Attributes.create("pwdChangedTime", timeValue);
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
    }

    public void clearPasswordChangedTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing password changed time for user %s", this.userDNString);
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdchangedtime", true);
        Attribute a = Attributes.empty(type);
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        AttributeType createTimeType = DirectoryServer.getAttributeType("createtimestamp", true);
        try {
            this.passwordChangedTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, createTimeType);
            if (this.passwordChangedTime < 0L) {
                this.passwordChangedTime = 0L;
            }
        }
        catch (Exception e) {
            this.passwordChangedTime = 0L;
        }
    }

    public void setDisabled(boolean isDisabled) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating user %s to set the disabled flag to %b", this.userDNString, isDisabled);
        }
        if (isDisabled == this.isDisabled()) {
            return;
        }
        this.isDisabled = ConditionResult.inverseOf(this.isDisabled);
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
        if (isDisabled) {
            Attribute a = Attributes.create(type, String.valueOf(true));
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public boolean isAccountExpired() {
        if (this.isAccountExpired != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s", this.isAccountExpired == ConditionResult.TRUE, this.userDNString);
            }
            return this.isAccountExpired == ConditionResult.TRUE;
        }
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
        try {
            this.accountExpirationTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.isAccountExpired = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("User %s is considered to have an expired account because an error occurred while attempting to make the determination: %s.", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return true;
        }
        if (this.accountExpirationTime > this.currentTime) {
            this.isAccountExpired = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The account for user %s is not expired because the expiration time has not yet arrived.", this.userDNString);
            }
        } else if (this.accountExpirationTime >= 0L) {
            this.isAccountExpired = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The account for user %s is expired because the expiration time in that account has passed.", this.userDNString);
            }
        } else {
            this.isAccountExpired = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The account for user %s is not expired because there is no expiration time in the user's entry.", this.userDNString);
            }
        }
        return this.isAccountExpired == ConditionResult.TRUE;
    }

    public long getAccountExpirationTime() {
        if (this.accountExpirationTime == Long.MIN_VALUE) {
            this.isAccountExpired();
        }
        return this.accountExpirationTime;
    }

    public void setAccountExpirationTime(long accountExpirationTime) {
        if (accountExpirationTime < 0L) {
            this.clearAccountExpirationTime();
        } else {
            String timeStr = GeneralizedTimeSyntax.format(accountExpirationTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Setting account expiration time for user %s to %s", this.userDNString, timeStr);
            }
            this.accountExpirationTime = accountExpirationTime;
            AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
            Attribute a = Attributes.create(type, timeStr);
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
    }

    public void clearAccountExpirationTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing account expiration time for user %s", this.userDNString);
        }
        this.accountExpirationTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    public List<Long> getAuthFailureTimes() {
        if (this.authFailureTimes != null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored auth failure time list of %d elements for user %s", this.authFailureTimes.size(), this.userDNString);
            }
            return this.authFailureTimes;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        try {
            this.authFailureTimes = this.getGeneralizedTimes(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Error while processing auth failure times for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            this.authFailureTimes = new ArrayList<Long>();
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
            return this.authFailureTimes;
        }
        if (this.authFailureTimes.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning an empty auth failure time list for user %s because the attribute is absent from the entry.", this.userDNString);
            }
            return this.authFailureTimes;
        }
        if (this.passwordPolicy.getLockoutFailureExpirationInterval() > 0L) {
            LinkedHashSet<AttributeValue> valuesToRemove = null;
            long expirationTime = this.currentTime - this.passwordPolicy.getLockoutFailureExpirationInterval() * 1000L;
            Iterator<Long> iterator = this.authFailureTimes.iterator();
            while (iterator.hasNext()) {
                long l = iterator.next();
                if (l >= expirationTime) continue;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Removing expired auth failure time %d for user %s", l, this.userDNString);
                }
                iterator.remove();
                if (valuesToRemove == null) {
                    valuesToRemove = new LinkedHashSet<AttributeValue>();
                }
                valuesToRemove.add(AttributeValues.create(type, GeneralizedTimeSyntax.format(l)));
            }
            if (valuesToRemove != null) {
                AttributeBuilder builder = new AttributeBuilder(type);
                builder.addAll(valuesToRemove);
                Attribute a = builder.toAttribute();
                this.modifications.add(new Modification(ModificationType.DELETE, a, true));
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning auth failure time list of %d elements for user %s", this.authFailureTimes.size(), this.userDNString);
        }
        return this.authFailureTimes;
    }

    public void updateAuthFailureTimes() {
        if (this.passwordPolicy.getLockoutFailureCount() <= 0) {
            return;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating authentication failure times for user %s", this.userDNString);
        }
        List<Long> failureTimes = this.getAuthFailureTimes();
        long highestFailureTime = -1L;
        for (Long l : failureTimes) {
            highestFailureTime = Math.max(l, highestFailureTime);
        }
        highestFailureTime = highestFailureTime >= this.currentTime ? ++highestFailureTime : this.currentTime;
        failureTimes.add(highestFailureTime);
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        Attribute addAttr = Attributes.create(type, AttributeValues.create(type, GeneralizedTimeSyntax.format(highestFailureTime)));
        this.modifications.add(new Modification(ModificationType.ADD, addAttr, true));
        int lockoutCount = this.passwordPolicy.getLockoutFailureCount();
        if (lockoutCount > 0 && lockoutCount <= this.authFailureTimes.size()) {
            this.setFailureLockedTime(highestFailureTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Locking user account %s due to too many failures.", this.userDNString);
            }
        }
    }

    public void setAuthFailureTimes(List<Long> authFailureTimes) {
        if (authFailureTimes == null || authFailureTimes.isEmpty()) {
            this.clearAuthFailureTimes();
            this.clearFailureLockedTime();
            return;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime", true);
        this.authFailureTimes = authFailureTimes;
        AttributeBuilder builder = new AttributeBuilder(type);
        long highestFailureTime = -1L;
        for (Long l : authFailureTimes) {
            highestFailureTime = Math.max(l, highestFailureTime);
            builder.add(AttributeValues.create(type, GeneralizedTimeSyntax.format(l)));
        }
        Attribute a = builder.toAttribute();
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        int lockoutCount = this.passwordPolicy.getLockoutFailureCount();
        if (lockoutCount > 0 && lockoutCount <= authFailureTimes.size()) {
            this.setFailureLockedTime(highestFailureTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Locking user account %s due to too many failures.", this.userDNString);
            }
        }
    }

    private void clearAuthFailureTimes() {
        List<Long> failureTimes;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing authentication failure times for user %s", this.userDNString);
        }
        if ((failureTimes = this.getAuthFailureTimes()).isEmpty()) {
            return;
        }
        failureTimes.clear();
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    private long getFailureLockedTime() {
        if (this.failureLockedTime != Long.MIN_VALUE) {
            return this.failureLockedTime;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        try {
            this.failureLockedTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.failureLockedTime = this.currentTime;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Returning current time for user %s because an error occurred: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return this.failureLockedTime;
        }
        return this.failureLockedTime;
    }

    private void setFailureLockedTime(long time) {
        if (time == this.getFailureLockedTime()) {
            return;
        }
        this.failureLockedTime = time;
        AttributeType type = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        Attribute a = Attributes.create(type, AttributeValues.create(type, GeneralizedTimeSyntax.format(this.failureLockedTime)));
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
    }

    private void clearFailureLockedTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing failure lockout time for user %s.", this.userDNString);
        }
        if (-1L == this.getFailureLockedTime()) {
            return;
        }
        this.failureLockedTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    public boolean lockedDueToFailures() {
        int maxFailures = this.passwordPolicy.getLockoutFailureCount();
        if (maxFailures <= 0) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because lockout due to failures is not enabled.", this.userDNString);
            }
            return false;
        }
        if (this.getFailureLockedTime() < 0L) {
            if (this.getAuthFailureTimes().size() < maxFailures) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false for user %s because there is no locked time.", this.userDNString);
                }
                return false;
            }
            this.setFailureLockedTime(this.currentTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Locking user %s because there were enough existing failures even though there was no account locked time.", this.userDNString);
            }
        }
        if (this.passwordPolicy.getLockoutDuration() > 0L) {
            long unlockTime = this.getFailureLockedTime() + 1000L * this.passwordPolicy.getLockoutDuration();
            if (unlockTime > this.currentTime) {
                this.secondsUntilUnlock = (int)((unlockTime - this.currentTime) / 1000L);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning true for user %s because there is a locked time and the lockout duration has not been reached.", this.userDNString);
                }
                return true;
            }
            this.clearFailureLockout();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because the existing lockout has expired.", this.userDNString);
            }
            assert (-1L == this.getFailureLockedTime());
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning true for user %s because there is a locked time and no lockout duration.", this.userDNString);
        }
        assert (-1L <= this.getFailureLockedTime());
        return true;
    }

    public int getSecondsUntilUnlock() {
        assert (this.failureLockedTime != Long.MIN_VALUE);
        return this.secondsUntilUnlock < 0 ? -1 : this.secondsUntilUnlock;
    }

    public void clearFailureLockout() {
        this.clearAuthFailureTimes();
        this.clearFailureLockedTime();
    }

    public long getLastLoginTime() {
        if (this.lastLoginTime != Long.MIN_VALUE) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored last login time of %d for user %s.", this.lastLoginTime, this.userDNString);
            }
            return this.lastLoginTime;
        }
        AttributeType type = this.passwordPolicy.getLastLoginTimeAttribute();
        String format = this.passwordPolicy.getLastLoginTimeFormat();
        if (type == null || format == null) {
            this.lastLoginTime = -1L;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning -1 for user %s because no last login time will be maintained.", this.userDNString);
            }
            return this.lastLoginTime;
        }
        boolean isGeneralizedTime = type.getSyntax().getSyntaxName().equals("GeneralizedTime");
        this.lastLoginTime = -1L;
        List<Attribute> attrList = this.userEntry.getAttribute(type);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                String valueString = a.iterator().next().getValue().toString();
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    if (isGeneralizedTime) {
                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    }
                    this.lastLoginTime = dateFormat.parse(valueString).getTime();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning last login time of %d for user %sdecoded using current last login time format.", this.lastLoginTime, this.userDNString);
                    }
                    return this.lastLoginTime;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    for (String f : this.passwordPolicy.getPreviousLastLoginTimeFormats()) {
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(f);
                            if (isGeneralizedTime) {
                                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            }
                            this.lastLoginTime = dateFormat.parse(valueString).getTime();
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Returning last login time of %d for user %s decoded using previous last login time format of %s.", this.lastLoginTime, this.userDNString, f);
                            }
                            return this.lastLoginTime;
                        }
                        catch (Exception e2) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    assert (this.lastLoginTime == -1L);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugWarning("Returning -1 for user %s because the last login time value %s could not be parsed using any known format.", this.userDNString, valueString);
                    }
                    return this.lastLoginTime;
                }
            }
        }
        assert (this.lastLoginTime == -1L);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %d for user %s because no last login time value exists.", this.lastLoginTime, this.userDNString);
        }
        return this.lastLoginTime;
    }

    public void setLastLoginTime() {
        this.setLastLoginTime(this.currentTime);
    }

    public void setLastLoginTime(long lastLoginTime) {
        String timestamp;
        AttributeType type = this.passwordPolicy.getLastLoginTimeAttribute();
        String format = this.passwordPolicy.getLastLoginTimeFormat();
        if (type == null || format == null) {
            return;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            if (type.getSyntax().getSyntaxName().equals("GeneralizedTime")) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            timestamp = dateFormat.format(new Date(lastLoginTime));
            this.lastLoginTime = dateFormat.parse(timestamp).getTime();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Unable to set last login time for user %s because an error occurred: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return;
        }
        String existingTimestamp = this.getValue(type);
        if (existingTimestamp != null && timestamp.equals(existingTimestamp)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Not updating last login time for user %s because the new value matches the existing value.", this.userDNString);
            }
            return;
        }
        Attribute a = Attributes.create(type, timestamp);
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updated the last login time for user %s to %s", this.userDNString, timestamp);
        }
    }

    public void clearLastLoginTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing last login time for user %s", this.userDNString);
        }
        this.lastLoginTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-last-login-time", true);
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    public boolean lockedDueToIdleInterval() {
        long theLastLoginTime;
        if (this.isIdleLocked != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s", this.isIdleLocked == ConditionResult.TRUE, this.userDNString);
            }
            return this.isIdleLocked == ConditionResult.TRUE;
        }
        if (this.passwordPolicy.getIdleLockoutInterval() <= 0L) {
            this.isIdleLocked = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because no idle lockout interval is defined.", this.userDNString);
            }
            return false;
        }
        long lockTime = this.currentTime - 1000L * this.passwordPolicy.getIdleLockoutInterval();
        if (lockTime < 0L) {
            lockTime = 0L;
        }
        if ((theLastLoginTime = this.getLastLoginTime()) > lockTime || this.getPasswordChangedTime() > lockTime) {
            this.isIdleLocked = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                StringBuilder reason = new StringBuilder();
                if (theLastLoginTime > lockTime) {
                    reason.append("the last login time is in an acceptable window");
                } else {
                    if (theLastLoginTime < 0L) {
                        reason.append("there is no last login time, but ");
                    }
                    reason.append("the password changed time is in an acceptable window");
                }
                TRACER.debugInfo("Returning false for user %s because %s.", this.userDNString, reason.toString());
            }
        } else {
            this.isIdleLocked = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                String reason = theLastLoginTime < 0L ? "there is no last login time and the password changed time is not in an acceptable window" : "neither last login time nor password changed time are in an acceptable window";
                TRACER.debugInfo("Returning true for user %s because %s.", this.userDNString, reason);
            }
        }
        return this.isIdleLocked == ConditionResult.TRUE;
    }

    public boolean mustChangePassword() {
        if (this.mustChangePassword != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s.", this.mustChangePassword == ConditionResult.TRUE, this.userDNString);
            }
            return this.mustChangePassword == ConditionResult.TRUE;
        }
        if (!this.passwordPolicy.isAllowUserPasswordChanges() || !this.passwordPolicy.isForceChangeOnAdd() && !this.passwordPolicy.isForceChangeOnReset()) {
            this.mustChangePassword = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because neither force change on add nor force change on reset is enabled, or users are not allowed to self-modify passwords.", this.userDNString);
            }
            return false;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdreset");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdReset");
        }
        try {
            this.mustChangePassword = PasswordPolicyState.getBoolean(this.userEntry, type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                TRACER.debugWarning("Returning true for user %s because an error occurred: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            this.mustChangePassword = ConditionResult.TRUE;
            return true;
        }
        if (this.mustChangePassword == ConditionResult.UNDEFINED) {
            this.mustChangePassword = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning %b for user since the attribute \"%s\" is not present in the entry.", false, this.userDNString, "pwdReset");
            }
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %b for user %s.", this.mustChangePassword == ConditionResult.TRUE, this.userDNString);
        }
        return this.mustChangePassword == ConditionResult.TRUE;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating user %s to set the reset flag to %b", this.userDNString, mustChangePassword);
        }
        if (mustChangePassword == this.mustChangePassword()) {
            return;
        }
        this.mustChangePassword = ConditionResult.inverseOf(this.mustChangePassword);
        AttributeType type = DirectoryServer.getAttributeType("pwdreset");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdReset");
        }
        if (mustChangePassword) {
            Attribute a = Attributes.create(type, String.valueOf(true));
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public boolean lockedDueToMaximumResetAge() {
        boolean locked;
        if (this.passwordPolicy.getMaxPasswordResetAge() <= 0L) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because there is no maximum reset age.", this.userDNString);
            }
            return false;
        }
        if (!this.mustChangePassword()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because the user's password has not been reset.", this.userDNString);
            }
            return false;
        }
        long maxResetTime = this.getPasswordChangedTime() + 1000L * this.passwordPolicy.getMaxPasswordResetAge();
        boolean bl = locked = maxResetTime < this.currentTime;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %b for user %s after comparing the current and max reset times.", locked, this.userDNString);
        }
        return locked;
    }

    public long getPasswordExpirationTime() {
        if (this.passwordExpirationTime == Long.MIN_VALUE) {
            long reqChangeTime;
            long mustChangeTime;
            long expTime;
            long expTime2;
            this.passwordExpirationTime = Long.MAX_VALUE;
            boolean checkWarning = false;
            long maxAge = this.passwordPolicy.getMaxPasswordAge();
            if (maxAge > 0L && (expTime2 = this.getPasswordChangedTime() + 1000L * maxAge) < this.passwordExpirationTime) {
                this.passwordExpirationTime = expTime2;
                checkWarning = true;
            }
            long maxResetAge = this.passwordPolicy.getMaxPasswordResetAge();
            if (this.mustChangePassword() && maxResetAge > 0L && (expTime = this.getPasswordChangedTime() + 1000L * maxResetAge) < this.passwordExpirationTime) {
                this.passwordExpirationTime = expTime;
                checkWarning = false;
            }
            if ((mustChangeTime = this.passwordPolicy.getRequireChangeByTime()) > 0L && (reqChangeTime = this.getRequiredChangeTime()) != mustChangeTime && mustChangeTime < this.passwordExpirationTime) {
                this.passwordExpirationTime = mustChangeTime;
                checkWarning = true;
            }
            if (this.passwordExpirationTime == Long.MAX_VALUE) {
                this.passwordExpirationTime = -1L;
                this.shouldWarn = ConditionResult.FALSE;
                this.isFirstWarning = ConditionResult.FALSE;
                this.isPasswordExpired = ConditionResult.FALSE;
                this.mayUseGraceLogin = ConditionResult.TRUE;
            } else if (checkWarning) {
                this.mayUseGraceLogin = ConditionResult.TRUE;
                long warningInterval = this.passwordPolicy.getPasswordExpirationWarningInterval();
                if (warningInterval > 0L) {
                    long shouldWarnTime = this.passwordExpirationTime - warningInterval * 1000L;
                    if (shouldWarnTime > this.currentTime) {
                        this.shouldWarn = ConditionResult.FALSE;
                        this.isFirstWarning = ConditionResult.FALSE;
                        this.isPasswordExpired = ConditionResult.FALSE;
                    } else {
                        long theWarnedTime = this.getWarnedTime();
                        if (this.passwordExpirationTime > this.currentTime) {
                            this.shouldWarn = ConditionResult.TRUE;
                            this.isPasswordExpired = ConditionResult.FALSE;
                            if (theWarnedTime < 0L) {
                                this.isFirstWarning = ConditionResult.TRUE;
                                this.setWarnedTime();
                                if (!this.passwordPolicy.isExpirePasswordsWithoutWarning()) {
                                    this.passwordExpirationTime = this.currentTime + warningInterval * 1000L;
                                }
                            } else {
                                this.isFirstWarning = ConditionResult.FALSE;
                                if (!this.passwordPolicy.isExpirePasswordsWithoutWarning()) {
                                    this.passwordExpirationTime = theWarnedTime + warningInterval * 1000L;
                                }
                            }
                        } else if (this.passwordPolicy.isExpirePasswordsWithoutWarning()) {
                            this.shouldWarn = ConditionResult.FALSE;
                            this.isFirstWarning = ConditionResult.FALSE;
                            this.isPasswordExpired = ConditionResult.TRUE;
                        } else if (theWarnedTime > 0L) {
                            this.passwordExpirationTime = theWarnedTime + warningInterval * 1000L;
                            if (this.passwordExpirationTime > this.currentTime) {
                                this.shouldWarn = ConditionResult.TRUE;
                                this.isFirstWarning = ConditionResult.FALSE;
                                this.isPasswordExpired = ConditionResult.FALSE;
                            } else {
                                this.shouldWarn = ConditionResult.FALSE;
                                this.isFirstWarning = ConditionResult.FALSE;
                                this.isPasswordExpired = ConditionResult.TRUE;
                            }
                        } else {
                            this.shouldWarn = ConditionResult.TRUE;
                            this.isFirstWarning = ConditionResult.TRUE;
                            this.isPasswordExpired = ConditionResult.FALSE;
                            this.passwordExpirationTime = this.currentTime + warningInterval * 1000L;
                        }
                    }
                } else {
                    this.shouldWarn = ConditionResult.FALSE;
                    this.isFirstWarning = ConditionResult.FALSE;
                    this.isPasswordExpired = this.currentTime > this.passwordExpirationTime ? ConditionResult.TRUE : ConditionResult.FALSE;
                }
            } else {
                this.mayUseGraceLogin = ConditionResult.FALSE;
                this.shouldWarn = ConditionResult.FALSE;
                this.isFirstWarning = ConditionResult.FALSE;
                this.isPasswordExpired = this.passwordExpirationTime < this.currentTime ? ConditionResult.TRUE : ConditionResult.FALSE;
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning password expiration time of %d for user %s.", this.passwordExpirationTime, this.userDNString);
        }
        return this.passwordExpirationTime;
    }

    public boolean isPasswordExpired() {
        if (this.isPasswordExpired == null || this.isPasswordExpired == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.isPasswordExpired == ConditionResult.TRUE;
    }

    public boolean isWithinMinimumAge() {
        long minAge = this.passwordPolicy.getMinPasswordAge();
        if (minAge <= 0L) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because there is no minimum age.");
            }
            return false;
        }
        if (this.getPasswordChangedTime() + minAge * 1000L < this.currentTime) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because the minimum age has expired.");
            }
            return false;
        }
        if (this.mustChangePassword()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because the account is in a must-change state.");
            }
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning true.");
        }
        return true;
    }

    public boolean mayUseGraceLogin() {
        if (this.mayUseGraceLogin == null || this.mayUseGraceLogin == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.mayUseGraceLogin == ConditionResult.TRUE;
    }

    public boolean shouldWarn() {
        if (this.shouldWarn == null || this.shouldWarn == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.shouldWarn == ConditionResult.TRUE;
    }

    public boolean isFirstWarning() {
        if (this.isFirstWarning == null || this.isFirstWarning == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.isFirstWarning == ConditionResult.TRUE;
    }

    public int getSecondsUntilExpiration() {
        long expirationTime = this.getPasswordExpirationTime();
        if (expirationTime < 0L) {
            return -1;
        }
        if (expirationTime < this.currentTime) {
            return 0;
        }
        return (int)((expirationTime - this.currentTime) / 1000L);
    }

    public long getRequiredChangeTime() {
        if (this.requiredChangeTime != Long.MIN_VALUE) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored required change time of %d for user %s", this.requiredChangeTime, this.userDNString);
            }
            return this.requiredChangeTime;
        }
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
        try {
            this.requiredChangeTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.requiredChangeTime = -1L;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Returning %d for user %s because an error occurred: %s", this.requiredChangeTime, this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return this.requiredChangeTime;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning required change time of %d for user %s", this.requiredChangeTime, this.userDNString);
        }
        return this.requiredChangeTime;
    }

    public void setRequiredChangeTime() {
        long requiredChangeByTimePolicy = this.passwordPolicy.getRequireChangeByTime();
        if (requiredChangeByTimePolicy > 0L) {
            this.setRequiredChangeTime(requiredChangeByTimePolicy);
        }
    }

    public void setRequiredChangeTime(long requiredChangeTime) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating required change time for user %s", this.userDNString);
        }
        if (this.getRequiredChangeTime() != requiredChangeTime) {
            this.requiredChangeTime = requiredChangeTime;
            AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
            String timeValue = GeneralizedTimeSyntax.format(requiredChangeTime);
            Attribute a = Attributes.create(type, timeValue);
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
    }

    public void clearRequiredChangeTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing required change time for user %s", this.userDNString);
        }
        this.requiredChangeTime = Long.MIN_VALUE;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    public long getWarnedTime() {
        if (this.warnedTime == Long.MIN_VALUE) {
            AttributeType type = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
            try {
                this.warnedTime = PasswordPolicyState.getGeneralizedTime(this.userEntry, type);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("Unable to decode the warned time for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
                this.warnedTime = -1L;
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning a warned time of %d for user %s", this.warnedTime, this.userDNString);
        }
        return this.warnedTime;
    }

    public void setWarnedTime() {
        this.setWarnedTime(this.currentTime);
    }

    public void setWarnedTime(long warnedTime) {
        long warnTime = this.getWarnedTime();
        if (warnTime == warnedTime) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Not updating warned time for user %s because the warned time is the same as the specified time.", this.userDNString);
            }
            return;
        }
        this.warnedTime = warnedTime;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
        Attribute a = Attributes.create(type, GeneralizedTimeSyntax.createGeneralizedTimeValue(this.currentTime));
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updated the warned time for user %s", this.userDNString);
        }
    }

    public void clearWarnedTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing warned time for user %s", this.userDNString);
        }
        if (this.getWarnedTime() < 0L) {
            return;
        }
        this.warnedTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
        Attribute a = Attributes.empty(type);
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Cleared the warned time for user %s", this.userDNString);
        }
    }

    public List<Long> getGraceLoginTimes() {
        if (this.graceLoginTimes == null) {
            AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime");
            if (type == null) {
                type = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
            }
            try {
                this.graceLoginTimes = this.getGeneralizedTimes(type);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("Error while processing grace login times for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
                this.graceLoginTimes = new ArrayList<Long>();
                this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning grace login times for user %s", this.userDNString);
        }
        return this.graceLoginTimes;
    }

    public int getGraceLoginsRemaining() {
        int maxGraceLogins = this.passwordPolicy.getGraceLoginCount();
        if (maxGraceLogins <= 0) {
            return -1;
        }
        List<Long> theGraceLoginTimes = this.getGraceLoginTimes();
        return maxGraceLogins - theGraceLoginTimes.size();
    }

    public void updateGraceLoginTimes() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating grace login times for user %s", this.userDNString);
        }
        List<Long> graceTimes = this.getGraceLoginTimes();
        long highestGraceTime = -1L;
        for (Long l : graceTimes) {
            highestGraceTime = Math.max(l, highestGraceTime);
        }
        highestGraceTime = highestGraceTime >= this.currentTime ? ++highestGraceTime : this.currentTime;
        graceTimes.add(highestGraceTime);
        AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
        }
        Attribute addAttr = Attributes.create(type, AttributeValues.create(type, GeneralizedTimeSyntax.format(highestGraceTime)));
        this.modifications.add(new Modification(ModificationType.ADD, addAttr, true));
    }

    public void setGraceLoginTimes(List<Long> graceLoginTimes) {
        if (graceLoginTimes == null || graceLoginTimes.isEmpty()) {
            this.clearGraceLoginTimes();
            return;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating grace login times for user %s", this.userDNString);
        }
        this.graceLoginTimes = graceLoginTimes;
        AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime", true);
        AttributeBuilder builder = new AttributeBuilder(type);
        for (Long l : graceLoginTimes) {
            builder.add(AttributeValues.create(type, GeneralizedTimeSyntax.format(l)));
        }
        Attribute a = builder.toAttribute();
        this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
    }

    public void clearGraceLoginTimes() {
        List<Long> graceTimes;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing grace login times for user %s", this.userDNString);
        }
        if ((graceTimes = this.getGraceLoginTimes()).isEmpty()) {
            return;
        }
        graceTimes.clear();
        AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
        }
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    public List<ByteString> getClearPasswords() {
        LinkedList<ByteString> clearPasswords = new LinkedList<ByteString>();
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList == null) {
            return clearPasswords;
        }
        for (Attribute a : attrList) {
            boolean usesAuthPasswordSyntax = this.passwordPolicy.isAuthPasswordSyntax();
            for (AttributeValue v : a) {
                try {
                    PasswordStorageScheme scheme;
                    StringBuilder[] pwComponents;
                    if (usesAuthPasswordSyntax) {
                        pwComponents = AuthPasswordSyntax.decodeAuthPassword(v.getValue().toString());
                    } else {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(v.getValue().toString());
                        pwComponents = new StringBuilder[userPwComponents.length];
                        for (int i = 0; i < userPwComponents.length; ++i) {
                            pwComponents[i] = new StringBuilder(userPwComponents[i]);
                        }
                    }
                    String schemeName = pwComponents[0].toString();
                    PasswordStorageScheme passwordStorageScheme = scheme = usesAuthPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(schemeName);
                    if (scheme == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("User entry %s contains a password with scheme %s that is not defined in the server.", this.userDNString, schemeName);
                        continue;
                    }
                    if (!scheme.isReversible()) continue;
                    ByteString clearValue = usesAuthPasswordSyntax ? scheme.getAuthPasswordPlaintextValue(pwComponents[1].toString(), pwComponents[2].toString()) : scheme.getPlaintextValue(ByteString.valueOf(pwComponents[1].toString()));
                    clearPasswords.add(clearValue);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugWarning("Cannot get clear password value foruser %s: %s", this.userDNString, e);
                }
            }
        }
        return clearPasswords;
    }

    @Override
    public boolean passwordMatches(ByteString password) {
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList == null || attrList.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because user %s does not have any values for password attribute %s", this.userDNString, this.passwordPolicy.getPasswordAttribute().getNameOrOID());
            }
            return false;
        }
        for (Attribute a : attrList) {
            boolean usesAuthPasswordSyntax = this.passwordPolicy.isAuthPasswordSyntax();
            for (AttributeValue v : a) {
                try {
                    PasswordStorageScheme scheme;
                    StringBuilder[] pwComponents;
                    if (usesAuthPasswordSyntax) {
                        pwComponents = AuthPasswordSyntax.decodeAuthPassword(v.getValue().toString());
                    } else {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(v.getValue().toString());
                        pwComponents = new StringBuilder[userPwComponents.length];
                        for (int i = 0; i < userPwComponents.length; ++i) {
                            pwComponents[i] = new StringBuilder(userPwComponents[i]);
                        }
                    }
                    String schemeName = pwComponents[0].toString();
                    PasswordStorageScheme passwordStorageScheme = scheme = usesAuthPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(schemeName);
                    if (scheme == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("User entry %s contains a password with scheme %s that is not defined in the server.", this.userDNString, schemeName);
                        continue;
                    }
                    boolean passwordMatches = usesAuthPasswordSyntax ? scheme.authPasswordMatches(password, pwComponents[1].toString(), pwComponents[2].toString()) : scheme.passwordMatches(password, ByteString.valueOf(pwComponents[1].toString()));
                    if (!passwordMatches) continue;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning true for user %s because the provided password matches a value encoded with scheme %s", this.userDNString, schemeName);
                    }
                    return true;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugWarning("An error occurred while attempting to process a password value for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning false because the provided password does not match any of the stored password values for user %s", this.userDNString);
        }
        return false;
    }

    public boolean passwordIsPreEncoded(ByteString passwordValue) {
        if (this.passwordPolicy.isAuthPasswordSyntax()) {
            return AuthPasswordSyntax.isEncoded(passwordValue);
        }
        return UserPasswordSyntax.isEncoded(passwordValue);
    }

    public List<ByteString> encodePassword(ByteString password) throws DirectoryException {
        List<PasswordStorageScheme<?>> schemes = this.passwordPolicy.getDefaultPasswordStorageSchemes();
        ArrayList<ByteString> encodedPasswords = new ArrayList<ByteString>(schemes.size());
        if (this.passwordPolicy.isAuthPasswordSyntax()) {
            for (PasswordStorageScheme<?> s : schemes) {
                encodedPasswords.add(s.encodeAuthPassword(password));
            }
        } else {
            for (PasswordStorageScheme<?> s : schemes) {
                encodedPasswords.add(s.encodePasswordWithScheme(password));
            }
        }
        return encodedPasswords;
    }

    public boolean passwordIsAcceptable(Operation operation, Entry userEntry, ByteString newPassword, Set<ByteString> currentPasswords, MessageBuilder invalidReason) {
        for (PasswordValidator<?> validator : this.passwordPolicy.getPasswordValidators()) {
            if (validator.passwordIsAcceptable(newPassword, currentPasswords, operation, userEntry, invalidReason)) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The password provided for user %s failed validation: %s", this.userDNString, invalidReason.toString());
            }
            return false;
        }
        return true;
    }

    public void handleDeprecatedStorageSchemes(ByteString password) {
        if (this.passwordPolicy.getDefaultPasswordStorageSchemes().isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Doing nothing for user %s because no deprecated storage schemes have been defined.", this.userDNString);
            }
            return;
        }
        AttributeType type = this.passwordPolicy.getPasswordAttribute();
        List<Attribute> attrList = this.userEntry.getAttribute(type);
        if (attrList == null || attrList.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Doing nothing for entry %s because no password values were found.", this.userDNString);
            }
            return;
        }
        HashSet<String> existingDefaultSchemes = new HashSet<String>();
        LinkedHashSet<AttributeValue> removedValues = new LinkedHashSet<AttributeValue>();
        LinkedHashSet<AttributeValue> updatedValues = new LinkedHashSet<AttributeValue>();
        boolean usesAuthPasswordSyntax = this.passwordPolicy.isAuthPasswordSyntax();
        for (Attribute a : attrList) {
            for (AttributeValue v : a) {
                try {
                    PasswordStorageScheme scheme;
                    StringBuilder[] pwComponents;
                    if (usesAuthPasswordSyntax) {
                        pwComponents = AuthPasswordSyntax.decodeAuthPassword(v.getValue().toString());
                    } else {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(v.getValue().toString());
                        pwComponents = new StringBuilder[userPwComponents.length];
                        for (int i = 0; i < userPwComponents.length; ++i) {
                            pwComponents[i] = new StringBuilder(userPwComponents[i]);
                        }
                    }
                    String schemeName = pwComponents[0].toString();
                    PasswordStorageScheme passwordStorageScheme = scheme = usesAuthPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(schemeName);
                    if (scheme == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("Skipping password value for user %s because the associated storage scheme %s is not configured for use.", this.userDNString, schemeName);
                        continue;
                    }
                    boolean passwordMatches = usesAuthPasswordSyntax ? scheme.authPasswordMatches(password, pwComponents[1].toString(), pwComponents[2].toString()) : scheme.passwordMatches(password, ByteString.valueOf(pwComponents[1].toString()));
                    if (!passwordMatches) continue;
                    if (this.passwordPolicy.isDefaultPasswordStorageScheme(schemeName)) {
                        existingDefaultSchemes.add(schemeName);
                        updatedValues.add(v);
                        continue;
                    }
                    if (this.passwordPolicy.isDeprecatedPasswordStorageScheme(schemeName)) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Marking password with scheme %s for removal from user entry %s.", schemeName, this.userDNString);
                        }
                        removedValues.add(v);
                        continue;
                    }
                    updatedValues.add(v);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugWarning("Skipping password value for user %s because an error occurred while attempting to decode it based on the user password syntax: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
        if (removedValues.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("User entry %s does not have any password values encoded using deprecated schemes.", this.userDNString);
            }
            return;
        }
        LinkedHashSet<AttributeValue> addedValues = new LinkedHashSet<AttributeValue>();
        for (PasswordStorageScheme<?> s : this.passwordPolicy.getDefaultPasswordStorageSchemes()) {
            if (existingDefaultSchemes.contains(StaticUtils.toLowerCase(s.getStorageSchemeName()))) continue;
            try {
                ByteString encodedPassword = usesAuthPasswordSyntax ? s.encodeAuthPassword(password) : s.encodePasswordWithScheme(password);
                AttributeValue v = AttributeValues.create(type, encodedPassword);
                addedValues.add(v);
                updatedValues.add(v);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugWarning("Unable to encode password for user %s using default scheme %s: %s", this.userDNString, s.getStorageSchemeName(), StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        if (updatedValues.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Not updating user entry %s because removing deprecated schemes would leave the user without a password.", this.userDNString);
            }
            return;
        }
        AttributeBuilder builder = new AttributeBuilder(type);
        builder.addAll(removedValues);
        Attribute a = builder.toAttribute();
        this.modifications.add(new Modification(ModificationType.DELETE, a, true));
        if (!addedValues.isEmpty()) {
            builder = new AttributeBuilder(type);
            builder.addAll(addedValues);
            Attribute a2 = builder.toAttribute();
            this.modifications.add(new Modification(ModificationType.ADD, a2, true));
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating user entry %s to replace password values encoded with deprecated schemes with values encoded with the default schemes.", this.userDNString);
        }
    }

    public boolean maintainHistory() {
        return this.passwordPolicy.getPasswordHistoryCount() > 0 || this.passwordPolicy.getPasswordHistoryDuration() > 0L;
    }

    public boolean isPasswordInHistory(ByteString password) {
        long historyDuration;
        if (!this.maintainHistory()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because password history checking is disabled.");
            }
            return false;
        }
        if (this.passwordMatches(password)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning true because the provided password is currently in use.");
            }
            return true;
        }
        TreeMap<Long, AttributeValue> historyMap = this.getSortedHistoryValues(null);
        int historyCount = this.passwordPolicy.getPasswordHistoryCount();
        if (historyCount > 0 && historyMap.size() > historyCount) {
            Iterator<Long> iterator = historyMap.keySet().iterator();
            for (int numToDelete = historyMap.size() - historyCount; iterator.hasNext() && numToDelete > 0; --numToDelete) {
                iterator.next();
                iterator.remove();
            }
        }
        if ((historyDuration = this.passwordPolicy.getPasswordHistoryDuration()) > 0L) {
            long historyDate;
            long retainDate = this.currentTime - 1000L * historyDuration;
            Iterator<Long> iterator = historyMap.keySet().iterator();
            while (iterator.hasNext() && (historyDate = iterator.next().longValue()) < retainDate) {
                iterator.remove();
            }
        }
        for (AttributeValue v : historyMap.values()) {
            if (!this.historyValueMatches(password, v)) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning true because the password is in the history.");
            }
            return true;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning false because the password isn't in the history.");
        }
        return false;
    }

    private TreeMap<Long, AttributeValue> getSortedHistoryValues(List<Attribute> removeAttrs) {
        TreeMap<Long, AttributeValue> historyMap = new TreeMap<Long, AttributeValue>();
        AttributeType historyType = DirectoryServer.getAttributeType("pwdhistory", true);
        List<Attribute> attrList = this.userEntry.getAttribute(historyType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    String histStr = v.getValue().toString();
                    int hashPos = histStr.indexOf(35);
                    if (hashPos <= 0) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found value " + histStr + " in the " + "history with no timestamp.  Marking it " + "for removal.");
                        }
                        if (removeAttrs == null) continue;
                        removeAttrs.add(Attributes.create(a.getAttributeType(), v));
                        continue;
                    }
                    try {
                        long timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ByteString.valueOf(histStr.substring(0, hashPos)));
                        historyMap.put(timestamp, v);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            TRACER.debugInfo("Could not decode the timestamp in history value " + histStr + " -- " + e + ".  Marking it for removal.");
                        }
                        if (removeAttrs == null) continue;
                        removeAttrs.add(Attributes.create(a.getAttributeType(), v));
                    }
                }
            }
        }
        return historyMap;
    }

    private boolean historyValueMatches(ByteString password, AttributeValue historyValue) {
        try {
            String histStr = historyValue.getValue().toString();
            int hashPos1 = histStr.indexOf(35);
            if (hashPos1 <= 0) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the password history value didn't include any hash characters.");
                }
                return false;
            }
            int hashPos2 = histStr.indexOf(35, hashPos1 + 1);
            if (hashPos2 < 0) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the password history value only had one hash character.");
                }
                return false;
            }
            String syntaxOID = StaticUtils.toLowerCase(histStr.substring(hashPos1 + 1, hashPos2));
            if (syntaxOID.equals("1.3.6.1.4.1.4203.1.1.2")) {
                StringBuilder[] authPWComponents = AuthPasswordSyntax.decodeAuthPassword(histStr.substring(hashPos2 + 1));
                PasswordStorageScheme scheme = DirectoryServer.getAuthPasswordStorageScheme(authPWComponents[0].toString());
                if (scheme.authPasswordMatches(password, authPWComponents[1].toString(), authPWComponents[2].toString())) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning true because the auth password history value matched.");
                    }
                    return true;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the auth password history value did not match.");
                }
                return false;
            }
            if (syntaxOID.equals("1.3.6.1.4.1.26027.1.3.1")) {
                String[] userPWComponents = UserPasswordSyntax.decodeUserPassword(histStr.substring(hashPos2 + 1));
                PasswordStorageScheme scheme = DirectoryServer.getPasswordStorageScheme(userPWComponents[0]);
                if (scheme.passwordMatches(password, ByteString.valueOf(userPWComponents[1]))) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning true because the user password history value matched.");
                    }
                    return true;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the user password history value did not match.");
                }
                return false;
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because the syntax OID " + syntaxOID + " didn't match for either the auth " + "or user password syntax.");
            }
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because of an exception:  " + StaticUtils.stackTraceToSingleLineString(e));
                }
            }
            return false;
        }
    }

    public void updatePasswordHistory() {
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    this.addPasswordToHistory(v.getValue().toString());
                }
            }
        }
    }

    private void addPasswordToHistory(String encodedPassword) {
        long historyDuration;
        if (!this.maintainHistory()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Not doing anything because password history maintenance is disabled.");
            }
            return;
        }
        LinkedList<Attribute> removeAttrs = new LinkedList<Attribute>();
        TreeMap<Long, AttributeValue> historyMap = this.getSortedHistoryValues(removeAttrs);
        AttributeType historyType = DirectoryServer.getAttributeType("pwdhistory", true);
        int historyCount = this.passwordPolicy.getPasswordHistoryCount();
        if (historyCount > 0 && historyMap.size() >= historyCount) {
            int numToDelete;
            LinkedHashSet<AttributeValue> removeValues = new LinkedHashSet<AttributeValue>(numToDelete);
            Iterator<AttributeValue> iterator = historyMap.values().iterator();
            for (numToDelete = historyMap.size() - historyCount + 1; iterator.hasNext() && numToDelete > 0; --numToDelete) {
                AttributeValue v = iterator.next();
                removeValues.add(v);
                iterator.remove();
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugInfo("Removing history value " + v.getValue().toString() + " to preserve the history count.");
            }
            if (!removeValues.isEmpty()) {
                AttributeBuilder builder = new AttributeBuilder(historyType);
                builder.addAll(removeValues);
                removeAttrs.add(builder.toAttribute());
            }
        }
        if ((historyDuration = this.passwordPolicy.getPasswordHistoryDuration()) > 0L) {
            long timestamp;
            long minAgeToKeep = this.currentTime - 1000L * historyDuration;
            Iterator<Long> iterator = historyMap.keySet().iterator();
            LinkedHashSet<AttributeValue> removeValues = new LinkedHashSet<AttributeValue>();
            while (iterator.hasNext() && (timestamp = iterator.next().longValue()) < minAgeToKeep) {
                AttributeValue v = historyMap.get(timestamp);
                removeValues.add(v);
                iterator.remove();
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugInfo("Removing history value " + v.getValue().toString() + " to preserve the history duration.");
            }
            if (!removeValues.isEmpty()) {
                AttributeBuilder builder = new AttributeBuilder(historyType);
                builder.addAll(removeValues);
                removeAttrs.add(builder.toAttribute());
            }
        }
        long newTimestamp = this.currentTime;
        while (historyMap.containsKey(newTimestamp)) {
            ++newTimestamp;
        }
        String newHistStr = GeneralizedTimeSyntax.format(newTimestamp) + "#" + this.passwordPolicy.getPasswordAttribute().getSyntaxOID() + "#" + encodedPassword;
        Attribute newHistAttr = Attributes.create(historyType, newHistStr);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Going to add history value " + newHistStr);
        }
        for (Attribute a : removeAttrs) {
            this.modifications.add(new Modification(ModificationType.DELETE, a, true));
        }
        this.modifications.add(new Modification(ModificationType.ADD, newHistAttr, true));
    }

    public String[] getPasswordHistoryValues() {
        ArrayList<String> historyValues = new ArrayList<String>();
        AttributeType historyType = DirectoryServer.getAttributeType("pwdhistory", true);
        List<Attribute> attrList = this.userEntry.getAttribute(historyType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    historyValues.add(v.getValue().toString());
                }
            }
        }
        String[] historyArray = new String[historyValues.size()];
        return historyValues.toArray(historyArray);
    }

    public void clearPasswordHistory() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing password history for user %s", this.userDNString);
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdhistory", true);
        this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
    }

    public ByteString generatePassword() throws DirectoryException {
        PasswordGenerator<?> generator = this.passwordPolicy.getPasswordGenerator();
        if (generator == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Unable to generate a new password for user %s because no password generator has been defined in the associated password policy.", this.userDNString);
            }
            return null;
        }
        return generator.generatePassword(this.userEntry);
    }

    public void generateAccountStatusNotification(AccountStatusNotificationType notificationType, Entry userEntry, Message message, Map<AccountStatusNotificationProperty, List<String>> notificationProperties) {
        this.generateAccountStatusNotification(new AccountStatusNotification(notificationType, userEntry, message, notificationProperties));
    }

    public void generateAccountStatusNotification(AccountStatusNotification notification) {
        Collection<AccountStatusNotificationHandler<?>> handlers = this.passwordPolicy.getAccountStatusNotificationHandlers();
        for (AccountStatusNotificationHandler<?> handler : handlers) {
            handler.handleStatusNotification(notification);
        }
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    @Override
    public void finalizeStateAfterBind() throws DirectoryException {
        if (this.modifications.isEmpty()) {
            return;
        }
        ArrayList<RawModification> modList = new ArrayList<RawModification>();
        for (Modification m : this.modifications) {
            modList.add(RawModification.create(m.getModificationType(), new LDAPAttribute(m.getAttribute())));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyOperation internalModify = conn.processModify(ByteString.valueOf(this.userDNString), modList);
        ResultCode resultCode = internalModify.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            Message message = CoreMessages.ERR_PWPSTATE_CANNOT_UPDATE_USER_ENTRY.get(this.userDNString, String.valueOf(internalModify.getErrorMessage()));
            if (DirectoryServer.isRootDN(this.userEntry.getDN()) || this.passwordPolicy.getStateUpdateFailurePolicy() == PasswordPolicyCfgDefn.StateUpdateFailurePolicy.IGNORE) {
                ErrorLogger.logError(message);
            } else {
                throw new DirectoryException(resultCode, message);
            }
        }
    }
}

