/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Iterator;
import java.util.LinkedList;
import org.opends.server.api.DirectoryThread;

public class ServerShutdownMonitor
extends DirectoryThread {
    private volatile boolean monitorDone;
    private LinkedList<Thread> threadList;

    public ServerShutdownMonitor() {
        super("Directory Server Shutdown Monitor");
        this.setDaemon(true);
        long currentThreadID = Thread.currentThread().getId();
        this.threadList = new LinkedList();
        DirectoryThread.DirectoryThreadGroup threadGroup = DirectoryThread.DIRECTORY_THREAD_GROUP;
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2];
        int numThreads = threadGroup.enumerate(threadArray, true);
        for (int i = 0; i < numThreads; ++i) {
            Thread t = threadArray[i];
            if (!t.isAlive() || t.isDaemon() || t.getId() == currentThreadID) continue;
            this.threadList.add(t);
        }
        this.monitorDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.monitorDone = false;
        try {
            Thread t3;
            Iterator iterator = this.threadList.iterator();
            while (iterator.hasNext()) {
                Thread t2 = (Thread)iterator.next();
                if (t2.isAlive()) continue;
                iterator.remove();
            }
            if (this.threadList.isEmpty()) {
                return;
            }
            long stopTime = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < stopTime) {
                iterator = this.threadList.iterator();
                while (iterator.hasNext()) {
                    t3 = (Thread)iterator.next();
                    if (t3.isAlive()) continue;
                    iterator.remove();
                }
                if (this.threadList.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception t3) {}
            }
            for (Thread t3 : this.threadList) {
                try {
                    if (!t3.isAlive()) continue;
                    t3.interrupt();
                }
                catch (Exception exception) {}
            }
            if (this.threadList.isEmpty()) {
                return;
            }
            stopTime = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < stopTime) {
                iterator = this.threadList.iterator();
                while (iterator.hasNext()) {
                    t3 = (Thread)iterator.next();
                    if (t3.isAlive()) continue;
                    iterator.remove();
                }
                if (this.threadList.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception t4) {}
            }
            System.err.println("WARNING:  The following threads were still active after waiting up to 60 seconds for them to stop:");
            for (Thread t3 : this.threadList) {
                System.err.println("Thread Name:  " + t3.getName());
                System.err.println("Stack Trace:");
                for (StackTraceElement e : t3.getStackTrace()) {
                    System.err.print("              " + e.getClassName() + "." + e.getMethodName() + "(" + e.getFileName() + ":");
                    if (e.isNativeMethod()) {
                        System.err.print("native method");
                    } else {
                        System.err.print(e.getLineNumber());
                    }
                    System.err.println(")");
                    System.err.println();
                }
            }
        }
        finally {
            this.monitorDone = true;
        }
    }

    public void waitForMonitor() {
        while (!this.monitorDone) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }
}

