/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.VirtualAttributeCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

public class VirtualAttributeConfigManager
implements ConfigurationChangeListener<VirtualAttributeCfg>,
ConfigurationAddListener<VirtualAttributeCfg>,
ConfigurationDeleteListener<VirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, VirtualAttributeRule> rules = new ConcurrentHashMap();

    public void initializeVirtualAttributes() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addVirtualAttributeAddListener(this);
        rootConfiguration.addVirtualAttributeDeleteListener(this);
        for (String providerName : rootConfiguration.listVirtualAttributes()) {
            VirtualAttributeCfg cfg = rootConfiguration.getVirtualAttribute(providerName);
            cfg.addChangeListener(this);
            if (!cfg.isEnabled()) continue;
            String className = cfg.getJavaClass();
            try {
                VirtualAttributeProvider<? extends VirtualAttributeCfg> provider = this.loadProvider(className, cfg, true);
                LinkedHashSet<SearchFilter> filters = new LinkedHashSet<SearchFilter>();
                for (String filterString : cfg.getFilter()) {
                    try {
                        filters.add(SearchFilter.createFilterFromString(filterString));
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        Message message = ConfigMessages.ERR_CONFIG_VATTR_INVALID_SEARCH_FILTER.get(filterString, String.valueOf(cfg.dn()), de.getMessageObject());
                        throw new ConfigException(message, (Throwable)de);
                    }
                }
                if (cfg.getAttributeType().isSingleValue()) {
                    Message message;
                    if (provider.isMultiValued()) {
                        message = ConfigMessages.ERR_CONFIG_VATTR_SV_TYPE_WITH_MV_PROVIDER.get(String.valueOf(cfg.dn()), cfg.getAttributeType().getNameOrOID(), className);
                        throw new ConfigException(message);
                    }
                    if (cfg.getConflictBehavior() == VirtualAttributeCfgDefn.ConflictBehavior.MERGE_REAL_AND_VIRTUAL) {
                        message = ConfigMessages.ERR_CONFIG_VATTR_SV_TYPE_WITH_MERGE_VALUES.get(String.valueOf(cfg.dn()), cfg.getAttributeType().getNameOrOID());
                        throw new ConfigException(message);
                    }
                }
                VirtualAttributeRule rule = new VirtualAttributeRule(cfg.getAttributeType(), provider, cfg.getBaseDN(), SearchScope.valueOf(cfg.getScope().name()), cfg.getGroupDN(), filters, cfg.getConflictBehavior());
                this.rules.put(cfg.dn(), rule);
                DirectoryServer.registerVirtualAttribute(rule);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(VirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        for (String filterString : configuration.getFilter()) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message message = ConfigMessages.ERR_CONFIG_VATTR_INVALID_SEARCH_FILTER.get(filterString, String.valueOf(configuration.dn()), de.getMessageObject());
                unacceptableReasons.add(message);
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(VirtualAttributeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        LinkedHashSet<SearchFilter> filters = new LinkedHashSet<SearchFilter>();
        for (String filterString : configuration.getFilter()) {
            try {
                filters.add(SearchFilter.createFilterFromString(filterString));
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                }
                Message message = ConfigMessages.ERR_CONFIG_VATTR_INVALID_SEARCH_FILTER.get(filterString, String.valueOf(configuration.dn()), de.getMessageObject());
                messages.add(message);
            }
        }
        VirtualAttributeProvider<? extends VirtualAttributeCfg> provider = null;
        if (resultCode == ResultCode.SUCCESS) {
            String className = configuration.getJavaClass();
            try {
                provider = this.loadProvider(className, configuration, true);
            }
            catch (InitializationException ie) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ie.getMessageObject());
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            VirtualAttributeRule rule = new VirtualAttributeRule(configuration.getAttributeType(), provider, configuration.getBaseDN(), SearchScope.valueOf(configuration.getScope().name()), configuration.getGroupDN(), filters, configuration.getConflictBehavior());
            this.rules.put(configuration.dn(), rule);
            DirectoryServer.registerVirtualAttribute(rule);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(VirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(VirtualAttributeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        VirtualAttributeRule rule = this.rules.remove(configuration.dn());
        if (rule != null) {
            DirectoryServer.deregisterVirtualAttribute(rule);
            rule.getProvider().finalizeVirtualAttributeProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(VirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        for (String filterString : configuration.getFilter()) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message message = ConfigMessages.ERR_CONFIG_VATTR_INVALID_SEARCH_FILTER.get(filterString, String.valueOf(configuration.dn()), de.getMessageObject());
                unacceptableReasons.add(message);
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(VirtualAttributeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        VirtualAttributeRule existingRule = this.rules.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingRule != null) {
                this.rules.remove(configuration.dn());
                DirectoryServer.deregisterVirtualAttribute(existingRule);
                existingRule.getProvider().finalizeVirtualAttributeProvider();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        LinkedHashSet<SearchFilter> filters = new LinkedHashSet<SearchFilter>();
        for (String filterString : configuration.getFilter()) {
            try {
                filters.add(SearchFilter.createFilterFromString(filterString));
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                }
                Message message = ConfigMessages.ERR_CONFIG_VATTR_INVALID_SEARCH_FILTER.get(filterString, String.valueOf(configuration.dn()), de.getMessageObject());
                messages.add(message);
            }
        }
        VirtualAttributeProvider<? extends VirtualAttributeCfg> provider = null;
        if (resultCode == ResultCode.SUCCESS) {
            String className = configuration.getJavaClass();
            try {
                provider = this.loadProvider(className, configuration, true);
            }
            catch (InitializationException ie) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ie.getMessageObject());
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            VirtualAttributeRule rule = new VirtualAttributeRule(configuration.getAttributeType(), provider, configuration.getBaseDN(), SearchScope.valueOf(configuration.getScope().name()), configuration.getGroupDN(), filters, configuration.getConflictBehavior());
            this.rules.put(configuration.dn(), rule);
            if (existingRule == null) {
                DirectoryServer.registerVirtualAttribute(rule);
            } else {
                DirectoryServer.replaceVirtualAttribute(existingRule, rule);
                existingRule.getProvider().finalizeVirtualAttributeProvider();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private VirtualAttributeProvider<? extends VirtualAttributeCfg> loadProvider(String className, VirtualAttributeCfg configuration, boolean initialize) throws InitializationException {
        try {
            VirtualAttributeCfgDefn definition = VirtualAttributeCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<VirtualAttributeProvider> providerClass = propertyDefinition.loadClass(className, VirtualAttributeProvider.class);
            VirtualAttributeProvider provider = providerClass.newInstance();
            if (initialize) {
                Method method = provider.getClass().getMethod("initializeVirtualAttributeProvider", configuration.configurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", VirtualAttributeCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_VATTR_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return provider;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_VATTR_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

