/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AttributeValuePasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

public class AttributeValuePasswordValidator
extends PasswordValidator<AttributeValuePasswordValidatorCfg>
implements ConfigurationChangeListener<AttributeValuePasswordValidatorCfg> {
    private AttributeValuePasswordValidatorCfg currentConfig;

    @Override
    public void initializePasswordValidator(AttributeValuePasswordValidatorCfg configuration) {
        configuration.addAttributeValueChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeAttributeValueChangeListener(this);
    }

    private boolean containsSubstring(String password, int minSubstringLength, Attribute a) {
        int passwordLength = password.length();
        for (int i = 0; i < passwordLength; ++i) {
            for (int j = i + minSubstringLength; j <= passwordLength; ++j) {
                Attribute substring = Attributes.create(a.getAttributeType(), password.substring(i, j));
                for (AttributeValue val : a) {
                    if (!substring.contains(val)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
        Set<AttributeType> matchAttributes;
        AttributeValuePasswordValidatorCfg config = this.currentConfig;
        String password = newPassword.toString();
        String reversed = new StringBuilder(password).reverse().toString();
        int minSubstringLength = password.length();
        if (config.isCheckSubstrings() && config.getMinSubstringLength() < password.length()) {
            minSubstringLength = config.getMinSubstringLength();
        }
        if ((matchAttributes = config.getMatchAttribute()) == null || matchAttributes.isEmpty()) {
            matchAttributes = userEntry.getUserAttributes().keySet();
        }
        for (AttributeType t : matchAttributes) {
            List<Attribute> attrList = userEntry.getAttribute(t);
            if (attrList == null || attrList.isEmpty()) continue;
            AttributeValue vf = AttributeValues.create(t, password);
            AttributeValue vr = AttributeValues.create(t, reversed);
            for (Attribute a : attrList) {
                if (!a.contains(vf) && (!config.isTestReversedPassword() || !a.contains(vr)) && (!config.isCheckSubstrings() || !this.containsSubstring(password, minSubstringLength, a))) continue;
                invalidReason.append(ExtensionMessages.ERR_ATTRVALUE_VALIDATOR_PASSWORD_IN_ENTRY.get());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        AttributeValuePasswordValidatorCfg config = (AttributeValuePasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AttributeValuePasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AttributeValuePasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

