/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.ClearPasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class ClearPasswordStorageScheme
extends PasswordStorageScheme<ClearPasswordStorageSchemeCfg> {
    @Override
    public void initializePasswordStorageScheme(ClearPasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getStorageSchemeName() {
        return "CLEAR";
    }

    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        return plaintext.toByteString();
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("CLEAR");
        buffer.append('}');
        buffer.append(plaintext.toString());
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        return plaintextPassword.equals(storedPassword);
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        return storedPassword.toByteString();
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return false;
    }
}

