/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.EntryUUIDVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

public class EntryUUIDVirtualAttributeProvider
extends VirtualAttributeProvider<EntryUUIDVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(EntryUUIDVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        String normDNString = entry.getDN().toNormalizedString();
        String uuidString = UUID.nameUUIDFromBytes(StaticUtils.getBytes(normDNString)).toString();
        AttributeValue value = AttributeValues.create(ByteString.valueOf(uuidString), ByteString.valueOf(uuidString));
        return Collections.singleton(value);
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return true;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        try {
            String normalizedDN = entry.getDN().toNormalizedString();
            String uuidString = UUID.nameUUIDFromBytes(StaticUtils.getBytes(normalizedDN)).toString();
            String normalizedValue = value.getNormalizedValue().toString();
            return uuidString.equals(normalizedValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_ENTRYUUID_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

