/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Map;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.TraditionalWorkQueue;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Operation;
import org.opends.server.util.StaticUtils;

public class TraditionalWorkerThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile boolean shutdownRequested;
    private boolean stoppedByReducedThreadNumber;
    private boolean waitingForWork;
    private Operation operation;
    private Thread workerThread;
    private TraditionalWorkQueue workQueue;

    public TraditionalWorkerThread(TraditionalWorkQueue workQueue, int threadID) {
        super("Worker Thread " + threadID);
        this.workQueue = workQueue;
        this.stoppedByReducedThreadNumber = false;
        this.shutdownRequested = false;
        this.waitingForWork = false;
        this.operation = null;
        this.workerThread = null;
    }

    public void setStoppedByReducedThreadNumber() {
        this.stoppedByReducedThreadNumber = true;
    }

    public boolean isActive() {
        return this.isAlive() && this.operation != null;
    }

    @Override
    public void run() {
        this.workerThread = TraditionalWorkerThread.currentThread();
        while (!this.shutdownRequested) {
            try {
                this.waitingForWork = true;
                this.operation = null;
                this.operation = this.workQueue.nextOperation(this);
                this.waitingForWork = false;
                if (this.operation == null) break;
                this.operation.run();
                this.operation.operationCompleted();
            }
            catch (Throwable t) {
                Message message;
                block12: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugWarning("Uncaught exception in worker thread while processing operation %s: %s", String.valueOf(this.operation), t);
                        TRACER.debugCaught(DebugLogLevel.ERROR, t);
                    }
                    try {
                        message = CoreMessages.ERR_UNCAUGHT_WORKER_THREAD_EXCEPTION.get(this.getName(), String.valueOf(this.operation), StaticUtils.stackTraceToSingleLineString(t));
                        ErrorLogger.logError(message);
                        this.operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.operation.appendErrorMessage(message);
                        this.operation.getClientConnection().sendResponse(this.operation);
                    }
                    catch (Throwable t2) {
                        if (!DebugLogger.debugEnabled()) break block12;
                        TRACER.debugWarning("Exception in worker thread while trying to log a message about an uncaught exception %s: %s", t, t2);
                        TRACER.debugCaught(DebugLogLevel.ERROR, t2);
                    }
                }
                try {
                    message = CoreMessages.ERR_UNCAUGHT_WORKER_THREAD_EXCEPTION.get(this.getName(), String.valueOf(this.operation), StaticUtils.stackTraceToSingleLineString(t));
                    this.operation.disconnectClient(DisconnectReason.SERVER_ERROR, true, message);
                }
                catch (Throwable t2) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, t2);
                }
            }
        }
        if (this.stoppedByReducedThreadNumber) {
            ErrorLogger.logError(CoreMessages.INFO_WORKER_STOPPED_BY_REDUCED_THREADNUMBER.get(this.getName()));
        } else if (!this.workQueue.shutdownRequested()) {
            ErrorLogger.logError(CoreMessages.WARN_UNEXPECTED_WORKER_THREAD_EXIT.get(this.getName()));
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + " exiting.");
        }
    }

    public void shutDown() {
        block8: {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " being signaled to shut down.");
            }
            this.shutdownRequested = true;
            if (this.waitingForWork) {
                try {
                    this.workerThread.interrupt();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugWarning("Caught an exception while trying to interrupt the worker thread waiting for work: %s", e);
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    break block8;
                }
            }
            try {
                Operation localOperation = this.operation;
                if (localOperation != null) {
                    CancelRequest cancelRequest = new CancelRequest(true, CoreMessages.INFO_CANCELED_BY_SHUTDOWN.get());
                    localOperation.cancel(cancelRequest);
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugWarning("Caught an exception while trying to abandon the operation in progress for the worker thread: %s", e);
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public Map<String, String> getDebugProperties() {
        Map<String, String> properties = super.getDebugProperties();
        properties.put("clientConnection", this.operation.getClientConnection().toString());
        properties.put("operation", this.operation.toString());
        return properties;
    }
}

