/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileCountLogRetentionPolicyCfg;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class FileNumberRetentionPolicy
implements RetentionPolicy<FileCountLogRetentionPolicyCfg>,
ConfigurationChangeListener<FileCountLogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int numFiles = 0;
    private FileCountLogRetentionPolicyCfg config;

    @Override
    public void initializeLogRetentionPolicy(FileCountLogRetentionPolicyCfg config) {
        this.numFiles = config.getNumberOfFiles();
        this.config = config;
        config.addFileCountChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileCountLogRetentionPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileCountLogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.numFiles = config.getNumberOfFiles();
        this.config = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public File[] deleteFiles(FileNamingPolicy fileNamingPolicy) throws DirectoryException {
        File[] files = fileNamingPolicy.listFiles();
        if (files == null) {
            Message message = LoggerMessages.ERR_LOGGER_ERROR_LISTING_FILES.get(fileNamingPolicy.getInitialName().toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        if (files.length <= this.numFiles) {
            return new File[0];
        }
        Arrays.sort(files, new FileComparator());
        for (int j = this.numFiles; j < files.length; ++j) {
            filesToDelete.add(files[j]);
        }
        return filesToDelete.toArray(new File[0]);
    }

    public String toString() {
        return "Free Number Retention Policy " + this.config.dn().toString();
    }
}

