/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.Collection;
import org.opends.messages.ConfigMessages;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.std.meta.HTTPAccessLogPublisherCfgDefn;
import org.opends.server.admin.std.server.HTTPAccessLogPublisherCfg;
import org.opends.server.api.HTTPAccessLogPublisher;
import org.opends.server.loggers.AbstractLogger;
import org.opends.server.loggers.HTTPRequestInfo;

public class HTTPAccessLogger
extends AbstractLogger<HTTPAccessLogPublisher<HTTPAccessLogPublisherCfg>, HTTPAccessLogPublisherCfg> {
    private static AbstractLogger.LoggerStorage<HTTPAccessLogPublisher<HTTPAccessLogPublisherCfg>, HTTPAccessLogPublisherCfg> loggerStorage = new AbstractLogger.LoggerStorage();
    private static final HTTPAccessLogger instance = new HTTPAccessLogger();

    public HTTPAccessLogger() {
        super(HTTPAccessLogPublisher.class, ConfigMessages.ERR_CONFIG_LOGGER_INVALID_HTTP_ACCESS_LOGGER_CLASS);
    }

    @Override
    protected ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return HTTPAccessLogPublisherCfgDefn.getInstance().getJavaClassPropertyDefinition();
    }

    @Override
    protected AbstractLogger.LoggerStorage<HTTPAccessLogPublisher<HTTPAccessLogPublisherCfg>, HTTPAccessLogPublisherCfg> getStorage() {
        return loggerStorage;
    }

    public static HTTPAccessLogger getInstance() {
        return instance;
    }

    public static synchronized void addHTTPAccessLogPublisher(HTTPAccessLogPublisher publisher) {
        loggerStorage.addLogPublisher(publisher);
    }

    public static synchronized boolean removeHTTPAccessLogPublisher(HTTPAccessLogPublisher<HTTPAccessLogPublisherCfg> publisher) {
        return loggerStorage.removeLogPublisher(publisher);
    }

    public static synchronized void removeAllHTTPAccessLogPublishers() {
        loggerStorage.removeAllLogPublishers();
    }

    public static Collection<HTTPAccessLogPublisher<HTTPAccessLogPublisherCfg>> getHTTPAccessLogPublishers() {
        return loggerStorage.getLogPublishers();
    }

    public static void logRequestInfo(HTTPRequestInfo requestInfo) {
        for (HTTPAccessLogPublisher<HTTPAccessLogPublisherCfg> publisher : loggerStorage.getLogPublishers()) {
            publisher.logRequestInfo(requestInfo);
        }
    }
}

